/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.database;

import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.NextVal;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SQLExpressionBuilderKt;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.Table;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/kopi/galite/database/Utils;", "", "()V", "Companion", "galite-data"})
public final class Utils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NULL_LITERAL = "NULL";

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kopi/galite/database/Utils$Companion;", "", "()V", "NULL_LITERAL", "", "getNextTableId", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "id", "sequence", "Lorg/jetbrains/exposed/sql/Sequence;", "toSql", "l", "trailString", "input", "trimString", "galite-data"})
    public static final class Companion {
        private Companion() {
        }

        public final int getNextTableId(@NotNull Table table, @NotNull String id, @Nullable Sequence sequence) {
            int n;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            NextVal seqNextVal = null;
            try {
                Sequence sequence2 = sequence;
                if (sequence2 == null) {
                    sequence2 = new Sequence(table.nameInDatabaseCase() + "Id", null, null, null, null, null, null, 126, null);
                }
                seqNextVal = SQLExpressionBuilderKt.nextIntVal((Sequence)sequence2);
                n = ((Number)((ResultRow)CollectionsKt.single((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)Table.Dual.INSTANCE.slice((Expression)seqNextVal, new Expression[0]))))).get((Expression)seqNextVal)).intValue();
            }
            catch (SQLException e) {
                int n2;
                try {
                    seqNextVal = SQLExpressionBuilderKt.nextIntVal((Sequence)new Sequence(table.nameInDatabaseCase() + "_" + id + "_seq", null, null, null, null, null, null, 126, null));
                    n2 = ((Number)((ResultRow)CollectionsKt.single((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)Table.Dual.INSTANCE.slice((Expression)seqNextVal, new Expression[0]))))).get((Expression)seqNextVal)).intValue();
                }
                catch (SQLException e2) {
                    throw new RuntimeException("Unable to get the sequence next value for table " + table.nameInDatabaseCase() + " : " + e2.getMessage());
                }
                n = n2;
            }
            return n;
        }

        public static /* synthetic */ int getNextTableId$default(Companion companion, Table table, String string, Sequence sequence, int n, Object object) {
            if ((n & 4) != 0) {
                sequence = null;
            }
            return companion.getNextTableId(table, string, sequence);
        }

        @NotNull
        public final String trimString(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            char[] buffer = new char[input.length()];
            int bufpos = 0;
            int state = 0;
            int n = input.length();
            for (int i = 0; i < n; ++i) {
                char element = input.charAt(i);
                if (Character.isWhitespace(element)) {
                    state = state == 0 ? 0 : 2;
                    continue;
                }
                if (state == 2) {
                    buffer[bufpos++] = 32;
                }
                buffer[bufpos++] = element;
                state = 1;
            }
            return bufpos == 0 ? "" : new String(buffer, 0, bufpos);
        }

        @Nullable
        public final String trailString(@NotNull String input) {
            String string;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int last = -1;
            for (int i = input.length() - 1; last == -1 && i >= 0; --i) {
                if (Character.isWhitespace(input.charAt(i))) continue;
                last = i;
            }
            if (last == -1) {
                string = "";
            } else if (last == input.length()) {
                string = input;
            } else {
                String string2 = input.substring(0, last + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            return string;
        }

        @NotNull
        public final String toSql(@Nullable String l) {
            String string;
            if (l == null) {
                string = Utils.NULL_LITERAL;
            } else {
                StringBuffer b = new StringBuffer();
                b.append('\'');
                for (int i = 0; i < l.length(); ++i) {
                    char element = l.charAt(i);
                    if (element == '\'') {
                        b.append('\'');
                    }
                    b.append(element);
                }
                b.append('\'');
                String string2 = b.toString();
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

