/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.type;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\t\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\n\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\f\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\r\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u000e\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0005\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"normal", "Ljava/text/SimpleDateFormat;", "getNormal", "()Ljava/text/SimpleDateFormat;", "format", "", "datetime", "nanos", "", "Ljava/math/BigDecimal;", "Ljava/time/Instant;", "pattern", "Ljava/time/LocalDate;", "Ljava/time/LocalDateTime;", "Ljava/time/LocalTime;", "Ljava/time/temporal/Temporal;", "galite-data"})
@SourceDebugExtension(value={"SMAP\nDefaultFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFormat.kt\norg/kopi/galite/type/DefaultFormatKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class DefaultFormatKt {
    @NotNull
    private static final SimpleDateFormat normal = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @NotNull
    public static final String format(@NotNull LocalDate $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        String string = $this$format.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final String format(@NotNull LocalTime $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        String string = $this$format.format(DateTimeFormatter.ofPattern("HH:mm"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final String format(@NotNull LocalDateTime $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        String string = normal.format(Timestamp.valueOf($this$format));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return DefaultFormatKt.format(string, $this$format.getNano());
    }

    @NotNull
    public static final String format(@NotNull LocalDateTime $this$format, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = new SimpleDateFormat(pattern).format(Timestamp.valueOf($this$format));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final String format(@NotNull Instant $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        String string = normal.format(Timestamp.from($this$format));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return DefaultFormatKt.format(string, $this$format.getNano());
    }

    @NotNull
    public static final String format(@NotNull Instant $this$format, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = new SimpleDateFormat(pattern).format(Timestamp.from($this$format));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final String format(@NotNull Temporal $this$format, @NotNull String pattern) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Temporal temporal = $this$format;
        if (temporal instanceof Instant) {
            string = DefaultFormatKt.format((Instant)$this$format, pattern);
        } else if (temporal instanceof LocalDateTime) {
            string = DefaultFormatKt.format((LocalDateTime)$this$format, pattern);
        } else if (temporal instanceof LocalDate) {
            String string2 = ((LocalDate)$this$format).format(DateTimeFormatter.ofPattern(pattern));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        } else if (temporal instanceof LocalTime) {
            String string3 = ((LocalTime)$this$format).format(DateTimeFormatter.ofPattern(pattern));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string = $this$format.toString();
        }
        return string;
    }

    private static final String format(String datetime, int nanos) {
        StringBuffer tmp = new StringBuffer(datetime);
        if (nanos >= 100) {
            tmp.append(nanos);
        } else if (nanos >= 10) {
            tmp.append("0" + nanos);
        } else {
            tmp.append("00" + nanos);
        }
        String string = tmp.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final SimpleDateFormat getNormal() {
        return normal;
    }

    @NotNull
    public static final String format(@NotNull BigDecimal $this$format) {
        int n;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        String string = $this$format.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String str = string;
        int pos = 0;
        int dot = 0;
        StringBuilder $this$format_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (str.charAt(0) == '-') {
            $this$format_u24lambda_u242.append('-');
            pos = 1;
        }
        int it = n = StringsKt.indexOf$default((CharSequence)str, (char)'.', (int)0, (boolean)false, (int)6, null);
        boolean bl2 = false;
        dot = it;
        if (n == -1) {
            it = n = StringsKt.indexOf$default((CharSequence)str, (char)' ', (int)0, (boolean)false, (int)6, null);
            boolean bl3 = false;
            dot = it;
            if (n == -1) {
                dot = str.length();
            }
        }
        if (dot - pos <= 3) {
            String string2 = str.substring(pos, dot);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$format_u24lambda_u242.append(string2);
            pos = dot;
        } else {
            switch ((dot - pos) % 3) {
                case 1: {
                    String string3 = str.substring(pos, pos + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$format_u24lambda_u242.append(string3);
                    ++pos;
                    break;
                }
                case 2: {
                    String string4 = str.substring(pos, pos + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$format_u24lambda_u242.append(string4);
                    pos += 2;
                    break;
                }
                case 0: {
                    String string5 = str.substring(pos, pos + 3);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$format_u24lambda_u242.append(string5);
                    pos += 3;
                }
            }
            do {
                StringBuilder stringBuilder2 = $this$format_u24lambda_u242.append(".");
                String string6 = str.substring(pos, pos + 3);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                stringBuilder2.append(string6);
            } while (dot - (pos += 3) > 0);
        }
        if (str.length() > pos) {
            StringBuilder stringBuilder3 = $this$format_u24lambda_u242.append(",");
            String string7 = str.substring(pos + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
            stringBuilder3.append(string7);
        }
        String string8 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"StringBuilder().apply(builderAction).toString()");
        return string8;
    }
}

