/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.type;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.type.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 )2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0002J\u0011\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u0016\u001a\u00020\u0000J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0017J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0002H\u0016J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0002H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0002H\u0086\u0002J\u000e\u0010\"\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0000J\r\u0010#\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u001a\u0010\t\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0003\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006*"}, d2={"Lorg/kopi/galite/type/Week;", "Lorg/kopi/galite/type/Type;", "", "year", "week", "(II)V", "date", "Ljava/time/LocalDate;", "(Ljava/time/LocalDate;)V", "scalar", "(I)V", "getScalar", "()I", "setScalar", "getWeek", "getYear", "add", "weeks", "addTo", "", "compareTo", "other", "copy", "equals", "", "", "getDate", "weekday", "getFirstDay", "getLastDay", "hashCode", "minus", "w", "plus", "subtract", "toSql", "()Ljava/lang/Integer;", "toString", "", "locale", "Ljava/util/Locale;", "Companion", "galite-data"})
public class Week
extends Type<Week, Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int scalar;
    @NotNull
    private static final int[] DAYS_BEFORE_MONTH;
    @NotNull
    private static GregorianCalendar calendar;
    @NotNull
    private static final Week DEFAULT;

    private Week(int scalar) {
        this.scalar = scalar;
    }

    public final int getScalar() {
        return this.scalar;
    }

    public final void setScalar(int n) {
        this.scalar = n;
    }

    public Week(int year, int week) {
        this(year * 53 + week - 1);
    }

    public Week(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this(Week.Companion.iso8601(date.getYear(), date.getMonthValue(), date.getDayOfMonth()));
    }

    @NotNull
    public final Week copy() {
        return new Week(this.scalar / 53, this.scalar % 53 + 1);
    }

    public final void addTo(int weeks) {
        this.scalar += weeks;
    }

    @NotNull
    public final Week plus(int w) {
        return this.add(w);
    }

    @NotNull
    public final Week minus(int w) {
        return this.add(-w);
    }

    public final int minus(@NotNull Week w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        return this.subtract(w);
    }

    @NotNull
    public final Week add(int weeks) {
        return new Week((this.scalar + weeks) / 53, (this.scalar + weeks) % 53 + 1);
    }

    public final int subtract(@NotNull Week other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.scalar - other.scalar;
    }

    @Override
    public int compareTo(@NotNull Week other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int v1 = this.scalar;
        int v2 = other.scalar;
        return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
    }

    public final int getWeek() {
        return this.scalar % 53 + 1;
    }

    public final int getYear() {
        return this.scalar / 53;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final LocalDate getDate(int weekday) {
        int year = 0;
        int month = 0;
        int day = 0;
        GregorianCalendar gregorianCalendar = calendar;
        synchronized (gregorianCalendar) {
            boolean bl = false;
            calendar.clear();
            calendar.set(1, this.scalar / 53);
            calendar.set(3, this.scalar % 53 + 1);
            calendar.set(7, weekday % 7 + 1);
            year = calendar.get(1);
            month = calendar.get(2) + 1;
            day = calendar.get(5);
            Unit unit = Unit.INSTANCE;
        }
        LocalDate localDate = LocalDate.of(year, month, day);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(...)");
        return localDate;
    }

    @NotNull
    public LocalDate getFirstDay() {
        return this.getDate(1);
    }

    @NotNull
    public LocalDate getLastDay() {
        return this.getDate(7);
    }

    @Deprecated(message="")
    @NotNull
    public LocalDate getDate() {
        return this.getDate(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (!(object == null ? true : object instanceof Week)) return false;
        Week week = (Week)other;
        if (week == null) return false;
        if (this.scalar != week.scalar) return false;
        return true;
    }

    @Override
    @NotNull
    public String toString(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        int year = this.scalar / 53;
        int week = this.scalar % 53 + 1;
        return (week < 10 ? "0" + week : "" + week) + "." + year;
    }

    @Override
    @NotNull
    public Integer toSql() {
        int year = this.scalar / 53;
        int week = this.scalar % 53 + 1;
        return year * 100 + week;
    }

    public int hashCode() {
        return this.scalar;
    }

    static {
        int[] nArray = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        DAYS_BEFORE_MONTH = nArray;
        calendar = new GregorianCalendar();
        DEFAULT = new Week(0, 0);
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0006\u0010\u0012\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/kopi/galite/type/Week$Companion;", "", "()V", "DAYS_BEFORE_MONTH", "", "DEFAULT", "Lorg/kopi/galite/type/Week;", "getDEFAULT", "()Lorg/kopi/galite/type/Week;", "calendar", "Ljava/util/GregorianCalendar;", "isLeapYear", "", "year", "", "iso8601", "month", "day", "now", "galite-data"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Week now() {
            Calendar now = Calendar.getInstance();
            return new Week(now.get(1), now.get(3));
        }

        private final int iso8601(int year, int month, int day) {
            int i;
            boolean leapYear = this.isLeapYear(year);
            boolean leapYear_m_1 = this.isLeapYear(year - 1);
            int dayOfYearNumber = day + DAYS_BEFORE_MONTH[month - 1];
            if (leapYear && month > 2) {
                ++dayOfYearNumber;
            }
            int yy = (year - 1) % 100;
            int c = year - 1 - yy;
            int g = yy + yy / 4;
            int jan1Weekday = 1 + (c / 100 % 4 * 5 + g) % 7;
            int h = dayOfYearNumber + (jan1Weekday - 1);
            int weekday = 1 + (h - 1) % 7;
            int yearNumber = 0;
            int weekNumber = 0;
            if (dayOfYearNumber <= 8 - jan1Weekday && jan1Weekday > 4) {
                yearNumber = year - 1;
                weekNumber = jan1Weekday == 5 || jan1Weekday == 6 && leapYear_m_1 ? 53 : 52;
            } else {
                yearNumber = year;
                weekNumber = -10000000;
            }
            int n = i = leapYear ? 366 : 365;
            if (i - dayOfYearNumber < 4 - weekday) {
                yearNumber = year + 1;
                weekNumber = 1;
            }
            if (yearNumber == year) {
                int j = dayOfYearNumber + (7 - weekday) + (jan1Weekday - 1);
                weekNumber = j / 7;
                if (jan1Weekday > 4) {
                    --weekNumber;
                }
            }
            return yearNumber * 53 + weekNumber - 1;
        }

        private final boolean isLeapYear(int year) {
            return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        }

        @NotNull
        public final Week getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

