/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.util.ipp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.util.ipp.IPP;
import org.kopi.galite.util.ipp.IPPHttp;
import org.kopi.galite.util.ipp.IPPInputStream;
import org.kopi.galite.util.ipp.IPPOutputStream;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kopi/galite/util/ipp/IPPHttpConnection;", "", "url", "Ljava/net/URL;", "(Ljava/net/URL;)V", "connection", "Ljava/net/Socket;", "inputStream", "Ljava/io/InputStream;", "os", "Ljava/io/OutputStream;", "receiveResponse", "Lorg/kopi/galite/util/ipp/IPP;", "sendRequest", "", "request", "galite-util"})
public final class IPPHttpConnection {
    @NotNull
    private final URL url;
    @NotNull
    private final Socket connection;
    @NotNull
    private final OutputStream os;
    @NotNull
    private final InputStream inputStream;

    public IPPHttpConnection(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.connection = new Socket(this.url.getHost(), this.url.getPort());
        this.os = new BufferedOutputStream(new DataOutputStream(this.connection.getOutputStream()));
        this.inputStream = new BufferedInputStream(new DataInputStream(this.connection.getInputStream()));
    }

    public final void sendRequest(@NotNull IPP request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = this.url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
        IPPHttp httpRequest = new IPPHttp(string, request);
        httpRequest.write(new IPPOutputStream(this.os));
        this.os.flush();
    }

    @NotNull
    public final IPP receiveResponse() {
        IPPHttp httpRequest = new IPPHttp(new IPPInputStream(this.inputStream));
        return httpRequest.getIpp();
    }
}

