/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.util.ipp;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kopi/galite/util/ipp/IPPOutputStream;", "", "os", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "writeArray", "", "array", "", "writeByte", "b", "", "writeInteger", "i", "writeShort", "s", "writeString", "", "galite-util"})
public final class IPPOutputStream {
    @NotNull
    private final OutputStream os;

    public IPPOutputStream(@NotNull OutputStream os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        this.os = os;
    }

    public final void writeByte(int b) {
        this.os.write(b & 0xFF);
    }

    public final void writeShort(int s) {
        this.os.write((s & 0xFF00) >> 8);
        this.os.write(s & 0xFF);
    }

    public final void writeInteger(int i) {
        this.os.write((i & 0xFF000000) >> 24);
        this.os.write((i & 0xFF0000) >> 16);
        this.os.write((i & 0xFF00) >> 8);
        this.os.write(i & 0xFF);
    }

    public final void writeString(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Charset charset = Charset.forName("iso-8859-1");
        ByteBuffer byteBuffer = charset.encode(s);
        int n = 0;
        int n2 = s.length();
        while (n < n2) {
            int i = n++;
            this.os.write(byteBuffer.get(i));
        }
    }

    public final void writeArray(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.os.write(array, 0, array.length);
    }
}

