/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.util.ipp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.util.ipp.IPPInputStream;
import org.kopi.galite.util.ipp.IPPOutputStream;
import org.kopi.galite.util.ipp.IPPValue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kopi/galite/util/ipp/LangValue;", "Lorg/kopi/galite/util/ipp/IPPValue;", "charset", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "inputStream", "Lorg/kopi/galite/util/ipp/IPPInputStream;", "(Lorg/kopi/galite/util/ipp/IPPInputStream;)V", "dump", "", "getSize", "", "toString", "write", "os", "Lorg/kopi/galite/util/ipp/IPPOutputStream;", "galite-util"})
public final class LangValue
extends IPPValue {
    @NotNull
    private String charset;
    @NotNull
    private String value;

    public LangValue(@NotNull String charset, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.charset = charset;
        this.value = value;
    }

    public LangValue(@NotNull IPPInputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        inputStream.readShort();
        short n = inputStream.readShort();
        this.charset = inputStream.readString(n);
        n = inputStream.readShort();
        this.value = inputStream.readString(n);
    }

    @Override
    public int getSize() {
        return 6 + this.charset.length() + this.value.length();
    }

    @Override
    public void write(@NotNull IPPOutputStream os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        os.writeShort(4 + this.value.length() + this.charset.length());
        os.writeShort(this.charset.length());
        os.writeString(this.charset);
        os.writeShort(this.value.length());
        os.writeString(this.value);
    }

    @Override
    public void dump() {
        System.out.println((Object)("\tcharset : " + this.charset + "\tvalue : " + this.value));
    }

    @NotNull
    public String toString() {
        return this.value;
    }
}

