/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.util.mailer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.util.mailer.Attachment;
import org.kopi.galite.util.mailer.SMTPException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u00a2\u0006\u0002\u0010\nJR\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\tJJ\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0014Jb\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\t2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\t2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\tJ\u0010\u0010\u0018\u001a\u00020\f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/kopi/galite/util/mailer/Mailer;", "", "()V", "mailHost", "", "getAddresses", "", "Ljavax/mail/Address;", "recipients", "", "(Ljava/util/List;)[Ljavax/mail/Address;", "sendMessage", "", "sender", "recipient", "ccRecipient", "bccRecipient", "subject", "message", "attachments", "Lorg/kopi/galite/util/mailer/Attachment;", "attachment", "ccRecipients", "bccRecipients", "setMailHost", "split", "", "line", "Companion", "galite-util"})
public final class Mailer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String mailHost;

    public final void sendMessage(@NotNull String sender, @Nullable String recipient, @Nullable String ccRecipient, @Nullable String bccRecipient, @Nullable String subject, @Nullable String message, @NotNull Attachment attachment) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        List attachments = CollectionsKt.listOf((Object)attachment);
        this.sendMessage(sender, recipient, ccRecipient, bccRecipient, subject, message, (List<Attachment>)attachments);
    }

    public static /* synthetic */ void sendMessage$default(Mailer mailer, String string, String string2, String string3, String string4, String string5, String string6, Attachment attachment, int n, Object object) {
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        mailer.sendMessage(string, string2, string3, string4, string5, string6, attachment);
    }

    public final void sendMessage(@NotNull String sender, @Nullable String recipient, @Nullable String ccRecipient, @Nullable String bccRecipient, @Nullable String subject, @Nullable String message, @Nullable List<Attachment> attachments) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        List<String> recipients = this.split(recipient);
        List<String> ccRecipients = this.split(ccRecipient);
        List<String> bccRecipients = this.split(bccRecipient);
        this.sendMessage(sender, recipients, ccRecipients, bccRecipients, subject, message, attachments);
    }

    public static /* synthetic */ void sendMessage$default(Mailer mailer, String string, String string2, String string3, String string4, String string5, String string6, List list, int n, Object object) {
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        mailer.sendMessage(string, string2, string3, string4, string5, string6, (List<Attachment>)list);
    }

    public final void sendMessage(@NotNull String sender, @Nullable List<String> recipients, @Nullable List<String> ccRecipients, @Nullable List<String> bccRecipients, @Nullable String subject, @Nullable String message, @Nullable List<Attachment> attachments) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        try {
            String string;
            Properties props = new Properties();
            ((Map)props).put("mail.smtp.host", this.mailHost);
            Session session = Session.getDefaultInstance((Properties)props);
            Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getDefaultInstance(props)");
            Session session2 = session;
            Message msg = (Message)new MimeMessage(session2);
            msg.setFrom((Address)new InternetAddress(sender));
            if (recipients != null && !((Collection)recipients).isEmpty()) {
                msg.addRecipients(Message.RecipientType.TO, this.getAddresses(recipients));
            }
            if (ccRecipients != null && !((Collection)ccRecipients).isEmpty()) {
                msg.addRecipients(Message.RecipientType.CC, this.getAddresses(ccRecipients));
            }
            if (bccRecipients != null && !((Collection)bccRecipients).isEmpty()) {
                msg.addRecipients(Message.RecipientType.BCC, this.getAddresses(bccRecipients));
            }
            if ((string = subject) == null) {
                string = "NO SUBJECT";
            }
            msg.setSubject(string);
            if (attachments == null || attachments.isEmpty()) {
                msg.setText(message);
            } else {
                MimeMultipart content = new MimeMultipart();
                MimeBodyPart text = new MimeBodyPart();
                text.setText(message);
                content.addBodyPart((BodyPart)text);
                ListIterator<Attachment> iterator = attachments.listIterator();
                while (iterator.hasNext()) {
                    Attachment attachment = iterator.next();
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    bodyPart.setDataHandler(new DataHandler((DataSource)attachment));
                    bodyPart.setHeader("Content-Transfer-Encoding", "base64");
                    bodyPart.setFileName(attachment.getName());
                    content.addBodyPart((BodyPart)bodyPart);
                }
                msg.setContent((Multipart)content);
            }
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            throw new SMTPException((Exception)((Object)e));
        }
    }

    private final Address[] getAddresses(List<?> recipients) {
        ListIterator<?> iterator = recipients.listIterator();
        List addresses = new ArrayList();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String tmp = (String)obj;
            if (!(((CharSequence)tmp).length() > 0)) continue;
            addresses.add(new InternetAddress(tmp));
        }
        Collection $this$toTypedArray$iv = addresses;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Address[] addressArray = thisCollection$iv.toArray(new Address[0]);
        if (addressArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return addressArray;
    }

    public final void setMailHost(@Nullable String mailHost) {
        this.mailHost = mailHost;
    }

    private final List<String> split(String line) {
        List result = null;
        if (line == null) {
            result = new ArrayList();
        } else {
            StringTokenizer tok = new StringTokenizer(line, ",");
            result = new ArrayList();
            while (tok.hasMoreTokens()) {
                String string = tok.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tok.nextToken()");
                result.add(string);
            }
        }
        return result;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0006JZ\u0010\u0003\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u00062\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/kopi/galite/util/mailer/Mailer$Companion;", "", "()V", "sendMail", "", "mailHost", "", "recipient", "ccRecipient", "bccRecipient", "subject", "body", "sender", "host", "attachments", "", "Lorg/kopi/galite/util/mailer/Attachment;", "galite-util"})
    public static final class Companion {
        private Companion() {
        }

        public final void sendMail(@Nullable String mailHost, @Nullable String recipient, @Nullable String ccRecipient, @Nullable String bccRecipient, @Nullable String subject, @Nullable String body, @NotNull String sender) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            this.sendMail(mailHost, recipient, ccRecipient, bccRecipient, subject, body, sender, null);
        }

        public final void sendMail(@Nullable String host, @Nullable String recipient, @Nullable String ccRecipient, @Nullable String bccRecipient, @Nullable String subject, @Nullable String body, @NotNull String sender, @Nullable List<Attachment> attachments) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Runnable runnable = () -> Companion.sendMail$lambda-0(host, sender, recipient, ccRecipient, bccRecipient, subject, body, attachments);
            new Thread(runnable).start();
        }

        private static final void sendMail$lambda-0(String $host, String $sender, String $recipient, String $ccRecipient, String $bccRecipient, String $subject, String $body, List $attachments) {
            Intrinsics.checkNotNullParameter((Object)$sender, (String)"$sender");
            try {
                Mailer mailer = new Mailer();
                mailer.setMailHost($host);
                mailer.sendMessage($sender, $recipient, $ccRecipient, $bccRecipient, $subject, $body, (List<Attachment>)$attachments);
            }
            catch (SMTPException e) {
                e.printStackTrace();
                System.err.println(Intrinsics.stringPlus((String)"*** SMTP Exception: ", (Object)e.getMessage()));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

