/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.util.ipp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.util.ipp.BooleanValue;
import org.kopi.galite.util.ipp.DateValue;
import org.kopi.galite.util.ipp.IPPInputStream;
import org.kopi.galite.util.ipp.IPPOutputStream;
import org.kopi.galite.util.ipp.IPPValue;
import org.kopi.galite.util.ipp.IntegerValue;
import org.kopi.galite.util.ipp.LangValue;
import org.kopi.galite.util.ipp.RangeValue;
import org.kopi.galite.util.ipp.ResolutionValue;
import org.kopi.galite.util.ipp.StringValue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u0006\u0010\u001c\u001a\u00020\u0015J\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u0003R\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/kopi/galite/util/ipp/IPPAttribute;", "", "groupTag", "", "valueTag", "name", "", "(IILjava/lang/String;)V", "inputStream", "Lorg/kopi/galite/util/ipp/IPPInputStream;", "(Lorg/kopi/galite/util/ipp/IPPInputStream;I)V", "<set-?>", "group", "getGroup", "()I", "getName", "()Ljava/lang/String;", "values", "", "Lorg/kopi/galite/util/ipp/IPPValue;", "addValue", "", "value", "dump", "getSize", "lastGroup", "getValues", "", "simpleDump", "write", "os", "Lorg/kopi/galite/util/ipp/IPPOutputStream;", "galite-util"})
public final class IPPAttribute {
    private int group;
    private int valueTag;
    @NotNull
    private String name;
    @NotNull
    private List<IPPValue> values;

    public final int getGroup() {
        return this.group;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public IPPAttribute(int groupTag, int valueTag, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.group = groupTag;
        this.valueTag = valueTag;
        this.name = name;
        this.values = new ArrayList();
    }

    public IPPAttribute(@NotNull IPPInputStream inputStream, int groupTag) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        byte read = 0;
        short n = inputStream.readShort();
        boolean endAttribute = false;
        this.group = groupTag;
        this.values = new ArrayList();
        this.valueTag = inputStream.readByte();
        this.name = inputStream.readString(n);
        while (!endAttribute) {
            switch (this.valueTag) {
                case 33: 
                case 35: {
                    this.values.add(new IntegerValue(inputStream));
                    break;
                }
                case 34: {
                    this.values.add(new BooleanValue(inputStream));
                    break;
                }
                case 48: 
                case 65: 
                case 66: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: {
                    this.values.add(new StringValue(inputStream));
                    break;
                }
                case 49: {
                    this.values.add(new DateValue(inputStream));
                    break;
                }
                case 50: {
                    this.values.add(new ResolutionValue(inputStream));
                    break;
                }
                case 51: {
                    this.values.add(new RangeValue(inputStream));
                    break;
                }
                case 53: 
                case 54: {
                    this.values.add(new LangValue(inputStream));
                    n = inputStream.readShort();
                    inputStream.readString(n);
                    break;
                }
                default: {
                    n = inputStream.readShort();
                    inputStream.readString(n);
                }
            }
            read = inputStream.peekByte();
            if (read < 16) {
                endAttribute = true;
                continue;
            }
            short nameLengthNextAttribute = inputStream.peekShortAfterFirstByte();
            if (nameLengthNextAttribute == 0) {
                inputStream.readByte();
                inputStream.readShort();
                continue;
            }
            endAttribute = true;
        }
    }

    @NotNull
    public final Iterator<?> getValues() {
        return this.values.iterator();
    }

    public final void addValue(@NotNull IPPValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.values.add(value);
    }

    public final int getSize(int lastGroup) {
        int n;
        int size = 0;
        boolean firstValue = true;
        Iterator<IPPValue> vals = this.values.iterator();
        IPPValue value = null;
        if (lastGroup != this.group) {
            n = size;
            size = n + 1;
        }
        while (vals.hasNext()) {
            value = vals.next();
            n = size;
            size = n + 1;
            size += 2;
            if (firstValue) {
                size += this.name.length();
                firstValue = false;
            }
            size += value.getSize();
        }
        return size;
    }

    public final void write(@NotNull IPPOutputStream os, int lastGroup) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        boolean firstValue = true;
        Iterator<IPPValue> vals = this.values.iterator();
        IPPValue value = null;
        if (lastGroup != this.group) {
            os.writeByte(this.group);
        }
        while (vals.hasNext()) {
            value = vals.next();
            os.writeByte(this.valueTag);
            if (firstValue) {
                os.writeShort(this.name.length());
                os.writeString(this.name);
                firstValue = false;
            } else {
                os.writeShort(0);
            }
            value.write(os);
        }
    }

    public final void dump() {
        Iterator<IPPValue> vals = this.values.iterator();
        IPPValue value = null;
        System.out.println((Object)"");
        System.out.println((Object)("Group Tag : " + this.group));
        System.out.println((Object)("Value Tag : " + this.valueTag));
        System.out.println((Object)("Att Name : " + this.name));
        System.out.println((Object)"Values :");
        while (vals.hasNext()) {
            value = vals.next();
            value.dump();
        }
    }

    public final void simpleDump() {
        Iterator<IPPValue> vals = this.values.iterator();
        IPPValue value = null;
        System.out.print((Object)(this.name + " = "));
        while (vals.hasNext()) {
            value = vals.next();
            System.out.print((Object)value.toString());
            if (!vals.hasNext()) continue;
            System.out.print((Object)", ");
        }
        System.out.println();
    }
}

