/*
 * Decompiled with CFR 0.152.
 */
package org.koshinuke.yuzen.reload;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaththroughHandler
extends WebSocketHandler {
    static final Logger LOG = LoggerFactory.getLogger(PaththroughHandler.class);
    List<PaththroughSocket> sockets = new CopyOnWriteArrayList<PaththroughSocket>();

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        return new PaththroughSocket();
    }

    class PaththroughSocket
    implements WebSocket.OnTextMessage {
        WebSocket.Connection connection;

        PaththroughSocket() {
        }

        public void onOpen(WebSocket.Connection connection) {
            LOG.debug("onOpen");
            this.connection = connection;
            PaththroughHandler.this.sockets.add(this);
        }

        public void onClose(int closeCode, String message) {
            LOG.debug("onClose {} {}", (Object)closeCode, (Object)message);
            PaththroughHandler.this.sockets.remove(this);
        }

        public void onMessage(String data) {
            LOG.debug("onMessage {}", (Object)data);
            for (PaththroughSocket rs : PaththroughHandler.this.sockets) {
                try {
                    rs.connection.sendMessage(data);
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

