/*
 * Decompiled with CFR 0.152.
 */
package org.koshinuke.yuzen.file;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.koshinuke._;
import org.koshinuke.yuzen.file.DefaultPathEvent;
import org.koshinuke.yuzen.file.PathEvent;
import org.koshinuke.yuzen.file.PathEventDispatcher;
import org.koshinuke.yuzen.file.PathEventListener;
import org.koshinuke.yuzen.util.WatchServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathSentinel {
    static Logger LOG = LoggerFactory.getLogger(PathSentinel.class);
    protected Deque<PathEvent> events = new LinkedList<PathEvent>();
    protected CopyOnWriteArrayList<PathEventListener> listeners = new CopyOnWriteArrayList();
    protected Map<WatchEvent.Kind<?>, PathEventDispatcher> dispatchers = new HashMap();
    protected WatchService watchService = WatchServiceUtil.newWatchService();
    protected ExecutorService watcherExecutor;
    protected ScheduledExecutorService workerExecutor;

    public PathSentinel() {
        this(Executors.newFixedThreadPool(1), Executors.newScheduledThreadPool(1));
    }

    public PathSentinel(@Nonnull ExecutorService watcherExecutor, @Nonnull ScheduledExecutorService workerExecutor) {
        Objects.requireNonNull(watcherExecutor);
        Objects.requireNonNull(workerExecutor);
        this.watcherExecutor = watcherExecutor;
        this.workerExecutor = workerExecutor;
        this.setUpDispatchers();
    }

    public PathSentinel watch(@Nonnull String path) {
        Objects.requireNonNull(path);
        this.watch(Paths.get(path, new String[0]));
        return this;
    }

    public PathSentinel watch(@Nonnull Path path) {
        Objects.requireNonNull(path);
        WatchServiceUtil.watch(this.watchService, path, new WatchEvent.Modifier[0]);
        return this;
    }

    public PathSentinel watchTree(@Nonnull Path path) {
        Objects.requireNonNull(path);
        WatchServiceUtil.watchTree(this.watchService, path);
        return this;
    }

    public PathSentinel register(@Nonnull PathEventListener _2) {
        Objects.requireNonNull(_2);
        this.listeners.add(_2);
        return this;
    }

    public PathSentinel unregister(@Nonnull PathEventListener _2) {
        Objects.requireNonNull(_2);
        this.listeners.remove(_2);
        return this;
    }

    public void startUp() {
        this.startWatcher();
        this.startWorker();
    }

    protected void startWatcher() {
        this.watcherExecutor.submit(new Callable<_>(){

            @Override
            public _ call() throws Exception {
                try {
                    LOG.debug("take watchkey");
                    WatchKey key = PathSentinel.this.watchService.take();
                    Path path = (Path)Path.class.cast(key.watchable());
                    for (WatchEvent<?> i : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = i.kind();
                        Path resolved = path.resolve((Path)Path.class.cast(i.context()));
                        DefaultPathEvent event = new DefaultPathEvent(kind, resolved);
                        PathSentinel.this.add(event);
                    }
                    key.reset();
                    PathSentinel.this.watcherExecutor.submit(this);
                    return _._;
                }
                catch (ClosedWatchServiceException | RejectedExecutionException e) {
                    LOG.debug("any time no problem.", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean add(PathEvent event) {
        Deque<PathEvent> deque = this.events;
        synchronized (deque) {
            if (this.events.contains(event)) {
                LOG.debug("duplicated {}", (Object)event);
                return false;
            }
            LOG.debug("queued {}", (Object)event);
            this.events.add(event);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearEvents() {
        Deque<PathEvent> deque = this.events;
        synchronized (deque) {
            this.events.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasEvents() {
        Deque<PathEvent> deque = this.events;
        synchronized (deque) {
            return !this.events.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PathEvent take() {
        Deque<PathEvent> deque = this.events;
        synchronized (deque) {
            return this.events.removeFirst();
        }
    }

    protected void startWorker() {
        this.workerExecutor.submit(new Callable<_>(){

            @Override
            public _ call() throws Exception {
                try {
                    while (PathSentinel.this.hasEvents()) {
                        PathEvent event = PathSentinel.this.take();
                        PathSentinel.this.dispatch(event);
                    }
                    PathSentinel.this.workerExecutor.schedule(this, 10L, TimeUnit.MILLISECONDS);
                    return _._;
                }
                catch (RejectedExecutionException e) {
                    LOG.debug("any time no problem.", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        });
    }

    protected void setUpDispatchers() {
        this.dispatchers.put(StandardWatchEventKinds.OVERFLOW, new PathEventDispatcher(){

            @Override
            public void dispatch(PathEventListener listener, PathEvent event) throws IOException {
                listener.overflowed();
            }
        });
        this.dispatchers.put(StandardWatchEventKinds.ENTRY_CREATE, new PathEventDispatcher(){

            @Override
            public void dispatch(PathEventListener listener, PathEvent event) throws IOException {
                listener.created(event);
            }
        });
        this.dispatchers.put(StandardWatchEventKinds.ENTRY_DELETE, new PathEventDispatcher(){

            @Override
            public void dispatch(PathEventListener listener, PathEvent event) throws IOException {
                listener.deleted(event);
            }
        });
        this.dispatchers.put(StandardWatchEventKinds.ENTRY_MODIFY, new PathEventDispatcher(){

            @Override
            public void dispatch(PathEventListener listener, PathEvent event) throws IOException {
                listener.modified(event);
            }
        });
    }

    protected void dispatch(PathEvent event) throws IOException {
        LOG.debug("dispatch {}", (Object)event);
        PathEventDispatcher dispatcher = this.dispatchers.get(event.getKind());
        if (dispatcher != null) {
            for (PathEventListener listener : this.listeners) {
                dispatcher.dispatch(listener, event);
            }
        }
    }

    public void shutdown() {
        this.listeners.clear();
        this.clearEvents();
        WatchServiceUtil.close(this.watchService);
        this.watcherExecutor.shutdownNow();
        this.workerExecutor.shutdownNow();
    }
}

