/*
 * Decompiled with CFR 0.152.
 */
package org.koshinuke.yuzen.pegdown;

import org.eclipse.jgit.util.StringUtils;
import org.parboiled.common.Preconditions;
import org.pegdown.LinkRenderer;
import org.pegdown.ToHtmlSerializer;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.Visitor;

public class SlideHtmlSerializer
extends ToHtmlSerializer {
    int pages = 0;
    String title;

    public SlideHtmlSerializer() {
        super(new LinkRenderer());
    }

    public SlideHtmlSerializer(LinkRenderer linkRenderer) {
        super(linkRenderer);
    }

    public String toHtml(RootNode astRoot) {
        Preconditions.checkArgNotNull((Object)astRoot, (String)"astRoot");
        this.printer.print("<section>");
        astRoot.accept((Visitor)this);
        this.printer.print("</section>");
        return this.printer.getString();
    }

    public void visit(HeaderNode node) {
        int level = node.getLevel();
        if (level < 3 && 0 < this.pages++) {
            this.printer.print("</section><section>");
        }
        this.printTag((SuperNode)node, "h" + node.getLevel());
    }

    public void visit(TextNode node) {
        if (this.pages < 2 && StringUtils.isEmptyOrNull((String)this.title)) {
            this.title = node.getText();
        }
        super.visit(node);
    }

    public int getPages() {
        return this.pages;
    }
}

