/*
 * Decompiled with CFR 0.152.
 */
package org.koshinuke.yuzen.thymeleaf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.koshinuke.yuzen.thymeleaf.MarkdownTemplateResolver;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.processor.attr.AbstractChildrenModifierAttrProcessor;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.templateresolver.TemplateResolver;
import org.thymeleaf.util.StringUtils;

public class MarkdownProcessor
extends AbstractChildrenModifierAttrProcessor {
    TemplateResolver resolver;

    public MarkdownProcessor(TemplateResolver rr) {
        super("MARKDOWN".toLowerCase());
        this.resolver = rr;
    }

    public int getPrecedence() {
        return 10000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Node> getModifiedChildren(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        Object v = StandardExpressionProcessor.processExpression((Arguments)arguments, (String)attributeValue);
        if (v == null) return Collections.emptyList();
        Configuration conf = arguments.getConfiguration();
        TemplateProcessingParameters tpp = new TemplateProcessingParameters(conf, v.toString(), arguments.getContext());
        TemplateResolution tr = this.resolver.resolveTemplate(tpp);
        IResourceResolver rr = tr.getResourceResolver();
        try (Reader source = this.makeReader(rr.getResourceAsStream(tpp, tr.getResourceName()), tr);){
            Document doc = MarkdownTemplateResolver.MARKDOWN.getTemplateParser().parseTemplate(conf, tr.getTemplateName(), source);
            doc.precompute(conf);
            List list = doc.getChildren();
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Reader makeReader(InputStream in, TemplateResolution tr) {
        String characterEncoding = tr.getCharacterEncoding();
        InputStreamReader reader = null;
        if (!StringUtils.isEmpty((Object)characterEncoding).booleanValue()) {
            try {
                reader = new InputStreamReader(in, characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new TemplateInputException("Exception parsing document", (Throwable)e);
            }
        } else {
            reader = new InputStreamReader(in, Charset.defaultCharset());
        }
        return reader;
    }
}

