/*
 * Decompiled with CFR 0.152.
 */
package org.koshinuke.yuzen.file;

import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.koshinuke.yuzen.file.PathEvent;

public class DefaultPathEvent
implements PathEvent,
Comparable<PathEvent> {
    final WatchEvent.Kind<?> kind;
    final Path path;

    public DefaultPathEvent(@Nonnull WatchEvent.Kind<?> kind, @Nonnull Path path) {
        Objects.requireNonNull(kind);
        Objects.requireNonNull(path);
        this.kind = kind;
        this.path = path;
    }

    @Override
    public WatchEvent.Kind<?> getKind() {
        return this.kind;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public int compareTo(PathEvent o) {
        int result = o.getPath().compareTo(this.getPath());
        if (result == 0) {
            result = o.getKind().name().compareTo(this.getKind().name());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathEvent other = (PathEvent)obj;
        return this.kind.equals(other.getKind()) && this.path.equals(other.getPath());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultPathEvent [kind=");
        builder.append(this.kind);
        builder.append(", path=");
        builder.append(this.path);
        builder.append("]");
        return builder.toString();
    }
}

