/*
 * Decompiled with CFR 0.152.
 */
package org.koshinuke.yuzen.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.koshinuke.yuzen.util.IORuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchServiceUtil {
    static final Logger LOG = LoggerFactory.getLogger(WatchServiceUtil.class);
    static final WatchEvent.Modifier FILE_TREE = WatchServiceUtil.findFileTree();

    static WatchEvent.Modifier findFileTree() {
        try {
            Class<?> clazz = Class.forName("com.sun.nio.file.ExtendedWatchEventModifier");
            for (Object o : clazz.getEnumConstants()) {
                WatchEvent.Modifier mod = (WatchEvent.Modifier)o;
                if (!"FILE_TREE".equals(mod.name())) continue;
                return mod;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    public static WatchService newWatchService() {
        try {
            return FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void watchAll(final @Nonnull WatchService ws, @Nonnull Path root) {
        Objects.requireNonNull(ws);
        Objects.requireNonNull(root);
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    WatchServiceUtil.watch(ws, dir, new WatchEvent.Modifier[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void watchTree(@Nonnull WatchService ws, @Nonnull Path root) {
        if (FILE_TREE == null) {
            WatchServiceUtil.watchAll(ws, root);
        } else {
            WatchServiceUtil.watch(ws, root, FILE_TREE);
        }
    }

    public static WatchKey watch(@Nonnull WatchService ws, @Nonnull Path dir, WatchEvent.Modifier ... modifiers) {
        Objects.requireNonNull(ws);
        Objects.requireNonNull(dir);
        LOG.debug("watch {}", (Object)dir);
        try {
            return dir.register(ws, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW}, modifiers);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void close(WatchService ws) {
        try {
            if (ws != null) {
                ws.close();
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

