(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'endians-endians-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'endians-endians-js-legacy'.");
    }
    root['endians-endians-js-legacy'] = factory(typeof this['endians-endians-js-legacy'] === 'undefined' ? {} : this['endians-endians-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
  var getOrNull = Kotlin.kotlin.collections.getOrNull_mrm5p$;
  var last = Kotlin.kotlin.collections.last_964n91$;
  var numberToShort = Kotlin.numberToShort;
  var numberToInt = Kotlin.numberToInt;
  var numberToLong = Kotlin.numberToLong;
  var toList = Kotlin.kotlin.collections.toList_964n91$;
  var toByte = Kotlin.toByte;
  var toShort = Kotlin.toShort;
  var L4294967295 = new Kotlin.Long(-1, 0);
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var get_lastIndex = Kotlin.kotlin.collections.get_lastIndex_964n91$;
  var primitiveArrayConcat = Kotlin.primitiveArrayConcat;
  var first = Kotlin.kotlin.collections.first_964n91$;
  function plus($receiver, other) {
    var b = new Int8Array($receiver.length + other.size | 0);
    arrayCopy($receiver, b, 0, 0, $receiver.length);
    other.copyInto_elxobu$(b, $receiver.length);
    return b;
  }
  function plus_0($receiver, other) {
    var b = new Int8Array($receiver.length + other.size | 0);
    arrayCopy($receiver, b, 0, 0, $receiver.length);
    other.copyInto_elxobu$(b, $receiver.length);
    return b;
  }
  function BigEndian(data) {
    BigEndian$Companion_getInstance();
    this.data_0 = data;
  }
  BigEndian.prototype.get_za3lpa$ = function (index) {
    return this.data_0[index];
  };
  BigEndian.prototype.getOrNull_za3lpa$ = function (index) {
    return getOrNull(this.data_0, index);
  };
  BigEndian.prototype.getOrElse_80wqxd$ = function (index, defaultValue) {
    var $receiver = this.data_0;
    return index >= 0 && index <= get_lastIndex($receiver) ? $receiver[index] : defaultValue(index);
  };
  BigEndian.prototype.plus_fqrh44$ = function (other) {
    return primitiveArrayConcat(this.data_0, other);
  };
  Object.defineProperty(BigEndian.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.data_0.length;
    }
  });
  Object.defineProperty(BigEndian.prototype, 'sizeBits', {
    configurable: true,
    get: function () {
      return this.size * 8 | 0;
    }
  });
  BigEndian.prototype.iterator = function () {
    return Kotlin.byteArrayIterator(this.data_0);
  };
  BigEndian.prototype.copyInto_elxobu$ = function (destination, destinationOffset, startIndex, endIndex) {
    if (destinationOffset === void 0)
      destinationOffset = 0;
    if (startIndex === void 0)
      startIndex = 0;
    if (endIndex === void 0)
      endIndex = this.size;
    arrayCopy(this.data_0, destination, destinationOffset, startIndex, endIndex);
    return destination;
  };
  BigEndian.prototype.toByteArray = function () {
    return this.data_0.slice();
  };
  BigEndian.prototype.toByte = function () {
    return last(this.data_0);
  };
  BigEndian.prototype.toShort = function () {
    return numberToShort(this.toNumber_0());
  };
  BigEndian.prototype.toInt = function () {
    return numberToInt(this.toNumber_0());
  };
  BigEndian.prototype.toLong = function () {
    return numberToLong(this.toNumber_0());
  };
  BigEndian.prototype.toLittleEndian = function () {
    var tmp$;
    switch (this.size) {
      case 2:
        tmp$ = LittleEndian_init(this.data_0[1], this.data_0[0]);
        break;
      case 4:
        tmp$ = LittleEndian_init_0(this.data_0[3], this.data_0[2], this.data_0[1], this.data_0[0]);
        break;
      default:
        tmp$ = LittleEndian_init_1(this.data_0[7], this.data_0[6], this.data_0[5], this.data_0[4], this.data_0[3], this.data_0[2], this.data_0[1], this.data_0[0]);
        break;
    }
    return tmp$;
  };
  BigEndian.prototype.toString = function () {
    return 'BE' + toList(this.data_0);
  };
  BigEndian.prototype.toNumber_0 = function () {
    var tmp$;
    switch (this.size) {
      case 2:
        tmp$ = BigEndian$Companion_getInstance().bytesToShort_5gdoe6$(this.data_0[0], this.data_0[1]);
        break;
      case 4:
        tmp$ = BigEndian$Companion_getInstance().bytesToInt_sz6or4$(this.data_0[0], this.data_0[1], this.data_0[2], this.data_0[3]);
        break;
      default:
        tmp$ = BigEndian$Companion_getInstance().bytesToLong_uwl3p0$(this.data_0[0], this.data_0[1], this.data_0[2], this.data_0[3], this.data_0[4], this.data_0[5], this.data_0[6], this.data_0[7]);
        break;
    }
    return tmp$;
  };
  function BigEndian$Companion() {
    BigEndian$Companion_instance = this;
  }
  BigEndian$Companion.prototype.toBigEndian_5vcgdc$ = function ($receiver) {
    return BigEndian_init(toByte($receiver >>> 8), toByte($receiver));
  };
  BigEndian$Companion.prototype.toBigEndian_s8ev3n$ = function ($receiver) {
    return BigEndian_init_0(toByte($receiver >>> 24), toByte($receiver >>> 16), toByte($receiver >>> 8), toByte($receiver));
  };
  BigEndian$Companion.prototype.toBigEndian_mts6qi$ = function ($receiver) {
    return BigEndian_init_1(toByte($receiver.shiftRightUnsigned(56).toInt()), toByte($receiver.shiftRightUnsigned(48).toInt()), toByte($receiver.shiftRightUnsigned(40).toInt()), toByte($receiver.shiftRightUnsigned(32).toInt()), toByte($receiver.shiftRightUnsigned(24).toInt()), toByte($receiver.shiftRightUnsigned(16).toInt()), toByte($receiver.shiftRightUnsigned(8).toInt()), toByte($receiver.toInt()));
  };
  BigEndian$Companion.prototype.bytesToShort_5gdoe6$ = function (b0, b1) {
    return toShort((b0 & 255) << 8 | b1 & 255);
  };
  BigEndian$Companion.prototype.bytesToInt_sz6or4$ = function (b0, b1, b2, b3) {
    return b0 << 24 | (b1 & 255) << 16 | (b2 & 255) << 8 | b3 & 255;
  };
  BigEndian$Companion.prototype.bytesToLong_uwl3p0$ = function (b0, b1, b2, b3, b4, b5, b6, b7) {
    var hi = this.bytesToInt_sz6or4$(b0, b1, b2, b3);
    var lo = this.bytesToInt_sz6or4$(b4, b5, b6, b7);
    return Kotlin.Long.fromInt(hi).and(L4294967295).shiftLeft(32).or(Kotlin.Long.fromInt(lo).and(L4294967295));
  };
  BigEndian$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var BigEndian$Companion_instance = null;
  function BigEndian$Companion_getInstance() {
    if (BigEndian$Companion_instance === null) {
      new BigEndian$Companion();
    }
    return BigEndian$Companion_instance;
  }
  BigEndian.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BigEndian',
    interfaces: []
  };
  function BigEndian_init(b0, b1, $this) {
    $this = $this || Object.create(BigEndian.prototype);
    var $receiver = new Int8Array(2);
    $receiver[0] = b0;
    $receiver[1] = b1;
    BigEndian.call($this, $receiver);
    return $this;
  }
  function BigEndian_init_0(b0, b1, b2, b3, $this) {
    $this = $this || Object.create(BigEndian.prototype);
    var $receiver = new Int8Array(4);
    $receiver[0] = b0;
    $receiver[1] = b1;
    $receiver[2] = b2;
    $receiver[3] = b3;
    BigEndian.call($this, $receiver);
    return $this;
  }
  function BigEndian_init_1(b0, b1, b2, b3, b4, b5, b6, b7, $this) {
    $this = $this || Object.create(BigEndian.prototype);
    var $receiver = new Int8Array(8);
    $receiver[0] = b0;
    $receiver[1] = b1;
    $receiver[2] = b2;
    $receiver[3] = b3;
    $receiver[4] = b4;
    $receiver[5] = b5;
    $receiver[6] = b6;
    $receiver[7] = b7;
    BigEndian.call($this, $receiver);
    return $this;
  }
  BigEndian.prototype.unbox = function () {
    return this.data_0;
  };
  BigEndian.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.data_0) | 0;
    return result;
  };
  BigEndian.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.data_0, other.data_0))));
  };
  function LittleEndian(data) {
    LittleEndian$Companion_getInstance();
    this.data_0 = data;
  }
  LittleEndian.prototype.get_za3lpa$ = function (index) {
    return this.data_0[index];
  };
  LittleEndian.prototype.getOrNull_za3lpa$ = function (index) {
    return getOrNull(this.data_0, index);
  };
  LittleEndian.prototype.getOrElse_80wqxd$ = function (index, defaultValue) {
    var $receiver = this.data_0;
    return index >= 0 && index <= get_lastIndex($receiver) ? $receiver[index] : defaultValue(index);
  };
  LittleEndian.prototype.plus_fqrh44$ = function (other) {
    return primitiveArrayConcat(this.data_0, other);
  };
  Object.defineProperty(LittleEndian.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.data_0.length;
    }
  });
  Object.defineProperty(LittleEndian.prototype, 'sizeBits', {
    configurable: true,
    get: function () {
      return this.size * 8 | 0;
    }
  });
  LittleEndian.prototype.iterator = function () {
    return Kotlin.byteArrayIterator(this.data_0);
  };
  LittleEndian.prototype.copyInto_elxobu$ = function (destination, destinationOffset, startIndex, endIndex) {
    if (destinationOffset === void 0)
      destinationOffset = 0;
    if (startIndex === void 0)
      startIndex = 0;
    if (endIndex === void 0)
      endIndex = this.size;
    arrayCopy(this.data_0, destination, destinationOffset, startIndex, endIndex);
    return destination;
  };
  LittleEndian.prototype.toByteArray = function () {
    return this.data_0.slice();
  };
  LittleEndian.prototype.toByte = function () {
    return first(this.data_0);
  };
  LittleEndian.prototype.toShort = function () {
    return numberToShort(this.toNumber_0());
  };
  LittleEndian.prototype.toInt = function () {
    return numberToInt(this.toNumber_0());
  };
  LittleEndian.prototype.toLong = function () {
    return numberToLong(this.toNumber_0());
  };
  LittleEndian.prototype.toBigEndian = function () {
    var tmp$;
    switch (this.size) {
      case 2:
        tmp$ = BigEndian_init(this.data_0[1], this.data_0[0]);
        break;
      case 4:
        tmp$ = BigEndian_init_0(this.data_0[3], this.data_0[2], this.data_0[1], this.data_0[0]);
        break;
      default:
        tmp$ = BigEndian_init_1(this.data_0[7], this.data_0[6], this.data_0[5], this.data_0[4], this.data_0[3], this.data_0[2], this.data_0[1], this.data_0[0]);
        break;
    }
    return tmp$;
  };
  LittleEndian.prototype.toString = function () {
    return 'LE' + toList(this.data_0);
  };
  LittleEndian.prototype.toNumber_0 = function () {
    var tmp$;
    switch (this.size) {
      case 2:
        tmp$ = LittleEndian$Companion_getInstance().bytesToShort_5gdoe6$(this.data_0[0], this.data_0[1]);
        break;
      case 4:
        tmp$ = LittleEndian$Companion_getInstance().bytesToInt_sz6or4$(this.data_0[0], this.data_0[1], this.data_0[2], this.data_0[3]);
        break;
      default:
        tmp$ = LittleEndian$Companion_getInstance().bytesToLong_uwl3p0$(this.data_0[0], this.data_0[1], this.data_0[2], this.data_0[3], this.data_0[4], this.data_0[5], this.data_0[6], this.data_0[7]);
        break;
    }
    return tmp$;
  };
  function LittleEndian$Companion() {
    LittleEndian$Companion_instance = this;
  }
  LittleEndian$Companion.prototype.toLittleEndian_5vcgdc$ = function ($receiver) {
    return LittleEndian_init(toByte($receiver), toByte($receiver >>> 8));
  };
  LittleEndian$Companion.prototype.toLittleEndian_s8ev3n$ = function ($receiver) {
    return LittleEndian_init_0(toByte($receiver), toByte($receiver >>> 8), toByte($receiver >>> 16), toByte($receiver >>> 24));
  };
  LittleEndian$Companion.prototype.toLittleEndian_mts6qi$ = function ($receiver) {
    return LittleEndian_init_1(toByte($receiver.toInt()), toByte($receiver.shiftRightUnsigned(8).toInt()), toByte($receiver.shiftRightUnsigned(16).toInt()), toByte($receiver.shiftRightUnsigned(24).toInt()), toByte($receiver.shiftRightUnsigned(32).toInt()), toByte($receiver.shiftRightUnsigned(40).toInt()), toByte($receiver.shiftRightUnsigned(48).toInt()), toByte($receiver.shiftRightUnsigned(56).toInt()));
  };
  LittleEndian$Companion.prototype.bytesToShort_5gdoe6$ = function (b0, b1) {
    return toShort(b0 & 255 | (b1 & 255) << 8);
  };
  LittleEndian$Companion.prototype.bytesToInt_sz6or4$ = function (b0, b1, b2, b3) {
    return b0 & 255 | (b1 & 255) << 8 | (b2 & 255) << 16 | b3 << 24;
  };
  LittleEndian$Companion.prototype.bytesToLong_uwl3p0$ = function (b0, b1, b2, b3, b4, b5, b6, b7) {
    var lo = this.bytesToInt_sz6or4$(b0, b1, b2, b3);
    var hi = this.bytesToInt_sz6or4$(b4, b5, b6, b7);
    return Kotlin.Long.fromInt(hi).and(L4294967295).shiftLeft(32).or(Kotlin.Long.fromInt(lo).and(L4294967295));
  };
  LittleEndian$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var LittleEndian$Companion_instance = null;
  function LittleEndian$Companion_getInstance() {
    if (LittleEndian$Companion_instance === null) {
      new LittleEndian$Companion();
    }
    return LittleEndian$Companion_instance;
  }
  LittleEndian.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LittleEndian',
    interfaces: []
  };
  function LittleEndian_init(b0, b1, $this) {
    $this = $this || Object.create(LittleEndian.prototype);
    var $receiver = new Int8Array(2);
    $receiver[0] = b0;
    $receiver[1] = b1;
    LittleEndian.call($this, $receiver);
    return $this;
  }
  function LittleEndian_init_0(b0, b1, b2, b3, $this) {
    $this = $this || Object.create(LittleEndian.prototype);
    var $receiver = new Int8Array(4);
    $receiver[0] = b0;
    $receiver[1] = b1;
    $receiver[2] = b2;
    $receiver[3] = b3;
    LittleEndian.call($this, $receiver);
    return $this;
  }
  function LittleEndian_init_1(b0, b1, b2, b3, b4, b5, b6, b7, $this) {
    $this = $this || Object.create(LittleEndian.prototype);
    var $receiver = new Int8Array(8);
    $receiver[0] = b0;
    $receiver[1] = b1;
    $receiver[2] = b2;
    $receiver[3] = b3;
    $receiver[4] = b4;
    $receiver[5] = b5;
    $receiver[6] = b6;
    $receiver[7] = b7;
    LittleEndian.call($this, $receiver);
    return $this;
  }
  LittleEndian.prototype.unbox = function () {
    return this.data_0;
  };
  LittleEndian.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.data_0) | 0;
    return result;
  };
  LittleEndian.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.data_0, other.data_0))));
  };
  var package$org = _.org || (_.org = {});
  var package$kotlincrypto = package$org.kotlincrypto || (package$org.kotlincrypto = {});
  var package$endians = package$kotlincrypto.endians || (package$kotlincrypto.endians = {});
  package$endians.plus_jmprgu$ = plus;
  package$endians.plus_zdh132$ = plus_0;
  Object.defineProperty(BigEndian, 'Companion', {
    get: BigEndian$Companion_getInstance
  });
  package$endians.BigEndian_init_5gdoe6$ = BigEndian_init;
  package$endians.BigEndian_init_sz6or4$ = BigEndian_init_0;
  package$endians.BigEndian_init_uwl3p0$ = BigEndian_init_1;
  package$endians.BigEndian = BigEndian;
  Object.defineProperty(LittleEndian, 'Companion', {
    get: LittleEndian$Companion_getInstance
  });
  package$endians.LittleEndian_init_5gdoe6$ = LittleEndian_init;
  package$endians.LittleEndian_init_sz6or4$ = LittleEndian_init_0;
  package$endians.LittleEndian_init_uwl3p0$ = LittleEndian_init_1;
  package$endians.LittleEndian = LittleEndian;
  Kotlin.defineModule('endians-endians-js-legacy', _);
  return _;
}));

//# sourceMappingURL=endians-endians-js-legacy.js.map
