/*
 * Copyright (c) 2025 KotlinCrypto
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/
@file:Suppress("EXPECT_ACTUAL_CLASSIFIERS_ARE_IN_BETA_WARNING")

package org.kotlincrypto.error

/**
 * The `KeyException` class is a generic security exception class that provides type safety for all
 * the key-related exception classes that extend from it.
 * */
public actual open class KeyException: GeneralSecurityException {
    public actual constructor(): super()
    public actual constructor(message: String?): super(message)
    public actual constructor(message: String?, cause: Throwable?): super(message, cause)
    public actual constructor(cause: Throwable?): super(cause)
}
