/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.blake2;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kotlincrypto.bitops.bits.Counter;
import org.kotlincrypto.bitops.endian.Endian;
import org.kotlincrypto.core.digest.Digest;
import org.kotlincrypto.hash.blake2.internal.Bit32Message;
import org.kotlincrypto.hash.blake2.internal.Bit64Message;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0018\u0019\u001aBs\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0014B\u000f\b\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0000H&R\u0010\u0010\u000b\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/kotlincrypto/hash/blake2/BLAKE2Digest;", "Lorg/kotlincrypto/core/digest/Digest;", "variant", "", "blockSize", "", "bitStrength", "isLastNode", "", "keyLength", "fanOut", "depth", "leafLength", "nodeOffset", "", "nodeDepth", "innerLength", "salt", "", "personalization", "(Ljava/lang/String;IIZIIIIJII[B[B)V", "other", "(Lorg/kotlincrypto/hash/blake2/BLAKE2Digest;)V", "copy", "Bit32", "Bit64", "Companion", "Lorg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit32;", "Lorg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit64;", "org.kotlincrypto.hash_blake2_jvm"})
@SourceDebugExtension(value={"SMAP\nBLAKE2Digest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BLAKE2Digest.kt\norg/kotlincrypto/hash/blake2/BLAKE2Digest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,680:1\n1#2:681\n*E\n"})
public abstract class BLAKE2Digest
extends Digest {
    @NotNull
    private static final Companion Companion;
    @JvmField
    protected final boolean isLastNode;
    @JvmField
    protected final int keyLength;
    @JvmField
    protected final int fanOut;
    @JvmField
    protected final int depth;
    @JvmField
    protected final int leafLength;
    @JvmField
    protected final long nodeOffset;
    @JvmField
    protected final int nodeDepth;
    @JvmField
    protected final int innerLength;
    @JvmField
    @Nullable
    protected final byte[] salt;
    @JvmField
    @Nullable
    protected final byte[] personalization;
    @NotNull
    private static final byte[][] SIGMA;

    private BLAKE2Digest(String variant, int blockSize, int bitStrength, boolean isLastNode, int keyLength, int fanOut, int depth, int leafLength, long nodeOffset, int nodeDepth, int innerLength, byte[] salt, byte[] personalization) throws IllegalArgumentException {
        super("BLAKE2" + variant + '-' + bitStrength, blockSize, bitStrength / 8);
        byte[] byArray;
        byte[] byArray2;
        if (!(bitStrength <= blockSize * 4)) {
            boolean $i$a$-require-BLAKE2Digest$42 = false;
            String $i$a$-require-BLAKE2Digest$42 = "bitStrength must be less than or equal to " + blockSize * 4;
            throw new IllegalArgumentException($i$a$-require-BLAKE2Digest$42.toString());
        }
        if (!(bitStrength >= 8)) {
            boolean $i$a$-require-BLAKE2Digest$52 = false;
            String $i$a$-require-BLAKE2Digest$52 = "bitStrength must be greater than or equal to 8";
            throw new IllegalArgumentException($i$a$-require-BLAKE2Digest$52.toString());
        }
        if (!(bitStrength % 8 == 0)) {
            boolean $i$a$-require-BLAKE2Digest$92 = false;
            String $i$a$-require-BLAKE2Digest$92 = "bitStrength must be a factor of 8";
            throw new IllegalArgumentException($i$a$-require-BLAKE2Digest$92.toString());
        }
        int size = blockSize / 2;
        boolean bl = false;
        if (!(0 <= keyLength ? keyLength <= size : false)) {
            boolean $i$a$-require-BLAKE2Digest$4$32 = false;
            String $i$a$-require-BLAKE2Digest$4$32 = "keyLength must be between 0 and " + size + " (inclusive)";
            throw new IllegalArgumentException($i$a$-require-BLAKE2Digest$4$32.toString());
        }
        if (!(0 <= innerLength ? innerLength <= size : false)) {
            boolean $i$a$-require-BLAKE2Digest$4$42 = false;
            String $i$a$-require-BLAKE2Digest$4$42 = "innerLength must be between 0 and " + size + " (inclusive)";
            throw new IllegalArgumentException($i$a$-require-BLAKE2Digest$4$42.toString());
        }
        size = blockSize / 8;
        boolean bl2 = false;
        if (salt != null && !(salt.length == size)) {
            boolean $i$a$-require-BLAKE2Digest$5$32 = false;
            String $i$a$-require-BLAKE2Digest$5$32 = "salt must be exactly " + size + " bytes";
            throw new IllegalArgumentException($i$a$-require-BLAKE2Digest$5$32.toString());
        }
        if (personalization != null && !(personalization.length == size)) {
            boolean bl3 = false;
            String string = "personalization must be exactly " + size + " bytes";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= fanOut ? fanOut < 256 : false)) {
            boolean $i$a$-require-BLAKE2Digest$102 = false;
            String $i$a$-require-BLAKE2Digest$102 = "fanOut must be between 0 and 255 (inclusive)";
            throw new IllegalArgumentException($i$a$-require-BLAKE2Digest$102.toString());
        }
        if (!(1 <= depth ? depth < 256 : false)) {
            boolean $i$a$-require-BLAKE2Digest$112 = false;
            String $i$a$-require-BLAKE2Digest$112 = "depth must be between 1 and 255 (inclusive)";
            throw new IllegalArgumentException($i$a$-require-BLAKE2Digest$112.toString());
        }
        if (!(0 <= nodeDepth ? nodeDepth < 256 : false)) {
            boolean bl4 = false;
            String string = "nodeDepth must be between 1 and 255 (inclusive)";
            throw new IllegalArgumentException(string.toString());
        }
        this.isLastNode = isLastNode;
        this.keyLength = keyLength;
        this.fanOut = fanOut;
        this.depth = depth;
        this.leafLength = leafLength;
        this.nodeOffset = nodeOffset;
        this.nodeDepth = nodeDepth;
        this.innerLength = innerLength;
        if (salt != null) {
            byte[] byArray3 = Arrays.copyOf(salt, salt.length);
            byArray2 = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
        } else {
            byArray2 = this.salt = null;
        }
        if (personalization != null) {
            byte[] byArray4 = Arrays.copyOf(personalization, personalization.length);
            byArray = byArray4;
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"copyOf(...)");
        } else {
            byArray = null;
        }
        this.personalization = byArray;
    }

    private BLAKE2Digest(BLAKE2Digest other) {
        super((Digest)other);
        byte[] byArray;
        this.isLastNode = other.isLastNode;
        this.keyLength = other.keyLength;
        this.fanOut = other.fanOut;
        this.depth = other.depth;
        this.leafLength = other.leafLength;
        this.nodeOffset = other.nodeOffset;
        this.nodeDepth = other.nodeDepth;
        this.innerLength = other.innerLength;
        if (other.salt != null) {
            byte[] byArray2 = Arrays.copyOf(other.salt, other.salt.length);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        } else {
            byte[] cfr_ignored_0 = other.salt;
            byArray = null;
        }
        this.salt = byArray;
        this.personalization = other.personalization;
    }

    @NotNull
    public abstract BLAKE2Digest copy();

    public /* synthetic */ BLAKE2Digest(String variant, int blockSize, int bitStrength, boolean isLastNode, int keyLength, int fanOut, int depth, int leafLength, long nodeOffset, int nodeDepth, int innerLength, byte[] salt, byte[] personalization, DefaultConstructorMarker $constructor_marker) {
        this(variant, blockSize, bitStrength, isLastNode, keyLength, fanOut, depth, leafLength, nodeOffset, nodeDepth, innerLength, salt, personalization);
    }

    public /* synthetic */ BLAKE2Digest(BLAKE2Digest other, DefaultConstructorMarker $constructor_marker) {
        this(other);
    }

    static {
        Companion $this$SIGMA_u24lambda_u2412 = Companion = new Companion(null);
        boolean bl = false;
        byte[] byArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        byte[] s0 = byArray;
        Object object = new byte[]{14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3};
        byte[] s1 = object;
        object = new byte[12][];
        object[0] = (byte)s0;
        object[1] = (byte)s1;
        byte[] byArray2 = new byte[]{11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4};
        object[2] = (byte)byArray2;
        byArray2 = new byte[]{7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8};
        object[3] = (byte)byArray2;
        byArray2 = new byte[]{9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13};
        object[4] = (byte)byArray2;
        byArray2 = new byte[]{2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9};
        object[5] = (byte)byArray2;
        byArray2 = new byte[]{12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11};
        object[6] = (byte)byArray2;
        byArray2 = new byte[]{13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10};
        object[7] = (byte)byArray2;
        byArray2 = new byte[]{6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5};
        object[8] = (byte)byArray2;
        byArray2 = new byte[]{10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0};
        object[9] = (byte)byArray2;
        object[10] = (byte)s0;
        object[11] = (byte)s1;
        SIGMA = (byte[][])object;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 62\u00020\u0001:\u00016Bk\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0013B\u000f\b\u0014\u0012\u0006\u0010\u0014\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0015JC\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0082\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%JA\u0010&\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0082\bJ\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u0005H\u0014J\b\u00100\u001a\u00020\u0000H&J\u0018\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0005H\u0014J\b\u00104\u001a\u00020\u001fH\u0014J\r\u00105\u001a\u00020\u0017*\u00020\u0017H\u0082\bR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u00017\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00068"}, d2={"Lorg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit32;", "Lorg/kotlincrypto/hash/blake2/BLAKE2Digest;", "variant", "", "bitStrength", "", "isLastNode", "", "keyLength", "fanOut", "depth", "leafLength", "nodeOffset", "", "nodeDepth", "innerLength", "salt", "", "personalization", "(Ljava/lang/String;IZIIIIJII[B[B)V", "other", "(Lorg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit32;)V", "h", "", "m", "Lorg/kotlincrypto/hash/blake2/internal/Bit32Message;", "[I", "t", "Lorg/kotlincrypto/bitops/bits/Counter$Bit32;", "v", "F", "", "tLo", "tHi", "f0", "f1", "F-9gdSZJ4", "([I[IIIII)V", "G", "a", "b", "c", "d", "x", "y", "compressProtected", "input", "offset", "copy", "digestProtected", "buf", "bufPos", "resetProtected", "initialize", "Companion", "Lorg/kotlincrypto/hash/blake2/BLAKE2s;", "org.kotlincrypto.hash_blake2_jvm"})
    @SourceDebugExtension(value={"SMAP\nBLAKE2Digest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BLAKE2Digest.kt\norg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit32\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Endian.kt\norg/kotlincrypto/bitops/endian/Endian$Little\n+ 4 -Message.kt\norg/kotlincrypto/hash/blake2/internal/_MessageKt\n*L\n1#1,680:1\n254#1,26:682\n280#1,13:709\n199#1,16:723\n232#1,19:740\n215#1:759\n232#1,19:760\n216#1:779\n232#1,19:780\n217#1:799\n232#1,19:800\n219#1:819\n232#1,19:820\n220#1:839\n232#1,19:840\n221#1:859\n232#1,19:860\n222#1,29:879\n199#1,16:911\n232#1,19:928\n215#1:947\n232#1,19:948\n216#1:967\n232#1,19:968\n217#1:987\n232#1,19:988\n219#1:1007\n232#1,19:1008\n220#1:1027\n232#1,19:1028\n221#1:1047\n232#1,19:1048\n222#1,29:1067\n232#1,19:1099\n232#1,19:1119\n232#1,19:1139\n232#1,19:1159\n232#1,19:1179\n232#1,19:1199\n232#1,19:1219\n232#1,19:1239\n254#1,26:1262\n280#1,13:1289\n1#2:681\n2091#3:708\n2267#3:909\n2258#3:1096\n2249#3:1097\n2091#3:1258\n2091#3:1259\n2091#3:1260\n2091#3:1261\n2091#3:1288\n40#4:722\n37#4:739\n47#4:908\n48#4:910\n37#4:927\n37#4:1098\n37#4:1118\n37#4:1138\n37#4:1158\n37#4:1178\n37#4:1198\n37#4:1218\n37#4:1238\n43#4:1302\n*S KotlinDebug\n*F\n+ 1 BLAKE2Digest.kt\norg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit32\n*L\n107#1:682,26\n107#1:709,13\n141#1:723,16\n141#1:740,19\n141#1:759\n141#1:760,19\n141#1:779\n141#1:780,19\n141#1:799\n141#1:800,19\n141#1:819\n141#1:820,19\n141#1:839\n141#1:840,19\n141#1:859\n141#1:860,19\n141#1:879,29\n173#1:911,16\n173#1:928,19\n173#1:947\n173#1:948,19\n173#1:967\n173#1:968,19\n173#1:987\n173#1:988,19\n173#1:1007\n173#1:1008,19\n173#1:1027\n173#1:1028,19\n173#1:1047\n173#1:1048,19\n173#1:1067,29\n214#1:1099,19\n215#1:1119,19\n216#1:1139,19\n217#1:1159,19\n219#1:1179,19\n220#1:1199,19\n221#1:1219,19\n222#1:1239,19\n297#1:1262,26\n297#1:1289,13\n107#1:708\n144#1:909\n179#1:1096\n187#1:1097\n279#1:1258\n280#1:1259\n288#1:1260\n289#1:1261\n297#1:1288\n115#1:722\n141#1:739\n144#1:908\n144#1:910\n173#1:927\n214#1:1098\n215#1:1118\n216#1:1138\n217#1:1158\n219#1:1178\n220#1:1198\n221#1:1218\n222#1:1238\n298#1:1302\n*E\n"})
    public static abstract class Bit32
    extends BLAKE2Digest {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final int[] v;
        @NotNull
        private final int[] h;
        @Nullable
        private int[] m;
        @NotNull
        private final Counter.Bit32 t;
        private static final long MAX_NODE_OFFSET = 0xFFFFFFFFFFFFL;
        private static final int BLOCK_SIZE = 64;
        private static final int ROUND_COUNT = 10;
        private static final int R1 = 16;
        private static final int R2 = 12;
        private static final int R3 = 8;
        private static final int R4 = 7;
        @NotNull
        private static final int[] IV;

        /*
         * WARNING - void declaration
         */
        private Bit32(String variant, int bitStrength, boolean isLastNode, int keyLength, int fanOut, int depth, int leafLength, long nodeOffset, int nodeDepth, int innerLength, byte[] salt, byte[] personalization) throws IllegalArgumentException {
            super(variant, 64, bitStrength, isLastNode, keyLength, fanOut, depth, leafLength, nodeOffset, nodeDepth, innerLength, salt, personalization, null);
            byte[] $this$leIntAt$iv$iv;
            boolean $i$f$leIntAt;
            int offset$iv$iv;
            void this_$iv;
            if (!(0L <= nodeOffset ? nodeOffset < 0x1000000000000L : false)) {
                boolean $i$a$-require-BLAKE2Digest$Bit32$22 = false;
                String $i$a$-require-BLAKE2Digest$Bit32$22 = "nodeOffset must be between 0 and 281474976710655 (inclusive)";
                throw new IllegalArgumentException($i$a$-require-BLAKE2Digest$Bit32$22.toString());
            }
            this.v = new int[16];
            Bit32 bit32 = this;
            int[] $this$initialize$iv = new int[8];
            boolean $i$f$initialize = false;
            int[] iv$iv = IV;
            byte[] salt$iv = this_$iv.salt;
            byte[] personalization$iv = this_$iv.personalization;
            $this$initialize$iv[0] = iv$iv[0] ^ (this_$iv.digestLength() | this_$iv.keyLength << 8 | this_$iv.fanOut << 16 | this_$iv.depth << 24);
            $this$initialize$iv[1] = iv$iv[1] ^ this_$iv.leafLength;
            $this$initialize$iv[2] = iv$iv[2] ^ (int)this_$iv.nodeOffset;
            $this$initialize$iv[3] = iv$iv[3] ^ ((int)(this_$iv.nodeOffset >> 32) | this_$iv.nodeDepth << 16 | this_$iv.innerLength << 24);
            if (salt$iv == null) {
                $this$initialize$iv[4] = iv$iv[4];
                $this$initialize$iv[5] = iv$iv[5];
            } else {
                byte[] byArray = salt$iv;
                offset$iv$iv = 0;
                $i$f$leIntAt = false;
                $this$initialize$iv[4] = iv$iv[4] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv$iv, offset$iv$iv);
                $this$leIntAt$iv$iv = salt$iv;
                offset$iv$iv = 4;
                $i$f$leIntAt = false;
                $this$initialize$iv[5] = iv$iv[5] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv$iv, offset$iv$iv);
            }
            if (personalization$iv == null) {
                $this$initialize$iv[6] = iv$iv[6];
                $this$initialize$iv[7] = iv$iv[7];
            } else {
                $this$leIntAt$iv$iv = personalization$iv;
                offset$iv$iv = 0;
                $i$f$leIntAt = false;
                $this$initialize$iv[6] = iv$iv[6] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv$iv, offset$iv$iv);
                $this$leIntAt$iv$iv = personalization$iv;
                offset$iv$iv = 4;
                $i$f$leIntAt = false;
                $this$initialize$iv[7] = iv$iv[7] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv$iv, offset$iv$iv);
            }
            this.h = $this$initialize$iv;
            this.m = null;
            this.t = new Counter.Bit32(64);
        }

        private Bit32(Bit32 other) {
            super(other, null);
            int[] nArray;
            int[] nArray2 = Arrays.copyOf(other.v, other.v.length);
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
            this.v = nArray2;
            int[] nArray3 = Arrays.copyOf(other.h, other.h.length);
            Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"copyOf(...)");
            this.h = nArray3;
            if (other.m != null) {
                int[] $this$copy_u2dihukYOo$iv = other.m;
                boolean bl = false;
                int[] nArray4 = Arrays.copyOf($this$copy_u2dihukYOo$iv, $this$copy_u2dihukYOo$iv.length);
                Intrinsics.checkNotNullExpressionValue((Object)nArray4, (String)"copyOf(...)");
                nArray = Bit32Message.constructor-impl(nArray4);
            } else {
                nArray = null;
            }
            this.m = nArray;
            this.t = other.t.copy();
        }

        @Override
        @NotNull
        public abstract Bit32 copy();

        /*
         * WARNING - void declaration
         */
        protected void compressProtected(@NotNull byte[] input, int offset) {
            void destOffset$iv$iv;
            void dest$iv$iv;
            void $this$lePackIntoUnsafe$iv$iv;
            int i$iv;
            boolean f0$iv;
            void tHi$iv22;
            void tLo$iv22;
            void h$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int[] m = this.m;
            if (m == null) {
                this.m = Bit32Message.constructor-impl(input, offset);
                return;
            }
            this.t.increment();
            Bit32 bit32 = this;
            int[] nArray = this.h;
            int n = this.t.lo();
            int n2 = this.t.hi();
            boolean bl = false;
            int f1$iv = 0;
            boolean bl2 = false;
            int[] iv$iv = IV;
            int[] v$iv = this_$iv.v;
            ArraysKt.copyInto$default((int[])h$iv, (int[])v$iv, (int)0, (int)0, (int)0, (int)14, null);
            ArraysKt.copyInto((int[])iv$iv, (int[])v$iv, (int)((void)h$iv).length, (int)0, (int)4);
            v$iv[12] = tLo$iv22 ^ iv$iv[4];
            v$iv[13] = tHi$iv22 ^ iv$iv[5];
            v$iv[14] = f0$iv ^ iv$iv[6];
            v$iv[15] = f1$iv ^ iv$iv[7];
            byte[][] s$iv = SIGMA;
            for (i$iv = 0; i$iv < 10; ++i$iv) {
                void x$iv$iv;
                void x$iv$iv82;
                void x$iv$iv72;
                void x$iv$iv62;
                void x$iv$iv52;
                void x$iv$iv42;
                void x$iv$iv32;
                void y$iv$iv;
                void x$iv$iv22;
                int d$iv$iv;
                int c$iv$iv;
                int b$iv$iv;
                int a$iv$iv;
                void $this$get_u2d_uwh3YE$iv$iv;
                void $this$get_u2d_uwh3YE$iv$iv2;
                void var15_18 = this_$iv;
                boolean bl3 = false;
                int n3 = 4;
                int n4 = 8;
                int n5 = 12;
                int[] nArray2 = m;
                byte sigmaByte$iv$iv22 = s$iv[i$iv][0];
                boolean bl4 = false;
                $this$get_u2d_uwh3YE$iv$iv2 = $this$get_u2d_uwh3YE$iv$iv2[sigmaByte$iv$iv22];
                int[] sigmaByte$iv$iv22 = m;
                byte sigmaByte$iv$iv = s$iv[i$iv][1];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                boolean $i$f$G = false;
                int va$iv$iv = v$iv[a$iv$iv];
                int vb$iv$iv = v$iv[b$iv$iv];
                int vc$iv$iv = v$iv[c$iv$iv];
                int vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv22;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                void this_$iv$iv = this_$iv;
                a$iv$iv = 1;
                b$iv$iv = 5;
                c$iv$iv = 9;
                d$iv$iv = 13;
                int[] x$iv$iv22 = m;
                byte sigmaByte$iv$iv32 = s$iv[i$iv][2];
                bl4 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv32];
                int[] sigmaByte$iv$iv32 = m;
                sigmaByte$iv$iv = s$iv[i$iv][3];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv32;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 2;
                b$iv$iv = 6;
                c$iv$iv = 10;
                d$iv$iv = 14;
                int[] x$iv$iv32 = m;
                byte sigmaByte$iv$iv42 = s$iv[i$iv][4];
                bl4 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv42];
                int[] sigmaByte$iv$iv42 = m;
                sigmaByte$iv$iv = s$iv[i$iv][5];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv42;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 3;
                b$iv$iv = 7;
                c$iv$iv = 11;
                d$iv$iv = 15;
                int[] x$iv$iv42 = m;
                byte sigmaByte$iv$iv52 = s$iv[i$iv][6];
                bl4 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv52];
                int[] sigmaByte$iv$iv52 = m;
                sigmaByte$iv$iv = s$iv[i$iv][7];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv52;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 0;
                b$iv$iv = 5;
                c$iv$iv = 10;
                d$iv$iv = 15;
                int[] x$iv$iv52 = m;
                byte sigmaByte$iv$iv62 = s$iv[i$iv][8];
                bl4 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv62];
                int[] sigmaByte$iv$iv62 = m;
                sigmaByte$iv$iv = s$iv[i$iv][9];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv62;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 1;
                b$iv$iv = 6;
                c$iv$iv = 11;
                d$iv$iv = 12;
                int[] x$iv$iv62 = m;
                byte sigmaByte$iv$iv72 = s$iv[i$iv][10];
                bl4 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv72];
                int[] sigmaByte$iv$iv72 = m;
                sigmaByte$iv$iv = s$iv[i$iv][11];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv72;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 2;
                b$iv$iv = 7;
                c$iv$iv = 8;
                d$iv$iv = 13;
                int[] x$iv$iv72 = m;
                byte sigmaByte$iv$iv82 = s$iv[i$iv][12];
                bl4 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv82];
                int[] sigmaByte$iv$iv82 = m;
                sigmaByte$iv$iv = s$iv[i$iv][13];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv82;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 3;
                b$iv$iv = 4;
                c$iv$iv = 9;
                d$iv$iv = 14;
                int[] x$iv$iv82 = m;
                byte sigmaByte$iv$iv92 = s$iv[i$iv][14];
                bl4 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv92];
                int[] sigmaByte$iv$iv92 = m;
                sigmaByte$iv$iv = s$iv[i$iv][15];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
            }
            for (i$iv = 0; i$iv < 8; ++i$iv) {
                h$iv[i$iv] = h$iv[i$iv] ^ v$iv[i$iv] ^ v$iv[i$iv + 8];
            }
            int[] $this$populate_u2dZE951QY$iv = m;
            boolean bl5 = false;
            byte[] tLo$iv22 = input;
            int[] tHi$iv22 = $this$populate_u2dZE951QY$iv;
            f0$iv = false;
            int sourceIndexEnd$iv$iv = offset + 64;
            boolean $i$f$lePackIntoUnsafe = false;
            Endian.Little.INSTANCE.packUnsafe((byte[])$this$lePackIntoUnsafe$iv$iv, (int[])dest$iv$iv, (int)destOffset$iv$iv, offset, sourceIndexEnd$iv$iv);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected byte[] digestProtected(@NotNull byte[] buf, int bufPos) {
            void sourceIndexStart$iv;
            boolean destOffset$iv;
            void dest$iv2;
            void $this$lePackIntoUnsafe$iv2;
            int i$iv;
            void f0$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int[] m = this.m;
            if (m != null) {
                if (bufPos == 0) {
                    this.t.increment();
                } else {
                    this.compressProtected(buf, 0);
                }
            } else {
                this.m = m = Bit32Message.constructor-impl(buf, 0);
            }
            Counter.Bit32.Final final_ = this.t.final(bufPos);
            int tLo = final_.component1();
            int tHi = final_.component2();
            int[] h = this.h;
            Bit32 bit32 = this;
            int n = -1;
            int f1$iv = this.isLastNode ? -1 : 0;
            boolean bl = false;
            int[] iv$iv = IV;
            Object[] v$iv = this_$iv.v;
            ArraysKt.copyInto$default((int[])h, (int[])v$iv, (int)0, (int)0, (int)0, (int)14, null);
            ArraysKt.copyInto((int[])iv$iv, (int[])v$iv, (int)h.length, (int)0, (int)4);
            v$iv[12] = tLo ^ iv$iv[4];
            v$iv[13] = tHi ^ iv$iv[5];
            v$iv[14] = f0$iv ^ iv$iv[6];
            v$iv[15] = f1$iv ^ iv$iv[7];
            byte[][] s$iv22 = SIGMA;
            for (i$iv = 0; i$iv < 10; ++i$iv) {
                void x$iv$iv;
                void x$iv$iv82;
                void x$iv$iv72;
                void x$iv$iv62;
                void x$iv$iv52;
                void x$iv$iv42;
                void x$iv$iv32;
                void y$iv$iv;
                void x$iv$iv22;
                int d$iv$iv;
                int c$iv$iv;
                int b$iv$iv;
                int a$iv$iv;
                void $this$get_u2d_uwh3YE$iv$iv;
                void $this$get_u2d_uwh3YE$iv$iv2;
                void var16_21 = this_$iv;
                boolean bl2 = false;
                int n2 = 4;
                int n3 = 8;
                int n4 = 12;
                int[] nArray = m;
                byte sigmaByte$iv$iv22 = s$iv22[i$iv][0];
                boolean bl3 = false;
                $this$get_u2d_uwh3YE$iv$iv2 = $this$get_u2d_uwh3YE$iv$iv2[sigmaByte$iv$iv22];
                int[] sigmaByte$iv$iv22 = m;
                byte sigmaByte$iv$iv = s$iv22[i$iv][1];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                boolean $i$f$G = false;
                int va$iv$iv = v$iv[a$iv$iv];
                int vb$iv$iv = v$iv[b$iv$iv];
                int vc$iv$iv = v$iv[c$iv$iv];
                int vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv22;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                void this_$iv$iv = this_$iv;
                a$iv$iv = 1;
                b$iv$iv = 5;
                c$iv$iv = 9;
                d$iv$iv = 13;
                int[] x$iv$iv22 = m;
                byte sigmaByte$iv$iv32 = s$iv22[i$iv][2];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv32];
                int[] sigmaByte$iv$iv32 = m;
                sigmaByte$iv$iv = s$iv22[i$iv][3];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv32;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 2;
                b$iv$iv = 6;
                c$iv$iv = 10;
                d$iv$iv = 14;
                int[] x$iv$iv32 = m;
                byte sigmaByte$iv$iv42 = s$iv22[i$iv][4];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv42];
                int[] sigmaByte$iv$iv42 = m;
                sigmaByte$iv$iv = s$iv22[i$iv][5];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv42;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 3;
                b$iv$iv = 7;
                c$iv$iv = 11;
                d$iv$iv = 15;
                int[] x$iv$iv42 = m;
                byte sigmaByte$iv$iv52 = s$iv22[i$iv][6];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv52];
                int[] sigmaByte$iv$iv52 = m;
                sigmaByte$iv$iv = s$iv22[i$iv][7];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv52;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 0;
                b$iv$iv = 5;
                c$iv$iv = 10;
                d$iv$iv = 15;
                int[] x$iv$iv52 = m;
                byte sigmaByte$iv$iv62 = s$iv22[i$iv][8];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv62];
                int[] sigmaByte$iv$iv62 = m;
                sigmaByte$iv$iv = s$iv22[i$iv][9];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv62;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 1;
                b$iv$iv = 6;
                c$iv$iv = 11;
                d$iv$iv = 12;
                int[] x$iv$iv62 = m;
                byte sigmaByte$iv$iv72 = s$iv22[i$iv][10];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv72];
                int[] sigmaByte$iv$iv72 = m;
                sigmaByte$iv$iv = s$iv22[i$iv][11];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv72;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 2;
                b$iv$iv = 7;
                c$iv$iv = 8;
                d$iv$iv = 13;
                int[] x$iv$iv72 = m;
                byte sigmaByte$iv$iv82 = s$iv22[i$iv][12];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv82];
                int[] sigmaByte$iv$iv82 = m;
                sigmaByte$iv$iv = s$iv22[i$iv][13];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv82;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 3;
                b$iv$iv = 4;
                c$iv$iv = 9;
                d$iv$iv = 14;
                int[] x$iv$iv82 = m;
                byte sigmaByte$iv$iv92 = s$iv22[i$iv][14];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv92];
                int[] sigmaByte$iv$iv92 = m;
                sigmaByte$iv$iv = s$iv22[i$iv][15];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv$iv = $this$get_u2d_uwh3YE$iv$iv[sigmaByte$iv$iv];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 12);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Integer.rotateRight(vd$iv$iv ^ va$iv$iv, 8);
                vb$iv$iv = Integer.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 7);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
            }
            for (i$iv = 0; i$iv < 8; ++i$iv) {
                h[i$iv] = h[i$iv] ^ v$iv[i$iv] ^ v$iv[i$iv + 8];
            }
            int len = this.innerLength != 0 ? this.innerLength : this.digestLength();
            int rem = len % 4;
            int iHEnd = len / 4;
            iv$iv = h;
            v$iv = new byte[len];
            boolean s$iv22 = false;
            i$iv = 0;
            boolean $i$f$lePackIntoUnsafe = false;
            byte[] out = Endian.Little.INSTANCE.packUnsafe((int[])$this$lePackIntoUnsafe$iv2, (byte[])dest$iv2, destOffset$iv ? 1 : 0, (int)sourceIndexStart$iv, iHEnd);
            if (rem > 0) {
                void sourceIndexStart$iv2;
                void destOffset$iv2;
                int $this$lePackIntoUnsafe$iv2 = h[iHEnd];
                int dest$iv2 = len - rem;
                destOffset$iv = false;
                boolean $i$f$lePackIntoUnsafe2 = false;
                Endian.Little.INSTANCE.packUnsafe($this$lePackIntoUnsafe$iv2, out, (int)destOffset$iv2, (int)sourceIndexStart$iv2, rem);
            }
            return out;
        }

        /*
         * WARNING - void declaration
         */
        private final void F-9gdSZJ4(int[] h, int[] m, int tLo, int tHi, int f0, int f1) {
            int i;
            boolean bl = false;
            int[] iv = IV;
            int[] v = this.v;
            ArraysKt.copyInto$default((int[])h, (int[])v, (int)0, (int)0, (int)0, (int)14, null);
            ArraysKt.copyInto((int[])iv, (int[])v, (int)h.length, (int)0, (int)4);
            v[12] = tLo ^ iv[4];
            v[13] = tHi ^ iv[5];
            v[14] = f0 ^ iv[6];
            v[15] = f1 ^ iv[7];
            byte[][] s = SIGMA;
            for (i = 0; i < 10; ++i) {
                void x$iv;
                void x$iv82;
                void x$iv72;
                void x$iv62;
                void x$iv52;
                void x$iv42;
                void x$iv32;
                void y$iv;
                void x$iv22;
                int d$iv;
                int c$iv;
                int b$iv;
                int a$iv;
                void $this$get_u2d_uwh3YE$iv;
                void $this$get_u2d_uwh3YE$iv2;
                Bit32 bit32 = this;
                boolean bl2 = false;
                int n = 4;
                int n2 = 8;
                int n3 = 12;
                int[] nArray = m;
                byte sigmaByte$iv22 = s[i][0];
                boolean bl3 = false;
                $this$get_u2d_uwh3YE$iv2 = $this$get_u2d_uwh3YE$iv2[sigmaByte$iv22];
                int[] sigmaByte$iv22 = m;
                byte sigmaByte$iv = s[i][1];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv];
                boolean $i$f$G = false;
                int va$iv = v[a$iv];
                int vb$iv = v[b$iv];
                int vc$iv = v[c$iv];
                int vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv22;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 12);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 8);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 7);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                Bit32 this_$iv = this;
                a$iv = 1;
                b$iv = 5;
                c$iv = 9;
                d$iv = 13;
                int[] x$iv22 = m;
                byte sigmaByte$iv32 = s[i][2];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv32];
                int[] sigmaByte$iv32 = m;
                sigmaByte$iv = s[i][3];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv32;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 12);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 8);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 7);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 2;
                b$iv = 6;
                c$iv = 10;
                d$iv = 14;
                int[] x$iv32 = m;
                byte sigmaByte$iv42 = s[i][4];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv42];
                int[] sigmaByte$iv42 = m;
                sigmaByte$iv = s[i][5];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv42;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 12);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 8);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 7);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 3;
                b$iv = 7;
                c$iv = 11;
                d$iv = 15;
                int[] x$iv42 = m;
                byte sigmaByte$iv52 = s[i][6];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv52];
                int[] sigmaByte$iv52 = m;
                sigmaByte$iv = s[i][7];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv52;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 12);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 8);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 7);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 0;
                b$iv = 5;
                c$iv = 10;
                d$iv = 15;
                int[] x$iv52 = m;
                byte sigmaByte$iv62 = s[i][8];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv62];
                int[] sigmaByte$iv62 = m;
                sigmaByte$iv = s[i][9];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv62;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 12);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 8);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 7);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 1;
                b$iv = 6;
                c$iv = 11;
                d$iv = 12;
                int[] x$iv62 = m;
                byte sigmaByte$iv72 = s[i][10];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv72];
                int[] sigmaByte$iv72 = m;
                sigmaByte$iv = s[i][11];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv72;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 12);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 8);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 7);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 2;
                b$iv = 7;
                c$iv = 8;
                d$iv = 13;
                int[] x$iv72 = m;
                byte sigmaByte$iv82 = s[i][12];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv82];
                int[] sigmaByte$iv82 = m;
                sigmaByte$iv = s[i][13];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv82;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 12);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 8);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 7);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 3;
                b$iv = 4;
                c$iv = 9;
                d$iv = 14;
                int[] x$iv82 = m;
                byte sigmaByte$iv92 = s[i][14];
                bl3 = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv92];
                int[] sigmaByte$iv92 = m;
                sigmaByte$iv = s[i][15];
                $i$f$get-_uwh3YE = false;
                $this$get_u2d_uwh3YE$iv = $this$get_u2d_uwh3YE$iv[sigmaByte$iv];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 12);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Integer.rotateRight(vd$iv ^ va$iv, 8);
                vb$iv = Integer.rotateRight(vb$iv ^ (vc$iv += vd$iv), 7);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
            }
            for (i = 0; i < 8; ++i) {
                h[i] = h[i] ^ v[i] ^ v[i + 8];
            }
        }

        private final void G(int[] v, int a, int b, int c, int d, int x, int y) {
            boolean $i$f$G = false;
            int va = v[a];
            int vb = v[b];
            int vc = v[c];
            int vd = v[d];
            va = va + vb + x;
            vd = Integer.rotateRight(vd ^ va, 16);
            vb = Integer.rotateRight(vb ^ (vc += vd), 12);
            va = va + vb + y;
            vd = Integer.rotateRight(vd ^ va, 8);
            vb = Integer.rotateRight(vb ^ (vc += vd), 7);
            v[a] = va;
            v[b] = vb;
            v[c] = vc;
            v[d] = vd;
        }

        private final int[] initialize(int[] $this$initialize) {
            byte[] $this$leIntAt$iv;
            boolean $i$f$leIntAt;
            int offset$iv;
            boolean $i$f$initialize = false;
            int[] iv = IV;
            byte[] salt = this.salt;
            byte[] personalization = this.personalization;
            $this$initialize[0] = iv[0] ^ (this.digestLength() | this.keyLength << 8 | this.fanOut << 16 | this.depth << 24);
            $this$initialize[1] = iv[1] ^ this.leafLength;
            $this$initialize[2] = iv[2] ^ (int)this.nodeOffset;
            $this$initialize[3] = iv[3] ^ ((int)(this.nodeOffset >> 32) | this.nodeDepth << 16 | this.innerLength << 24);
            if (salt == null) {
                $this$initialize[4] = iv[4];
                $this$initialize[5] = iv[5];
            } else {
                byte[] byArray = salt;
                offset$iv = 0;
                $i$f$leIntAt = false;
                $this$initialize[4] = iv[4] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv, offset$iv);
                $this$leIntAt$iv = salt;
                offset$iv = 4;
                $i$f$leIntAt = false;
                $this$initialize[5] = iv[5] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv, offset$iv);
            }
            if (personalization == null) {
                $this$initialize[6] = iv[6];
                $this$initialize[7] = iv[7];
            } else {
                $this$leIntAt$iv = personalization;
                offset$iv = 0;
                $i$f$leIntAt = false;
                $this$initialize[6] = iv[6] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv, offset$iv);
                $this$leIntAt$iv = personalization;
                offset$iv = 4;
                $i$f$leIntAt = false;
                $this$initialize[7] = iv[7] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv, offset$iv);
            }
            return $this$initialize;
        }

        /*
         * WARNING - void declaration
         */
        protected void resetProtected() {
            byte[] $this$leIntAt$iv$iv;
            boolean $i$f$leIntAt;
            int offset$iv$iv;
            void this_$iv;
            ArraysKt.fill$default((int[])this.v, (int)0, (int)0, (int)0, (int)6, null);
            Bit32 bit32 = this;
            int[] $this$initialize$iv = this.h;
            boolean $i$f$initialize = false;
            int[] iv$iv = IV;
            byte[] salt$iv = this_$iv.salt;
            byte[] personalization$iv = this_$iv.personalization;
            $this$initialize$iv[0] = iv$iv[0] ^ (this_$iv.digestLength() | this_$iv.keyLength << 8 | this_$iv.fanOut << 16 | this_$iv.depth << 24);
            $this$initialize$iv[1] = iv$iv[1] ^ this_$iv.leafLength;
            $this$initialize$iv[2] = iv$iv[2] ^ (int)this_$iv.nodeOffset;
            $this$initialize$iv[3] = iv$iv[3] ^ ((int)(this_$iv.nodeOffset >> 32) | this_$iv.nodeDepth << 16 | this_$iv.innerLength << 24);
            if (salt$iv == null) {
                $this$initialize$iv[4] = iv$iv[4];
                $this$initialize$iv[5] = iv$iv[5];
            } else {
                byte[] byArray = salt$iv;
                offset$iv$iv = 0;
                $i$f$leIntAt = false;
                $this$initialize$iv[4] = iv$iv[4] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv$iv, offset$iv$iv);
                $this$leIntAt$iv$iv = salt$iv;
                offset$iv$iv = 4;
                $i$f$leIntAt = false;
                $this$initialize$iv[5] = iv$iv[5] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv$iv, offset$iv$iv);
            }
            if (personalization$iv == null) {
                $this$initialize$iv[6] = iv$iv[6];
                $this$initialize$iv[7] = iv$iv[7];
            } else {
                $this$leIntAt$iv$iv = personalization$iv;
                offset$iv$iv = 0;
                $i$f$leIntAt = false;
                $this$initialize$iv[6] = iv$iv[6] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv$iv, offset$iv$iv);
                $this$leIntAt$iv$iv = personalization$iv;
                offset$iv$iv = 4;
                $i$f$leIntAt = false;
                $this$initialize$iv[7] = iv$iv[7] ^ Endian.Little.INSTANCE.intFrom($this$leIntAt$iv$iv, offset$iv$iv);
            }
            if (this.m != null) {
                int[] $this$fill_u2dihukYOo$iv = this.m;
                boolean bl = false;
                ArraysKt.fill$default((int[])$this$fill_u2dihukYOo$iv, (int)0, (int)0, (int)0, (int)6, null);
            }
            this.m = null;
            this.t.reset();
        }

        public /* synthetic */ Bit32(String variant, int bitStrength, boolean isLastNode, int keyLength, int fanOut, int depth, int leafLength, long nodeOffset, int nodeDepth, int innerLength, byte[] salt, byte[] personalization, DefaultConstructorMarker $constructor_marker) {
            this(variant, bitStrength, isLastNode, keyLength, fanOut, depth, leafLength, nodeOffset, nodeDepth, innerLength, salt, personalization);
        }

        public /* synthetic */ Bit32(Bit32 other, DefaultConstructorMarker $constructor_marker) {
            this(other);
        }

        static {
            int[] nArray = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
            IV = nArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit32$Companion;", "", "()V", "BLOCK_SIZE", "", "IV", "", "MAX_NODE_OFFSET", "", "R1", "R2", "R3", "R4", "ROUND_COUNT", "org.kotlincrypto.hash_blake2_jvm"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 62\u00020\u0001:\u00016Bk\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0013B\u000f\b\u0014\u0012\u0006\u0010\u0014\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0015JC\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0082\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%JA\u0010&\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\rH\u0082\bJ\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u0005H\u0014J\b\u00100\u001a\u00020\u0000H&J\u0018\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0005H\u0014J\b\u00104\u001a\u00020\u001fH\u0014J\r\u00105\u001a\u00020\u0017*\u00020\u0017H\u0082\bR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u00017\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00068"}, d2={"Lorg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit64;", "Lorg/kotlincrypto/hash/blake2/BLAKE2Digest;", "variant", "", "bitStrength", "", "isLastNode", "", "keyLength", "fanOut", "depth", "leafLength", "nodeOffset", "", "nodeDepth", "innerLength", "salt", "", "personalization", "(Ljava/lang/String;IZIIIIJII[B[B)V", "other", "(Lorg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit64;)V", "h", "", "m", "Lorg/kotlincrypto/hash/blake2/internal/Bit64Message;", "[J", "t", "Lorg/kotlincrypto/bitops/bits/Counter$Bit64;", "v", "F", "", "tLo", "tHi", "f0", "f1", "F-dHqpHZs", "([J[JJJJJ)V", "G", "a", "b", "c", "d", "x", "y", "compressProtected", "input", "offset", "copy", "digestProtected", "buf", "bufPos", "resetProtected", "initialize", "Companion", "Lorg/kotlincrypto/hash/blake2/BLAKE2b;", "org.kotlincrypto.hash_blake2_jvm"})
    @SourceDebugExtension(value={"SMAP\nBLAKE2Digest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BLAKE2Digest.kt\norg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit64\n+ 2 Endian.kt\norg/kotlincrypto/bitops/endian/Endian$Little\n+ 3 -Message.kt\norg/kotlincrypto/hash/blake2/internal/_MessageKt\n*L\n1#1,680:1\n512#1,27:681\n539#1,13:709\n457#1,16:723\n490#1,19:740\n473#1:759\n490#1,19:760\n474#1:779\n490#1,19:780\n475#1:799\n490#1,19:800\n477#1:819\n490#1,19:820\n478#1:839\n490#1,19:840\n479#1:859\n490#1,19:860\n480#1,29:879\n457#1,16:911\n490#1,19:928\n473#1:947\n490#1,19:948\n474#1:967\n490#1,19:968\n475#1:987\n490#1,19:988\n477#1:1007\n490#1,19:1008\n478#1:1027\n490#1,19:1028\n479#1:1047\n490#1,19:1048\n480#1,29:1067\n490#1,19:1099\n490#1,19:1119\n490#1,19:1139\n490#1,19:1159\n490#1,19:1179\n490#1,19:1199\n490#1,19:1219\n490#1,19:1239\n512#1,27:1262\n539#1,13:1290\n2097#2:708\n2301#2:909\n2292#2:1096\n2283#2:1097\n2097#2:1258\n2097#2:1259\n2097#2:1260\n2097#2:1261\n2097#2:1289\n41#3:722\n38#3:739\n51#3:908\n52#3:910\n38#3:927\n38#3:1098\n38#3:1118\n38#3:1138\n38#3:1158\n38#3:1178\n38#3:1198\n38#3:1218\n38#3:1238\n44#3:1303\n*S KotlinDebug\n*F\n+ 1 BLAKE2Digest.kt\norg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit64\n*L\n365#1:681,27\n365#1:709,13\n399#1:723,16\n399#1:740,19\n399#1:759\n399#1:760,19\n399#1:779\n399#1:780,19\n399#1:799\n399#1:800,19\n399#1:819\n399#1:820,19\n399#1:839\n399#1:840,19\n399#1:859\n399#1:860,19\n399#1:879,29\n431#1:911,16\n431#1:928,19\n431#1:947\n431#1:948,19\n431#1:967\n431#1:968,19\n431#1:987\n431#1:988,19\n431#1:1007\n431#1:1008,19\n431#1:1027\n431#1:1028,19\n431#1:1047\n431#1:1048,19\n431#1:1067,29\n472#1:1099,19\n473#1:1119,19\n474#1:1139,19\n475#1:1159,19\n477#1:1179,19\n478#1:1199,19\n479#1:1219,19\n480#1:1239,19\n556#1:1262,27\n556#1:1290,13\n365#1:708\n402#1:909\n437#1:1096\n445#1:1097\n538#1:1258\n539#1:1259\n547#1:1260\n548#1:1261\n556#1:1289\n373#1:722\n399#1:739\n402#1:908\n402#1:910\n431#1:927\n472#1:1098\n473#1:1118\n474#1:1138\n475#1:1158\n477#1:1178\n478#1:1198\n479#1:1218\n480#1:1238\n557#1:1303\n*E\n"})
    public static abstract class Bit64
    extends BLAKE2Digest {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final long[] v;
        @NotNull
        private final long[] h;
        @Nullable
        private long[] m;
        @NotNull
        private final Counter.Bit64 t;
        private static final int BLOCK_SIZE = 128;
        private static final int ROUND_COUNT = 12;
        private static final int R1 = 32;
        private static final int R2 = 24;
        private static final int R3 = 16;
        private static final int R4 = 63;
        @NotNull
        private static final long[] IV;

        /*
         * WARNING - void declaration
         */
        private Bit64(String variant, int bitStrength, boolean isLastNode, int keyLength, int fanOut, int depth, int leafLength, long nodeOffset, int nodeDepth, int innerLength, byte[] salt, byte[] personalization) throws IllegalArgumentException {
            super(variant, 128, bitStrength, isLastNode, keyLength, fanOut, depth, leafLength, nodeOffset, nodeDepth, innerLength, salt, personalization, null);
            byte[] $this$leLongAt$iv$iv;
            boolean $i$f$leLongAt;
            int offset$iv$iv;
            void this_$iv;
            this.v = new long[16];
            Bit64 bit64 = this;
            long[] $this$initialize$iv = new long[8];
            boolean $i$f$initialize = false;
            long[] iv$iv = IV;
            byte[] salt$iv = this_$iv.salt;
            byte[] personalization$iv = this_$iv.personalization;
            $this$initialize$iv[0] = iv$iv[0] ^ ((long)(this_$iv.digestLength() | this_$iv.keyLength << 8 | this_$iv.fanOut << 16 | this_$iv.depth << 24) | (long)this_$iv.leafLength << 32);
            $this$initialize$iv[1] = iv$iv[1] ^ this_$iv.nodeOffset;
            $this$initialize$iv[2] = iv$iv[2] ^ (long)(this_$iv.nodeDepth | this_$iv.innerLength << 8);
            $this$initialize$iv[3] = iv$iv[3];
            if (salt$iv == null) {
                $this$initialize$iv[4] = iv$iv[4];
                $this$initialize$iv[5] = iv$iv[5];
            } else {
                byte[] byArray = salt$iv;
                offset$iv$iv = 0;
                $i$f$leLongAt = false;
                $this$initialize$iv[4] = iv$iv[4] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv$iv, offset$iv$iv);
                $this$leLongAt$iv$iv = salt$iv;
                offset$iv$iv = 8;
                $i$f$leLongAt = false;
                $this$initialize$iv[5] = iv$iv[5] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv$iv, offset$iv$iv);
            }
            if (personalization$iv == null) {
                $this$initialize$iv[6] = iv$iv[6];
                $this$initialize$iv[7] = iv$iv[7];
            } else {
                $this$leLongAt$iv$iv = personalization$iv;
                offset$iv$iv = 0;
                $i$f$leLongAt = false;
                $this$initialize$iv[6] = iv$iv[6] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv$iv, offset$iv$iv);
                $this$leLongAt$iv$iv = personalization$iv;
                offset$iv$iv = 8;
                $i$f$leLongAt = false;
                $this$initialize$iv[7] = iv$iv[7] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv$iv, offset$iv$iv);
            }
            this.h = $this$initialize$iv;
            this.m = null;
            this.t = new Counter.Bit64(128L);
        }

        private Bit64(Bit64 other) {
            super(other, null);
            long[] lArray;
            long[] lArray2 = Arrays.copyOf(other.v, other.v.length);
            Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(...)");
            this.v = lArray2;
            long[] lArray3 = Arrays.copyOf(other.h, other.h.length);
            Intrinsics.checkNotNullExpressionValue((Object)lArray3, (String)"copyOf(...)");
            this.h = lArray3;
            if (other.m != null) {
                long[] $this$copy_u2dlifN7JQ$iv = other.m;
                boolean bl = false;
                long[] lArray4 = Arrays.copyOf($this$copy_u2dlifN7JQ$iv, $this$copy_u2dlifN7JQ$iv.length);
                Intrinsics.checkNotNullExpressionValue((Object)lArray4, (String)"copyOf(...)");
                lArray = Bit64Message.constructor-impl(lArray4);
            } else {
                lArray = null;
            }
            this.m = lArray;
            this.t = other.t.copy();
        }

        @Override
        @NotNull
        public abstract Bit64 copy();

        /*
         * WARNING - void declaration
         */
        protected void compressProtected(@NotNull byte[] input, int offset) {
            void destOffset$iv$iv;
            void dest$iv$iv;
            void $this$lePackIntoUnsafe$iv$iv;
            int i$iv;
            void f0$iv;
            void tHi$iv22;
            void tLo$iv22;
            void h$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            long[] m = this.m;
            if (m == null) {
                this.m = Bit64Message.constructor-impl(input, offset);
                return;
            }
            this.t.increment();
            Bit64 bit64 = this;
            long[] lArray = this.h;
            long l = this.t.lo();
            long l2 = this.t.hi();
            long l3 = 0L;
            long f1$iv = 0L;
            boolean bl = false;
            long[] iv$iv = IV;
            long[] v$iv = this_$iv.v;
            ArraysKt.copyInto$default((long[])h$iv, (long[])v$iv, (int)0, (int)0, (int)0, (int)14, null);
            ArraysKt.copyInto((long[])iv$iv, (long[])v$iv, (int)((void)h$iv).length, (int)0, (int)4);
            v$iv[12] = tLo$iv22 ^ iv$iv[4];
            v$iv[13] = tHi$iv22 ^ iv$iv[5];
            v$iv[14] = f0$iv ^ iv$iv[6];
            v$iv[15] = f1$iv ^ iv$iv[7];
            byte[][] s$iv = SIGMA;
            for (i$iv = 0; i$iv < 12; ++i$iv) {
                void y$iv$iv;
                long x$iv$iv;
                int d$iv$iv;
                int c$iv$iv;
                int b$iv$iv;
                int a$iv$iv;
                void $this$get_u2d4_u2dOz4dc$iv$iv;
                long[] $this$get_u2d4_u2dOz4dc$iv$iv2;
                void var19_19 = this_$iv;
                boolean bl2 = false;
                int n = 4;
                int n2 = 8;
                int n3 = 12;
                long[] lArray2 = m;
                byte sigmaByte$iv$iv = s$iv[i$iv][0];
                boolean $i$f$get-4-Oz4dc22 = false;
                void var27_42 = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc22 = m;
                byte sigmaByte$iv$iv2 = s$iv[i$iv][1];
                boolean bl3 = false;
                void var31_45 = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                boolean $i$f$G = false;
                long va$iv$iv = v$iv[a$iv$iv];
                long vb$iv$iv = v$iv[b$iv$iv];
                long vc$iv$iv = v$iv[c$iv$iv];
                long vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                void this_$iv$iv = this_$iv;
                a$iv$iv = 1;
                b$iv$iv = 5;
                c$iv$iv = 9;
                d$iv$iv = 13;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][2];
                $i$f$get-4-Oz4dc3 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc3 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][3];
                bl3 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 2;
                b$iv$iv = 6;
                c$iv$iv = 10;
                d$iv$iv = 14;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][4];
                $i$f$get-4-Oz4dc4 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc4 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][5];
                bl3 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 3;
                b$iv$iv = 7;
                c$iv$iv = 11;
                d$iv$iv = 15;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][6];
                $i$f$get-4-Oz4dc5 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc5 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][7];
                bl3 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 0;
                b$iv$iv = 5;
                c$iv$iv = 10;
                d$iv$iv = 15;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][8];
                $i$f$get-4-Oz4dc6 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc6 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][9];
                bl3 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 1;
                b$iv$iv = 6;
                c$iv$iv = 11;
                d$iv$iv = 12;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][10];
                $i$f$get-4-Oz4dc7 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc7 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][11];
                bl3 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 2;
                b$iv$iv = 7;
                c$iv$iv = 8;
                d$iv$iv = 13;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][12];
                $i$f$get-4-Oz4dc8 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc8 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][13];
                bl3 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 3;
                b$iv$iv = 4;
                c$iv$iv = 9;
                d$iv$iv = 14;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][14];
                $i$f$get-4-Oz4dc9 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc9 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][15];
                bl3 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv[a$iv$iv];
                vb$iv$iv = v$iv[b$iv$iv];
                vc$iv$iv = v$iv[c$iv$iv];
                vd$iv$iv = v$iv[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv[a$iv$iv] = va$iv$iv;
                v$iv[b$iv$iv] = vb$iv$iv;
                v$iv[c$iv$iv] = vc$iv$iv;
                v$iv[d$iv$iv] = vd$iv$iv;
            }
            for (i$iv = 0; i$iv < 8; ++i$iv) {
                h$iv[i$iv] = h$iv[i$iv] ^ v$iv[i$iv] ^ v$iv[i$iv + 8];
            }
            long[] $this$populate_u2dEAoUrnQ$iv = m;
            boolean bl4 = false;
            byte[] tLo$iv22 = input;
            long[] lArray3 = $this$populate_u2dEAoUrnQ$iv;
            boolean tHi$iv22 = false;
            int sourceIndexEnd$iv$iv = offset + 128;
            boolean $i$f$lePackIntoUnsafe = false;
            Endian.Little.INSTANCE.packUnsafe((byte[])$this$lePackIntoUnsafe$iv$iv, (long[])dest$iv$iv, (int)destOffset$iv$iv, offset, sourceIndexEnd$iv$iv);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected byte[] digestProtected(@NotNull byte[] buf, int bufPos) {
            int sourceIndexStart$iv;
            int destOffset$iv;
            void dest$iv;
            void $this$lePackIntoUnsafe$iv2;
            int i$iv;
            void f0$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            long[] m = this.m;
            if (m != null) {
                if (bufPos == 0) {
                    this.t.increment();
                } else {
                    this.compressProtected(buf, 0);
                }
            } else {
                this.m = m = Bit64Message.constructor-impl(buf, 0);
            }
            Counter.Bit64.Final final_ = this.t.final(bufPos);
            long tLo = final_.component1();
            long tHi = final_.component2();
            long[] h = this.h;
            Bit64 bit64 = this;
            long l = -1L;
            long f1$iv = this.isLastNode ? -1L : 0L;
            boolean $i$f$F-dHqpHZs22 = false;
            long[] iv$iv22 = IV;
            long[] v$iv22 = this_$iv.v;
            ArraysKt.copyInto$default((long[])h, (long[])v$iv22, (int)0, (int)0, (int)0, (int)14, null);
            ArraysKt.copyInto((long[])iv$iv22, (long[])v$iv22, (int)h.length, (int)0, (int)4);
            v$iv22[12] = tLo ^ iv$iv22[4];
            v$iv22[13] = tHi ^ iv$iv22[5];
            v$iv22[14] = f0$iv ^ iv$iv22[6];
            v$iv22[15] = f1$iv ^ iv$iv22[7];
            byte[][] s$iv = SIGMA;
            for (i$iv = 0; i$iv < 12; ++i$iv) {
                void y$iv$iv;
                long x$iv$iv;
                int d$iv$iv;
                int c$iv$iv;
                int b$iv$iv;
                int a$iv$iv;
                void $this$get_u2d4_u2dOz4dc$iv$iv;
                long[] $this$get_u2d4_u2dOz4dc$iv$iv2;
                void var20_23 = this_$iv;
                boolean bl = false;
                int n = 4;
                int n2 = 8;
                int n3 = 12;
                long[] lArray = m;
                byte sigmaByte$iv$iv = s$iv[i$iv][0];
                boolean $i$f$get-4-Oz4dc22 = false;
                void var28_46 = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc22 = m;
                byte sigmaByte$iv$iv2 = s$iv[i$iv][1];
                boolean bl2 = false;
                void var32_49 = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                boolean $i$f$G = false;
                long va$iv$iv = v$iv22[a$iv$iv];
                long vb$iv$iv = v$iv22[b$iv$iv];
                long vc$iv$iv = v$iv22[c$iv$iv];
                long vd$iv$iv = v$iv22[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv22[a$iv$iv] = va$iv$iv;
                v$iv22[b$iv$iv] = vb$iv$iv;
                v$iv22[c$iv$iv] = vc$iv$iv;
                v$iv22[d$iv$iv] = vd$iv$iv;
                void this_$iv$iv = this_$iv;
                a$iv$iv = 1;
                b$iv$iv = 5;
                c$iv$iv = 9;
                d$iv$iv = 13;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][2];
                $i$f$get-4-Oz4dc3 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc3 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][3];
                bl2 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv22[a$iv$iv];
                vb$iv$iv = v$iv22[b$iv$iv];
                vc$iv$iv = v$iv22[c$iv$iv];
                vd$iv$iv = v$iv22[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv22[a$iv$iv] = va$iv$iv;
                v$iv22[b$iv$iv] = vb$iv$iv;
                v$iv22[c$iv$iv] = vc$iv$iv;
                v$iv22[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 2;
                b$iv$iv = 6;
                c$iv$iv = 10;
                d$iv$iv = 14;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][4];
                $i$f$get-4-Oz4dc4 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc4 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][5];
                bl2 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv22[a$iv$iv];
                vb$iv$iv = v$iv22[b$iv$iv];
                vc$iv$iv = v$iv22[c$iv$iv];
                vd$iv$iv = v$iv22[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv22[a$iv$iv] = va$iv$iv;
                v$iv22[b$iv$iv] = vb$iv$iv;
                v$iv22[c$iv$iv] = vc$iv$iv;
                v$iv22[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 3;
                b$iv$iv = 7;
                c$iv$iv = 11;
                d$iv$iv = 15;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][6];
                $i$f$get-4-Oz4dc5 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc5 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][7];
                bl2 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv22[a$iv$iv];
                vb$iv$iv = v$iv22[b$iv$iv];
                vc$iv$iv = v$iv22[c$iv$iv];
                vd$iv$iv = v$iv22[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv22[a$iv$iv] = va$iv$iv;
                v$iv22[b$iv$iv] = vb$iv$iv;
                v$iv22[c$iv$iv] = vc$iv$iv;
                v$iv22[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 0;
                b$iv$iv = 5;
                c$iv$iv = 10;
                d$iv$iv = 15;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][8];
                $i$f$get-4-Oz4dc6 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc6 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][9];
                bl2 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv22[a$iv$iv];
                vb$iv$iv = v$iv22[b$iv$iv];
                vc$iv$iv = v$iv22[c$iv$iv];
                vd$iv$iv = v$iv22[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv22[a$iv$iv] = va$iv$iv;
                v$iv22[b$iv$iv] = vb$iv$iv;
                v$iv22[c$iv$iv] = vc$iv$iv;
                v$iv22[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 1;
                b$iv$iv = 6;
                c$iv$iv = 11;
                d$iv$iv = 12;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][10];
                $i$f$get-4-Oz4dc7 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc7 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][11];
                bl2 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv22[a$iv$iv];
                vb$iv$iv = v$iv22[b$iv$iv];
                vc$iv$iv = v$iv22[c$iv$iv];
                vd$iv$iv = v$iv22[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv22[a$iv$iv] = va$iv$iv;
                v$iv22[b$iv$iv] = vb$iv$iv;
                v$iv22[c$iv$iv] = vc$iv$iv;
                v$iv22[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 2;
                b$iv$iv = 7;
                c$iv$iv = 8;
                d$iv$iv = 13;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][12];
                $i$f$get-4-Oz4dc8 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc8 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][13];
                bl2 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv22[a$iv$iv];
                vb$iv$iv = v$iv22[b$iv$iv];
                vc$iv$iv = v$iv22[c$iv$iv];
                vd$iv$iv = v$iv22[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv22[a$iv$iv] = va$iv$iv;
                v$iv22[b$iv$iv] = vb$iv$iv;
                v$iv22[c$iv$iv] = vc$iv$iv;
                v$iv22[d$iv$iv] = vd$iv$iv;
                this_$iv$iv = this_$iv;
                a$iv$iv = 3;
                b$iv$iv = 4;
                c$iv$iv = 9;
                d$iv$iv = 14;
                $this$get_u2d4_u2dOz4dc$iv$iv2 = m;
                sigmaByte$iv$iv = s$iv[i$iv][14];
                $i$f$get-4-Oz4dc9 = false;
                x$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv2[sigmaByte$iv$iv];
                long[] $i$f$get-4-Oz4dc9 = m;
                sigmaByte$iv$iv2 = s$iv[i$iv][15];
                bl2 = false;
                y$iv$iv = $this$get_u2d4_u2dOz4dc$iv$iv[sigmaByte$iv$iv2];
                $i$f$G = false;
                va$iv$iv = v$iv22[a$iv$iv];
                vb$iv$iv = v$iv22[b$iv$iv];
                vc$iv$iv = v$iv22[c$iv$iv];
                vd$iv$iv = v$iv22[d$iv$iv];
                va$iv$iv = va$iv$iv + vb$iv$iv + x$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 32);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 24);
                va$iv$iv = va$iv$iv + vb$iv$iv + y$iv$iv;
                vd$iv$iv = Long.rotateRight(vd$iv$iv ^ va$iv$iv, 16);
                vb$iv$iv = Long.rotateRight(vb$iv$iv ^ (vc$iv$iv += vd$iv$iv), 63);
                v$iv22[a$iv$iv] = va$iv$iv;
                v$iv22[b$iv$iv] = vb$iv$iv;
                v$iv22[c$iv$iv] = vc$iv$iv;
                v$iv22[d$iv$iv] = vd$iv$iv;
            }
            for (i$iv = 0; i$iv < 8; ++i$iv) {
                h[i$iv] = h[i$iv] ^ v$iv22[i$iv] ^ v$iv22[i$iv + 8];
            }
            int len = this.innerLength != 0 ? this.innerLength : this.digestLength();
            int rem = len % 8;
            int iHEnd = len / 8;
            long[] lArray = h;
            byte[] $i$f$F-dHqpHZs22 = new byte[len];
            boolean iv$iv22 = false;
            boolean v$iv22 = false;
            boolean $i$f$lePackIntoUnsafe = false;
            byte[] out = Endian.Little.INSTANCE.packUnsafe((long[])$this$lePackIntoUnsafe$iv2, (byte[])dest$iv, destOffset$iv, sourceIndexStart$iv, iHEnd);
            if (rem > 0) {
                long $this$lePackIntoUnsafe$iv2 = h[iHEnd];
                destOffset$iv = len - rem;
                sourceIndexStart$iv = 0;
                $i$f$lePackIntoUnsafe = false;
                Endian.Little.INSTANCE.packUnsafe($this$lePackIntoUnsafe$iv2, out, destOffset$iv, sourceIndexStart$iv, rem);
            }
            return out;
        }

        /*
         * WARNING - void declaration
         */
        private final void F-dHqpHZs(long[] h, long[] m, long tLo, long tHi, long f0, long f1) {
            int i;
            boolean bl = false;
            long[] iv = IV;
            long[] v = this.v;
            ArraysKt.copyInto$default((long[])h, (long[])v, (int)0, (int)0, (int)0, (int)14, null);
            ArraysKt.copyInto((long[])iv, (long[])v, (int)h.length, (int)0, (int)4);
            v[12] = tLo ^ iv[4];
            v[13] = tHi ^ iv[5];
            v[14] = f0 ^ iv[6];
            v[15] = f1 ^ iv[7];
            byte[][] s = SIGMA;
            for (i = 0; i < 12; ++i) {
                void x$iv;
                void x$iv82;
                void x$iv72;
                void x$iv62;
                void x$iv52;
                void x$iv42;
                void x$iv32;
                void y$iv;
                void x$iv22;
                int d$iv;
                int c$iv;
                int b$iv;
                int a$iv;
                void $this$get_u2d4_u2dOz4dc$iv;
                void $this$get_u2d4_u2dOz4dc$iv2;
                Bit64 bit64 = this;
                boolean bl2 = false;
                int n = 4;
                int n2 = 8;
                int n3 = 12;
                long[] lArray = m;
                byte sigmaByte$iv = s[i][0];
                boolean $i$f$get-4-Oz4dc22 = false;
                $this$get_u2d4_u2dOz4dc$iv2 = $this$get_u2d4_u2dOz4dc$iv2[sigmaByte$iv];
                long[] $i$f$get-4-Oz4dc22 = m;
                byte sigmaByte$iv2 = s[i][1];
                boolean bl3 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv2];
                boolean $i$f$G = false;
                long va$iv = v[a$iv];
                long vb$iv = v[b$iv];
                long vc$iv = v[c$iv];
                long vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv22;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 32);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 24);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 63);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                Bit64 this_$iv = this;
                a$iv = 1;
                b$iv = 5;
                c$iv = 9;
                d$iv = 13;
                long[] x$iv22 = m;
                sigmaByte$iv = s[i][2];
                $i$f$get-4-Oz4dc3 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv];
                long[] $i$f$get-4-Oz4dc3 = m;
                sigmaByte$iv2 = s[i][3];
                bl3 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv2];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv32;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 32);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 24);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 63);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 2;
                b$iv = 6;
                c$iv = 10;
                d$iv = 14;
                long[] x$iv32 = m;
                sigmaByte$iv = s[i][4];
                $i$f$get-4-Oz4dc4 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv];
                long[] $i$f$get-4-Oz4dc4 = m;
                sigmaByte$iv2 = s[i][5];
                bl3 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv2];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv42;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 32);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 24);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 63);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 3;
                b$iv = 7;
                c$iv = 11;
                d$iv = 15;
                long[] x$iv42 = m;
                sigmaByte$iv = s[i][6];
                $i$f$get-4-Oz4dc5 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv];
                long[] $i$f$get-4-Oz4dc5 = m;
                sigmaByte$iv2 = s[i][7];
                bl3 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv2];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv52;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 32);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 24);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 63);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 0;
                b$iv = 5;
                c$iv = 10;
                d$iv = 15;
                long[] x$iv52 = m;
                sigmaByte$iv = s[i][8];
                $i$f$get-4-Oz4dc6 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv];
                long[] $i$f$get-4-Oz4dc6 = m;
                sigmaByte$iv2 = s[i][9];
                bl3 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv2];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv62;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 32);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 24);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 63);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 1;
                b$iv = 6;
                c$iv = 11;
                d$iv = 12;
                long[] x$iv62 = m;
                sigmaByte$iv = s[i][10];
                $i$f$get-4-Oz4dc7 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv];
                long[] $i$f$get-4-Oz4dc7 = m;
                sigmaByte$iv2 = s[i][11];
                bl3 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv2];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv72;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 32);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 24);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 63);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 2;
                b$iv = 7;
                c$iv = 8;
                d$iv = 13;
                long[] x$iv72 = m;
                sigmaByte$iv = s[i][12];
                $i$f$get-4-Oz4dc8 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv];
                long[] $i$f$get-4-Oz4dc8 = m;
                sigmaByte$iv2 = s[i][13];
                bl3 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv2];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv82;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 32);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 24);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 63);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
                this_$iv = this;
                a$iv = 3;
                b$iv = 4;
                c$iv = 9;
                d$iv = 14;
                long[] x$iv82 = m;
                sigmaByte$iv = s[i][14];
                $i$f$get-4-Oz4dc9 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv];
                long[] $i$f$get-4-Oz4dc9 = m;
                sigmaByte$iv2 = s[i][15];
                bl3 = false;
                $this$get_u2d4_u2dOz4dc$iv = $this$get_u2d4_u2dOz4dc$iv[sigmaByte$iv2];
                $i$f$G = false;
                va$iv = v[a$iv];
                vb$iv = v[b$iv];
                vc$iv = v[c$iv];
                vd$iv = v[d$iv];
                va$iv = va$iv + vb$iv + x$iv;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 32);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 24);
                va$iv = va$iv + vb$iv + y$iv;
                vd$iv = Long.rotateRight(vd$iv ^ va$iv, 16);
                vb$iv = Long.rotateRight(vb$iv ^ (vc$iv += vd$iv), 63);
                v[a$iv] = va$iv;
                v[b$iv] = vb$iv;
                v[c$iv] = vc$iv;
                v[d$iv] = vd$iv;
            }
            for (i = 0; i < 8; ++i) {
                h[i] = h[i] ^ v[i] ^ v[i + 8];
            }
        }

        private final void G(long[] v, int a, int b, int c, int d, long x, long y) {
            boolean $i$f$G = false;
            long va = v[a];
            long vb = v[b];
            long vc = v[c];
            long vd = v[d];
            va = va + vb + x;
            vd = Long.rotateRight(vd ^ va, 32);
            vb = Long.rotateRight(vb ^ (vc += vd), 24);
            va = va + vb + y;
            vd = Long.rotateRight(vd ^ va, 16);
            vb = Long.rotateRight(vb ^ (vc += vd), 63);
            v[a] = va;
            v[b] = vb;
            v[c] = vc;
            v[d] = vd;
        }

        private final long[] initialize(long[] $this$initialize) {
            byte[] $this$leLongAt$iv;
            boolean $i$f$leLongAt;
            int offset$iv;
            boolean $i$f$initialize = false;
            long[] iv = IV;
            byte[] salt = this.salt;
            byte[] personalization = this.personalization;
            $this$initialize[0] = iv[0] ^ ((long)(this.digestLength() | this.keyLength << 8 | this.fanOut << 16 | this.depth << 24) | (long)this.leafLength << 32);
            $this$initialize[1] = iv[1] ^ this.nodeOffset;
            $this$initialize[2] = iv[2] ^ (long)(this.nodeDepth | this.innerLength << 8);
            $this$initialize[3] = iv[3];
            if (salt == null) {
                $this$initialize[4] = iv[4];
                $this$initialize[5] = iv[5];
            } else {
                byte[] byArray = salt;
                offset$iv = 0;
                $i$f$leLongAt = false;
                $this$initialize[4] = iv[4] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv, offset$iv);
                $this$leLongAt$iv = salt;
                offset$iv = 8;
                $i$f$leLongAt = false;
                $this$initialize[5] = iv[5] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv, offset$iv);
            }
            if (personalization == null) {
                $this$initialize[6] = iv[6];
                $this$initialize[7] = iv[7];
            } else {
                $this$leLongAt$iv = personalization;
                offset$iv = 0;
                $i$f$leLongAt = false;
                $this$initialize[6] = iv[6] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv, offset$iv);
                $this$leLongAt$iv = personalization;
                offset$iv = 8;
                $i$f$leLongAt = false;
                $this$initialize[7] = iv[7] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv, offset$iv);
            }
            return $this$initialize;
        }

        /*
         * WARNING - void declaration
         */
        protected void resetProtected() {
            byte[] $this$leLongAt$iv$iv;
            boolean $i$f$leLongAt;
            int offset$iv$iv;
            void this_$iv;
            ArraysKt.fill$default((long[])this.v, (long)0L, (int)0, (int)0, (int)6, null);
            Bit64 bit64 = this;
            long[] $this$initialize$iv = this.h;
            boolean $i$f$initialize = false;
            long[] iv$iv = IV;
            byte[] salt$iv = this_$iv.salt;
            byte[] personalization$iv = this_$iv.personalization;
            $this$initialize$iv[0] = iv$iv[0] ^ ((long)(this_$iv.digestLength() | this_$iv.keyLength << 8 | this_$iv.fanOut << 16 | this_$iv.depth << 24) | (long)this_$iv.leafLength << 32);
            $this$initialize$iv[1] = iv$iv[1] ^ this_$iv.nodeOffset;
            $this$initialize$iv[2] = iv$iv[2] ^ (long)(this_$iv.nodeDepth | this_$iv.innerLength << 8);
            $this$initialize$iv[3] = iv$iv[3];
            if (salt$iv == null) {
                $this$initialize$iv[4] = iv$iv[4];
                $this$initialize$iv[5] = iv$iv[5];
            } else {
                byte[] byArray = salt$iv;
                offset$iv$iv = 0;
                $i$f$leLongAt = false;
                $this$initialize$iv[4] = iv$iv[4] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv$iv, offset$iv$iv);
                $this$leLongAt$iv$iv = salt$iv;
                offset$iv$iv = 8;
                $i$f$leLongAt = false;
                $this$initialize$iv[5] = iv$iv[5] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv$iv, offset$iv$iv);
            }
            if (personalization$iv == null) {
                $this$initialize$iv[6] = iv$iv[6];
                $this$initialize$iv[7] = iv$iv[7];
            } else {
                $this$leLongAt$iv$iv = personalization$iv;
                offset$iv$iv = 0;
                $i$f$leLongAt = false;
                $this$initialize$iv[6] = iv$iv[6] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv$iv, offset$iv$iv);
                $this$leLongAt$iv$iv = personalization$iv;
                offset$iv$iv = 8;
                $i$f$leLongAt = false;
                $this$initialize$iv[7] = iv$iv[7] ^ Endian.Little.INSTANCE.longFrom($this$leLongAt$iv$iv, offset$iv$iv);
            }
            if (this.m != null) {
                long[] $this$fill_u2dlifN7JQ$iv = this.m;
                boolean bl = false;
                ArraysKt.fill$default((long[])$this$fill_u2dlifN7JQ$iv, (long)0L, (int)0, (int)0, (int)6, null);
            }
            this.m = null;
            this.t.reset();
        }

        public /* synthetic */ Bit64(String variant, int bitStrength, boolean isLastNode, int keyLength, int fanOut, int depth, int leafLength, long nodeOffset, int nodeDepth, int innerLength, byte[] salt, byte[] personalization, DefaultConstructorMarker $constructor_marker) {
            this(variant, bitStrength, isLastNode, keyLength, fanOut, depth, leafLength, nodeOffset, nodeDepth, innerLength, salt, personalization);
        }

        public /* synthetic */ Bit64(Bit64 other, DefaultConstructorMarker $constructor_marker) {
            this(other);
        }

        static {
            long[] lArray = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
            IV = lArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kotlincrypto/hash/blake2/BLAKE2Digest$Bit64$Companion;", "", "()V", "BLOCK_SIZE", "", "IV", "", "R1", "R2", "R3", "R4", "ROUND_COUNT", "org.kotlincrypto.hash_blake2_jvm"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kotlincrypto/hash/blake2/BLAKE2Digest$Companion;", "", "()V", "SIGMA", "", "", "[[B", "org.kotlincrypto.hash_blake2_jvm"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

