(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'core-digest-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('core-digest-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'hash-md-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'hash-md-js-legacy'.");
    }
    if (typeof this['core-digest-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'hash-md-js-legacy'. Its dependency 'core-digest-js-legacy' was not found. Please, check whether 'core-digest-js-legacy' is loaded prior to 'hash-md-js-legacy'.");
    }
    root['hash-md-js-legacy'] = factory(typeof this['hash-md-js-legacy'] === 'undefined' ? {} : this['hash-md-js-legacy'], kotlin, this['core-digest-js-legacy']);
  }
}(this, function (_, Kotlin, $module$core_digest_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var toByte = Kotlin.toByte;
  var fill = Kotlin.kotlin.collections.fill_6mk3ue$;
  var fill_0 = Kotlin.kotlin.collections.fill_tpuxuu$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Digest = $module$core_digest_js_legacy.org.kotlincrypto.core.digest.Digest;
  var Digest_init = $module$core_digest_js_legacy.org.kotlincrypto.core.digest.Digest_init_3m52m6$;
  var Digest_init_0 = $module$core_digest_js_legacy.org.kotlincrypto.core.digest.Digest_init_6hj6mx$;
  MD5.prototype = Object.create(Digest.prototype);
  MD5.prototype.constructor = MD5;
  function MD5() {
    MD5$Companion_getInstance();
    this.x_0 = null;
    this.state_0 = null;
  }
  MD5.prototype.copy_6hj6mx$ = function (state) {
    return MD5_init_0(state, this);
  };
  MD5.prototype.compress_ir89t6$ = function (input, offset) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6;
    var k = MD5$Companion_getInstance().K_0;
    var s = MD5$Companion_getInstance().S_0;
    var x = this.x_0;
    var a = this.state_0[0];
    var b = this.state_0[1];
    var c = this.state_0[2];
    var d = this.state_0[3];
    tmp$ = this.blockSize();
    for (var i = 0; i < tmp$; i++) {
      if (i < 16) {
        var j = (i * 4 | 0) + offset | 0;
        x[i] = input[tmp$_0 = j, j = tmp$_0 + 1 | 0, tmp$_0] & 255 | (input[tmp$_1 = j, j = tmp$_1 + 1 | 0, tmp$_1] & 255) << 8 | (input[tmp$_2 = j, j = tmp$_2 + 1 | 0, tmp$_2] & 255) << 16 | (input[j] & 255) << 24;
        var g = i + 0 | 0;
        var f = (b & c | ~b & d) + a + k[i] + x[g] | 0;
        a = d;
        d = c;
        c = b;
        var tmp$_7 = b;
        var n = s[i];
        b = tmp$_7 + (f << n | f >>> 32 - n) | 0;
      } else if (i < 32) {
        var g_0 = ((5 * i | 0) + 1 | 0) % 16 | 0;
        var f_0 = (d & b | ~d & c) + a + k[i] + x[g_0] | 0;
        a = d;
        d = c;
        c = b;
        var tmp$_8 = b;
        var n_0 = s[i];
        b = tmp$_8 + (f_0 << n_0 | f_0 >>> 32 - n_0) | 0;
      } else if (i < 48) {
        var g_1 = ((3 * i | 0) + 5 | 0) % 16 | 0;
        var f_1 = (b ^ c ^ d) + a + k[i] + x[g_1] | 0;
        a = d;
        d = c;
        c = b;
        var tmp$_9 = b;
        var n_1 = s[i];
        b = tmp$_9 + (f_1 << n_1 | f_1 >>> 32 - n_1) | 0;
      } else {
        var g_2 = (7 * i | 0) % 16 | 0;
        var f_2 = (c ^ (b | ~d)) + a + k[i] + x[g_2] | 0;
        a = d;
        d = c;
        c = b;
        var tmp$_10 = b;
        var n_2 = s[i];
        b = tmp$_10 + (f_2 << n_2 | f_2 >>> 32 - n_2) | 0;
      }
    }
    tmp$_3 = this.state_0;
    tmp$_3[0] = tmp$_3[0] + a | 0;
    tmp$_4 = this.state_0;
    tmp$_4[1] = tmp$_4[1] + b | 0;
    tmp$_5 = this.state_0;
    tmp$_5[2] = tmp$_5[2] + c | 0;
    tmp$_6 = this.state_0;
    tmp$_6[3] = tmp$_6[3] + d | 0;
  };
  MD5.prototype.digest_4r1zfv$ = function (bitLength, bufferOffset, buffer) {
    buffer[bufferOffset] = toByte(128);
    var size = bufferOffset + 1 | 0;
    if (size > 56) {
      fill(buffer, 0, size, this.blockSize());
      this.compress_ir89t6$(buffer, 0);
      fill(buffer, 0, 0, size);
    } else {
      fill(buffer, 0, size, 56);
    }
    buffer[56] = toByte(bitLength.toInt());
    buffer[57] = toByte(bitLength.shiftRightUnsigned(8).toInt());
    buffer[58] = toByte(bitLength.shiftRightUnsigned(16).toInt());
    buffer[59] = toByte(bitLength.shiftRightUnsigned(24).toInt());
    buffer[60] = toByte(bitLength.shiftRightUnsigned(32).toInt());
    buffer[61] = toByte(bitLength.shiftRightUnsigned(40).toInt());
    buffer[62] = toByte(bitLength.shiftRightUnsigned(48).toInt());
    buffer[63] = toByte(bitLength.shiftRightUnsigned(56).toInt());
    this.compress_ir89t6$(buffer, 0);
    var a = this.state_0[0];
    var b = this.state_0[1];
    var c = this.state_0[2];
    var d = this.state_0[3];
    return new Int8Array([toByte(a), toByte(a >> 8), toByte(a >> 16), toByte(a >> 24), toByte(b), toByte(b >> 8), toByte(b >> 16), toByte(b >> 24), toByte(c), toByte(c >> 8), toByte(c >> 16), toByte(c >> 24), toByte(d), toByte(d >> 8), toByte(d >> 16), toByte(d >> 24)]);
  };
  MD5.prototype.resetDigest = function () {
    fill_0(this.x_0, 0);
    this.state_0[0] = 1732584193;
    this.state_0[1] = -271733879;
    this.state_0[2] = -1732584194;
    this.state_0[3] = 271733878;
  };
  MD5.prototype.rotateLeft_0 = function ($receiver, n) {
    return $receiver << n | $receiver >>> 32 - n;
  };
  function MD5$Companion() {
    MD5$Companion_instance = this;
    this.S_0 = new Int32Array([7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21]);
    this.K_0 = new Int32Array([-680876936, -389564586, 606105819, -1044525330, -176418897, 1200080426, -1473231341, -45705983, 1770035416, -1958414417, -42063, -1990404162, 1804603682, -40341101, -1502002290, 1236535329, -165796510, -1069501632, 643717713, -373897302, -701558691, 38016083, -660478335, -405537848, 568446438, -1019803690, -187363961, 1163531501, -1444681467, -51403784, 1735328473, -1926607734, -378558, -2022574463, 1839030562, -35309556, -1530992060, 1272893353, -155497632, -1094730640, 681279174, -358537222, -722521979, 76029189, -640364487, -421815835, 530742520, -995338651, -198630844, 1126891415, -1416354905, -57434055, 1700485571, -1894986606, -1051523, -2054922799, 1873313359, -30611744, -1560198380, 1309151649, -145523070, -1120210379, 718787259, -343485551]);
  }
  MD5$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var MD5$Companion_instance = null;
  function MD5$Companion_getInstance() {
    if (MD5$Companion_instance === null) {
      new MD5$Companion();
    }
    return MD5$Companion_instance;
  }
  MD5.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MD5',
    interfaces: [Digest]
  };
  function MD5_init($this) {
    $this = $this || Object.create(MD5.prototype);
    Digest_init('MD5', 64, 16, $this);
    MD5.call($this);
    $this.x_0 = new Int32Array(16);
    $this.state_0 = new Int32Array([1732584193, -271733879, -1732584194, 271733878]);
    return $this;
  }
  function MD5_init_0(state, digest, $this) {
    $this = $this || Object.create(MD5.prototype);
    Digest_init_0(state, $this);
    MD5.call($this);
    $this.x_0 = digest.x_0.slice();
    $this.state_0 = digest.state_0.slice();
    return $this;
  }
  $$importsForInline$$['hash-md-js-legacy'] = _;
  var package$org = _.org || (_.org = {});
  var package$kotlincrypto = package$org.kotlincrypto || (package$org.kotlincrypto = {});
  var package$hash = package$kotlincrypto.hash || (package$kotlincrypto.hash = {});
  var package$md = package$hash.md || (package$hash.md = {});
  package$md.MD5_init = MD5_init;
  package$md.MD5 = MD5;
  Kotlin.defineModule('hash-md-js-legacy', _);
  return _;
}));

//# sourceMappingURL=hash-md-js-legacy.js.map
