/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.md;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.digest.Digest;
import org.kotlincrypto.core.digest.internal.DigestState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J \u0010\u0005\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0014J\b\u0010\u0014\u001a\u00020\nH\u0014J\u0015\u0010\u0015\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0082\fR\u000e\u0010\u0003\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/kotlincrypto/hash/md/MD5;", "Lorg/kotlincrypto/core/digest/Digest;", "()V", "state", "Lorg/kotlincrypto/core/digest/internal/DigestState;", "digest", "(Lorg/kotlincrypto/core/digest/internal/DigestState;Lorg/kotlincrypto/hash/md/MD5;)V", "", "x", "compress", "", "input", "", "offset", "", "copy", "bitLength", "", "bufferOffset", "buffer", "resetDigest", "rotateLeft", "n", "Companion", "md"})
@SourceDebugExtension(value={"SMAP\nMD5.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MD5.kt\norg/kotlincrypto/hash/md/MD5\n*L\n1#1,203:1\n161#1:204\n161#1:205\n161#1:206\n161#1:207\n*S KotlinDebug\n*F\n+ 1 MD5.kt\norg/kotlincrypto/hash/md/MD5\n*L\n69#1:204\n77#1:205\n85#1:206\n93#1:207\n*E\n"})
public final class MD5
extends Digest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] x;
    @NotNull
    private final int[] state;
    @NotNull
    private static final int[] S;
    @NotNull
    private static final int[] K;

    public MD5() {
        super("MD5", 64, 16);
        this.x = new int[16];
        int[] nArray = new int[]{1732584193, -271733879, -1732584194, 271733878};
        this.state = nArray;
    }

    private MD5(DigestState state, MD5 digest) {
        super(state);
        int[] nArray = Arrays.copyOf(digest.x, digest.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, size)");
        this.x = nArray;
        int[] nArray2 = Arrays.copyOf(digest.state, digest.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(this, size)");
        this.state = nArray2;
    }

    @NotNull
    protected Digest copy(@NotNull DigestState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new MD5(state, this);
    }

    /*
     * WARNING - void declaration
     */
    protected void compress(@NotNull byte[] input, int offset) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int[] k = K;
        int[] s = S;
        int[] x = this.x;
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        int n = this.blockSize();
        for (int i = 0; i < n; ++i) {
            boolean $i$f$rotateLeft;
            int n$iv;
            int f;
            int g;
            if (i < 16) {
                void $this$rotateLeft$iv;
                int j = i * 4 + offset;
                x[i] = input[j++] & 0xFF | (input[j++] & 0xFF) << 8 | (input[j++] & 0xFF) << 16 | (input[j] & 0xFF) << 24;
                int g2 = i + 0;
                int f2 = (b & c | ~b & d) + a + k[i] + x[g2];
                a = d;
                d = c;
                c = b;
                MD5 mD5 = this;
                int n2 = f2;
                int n$iv2 = s[i];
                boolean $i$f$rotateLeft2 = false;
                b += $this$rotateLeft$iv << n$iv2 | $this$rotateLeft$iv >>> 32 - n$iv2;
                continue;
            }
            if (i < 32) {
                void $this$rotateLeft$iv;
                g = (5 * i + 1) % 16;
                f = (d & b | ~d & c) + a + k[i] + x[g];
                a = d;
                d = c;
                c = b;
                MD5 f2 = this;
                int this_$iv = f;
                n$iv = s[i];
                $i$f$rotateLeft = false;
                b += $this$rotateLeft$iv << n$iv | $this$rotateLeft$iv >>> 32 - n$iv;
                continue;
            }
            if (i < 48) {
                g = (3 * i + 5) % 16;
                f = (b ^ c ^ d) + a + k[i] + x[g];
                a = d;
                d = c;
                c = b;
                MD5 this_$iv = this;
                int $this$rotateLeft$iv = f;
                n$iv = s[i];
                $i$f$rotateLeft = false;
                b += $this$rotateLeft$iv << n$iv | $this$rotateLeft$iv >>> 32 - n$iv;
                continue;
            }
            g = 7 * i % 16;
            f = (c ^ (b | ~d)) + a + k[i] + x[g];
            a = d;
            d = c;
            c = b;
            MD5 this_$iv = this;
            int $this$rotateLeft$iv = f;
            n$iv = s[i];
            $i$f$rotateLeft = false;
            b += $this$rotateLeft$iv << n$iv | $this$rotateLeft$iv >>> 32 - n$iv;
        }
        int[] nArray = this.state;
        nArray[0] = nArray[0] + a;
        nArray = this.state;
        nArray[1] = nArray[1] + b;
        nArray = this.state;
        nArray[2] = nArray[2] + c;
        nArray = this.state;
        nArray[3] = nArray[3] + d;
    }

    @NotNull
    protected byte[] digest(long bitLength, int bufferOffset, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer[bufferOffset] = -128;
        int size = bufferOffset + 1;
        if (size > 56) {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)this.blockSize());
            this.compress(buffer, 0);
            ArraysKt.fill((byte[])buffer, (byte)0, (int)0, (int)size);
        } else {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)56);
        }
        buffer[56] = (byte)bitLength;
        buffer[57] = (byte)(bitLength >>> 8);
        buffer[58] = (byte)(bitLength >>> 16);
        buffer[59] = (byte)(bitLength >>> 24);
        buffer[60] = (byte)(bitLength >>> 32);
        buffer[61] = (byte)(bitLength >>> 40);
        buffer[62] = (byte)(bitLength >>> 48);
        buffer[63] = (byte)(bitLength >>> 56);
        this.compress(buffer, 0);
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        byte[] byArray = new byte[]{(byte)a, (byte)(a >> 8), (byte)(a >> 16), (byte)(a >> 24), (byte)b, (byte)(b >> 8), (byte)(b >> 16), (byte)(b >> 24), (byte)c, (byte)(c >> 8), (byte)(c >> 16), (byte)(c >> 24), (byte)d, (byte)(d >> 8), (byte)(d >> 16), (byte)(d >> 24)};
        return byArray;
    }

    protected void resetDigest() {
        ArraysKt.fill$default((int[])this.x, (int)0, (int)0, (int)0, (int)6, null);
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
    }

    private final int rotateLeft(int $this$rotateLeft, int n) {
        boolean $i$f$rotateLeft = false;
        return $this$rotateLeft << n | $this$rotateLeft >>> 32 - n;
    }

    static {
        int[] nArray = new int[]{7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21};
        S = nArray;
        nArray = new int[]{-680876936, -389564586, 606105819, -1044525330, -176418897, 1200080426, -1473231341, -45705983, 1770035416, -1958414417, -42063, -1990404162, 1804603682, -40341101, -1502002290, 1236535329, -165796510, -1069501632, 643717713, -373897302, -701558691, 38016083, -660478335, -405537848, 568446438, -1019803690, -187363961, 1163531501, -1444681467, -51403784, 1735328473, -1926607734, -378558, -2022574463, 1839030562, -35309556, -1530992060, 1272893353, -155497632, -1094730640, 681279174, -358537222, -722521979, 76029189, -640364487, -421815835, 530742520, -995338651, -198630844, 1126891415, -1416354905, -57434055, 1700485571, -1894986606, -1051523, -2054922799, 1873313359, -30611744, -1560198380, 1309151649, -145523070, -1120210379, 718787259, -343485551};
        K = nArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kotlincrypto/hash/md/MD5$Companion;", "", "()V", "K", "", "S", "md"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

