/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.md;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.bitops.bits.Counter;
import org.kotlincrypto.bitops.endian.Endian;
import org.kotlincrypto.core.digest.Digest;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0000H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0014J(\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0014J\b\u0010\u0018\u001a\u00020\rH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kotlincrypto/hash/md/MD5;", "Lorg/kotlincrypto/core/digest/Digest;", "<init>", "()V", "other", "(Lorg/kotlincrypto/hash/md/MD5;)V", "x", "", "state", "count", "Lorg/kotlincrypto/bitops/bits/Counter$Bit32;", "copy", "compressProtected", "", "input", "", "offset", "", "digestProtected", "buf", "bufPos", "digestIntoProtected", "dest", "destOffset", "resetProtected", "Companion", "org.kotlincrypto.hash_md_jvm"})
@SourceDebugExtension(value={"SMAP\nMD5.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MD5.kt\norg/kotlincrypto/hash/md/MD5\n+ 2 Endian.kt\norg/kotlincrypto/bitops/endian/Endian$Little\n*L\n1#1,188:1\n2091#2:189\n2240#2:190\n2240#2:191\n2252#2,7:192\n*S KotlinDebug\n*F\n+ 1 MD5.kt\norg/kotlincrypto/hash/md/MD5\n*L\n63#1:189\n123#1:190\n124#1:191\n127#1:192,7\n*E\n"})
public final class MD5
extends Digest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] x;
    @NotNull
    private final int[] state;
    @NotNull
    private final Counter.Bit32 count;
    private static final int BLOCK_SIZE = 64;
    @NotNull
    private static final int[] H;
    @NotNull
    private static final int[] S;
    @NotNull
    private static final int[] K;

    public MD5() {
        super("MD5", 64, 16);
        this.x = new int[16];
        int[] nArray = Arrays.copyOf(H, H.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.state = nArray;
        this.count = new Counter.Bit32(64);
    }

    private MD5(MD5 other) {
        super((Digest)other);
        int[] nArray = Arrays.copyOf(other.x, other.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.x = nArray;
        int[] nArray2 = Arrays.copyOf(other.state, other.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        this.state = nArray2;
        this.count = other.count.copy();
    }

    @NotNull
    public MD5 copy() {
        return new MD5(this);
    }

    /*
     * WARNING - void declaration
     */
    protected void compressProtected(@NotNull byte[] input, int offset) {
        int g;
        int f;
        int i;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int[] k = K;
        int[] s = S;
        int[] x = this.x;
        int[] state = this.state;
        int a = state[0];
        int b = state[1];
        int c = state[2];
        int d = state[3];
        for (i = 0; i < 16; ++i) {
            void $this$leIntAt$iv;
            int xi;
            byte[] byArray = input;
            int offset$iv = i * 4 + offset;
            boolean $i$f$leIntAt = false;
            x[i] = xi = Endian.Little.INSTANCE.intFrom((byte[])$this$leIntAt$iv, offset$iv);
            f = (b & c | ~b & d) + a + k[i] + xi;
            a = d;
            d = c;
            c = b;
            b += Integer.rotateLeft(f, s[i]);
        }
        for (i = 16; i < 32; ++i) {
            g = (5 * i + 1) % 16;
            f = (d & b | ~d & c) + a + k[i] + x[g];
            a = d;
            d = c;
            c = b;
            b += Integer.rotateLeft(f, s[i]);
        }
        for (i = 32; i < 48; ++i) {
            g = (3 * i + 5) % 16;
            f = (b ^ c ^ d) + a + k[i] + x[g];
            a = d;
            d = c;
            c = b;
            b += Integer.rotateLeft(f, s[i]);
        }
        for (i = 48; i < 64; ++i) {
            g = 7 * i % 16;
            f = (c ^ (b | ~d)) + a + k[i] + x[g];
            a = d;
            d = c;
            c = b;
            b += Integer.rotateLeft(f, s[i]);
        }
        state[0] = state[0] + a;
        state[1] = state[1] + b;
        state[2] = state[2] + c;
        state[3] = state[3] + d;
        this.count.increment();
    }

    @NotNull
    protected byte[] digestProtected(@NotNull byte[] buf, int bufPos) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        byte[] digest = new byte[this.digestLength()];
        this.digestIntoProtected(digest, 0, buf, bufPos);
        return digest;
    }

    protected void digestIntoProtected(@NotNull byte[] dest, int destOffset, @NotNull byte[] buf, int bufPos) {
        int $this$lePackIntoUnsafe$iv;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Counter.Bit32.Final final_ = this.count.final(bufPos).asBits();
        int bitsLo = final_.component1();
        int bitsHi = final_.component2();
        buf[bufPos] = -128;
        if (bufPos + 1 > 56) {
            this.compressProtected(buf, 0);
            ArraysKt.fill((byte[])buf, (byte)0, (int)0, (int)56);
        }
        int n = bitsLo;
        int destOffset$iv = 56;
        boolean $i$f$lePackIntoUnsafe = false;
        Endian.Little.INSTANCE.packUnsafe($this$lePackIntoUnsafe$iv, buf, destOffset$iv);
        $this$lePackIntoUnsafe$iv = bitsHi;
        destOffset$iv = 60;
        $i$f$lePackIntoUnsafe = false;
        Endian.Little.INSTANCE.packUnsafe($this$lePackIntoUnsafe$iv, buf, destOffset$iv);
        this.compressProtected(buf, 0);
        int[] $this$lePackIntoUnsafe_u24default$iv = this.state;
        int sourceIndexStart$iv = 0;
        int sourceIndexEnd$iv = $this$lePackIntoUnsafe_u24default$iv.length;
        boolean $i$f$lePackIntoUnsafe2 = false;
        Endian.Little.INSTANCE.packUnsafe($this$lePackIntoUnsafe_u24default$iv, dest, destOffset, sourceIndexStart$iv, sourceIndexEnd$iv);
    }

    protected void resetProtected() {
        ArraysKt.fill$default((int[])this.x, (int)0, (int)0, (int)0, (int)6, null);
        ArraysKt.copyInto$default((int[])H, (int[])this.state, (int)0, (int)0, (int)0, (int)14, null);
        this.count.reset();
    }

    static {
        int[] nArray = new int[]{1732584193, -271733879, -1732584194, 271733878};
        H = nArray;
        nArray = new int[]{7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21};
        S = nArray;
        nArray = new int[]{-680876936, -389564586, 606105819, -1044525330, -176418897, 1200080426, -1473231341, -45705983, 1770035416, -1958414417, -42063, -1990404162, 1804603682, -40341101, -1502002290, 1236535329, -165796510, -1069501632, 643717713, -373897302, -701558691, 38016083, -660478335, -405537848, 568446438, -1019803690, -187363961, 1163531501, -1444681467, -51403784, 1735328473, -1926607734, -378558, -2022574463, 1839030562, -35309556, -1530992060, 1272893353, -155497632, -1094730640, 681279174, -358537222, -722521979, 76029189, -640364487, -421815835, 530742520, -995338651, -198630844, 1126891415, -1416354905, -57434055, 1700485571, -1894986606, -1051523, -2054922799, 1873313359, -30611744, -1560198380, 1309151649, -145523070, -1120210379, 718787259, -343485551};
        K = nArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/kotlincrypto/hash/md/MD5$Companion;", "", "<init>", "()V", "BLOCK_SIZE", "", "H", "", "S", "K", "org.kotlincrypto.hash_md_jvm"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

