(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'core-digest-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('core-digest-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'hash-sha1-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'hash-sha1-js-legacy'.");
    }
    if (typeof this['core-digest-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'hash-sha1-js-legacy'. Its dependency 'core-digest-js-legacy' was not found. Please, check whether 'core-digest-js-legacy' is loaded prior to 'hash-sha1-js-legacy'.");
    }
    root['hash-sha1-js-legacy'] = factory(typeof this['hash-sha1-js-legacy'] === 'undefined' ? {} : this['hash-sha1-js-legacy'], kotlin, this['core-digest-js-legacy']);
  }
}(this, function (_, Kotlin, $module$core_digest_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var toByte = Kotlin.toByte;
  var fill = Kotlin.kotlin.collections.fill_6mk3ue$;
  var fill_0 = Kotlin.kotlin.collections.fill_tpuxuu$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Digest = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest;
  var Digest_init = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest_init_3m52m6$;
  var Digest_init_0 = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest_init_l73exj$;
  SHA1.prototype = Object.create(Digest.prototype);
  SHA1.prototype.constructor = SHA1;
  function SHA1() {
    this.x_0 = null;
    this.state_0 = null;
  }
  SHA1.prototype.copy_l73exj$ = function (state) {
    return SHA1_init_0(state, this);
  };
  SHA1.prototype.compress_fqrh44$ = function (buffer) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8;
    var x = this.x_0;
    var bI = 0;
    for (var i = 0; i < 16; i++) {
      x[i] = (buffer[tmp$ = bI, bI = tmp$ + 1 | 0, tmp$] & 255) << 24 | (buffer[tmp$_0 = bI, bI = tmp$_0 + 1 | 0, tmp$_0] & 255) << 16 | (buffer[tmp$_1 = bI, bI = tmp$_1 + 1 | 0, tmp$_1] & 255) << 8 | buffer[tmp$_2 = bI, bI = tmp$_2 + 1 | 0, tmp$_2] & 255;
    }
    for (var i_0 = 16; i_0 < 80; i_0++) {
      var $receiver = x[i_0 - 3 | 0] ^ x[i_0 - 8 | 0] ^ x[i_0 - 14 | 0] ^ x[i_0 - 16 | 0];
      x[i_0] = $receiver << 1 | $receiver >>> 32 - 1;
    }
    var a = this.state_0[0];
    var b = this.state_0[1];
    var c = this.state_0[2];
    var d = this.state_0[3];
    var e = this.state_0[4];
    for (var i_1 = 0; i_1 < 80; i_1++) {
      if (i_1 < 20) {
        var f = d ^ b & (c ^ d);
        var k = 1518500249;
        var $receiver_0 = a;
        tmp$_3 = ($receiver_0 << 5 | $receiver_0 >>> 32 - 5) + f + e + k + x[i_1] | 0;
      } else if (i_1 < 40) {
        var f_0 = b ^ c ^ d;
        var k_0 = 1859775393;
        var $receiver_1 = a;
        tmp$_3 = ($receiver_1 << 5 | $receiver_1 >>> 32 - 5) + f_0 + e + k_0 + x[i_1] | 0;
      } else if (i_1 < 60) {
        var f_1 = b & c | b & d | c & d;
        var k_1 = -1894007588;
        var $receiver_2 = a;
        tmp$_3 = ($receiver_2 << 5 | $receiver_2 >>> 32 - 5) + f_1 + e + k_1 + x[i_1] | 0;
      } else {
        var f_2 = b ^ c ^ d;
        var k_2 = -899497514;
        var $receiver_3 = a;
        tmp$_3 = ($receiver_3 << 5 | $receiver_3 >>> 32 - 5) + f_2 + e + k_2 + x[i_1] | 0;
      }
      var a2 = tmp$_3;
      e = d;
      d = c;
      var $receiver_4 = b;
      c = $receiver_4 << 30 | $receiver_4 >>> 32 - 30;
      b = a;
      a = a2;
    }
    tmp$_4 = this.state_0;
    tmp$_4[0] = tmp$_4[0] + a | 0;
    tmp$_5 = this.state_0;
    tmp$_5[1] = tmp$_5[1] + b | 0;
    tmp$_6 = this.state_0;
    tmp$_6[2] = tmp$_6[2] + c | 0;
    tmp$_7 = this.state_0;
    tmp$_7[3] = tmp$_7[3] + d | 0;
    tmp$_8 = this.state_0;
    tmp$_8[4] = tmp$_8[4] + e | 0;
  };
  SHA1.prototype.digest_4r1zfv$ = function (bitLength, bufferOffset, buffer) {
    buffer[bufferOffset] = toByte(128);
    var size = bufferOffset + 1 | 0;
    if (size > 56) {
      fill(buffer, 0, size, this.blockSize());
      this.compress_fqrh44$(buffer);
      fill(buffer, 0, 0, size);
    } else {
      fill(buffer, 0, size, 56);
    }
    buffer[56] = toByte(bitLength.shiftRightUnsigned(56).toInt());
    buffer[57] = toByte(bitLength.shiftRightUnsigned(48).toInt());
    buffer[58] = toByte(bitLength.shiftRightUnsigned(40).toInt());
    buffer[59] = toByte(bitLength.shiftRightUnsigned(32).toInt());
    buffer[60] = toByte(bitLength.shiftRightUnsigned(24).toInt());
    buffer[61] = toByte(bitLength.shiftRightUnsigned(16).toInt());
    buffer[62] = toByte(bitLength.shiftRightUnsigned(8).toInt());
    buffer[63] = toByte(bitLength.toInt());
    this.compress_fqrh44$(buffer);
    var a = this.state_0[0];
    var b = this.state_0[1];
    var c = this.state_0[2];
    var d = this.state_0[3];
    var e = this.state_0[4];
    return new Int8Array([toByte(a >> 24), toByte(a >> 16), toByte(a >> 8), toByte(a), toByte(b >> 24), toByte(b >> 16), toByte(b >> 8), toByte(b), toByte(c >> 24), toByte(c >> 16), toByte(c >> 8), toByte(c), toByte(d >> 24), toByte(d >> 16), toByte(d >> 8), toByte(d), toByte(e >> 24), toByte(e >> 16), toByte(e >> 8), toByte(e)]);
  };
  SHA1.prototype.resetDigest = function () {
    fill_0(this.x_0, 0);
    this.state_0[0] = 1732584193;
    this.state_0[1] = -271733879;
    this.state_0[2] = -1732584194;
    this.state_0[3] = 271733878;
    this.state_0[4] = -1009589776;
  };
  SHA1.prototype.rotateLeft_0 = function ($receiver, n) {
    return $receiver << n | $receiver >>> 32 - n;
  };
  SHA1.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHA1',
    interfaces: [Digest]
  };
  function SHA1_init($this) {
    $this = $this || Object.create(SHA1.prototype);
    Digest_init('SHA-1', 64, 20, $this);
    SHA1.call($this);
    $this.x_0 = new Int32Array(80);
    $this.state_0 = new Int32Array([1732584193, -271733879, -1732584194, 271733878, -1009589776]);
    return $this;
  }
  function SHA1_init_0(state, digest, $this) {
    $this = $this || Object.create(SHA1.prototype);
    Digest_init_0(state, $this);
    SHA1.call($this);
    $this.x_0 = digest.x_0.slice();
    $this.state_0 = digest.state_0.slice();
    return $this;
  }
  $$importsForInline$$['hash-sha1-js-legacy'] = _;
  var package$org = _.org || (_.org = {});
  var package$kotlincrypto = package$org.kotlincrypto || (package$org.kotlincrypto = {});
  var package$hash = package$kotlincrypto.hash || (package$kotlincrypto.hash = {});
  var package$sha1 = package$hash.sha1 || (package$hash.sha1 = {});
  package$sha1.SHA1_init = SHA1_init;
  package$sha1.SHA1 = SHA1;
  Kotlin.defineModule('hash-sha1-js-legacy', _);
  return _;
}));

//# sourceMappingURL=hash-sha1-js-legacy.js.map
