/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha1;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.digest.Digest;
import org.kotlincrypto.core.digest.internal.DigestState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J \u0010\u0005\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0014J\b\u0010\u0014\u001a\u00020\nH\u0014J\u0015\u0010\u0015\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0082\fR\u000e\u0010\u0003\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kotlincrypto/hash/sha1/SHA1;", "Lorg/kotlincrypto/core/digest/Digest;", "()V", "state", "Lorg/kotlincrypto/core/digest/internal/DigestState;", "digest", "(Lorg/kotlincrypto/core/digest/internal/DigestState;Lorg/kotlincrypto/hash/sha1/SHA1;)V", "", "x", "compress", "", "input", "", "offset", "", "copy", "bitLength", "", "bufferOffset", "buffer", "resetDigest", "rotateLeft", "n", "sha1"})
@SourceDebugExtension(value={"SMAP\nSHA1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SHA1.kt\norg/kotlincrypto/hash/sha1/SHA1\n*L\n1#1,168:1\n166#1:169\n166#1:170\n166#1:171\n166#1:172\n166#1:173\n166#1:174\n*S KotlinDebug\n*F\n+ 1 SHA1.kt\norg/kotlincrypto/hash/sha1/SHA1\n*L\n56#1:169\n70#1:170\n75#1:171\n80#1:172\n85#1:173\n91#1:174\n*E\n"})
public final class SHA1
extends Digest {
    @NotNull
    private final int[] x;
    @NotNull
    private final int[] state;

    public SHA1() {
        super("SHA-1", 64, 20);
        this.x = new int[80];
        int[] nArray = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        this.state = nArray;
    }

    private SHA1(DigestState state, SHA1 digest) {
        super(state);
        int[] nArray = Arrays.copyOf(digest.x, digest.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, size)");
        this.x = nArray;
        int[] nArray2 = Arrays.copyOf(digest.state, digest.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(this, size)");
        this.state = nArray2;
    }

    @NotNull
    protected Digest copy(@NotNull DigestState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new SHA1(state, this);
    }

    /*
     * WARNING - void declaration
     */
    protected void compress(@NotNull byte[] input, int offset) {
        int i;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int[] x = this.x;
        int j = offset;
        for (i = 0; i < 16; ++i) {
            x[i] = (input[j++] & 0xFF) << 24 | (input[j++] & 0xFF) << 16 | (input[j++] & 0xFF) << 8 | input[j++] & 0xFF;
        }
        for (i = 16; i < 80; ++i) {
            void $this$rotateLeft$iv;
            SHA1 sHA1 = this;
            int n = x[i - 3] ^ x[i - 8] ^ x[i - 14] ^ x[i - 16];
            int n$iv = 1;
            boolean $i$f$rotateLeft = false;
            x[i] = $this$rotateLeft$iv << n$iv | $this$rotateLeft$iv >>> 32 - n$iv;
        }
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        int e = this.state[4];
        for (int i2 = 0; i2 < 80; ++i2) {
            void $this$rotateLeft$iv;
            SHA1 this_$iv;
            int n;
            int $this$rotateLeft$iv2;
            boolean $i$f$rotateLeft;
            int n$iv;
            int k;
            int f;
            if (i2 < 20) {
                f = d ^ b & (c ^ d);
                k = 1518500249;
                SHA1 sHA1 = this;
                int n2 = a;
                n$iv = 5;
                $i$f$rotateLeft = false;
                n = ($this$rotateLeft$iv2 << n$iv | $this$rotateLeft$iv2 >>> 32 - n$iv) + f + e + k + x[i2];
            } else if (i2 < 40) {
                f = b ^ c ^ d;
                k = 1859775393;
                this_$iv = this;
                $this$rotateLeft$iv2 = a;
                n$iv = 5;
                $i$f$rotateLeft = false;
                n = ($this$rotateLeft$iv2 << n$iv | $this$rotateLeft$iv2 >>> 32 - n$iv) + f + e + k + x[i2];
            } else if (i2 < 60) {
                f = b & c | b & d | c & d;
                k = -1894007588;
                this_$iv = this;
                $this$rotateLeft$iv2 = a;
                n$iv = 5;
                $i$f$rotateLeft = false;
                n = ($this$rotateLeft$iv2 << n$iv | $this$rotateLeft$iv2 >>> 32 - n$iv) + f + e + k + x[i2];
            } else {
                f = b ^ c ^ d;
                k = -899497514;
                this_$iv = this;
                $this$rotateLeft$iv2 = a;
                n$iv = 5;
                $i$f$rotateLeft = false;
                n = ($this$rotateLeft$iv2 << n$iv | $this$rotateLeft$iv2 >>> 32 - n$iv) + f + e + k + x[i2];
            }
            int a2 = n;
            e = d;
            d = c;
            SHA1 f2 = this;
            k = b;
            int n$iv2 = 30;
            boolean $i$f$rotateLeft2 = false;
            c = $this$rotateLeft$iv << n$iv2 | $this$rotateLeft$iv >>> 32 - n$iv2;
            b = a;
            a = a2;
        }
        int[] nArray = this.state;
        nArray[0] = nArray[0] + a;
        nArray = this.state;
        nArray[1] = nArray[1] + b;
        nArray = this.state;
        nArray[2] = nArray[2] + c;
        nArray = this.state;
        nArray[3] = nArray[3] + d;
        nArray = this.state;
        nArray[4] = nArray[4] + e;
    }

    @NotNull
    protected byte[] digest(long bitLength, int bufferOffset, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer[bufferOffset] = -128;
        int size = bufferOffset + 1;
        if (size > 56) {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)this.blockSize());
            this.compress(buffer, 0);
            ArraysKt.fill((byte[])buffer, (byte)0, (int)0, (int)size);
        } else {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)56);
        }
        buffer[56] = (byte)(bitLength >>> 56);
        buffer[57] = (byte)(bitLength >>> 48);
        buffer[58] = (byte)(bitLength >>> 40);
        buffer[59] = (byte)(bitLength >>> 32);
        buffer[60] = (byte)(bitLength >>> 24);
        buffer[61] = (byte)(bitLength >>> 16);
        buffer[62] = (byte)(bitLength >>> 8);
        buffer[63] = (byte)bitLength;
        this.compress(buffer, 0);
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        int e = this.state[4];
        byte[] byArray = new byte[]{(byte)(a >> 24), (byte)(a >> 16), (byte)(a >> 8), (byte)a, (byte)(b >> 24), (byte)(b >> 16), (byte)(b >> 8), (byte)b, (byte)(c >> 24), (byte)(c >> 16), (byte)(c >> 8), (byte)c, (byte)(d >> 24), (byte)(d >> 16), (byte)(d >> 8), (byte)d, (byte)(e >> 24), (byte)(e >> 16), (byte)(e >> 8), (byte)e};
        return byArray;
    }

    protected void resetDigest() {
        ArraysKt.fill$default((int[])this.x, (int)0, (int)0, (int)0, (int)6, null);
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
    }

    private final int rotateLeft(int $this$rotateLeft, int n) {
        boolean $i$f$rotateLeft = false;
        return $this$rotateLeft << n | $this$rotateLeft >>> 32 - n;
    }
}

