/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha1;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.bitops.bits.Counter;
import org.kotlincrypto.bitops.endian.Endian;
import org.kotlincrypto.core.digest.Digest;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0000H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0014J(\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0014J\b\u0010\u0018\u001a\u00020\rH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kotlincrypto/hash/sha1/SHA1;", "Lorg/kotlincrypto/core/digest/Digest;", "<init>", "()V", "other", "(Lorg/kotlincrypto/hash/sha1/SHA1;)V", "x", "", "state", "count", "Lorg/kotlincrypto/bitops/bits/Counter$Bit32;", "copy", "compressProtected", "", "input", "", "offset", "", "digestProtected", "buf", "bufPos", "digestIntoProtected", "dest", "destOffset", "resetProtected", "Companion", "org.kotlincrypto.hash_sha1_jvm"})
@SourceDebugExtension(value={"SMAP\nSHA1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SHA1.kt\norg/kotlincrypto/hash/sha1/SHA1\n+ 2 Endian.kt\norg/kotlincrypto/bitops/endian/Endian$Big\n*L\n1#1,152:1\n1848#2:153\n1821#2:154\n1821#2:155\n1833#2,7:156\n*S KotlinDebug\n*F\n+ 1 SHA1.kt\norg/kotlincrypto/hash/sha1/SHA1\n*L\n52#1:153\n133#1:154\n134#1:155\n137#1:156,7\n*E\n"})
public final class SHA1
extends Digest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] x;
    @NotNull
    private final int[] state;
    @NotNull
    private final Counter.Bit32 count;
    private static final int BLOCK_SIZE = 64;
    @NotNull
    private static final int[] H;

    public SHA1() {
        super("SHA-1", 64, 20);
        this.x = new int[80];
        int[] nArray = Arrays.copyOf(H, H.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.state = nArray;
        this.count = new Counter.Bit32(64);
    }

    private SHA1(SHA1 other) {
        super((Digest)other);
        int[] nArray = Arrays.copyOf(other.x, other.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.x = nArray;
        int[] nArray2 = Arrays.copyOf(other.state, other.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        this.state = nArray2;
        this.count = other.count.copy();
    }

    @NotNull
    public SHA1 copy() {
        return new SHA1(this);
    }

    /*
     * WARNING - void declaration
     */
    protected void compressProtected(@NotNull byte[] input, int offset) {
        int a2;
        int k;
        int f;
        int i;
        void destOffset$iv;
        void $this$bePackIntoUnsafe$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int[] x = this.x;
        byte[] byArray = input;
        boolean bl = false;
        int sourceIndexEnd$iv = offset + 64;
        boolean $i$f$bePackIntoUnsafe = false;
        Endian.Big.INSTANCE.packUnsafe((byte[])$this$bePackIntoUnsafe$iv, x, (int)destOffset$iv, offset, sourceIndexEnd$iv);
        for (int i2 = 16; i2 < 80; ++i2) {
            x[i2] = Integer.rotateLeft(x[i2 - 3] ^ x[i2 - 8] ^ x[i2 - 14] ^ x[i2 - 16], 1);
        }
        int[] state = this.state;
        int a = state[0];
        int b = state[1];
        int c = state[2];
        int d = state[3];
        int e = state[4];
        for (i = 0; i < 20; ++i) {
            f = d ^ b & (c ^ d);
            k = 1518500249;
            a2 = Integer.rotateLeft(a, 5) + f + e + k + x[i];
            e = d;
            d = c;
            c = Integer.rotateLeft(b, 30);
            b = a;
            a = a2;
        }
        for (i = 20; i < 40; ++i) {
            f = b ^ c ^ d;
            k = 1859775393;
            a2 = Integer.rotateLeft(a, 5) + f + e + k + x[i];
            e = d;
            d = c;
            c = Integer.rotateLeft(b, 30);
            b = a;
            a = a2;
        }
        for (i = 40; i < 60; ++i) {
            f = b & c | b & d | c & d;
            k = -1894007588;
            a2 = Integer.rotateLeft(a, 5) + f + e + k + x[i];
            e = d;
            d = c;
            c = Integer.rotateLeft(b, 30);
            b = a;
            a = a2;
        }
        for (i = 60; i < 80; ++i) {
            f = b ^ c ^ d;
            k = -899497514;
            a2 = Integer.rotateLeft(a, 5) + f + e + k + x[i];
            e = d;
            d = c;
            c = Integer.rotateLeft(b, 30);
            b = a;
            a = a2;
        }
        state[0] = state[0] + a;
        state[1] = state[1] + b;
        state[2] = state[2] + c;
        state[3] = state[3] + d;
        state[4] = state[4] + e;
        this.count.increment();
    }

    @NotNull
    protected byte[] digestProtected(@NotNull byte[] buf, int bufPos) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        byte[] digest = new byte[this.digestLength()];
        this.digestIntoProtected(digest, 0, buf, bufPos);
        return digest;
    }

    protected void digestIntoProtected(@NotNull byte[] dest, int destOffset, @NotNull byte[] buf, int bufPos) {
        int $this$bePackIntoUnsafe$iv;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Counter.Bit32.Final final_ = this.count.final(bufPos).asBits();
        int bitsLo = final_.component1();
        int bitsHi = final_.component2();
        buf[bufPos] = -128;
        if (bufPos + 1 > 56) {
            this.compressProtected(buf, 0);
            ArraysKt.fill((byte[])buf, (byte)0, (int)0, (int)56);
        }
        int n = bitsHi;
        int destOffset$iv = 56;
        boolean $i$f$bePackIntoUnsafe = false;
        Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe$iv, buf, destOffset$iv);
        $this$bePackIntoUnsafe$iv = bitsLo;
        destOffset$iv = 60;
        $i$f$bePackIntoUnsafe = false;
        Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe$iv, buf, destOffset$iv);
        this.compressProtected(buf, 0);
        int[] $this$bePackIntoUnsafe_u24default$iv = this.state;
        int sourceIndexStart$iv = 0;
        int sourceIndexEnd$iv = $this$bePackIntoUnsafe_u24default$iv.length;
        boolean $i$f$bePackIntoUnsafe2 = false;
        Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe_u24default$iv, dest, destOffset, sourceIndexStart$iv, sourceIndexEnd$iv);
    }

    protected void resetProtected() {
        ArraysKt.fill$default((int[])this.x, (int)0, (int)0, (int)0, (int)6, null);
        ArraysKt.copyInto$default((int[])H, (int[])this.state, (int)0, (int)0, (int)0, (int)14, null);
        this.count.reset();
    }

    static {
        int[] nArray = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        H = nArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kotlincrypto/hash/sha1/SHA1$Companion;", "", "<init>", "()V", "BLOCK_SIZE", "", "H", "", "org.kotlincrypto.hash_sha1_jvm"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

