(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'core-digest-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('core-digest-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'hash-256-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'hash-256-js-legacy'.");
    }
    if (typeof this['core-digest-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'hash-256-js-legacy'. Its dependency 'core-digest-js-legacy' was not found. Please, check whether 'core-digest-js-legacy' is loaded prior to 'hash-256-js-legacy'.");
    }
    root['hash-256-js-legacy'] = factory(typeof this['hash-256-js-legacy'] === 'undefined' ? {} : this['hash-256-js-legacy'], kotlin, this['core-digest-js-legacy']);
  }
}(this, function (_, Kotlin, $module$core_digest_js_legacy) {
  'use strict';
  var toByte = Kotlin.toByte;
  var fill = Kotlin.kotlin.collections.fill_6mk3ue$;
  var fill_0 = Kotlin.kotlin.collections.fill_tpuxuu$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Digest = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest;
  var Digest_init = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest_init_3m52m6$;
  var Digest_init_0 = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest_init_l73exj$;
  Sha256.prototype = Object.create(Digest.prototype);
  Sha256.prototype.constructor = Sha256;
  function Sha256() {
    Sha256$Companion_getInstance();
    this.x_0 = null;
    this.state_0 = null;
  }
  Sha256.prototype.copy_l73exj$ = function (state) {
    return Sha256_init_0(state, this);
  };
  Sha256.prototype.compress_fqrh44$ = function (buffer) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8, tmp$_9, tmp$_10;
    var x = this.x_0;
    var bI = 0;
    for (var i = 0; i < 16; i++) {
      x[i] = (buffer[tmp$ = bI, bI = tmp$ + 1 | 0, tmp$] & 255) << 24 | (buffer[tmp$_0 = bI, bI = tmp$_0 + 1 | 0, tmp$_0] & 255) << 16 | (buffer[tmp$_1 = bI, bI = tmp$_1 + 1 | 0, tmp$_1] & 255) << 8 | buffer[tmp$_2 = bI, bI = tmp$_2 + 1 | 0, tmp$_2] & 255;
    }
    for (var i_0 = 16; i_0 < 64; i_0++) {
      var x15 = x[i_0 - 15 | 0];
      var s0 = (x15 >>> 7 | x15 << 25) ^ (x15 >>> 18 | x15 << 14) ^ x15 >>> 3;
      var x2 = x[i_0 - 2 | 0];
      var s1 = (x2 >>> 17 | x2 << 15) ^ (x2 >>> 19 | x2 << 13) ^ x2 >>> 10;
      var x16 = x[i_0 - 16 | 0];
      var x7 = x[i_0 - 7 | 0];
      x[i_0] = x16 + s0 + x7 + s1 | 0;
    }
    var k = Sha256$Companion_getInstance().K_0;
    var a = this.state_0[0];
    var b = this.state_0[1];
    var c = this.state_0[2];
    var d = this.state_0[3];
    var e = this.state_0[4];
    var f = this.state_0[5];
    var g = this.state_0[6];
    var h = this.state_0[7];
    for (var i_1 = 0; i_1 < 64; i_1++) {
      var s0_0 = (a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10);
      var s1_0 = (e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7);
      var ch = e & f ^ ~e & g;
      var maj = a & b ^ a & c ^ b & c;
      var t1 = h + s1_0 + ch + k[i_1] + x[i_1] | 0;
      var t2 = s0_0 + maj | 0;
      h = g;
      g = f;
      f = e;
      e = d + t1 | 0;
      d = c;
      c = b;
      b = a;
      a = t1 + t2 | 0;
    }
    tmp$_3 = this.state_0;
    tmp$_3[0] = tmp$_3[0] + a | 0;
    tmp$_4 = this.state_0;
    tmp$_4[1] = tmp$_4[1] + b | 0;
    tmp$_5 = this.state_0;
    tmp$_5[2] = tmp$_5[2] + c | 0;
    tmp$_6 = this.state_0;
    tmp$_6[3] = tmp$_6[3] + d | 0;
    tmp$_7 = this.state_0;
    tmp$_7[4] = tmp$_7[4] + e | 0;
    tmp$_8 = this.state_0;
    tmp$_8[5] = tmp$_8[5] + f | 0;
    tmp$_9 = this.state_0;
    tmp$_9[6] = tmp$_9[6] + g | 0;
    tmp$_10 = this.state_0;
    tmp$_10[7] = tmp$_10[7] + h | 0;
  };
  Sha256.prototype.digest_4r1zfv$ = function (bitLength, bufferOffset, buffer) {
    buffer[bufferOffset] = toByte(128);
    var size = bufferOffset + 1 | 0;
    if (size > 56) {
      fill(buffer, 0, size, 64);
      this.compress_fqrh44$(buffer);
      fill(buffer, 0, 0, size);
    } else {
      fill(buffer, 0, size, 56);
    }
    buffer[56] = toByte(bitLength.shiftRightUnsigned(56).toInt());
    buffer[57] = toByte(bitLength.shiftRightUnsigned(48).toInt());
    buffer[58] = toByte(bitLength.shiftRightUnsigned(40).toInt());
    buffer[59] = toByte(bitLength.shiftRightUnsigned(32).toInt());
    buffer[60] = toByte(bitLength.shiftRightUnsigned(24).toInt());
    buffer[61] = toByte(bitLength.shiftRightUnsigned(16).toInt());
    buffer[62] = toByte(bitLength.shiftRightUnsigned(8).toInt());
    buffer[63] = toByte(bitLength.toInt());
    this.compress_fqrh44$(buffer);
    var a = this.state_0[0];
    var b = this.state_0[1];
    var c = this.state_0[2];
    var d = this.state_0[3];
    var e = this.state_0[4];
    var f = this.state_0[5];
    var g = this.state_0[6];
    var h = this.state_0[7];
    return new Int8Array([toByte(a >> 24), toByte(a >> 16), toByte(a >> 8), toByte(a), toByte(b >> 24), toByte(b >> 16), toByte(b >> 8), toByte(b), toByte(c >> 24), toByte(c >> 16), toByte(c >> 8), toByte(c), toByte(d >> 24), toByte(d >> 16), toByte(d >> 8), toByte(d), toByte(e >> 24), toByte(e >> 16), toByte(e >> 8), toByte(e), toByte(f >> 24), toByte(f >> 16), toByte(f >> 8), toByte(f), toByte(g >> 24), toByte(g >> 16), toByte(g >> 8), toByte(g), toByte(h >> 24), toByte(h >> 16), toByte(h >> 8), toByte(h)]);
  };
  Sha256.prototype.resetDigest = function () {
    fill_0(this.x_0, 0);
    this.state_0[0] = 1779033703;
    this.state_0[1] = -1150833019;
    this.state_0[2] = 1013904242;
    this.state_0[3] = -1521486534;
    this.state_0[4] = 1359893119;
    this.state_0[5] = -1694144372;
    this.state_0[6] = 528734635;
    this.state_0[7] = 1541459225;
  };
  function Sha256$Companion() {
    Sha256$Companion_instance = this;
    this.K_0 = new Int32Array([1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998]);
  }
  Sha256$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Sha256$Companion_instance = null;
  function Sha256$Companion_getInstance() {
    if (Sha256$Companion_instance === null) {
      new Sha256$Companion();
    }
    return Sha256$Companion_instance;
  }
  Sha256.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Sha256',
    interfaces: [Digest]
  };
  function Sha256_init($this) {
    $this = $this || Object.create(Sha256.prototype);
    Digest_init('SHA-256', 64, 32, $this);
    Sha256.call($this);
    $this.x_0 = new Int32Array(64);
    $this.state_0 = new Int32Array([1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225]);
    return $this;
  }
  function Sha256_init_0(state, sha256, $this) {
    $this = $this || Object.create(Sha256.prototype);
    Digest_init_0(state, $this);
    Sha256.call($this);
    $this.x_0 = sha256.x_0.slice();
    $this.state_0 = sha256.state_0.slice();
    return $this;
  }
  var package$org = _.org || (_.org = {});
  var package$kotlincrypto = package$org.kotlincrypto || (package$org.kotlincrypto = {});
  var package$hash = package$kotlincrypto.hash || (package$kotlincrypto.hash = {});
  package$hash.Sha256_init = Sha256_init;
  package$hash.Sha256 = Sha256;
  Kotlin.defineModule('hash-256-js-legacy', _);
  return _;
}));

//# sourceMappingURL=hash-256-js-legacy.js.map
