/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.Digest;
import org.kotlincrypto.core.internal.DigestState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\u0013\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kotlincrypto/hash/Sha256;", "Lorg/kotlincrypto/core/Digest;", "()V", "state", "Lorg/kotlincrypto/core/internal/DigestState;", "sha256", "(Lorg/kotlincrypto/core/internal/DigestState;Lorg/kotlincrypto/hash/Sha256;)V", "", "x", "compress", "", "buffer", "", "copy", "digest", "bitLength", "", "bufferOffset", "", "resetDigest", "Companion", "sha2-256"})
public final class Sha256
extends Digest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] x;
    @NotNull
    private final int[] state;
    @Deprecated
    @NotNull
    private static final int[] K;

    public Sha256() {
        super("SHA-256", 64, 32);
        this.x = new int[64];
        int[] nArray = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
        this.state = nArray;
    }

    private Sha256(DigestState state, Sha256 sha256) {
        super(state);
        int[] nArray = Arrays.copyOf(sha256.x, sha256.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, size)");
        this.x = nArray;
        int[] nArray2 = Arrays.copyOf(sha256.state, sha256.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(this, size)");
        this.state = nArray2;
    }

    @NotNull
    protected Digest copy(@NotNull DigestState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new Sha256(state, this);
    }

    protected void compress(@NotNull byte[] buffer) {
        int i;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int[] x = this.x;
        int bI = 0;
        for (i = 0; i < 16; ++i) {
            x[i] = (buffer[bI++] & 0xFF) << 24 | (buffer[bI++] & 0xFF) << 16 | (buffer[bI++] & 0xFF) << 8 | buffer[bI++] & 0xFF;
        }
        for (i = 16; i < 64; ++i) {
            int x15 = x[i - 15];
            int s0 = (x15 >>> 7 | x15 << 25) ^ (x15 >>> 18 | x15 << 14) ^ x15 >>> 3;
            int x2 = x[i - 2];
            int s1 = (x2 >>> 17 | x2 << 15) ^ (x2 >>> 19 | x2 << 13) ^ x2 >>> 10;
            int x16 = x[i - 16];
            int x7 = x[i - 7];
            x[i] = x16 + s0 + x7 + s1;
        }
        int[] k = K;
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        int e = this.state[4];
        int f = this.state[5];
        int g = this.state[6];
        int h = this.state[7];
        for (int i2 = 0; i2 < 64; ++i2) {
            int s0 = (a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10);
            int s1 = (e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7);
            int ch = e & f ^ ~e & g;
            int maj = a & b ^ a & c ^ b & c;
            int t1 = h + s1 + ch + k[i2] + x[i2];
            int t2 = s0 + maj;
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
        }
        int[] nArray = this.state;
        nArray[0] = nArray[0] + a;
        nArray = this.state;
        nArray[1] = nArray[1] + b;
        nArray = this.state;
        nArray[2] = nArray[2] + c;
        nArray = this.state;
        nArray[3] = nArray[3] + d;
        nArray = this.state;
        nArray[4] = nArray[4] + e;
        nArray = this.state;
        nArray[5] = nArray[5] + f;
        nArray = this.state;
        nArray[6] = nArray[6] + g;
        nArray = this.state;
        nArray[7] = nArray[7] + h;
    }

    @NotNull
    protected byte[] digest(long bitLength, int bufferOffset, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer[bufferOffset] = -128;
        int size = bufferOffset + 1;
        if (size > 56) {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)64);
            this.compress(buffer);
            ArraysKt.fill((byte[])buffer, (byte)0, (int)0, (int)size);
        } else {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)56);
        }
        buffer[56] = (byte)(bitLength >>> 56);
        buffer[57] = (byte)(bitLength >>> 48);
        buffer[58] = (byte)(bitLength >>> 40);
        buffer[59] = (byte)(bitLength >>> 32);
        buffer[60] = (byte)(bitLength >>> 24);
        buffer[61] = (byte)(bitLength >>> 16);
        buffer[62] = (byte)(bitLength >>> 8);
        buffer[63] = (byte)bitLength;
        this.compress(buffer);
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        int e = this.state[4];
        int f = this.state[5];
        int g = this.state[6];
        int h = this.state[7];
        byte[] byArray = new byte[]{(byte)(a >> 24), (byte)(a >> 16), (byte)(a >> 8), (byte)a, (byte)(b >> 24), (byte)(b >> 16), (byte)(b >> 8), (byte)b, (byte)(c >> 24), (byte)(c >> 16), (byte)(c >> 8), (byte)c, (byte)(d >> 24), (byte)(d >> 16), (byte)(d >> 8), (byte)d, (byte)(e >> 24), (byte)(e >> 16), (byte)(e >> 8), (byte)e, (byte)(f >> 24), (byte)(f >> 16), (byte)(f >> 8), (byte)f, (byte)(g >> 24), (byte)(g >> 16), (byte)(g >> 8), (byte)g, (byte)(h >> 24), (byte)(h >> 16), (byte)(h >> 8), (byte)h};
        return byArray;
    }

    protected void resetDigest() {
        ArraysKt.fill$default((int[])this.x, (int)0, (int)0, (int)0, (int)6, null);
        this.state[0] = 1779033703;
        this.state[1] = -1150833019;
        this.state[2] = 1013904242;
        this.state[3] = -1521486534;
        this.state[4] = 1359893119;
        this.state[5] = -1694144372;
        this.state[6] = 528734635;
        this.state[7] = 1541459225;
    }

    static {
        int[] nArray = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
        K = nArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kotlincrypto/hash/Sha256$Companion;", "", "()V", "K", "", "sha2-256"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

