/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.Digest;
import org.kotlincrypto.core.internal.DigestState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\u0013\u001a\u00020\nH\u0014J\u0015\u0010\u0014\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0012H\u0082\fR\u000e\u0010\u0003\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kotlincrypto/hash/Sha512;", "Lorg/kotlincrypto/core/Digest;", "()V", "state", "Lorg/kotlincrypto/core/internal/DigestState;", "sha512", "(Lorg/kotlincrypto/core/internal/DigestState;Lorg/kotlincrypto/hash/Sha512;)V", "", "x", "compress", "", "buffer", "", "copy", "digest", "bitLength", "", "bufferOffset", "", "resetDigest", "rotateRight", "n", "Companion", "sha2-512"})
@SourceDebugExtension(value={"SMAP\nSha512.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sha512.kt\norg/kotlincrypto/hash/Sha512\n*L\n1#1,259:1\n232#1:260\n232#1:261\n232#1:262\n232#1:263\n*S KotlinDebug\n*F\n+ 1 Sha512.kt\norg/kotlincrypto/hash/Sha512\n*L\n70#1:260\n72#1:261\n90#1:262\n91#1:263\n*E\n"})
public final class Sha512
extends Digest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final long[] x;
    @NotNull
    private final long[] state;
    @Deprecated
    @NotNull
    private static final long[] K;

    public Sha512() {
        super("SHA-512", 128, 64);
        this.x = new long[80];
        long[] lArray = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
        this.state = lArray;
    }

    private Sha512(DigestState state, Sha512 sha512) {
        super(state);
        long[] lArray = Arrays.copyOf(sha512.x, sha512.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(this, size)");
        this.x = lArray;
        long[] lArray2 = Arrays.copyOf(sha512.state, sha512.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(this, size)");
        this.state = lArray2;
    }

    @NotNull
    protected Digest copy(@NotNull DigestState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new Sha512(state, this);
    }

    protected void compress(@NotNull byte[] buffer) {
        int i;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long[] x = this.x;
        int bI = 0;
        for (i = 0; i < 16; ++i) {
            x[i] = ((long)buffer[bI++] & 0xFFL) << 56 | ((long)buffer[bI++] & 0xFFL) << 48 | ((long)buffer[bI++] & 0xFFL) << 40 | ((long)buffer[bI++] & 0xFFL) << 32 | ((long)buffer[bI++] & 0xFFL) << 24 | ((long)buffer[bI++] & 0xFFL) << 16 | ((long)buffer[bI++] & 0xFFL) << 8 | (long)buffer[bI++] & 0xFFL;
        }
        for (i = 16; i < 80; ++i) {
            long $this$rotateRight$iv;
            long $this$rotateRight$iv2;
            long x15 = x[i - 15];
            Sha512 sha512 = this;
            long l = x15;
            int n$iv = 1;
            boolean $i$f$rotateRight = false;
            void v0 = $this$rotateRight$iv2 >>> n$iv | $this$rotateRight$iv2 << 64 - n$iv;
            Sha512 this_$iv = this;
            $this$rotateRight$iv2 = x15;
            n$iv = 8;
            $i$f$rotateRight = false;
            void s0 = v0 ^ ($this$rotateRight$iv2 >>> n$iv | $this$rotateRight$iv2 << 64 - n$iv) ^ x15 >>> 7;
            long x2 = x[i - 2];
            Sha512 $i$f$rotateRight2 = this;
            long l2 = x2;
            int n$iv2 = 19;
            boolean $i$f$rotateRight3 = false;
            void v1 = $this$rotateRight$iv >>> n$iv2 | $this$rotateRight$iv << 64 - n$iv2;
            Sha512 this_$iv2 = this;
            $this$rotateRight$iv = x2;
            n$iv2 = 61;
            $i$f$rotateRight3 = false;
            void s1 = v1 ^ ($this$rotateRight$iv >>> n$iv2 | $this$rotateRight$iv << 64 - n$iv2) ^ x2 >>> 6;
            long x16 = x[i - 16];
            long x7 = x[i - 7];
            x[i] = x16 + s0 + x7 + s1;
        }
        long[] k = K;
        long a = this.state[0];
        long b = this.state[1];
        long c = this.state[2];
        long d = this.state[3];
        long e = this.state[4];
        long f = this.state[5];
        long g = this.state[6];
        long h = this.state[7];
        for (int i2 = 0; i2 < 80; ++i2) {
            long $this$rotateRight$iv;
            long $this$rotateRight$iv3;
            Sha512 sha512 = this;
            long l = a;
            int n$iv = 28;
            boolean $i$f$rotateRight = false;
            void v2 = $this$rotateRight$iv3 >>> n$iv | $this$rotateRight$iv3 << 64 - n$iv;
            Sha512 this_$iv = this;
            $this$rotateRight$iv3 = a;
            n$iv = 34;
            $i$f$rotateRight = false;
            void v3 = v2 ^ ($this$rotateRight$iv3 >>> n$iv | $this$rotateRight$iv3 << 64 - n$iv);
            this_$iv = this;
            $this$rotateRight$iv3 = a;
            n$iv = 39;
            $i$f$rotateRight = false;
            void s0 = v3 ^ ($this$rotateRight$iv3 >>> n$iv | $this$rotateRight$iv3 << 64 - n$iv);
            Sha512 sha5122 = this;
            long n$iv2 = e;
            int n$iv3 = 14;
            boolean $i$f$rotateRight4 = false;
            void v4 = $this$rotateRight$iv >>> n$iv3 | $this$rotateRight$iv << 64 - n$iv3;
            Sha512 this_$iv3 = this;
            $this$rotateRight$iv = e;
            n$iv3 = 18;
            $i$f$rotateRight4 = false;
            void v5 = v4 ^ ($this$rotateRight$iv >>> n$iv3 | $this$rotateRight$iv << 64 - n$iv3);
            this_$iv3 = this;
            $this$rotateRight$iv = e;
            n$iv3 = 41;
            $i$f$rotateRight4 = false;
            void s1 = v5 ^ ($this$rotateRight$iv >>> n$iv3 | $this$rotateRight$iv << 64 - n$iv3);
            long ch = e & f ^ (e ^ 0xFFFFFFFFFFFFFFFFL) & g;
            long maj = a & b ^ a & c ^ b & c;
            long t1 = h + s1 + ch + k[i2] + x[i2];
            void t2 = s0 + maj;
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
        }
        long[] lArray = this.state;
        lArray[0] = lArray[0] + a;
        lArray = this.state;
        lArray[1] = lArray[1] + b;
        lArray = this.state;
        lArray[2] = lArray[2] + c;
        lArray = this.state;
        lArray[3] = lArray[3] + d;
        lArray = this.state;
        lArray[4] = lArray[4] + e;
        lArray = this.state;
        lArray[5] = lArray[5] + f;
        lArray = this.state;
        lArray[6] = lArray[6] + g;
        lArray = this.state;
        lArray[7] = lArray[7] + h;
    }

    @NotNull
    protected byte[] digest(long bitLength, int bufferOffset, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer[bufferOffset] = -128;
        int size = bufferOffset + 1;
        if (size > 112) {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)128);
            this.compress(buffer);
            ArraysKt.fill((byte[])buffer, (byte)0, (int)0, (int)size);
        } else {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)120);
        }
        buffer[120] = (byte)(bitLength >>> 56);
        buffer[121] = (byte)(bitLength >>> 48);
        buffer[122] = (byte)(bitLength >>> 40);
        buffer[123] = (byte)(bitLength >>> 32);
        buffer[124] = (byte)(bitLength >>> 24);
        buffer[125] = (byte)(bitLength >>> 16);
        buffer[126] = (byte)(bitLength >>> 8);
        buffer[127] = (byte)bitLength;
        this.compress(buffer);
        long a = this.state[0];
        long b = this.state[1];
        long c = this.state[2];
        long d = this.state[3];
        long e = this.state[4];
        long f = this.state[5];
        long g = this.state[6];
        long h = this.state[7];
        byte[] byArray = new byte[]{(byte)(a >> 56), (byte)(a >> 48), (byte)(a >> 40), (byte)(a >> 32), (byte)(a >> 24), (byte)(a >> 16), (byte)(a >> 8), (byte)a, (byte)(b >> 56), (byte)(b >> 48), (byte)(b >> 40), (byte)(b >> 32), (byte)(b >> 24), (byte)(b >> 16), (byte)(b >> 8), (byte)b, (byte)(c >> 56), (byte)(c >> 48), (byte)(c >> 40), (byte)(c >> 32), (byte)(c >> 24), (byte)(c >> 16), (byte)(c >> 8), (byte)c, (byte)(d >> 56), (byte)(d >> 48), (byte)(d >> 40), (byte)(d >> 32), (byte)(d >> 24), (byte)(d >> 16), (byte)(d >> 8), (byte)d, (byte)(e >> 56), (byte)(e >> 48), (byte)(e >> 40), (byte)(e >> 32), (byte)(e >> 24), (byte)(e >> 16), (byte)(e >> 8), (byte)e, (byte)(f >> 56), (byte)(f >> 48), (byte)(f >> 40), (byte)(f >> 32), (byte)(f >> 24), (byte)(f >> 16), (byte)(f >> 8), (byte)f, (byte)(g >> 56), (byte)(g >> 48), (byte)(g >> 40), (byte)(g >> 32), (byte)(g >> 24), (byte)(g >> 16), (byte)(g >> 8), (byte)g, (byte)(h >> 56), (byte)(h >> 48), (byte)(h >> 40), (byte)(h >> 32), (byte)(h >> 24), (byte)(h >> 16), (byte)(h >> 8), (byte)h};
        return byArray;
    }

    protected void resetDigest() {
        ArraysKt.fill$default((long[])this.x, (long)0L, (int)0, (int)0, (int)6, null);
        this.state[0] = 7640891576956012808L;
        this.state[1] = -4942790177534073029L;
        this.state[2] = 4354685564936845355L;
        this.state[3] = -6534734903238641935L;
        this.state[4] = 5840696475078001361L;
        this.state[5] = -7276294671716946913L;
        this.state[6] = 2270897969802886507L;
        this.state[7] = 6620516959819538809L;
    }

    private final long rotateRight(long $this$rotateRight, int n) {
        boolean $i$f$rotateRight = false;
        return $this$rotateRight >>> n | $this$rotateRight << 64 - n;
    }

    static {
        long[] lArray = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
        K = lArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kotlincrypto/hash/Sha512$Companion;", "", "()V", "K", "", "sha2-512"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

