(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'core-digest-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('core-digest-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'hash-sha2-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'hash-sha2-js-legacy'.");
    }
    if (typeof this['core-digest-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'hash-sha2-js-legacy'. Its dependency 'core-digest-js-legacy' was not found. Please, check whether 'core-digest-js-legacy' is loaded prior to 'hash-sha2-js-legacy'.");
    }
    root['hash-sha2-js-legacy'] = factory(typeof this['hash-sha2-js-legacy'] === 'undefined' ? {} : this['hash-sha2-js-legacy'], kotlin, this['core-digest-js-legacy']);
  }
}(this, function (_, Kotlin, $module$core_digest_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var toByte = Kotlin.toByte;
  var fill = Kotlin.kotlin.collections.fill_6mk3ue$;
  var fill_0 = Kotlin.kotlin.collections.fill_tpuxuu$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Digest = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest;
  var Digest_init = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest_init_3m52m6$;
  var Digest_init_0 = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest_init_l73exj$;
  var L255 = Kotlin.Long.fromInt(255);
  var L0 = Kotlin.Long.ZERO;
  var fill_1 = Kotlin.kotlin.collections.fill_wp4zxy$;
  var L4794697086780616226 = new Kotlin.Long(-685199838, 1116352408);
  var L8158064640168781261 = new Kotlin.Long(602891725, 1899447441);
  var L_5349999486874862801 = new Kotlin.Long(-330482897, -1245643825);
  var L_1606136188198331460 = new Kotlin.Long(-2121671748, -373957723);
  var L4131703408338449720 = new Kotlin.Long(-213338824, 961987163);
  var L6480981068601479193 = new Kotlin.Long(-1241133031, 1508970993);
  var L_7908458776815382629 = new Kotlin.Long(-1357295717, -1841331548);
  var L_6116909921290321640 = new Kotlin.Long(-630357736, -1424204075);
  var L_2880145864133508542 = new Kotlin.Long(-1560083902, -670586216);
  var L1334009975649890238 = new Kotlin.Long(1164996542, 310598401);
  var L2608012711638119052 = new Kotlin.Long(1323610764, 607225278);
  var L6128411473006802146 = new Kotlin.Long(-704662302, 1426881987);
  var L8268148722764581231 = new Kotlin.Long(-226784913, 1925078388);
  var L_9160688886553864527 = new Kotlin.Long(991336113, -2132889090);
  var L_7215885187991268811 = new Kotlin.Long(633803317, -1680079193);
  var L_4495734319001033068 = new Kotlin.Long(-815192428, -1046744716);
  var L_1973867731355612462 = new Kotlin.Long(-1628353838, -459576895);
  var L_1171420211273849373 = new Kotlin.Long(944711139, -272742522);
  var L1135362057144423861 = new Kotlin.Long(-1953704523, 264347078);
  var L2597628984639134821 = new Kotlin.Long(2007800933, 604807628);
  var L3308224258029322869 = new Kotlin.Long(1495990901, 770255983);
  var L5365058923640841347 = new Kotlin.Long(1856431235, 1249150122);
  var L6679025012923562964 = new Kotlin.Long(-1119749164, 1555081692);
  var L8573033837759648693 = new Kotlin.Long(-2096016459, 1996064986);
  var L_7476448914759557205 = new Kotlin.Long(-295247957, -1740746414);
  var L_6327057829258317296 = new Kotlin.Long(766784016, -1473132947);
  var L_5763719355590565569 = new Kotlin.Long(-1728372417, -1341970488);
  var L_4658551843659510044 = new Kotlin.Long(-1091629340, -1084653625);
  var L_4116276920077217854 = new Kotlin.Long(1034457026, -958395405);
  var L_3051310485924567259 = new Kotlin.Long(-1828018395, -710438585);
  var L489312712824947311 = new Kotlin.Long(-536640913, 113926993);
  var L1452737877330783856 = new Kotlin.Long(168717936, 338241895);
  var L2861767655752347644 = new Kotlin.Long(1188179964, 666307205);
  var L3322285676063803686 = new Kotlin.Long(1546045734, 773529912);
  var L5560940570517711597 = new Kotlin.Long(1522805485, 1294757372);
  var L5996557281743188959 = new Kotlin.Long(-1651133473, 1396182291);
  var L7280758554555802590 = new Kotlin.Long(-1951439906, 1695183700);
  var L8532644243296465576 = new Kotlin.Long(1014477480, 1986661051);
  var L_9096487096722542874 = new Kotlin.Long(1206759142, -2117940946);
  var L_7894198246740708037 = new Kotlin.Long(344077627, -1838011259);
  var L_6719396339535248540 = new Kotlin.Long(1290863460, -1564481375);
  var L_6333637450476146687 = new Kotlin.Long(-1136513023, -1474664885);
  var L_4446306890439682159 = new Kotlin.Long(-789014639, -1035236496);
  var L_4076793802049405392 = new Kotlin.Long(106217008, -949202525);
  var L_3345356375505022440 = new Kotlin.Long(-688958952, -778901479);
  var L_2983346525034927856 = new Kotlin.Long(1432725776, -694614492);
  var L_860691631967231958 = new Kotlin.Long(1467031594, -200395387);
  var L1182934255886127544 = new Kotlin.Long(851169720, 275423344);
  var L1847814050463011016 = new Kotlin.Long(-1194143544, 430227734);
  var L2177327727835720531 = new Kotlin.Long(1363258195, 506948616);
  var L2830643537854262169 = new Kotlin.Long(-544281703, 659060556);
  var L3796741975233480872 = new Kotlin.Long(-509917016, 883997877);
  var L4115178125766777443 = new Kotlin.Long(-976659869, 958139571);
  var L5681478168544905931 = new Kotlin.Long(-482243893, 1322822218);
  var L6601373596472566643 = new Kotlin.Long(2003034995, 1537002063);
  var L7507060721942968483 = new Kotlin.Long(-692930397, 1747873779);
  var L8399075790359081724 = new Kotlin.Long(1575990012, 1955562222);
  var L8693463985226723168 = new Kotlin.Long(1125592928, 2024104815);
  var L_8878714635349349518 = new Kotlin.Long(-1578062990, -2067236844);
  var L_8302665154208450068 = new Kotlin.Long(442776044, -1933114872);
  var L_8016688836872298968 = new Kotlin.Long(593698344, -1866530822);
  var L_6606660893046293015 = new Kotlin.Long(-561857047, -1538233109);
  var L_4685533653050689259 = new Kotlin.Long(-1295615723, -1090935817);
  var L_4147400797238176981 = new Kotlin.Long(-479046869, -965641998);
  var L_3880063495543823972 = new Kotlin.Long(-366583396, -903397682);
  var L_3348786107499101689 = new Kotlin.Long(566280711, -779700025);
  var L_1523767162380948706 = new Kotlin.Long(-840897762, -354779690);
  var L_757361751448694408 = new Kotlin.Long(-294727304, -176337025);
  var L500013540394364858 = new Kotlin.Long(1914138554, 116418474);
  var L748580250866718886 = new Kotlin.Long(-1563912026, 174292421);
  var L1242879168328830382 = new Kotlin.Long(-1090974290, 289380356);
  var L1977374033974150939 = new Kotlin.Long(320620315, 460393269);
  var L2944078676154940804 = new Kotlin.Long(587496836, 685471733);
  var L3659926193048069267 = new Kotlin.Long(1086792851, 852142971);
  var L4368137639120453308 = new Kotlin.Long(365543100, 1017036298);
  var L4836135668995329356 = new Kotlin.Long(-1676669620, 1126000580);
  var L5532061633213252278 = new Kotlin.Long(-885112138, 1288033470);
  var L6448918945643986474 = new Kotlin.Long(-60457430, 1501505948);
  var L6902733635092675308 = new Kotlin.Long(987167468, 1607167915);
  var L7801388544844847127 = new Kotlin.Long(1246189591, 1816402316);
  var copyOf = Kotlin.kotlin.collections.copyOf_se6h4x$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var L_3766243637369397544 = new Kotlin.Long(-1056596264, -876896931);
  var L7105036623409894663 = new Kotlin.Long(914150663, 1654270250);
  var L_7973340178411365097 = new Kotlin.Long(812702999, -1856437926);
  var L1526699215303891257 = new Kotlin.Long(-150054599, 355462360);
  var L7436329637833083697 = new Kotlin.Long(-4191439, 1731405415);
  var L_8163818279084223215 = new Kotlin.Long(1750603025, -1900787065);
  var L_2662702644619276377 = new Kotlin.Long(1694076839, -619958771);
  var L5167115440072839076 = new Kotlin.Long(-1090891868, 1203062813);
  var L7640891576956012808 = new Kotlin.Long(-205731576, 1779033703);
  var L_4942790177534073029 = new Kotlin.Long(-2067093701, -1150833019);
  var L4354685564936845355 = new Kotlin.Long(-23791573, 1013904242);
  var L_6534734903238641935 = new Kotlin.Long(1595750129, -1521486534);
  var L5840696475078001361 = new Kotlin.Long(-1377402159, 1359893119);
  var L_7276294671716946913 = new Kotlin.Long(725511199, -1694144372);
  var L2270897969802886507 = new Kotlin.Long(-79577749, 528734635);
  var L6620516959819538809 = new Kotlin.Long(327033209, 1541459225);
  var IndexOutOfBoundsException = Kotlin.kotlin.IndexOutOfBoundsException;
  var L_3482333909917012819 = new Kotlin.Long(1444506797, -810794046);
  var L2216346199247487646 = new Kotlin.Long(560923294, 516033312);
  var L_7364697282686394994 = new Kotlin.Long(1529961870, -1714727209);
  var L65953792586715988 = new Kotlin.Long(-88566956, 15356063);
  var L_816286391624063116 = new Kotlin.Long(138618740, -190056486);
  var L4512832404995164602 = new Kotlin.Long(-1902392902, 1050725673);
  var L_5033199132376557362 = new Kotlin.Long(1592006862, -1171882994);
  var L_124578254951840548 = new Kotlin.Long(-1227127588, -29005636);
  Bit32Digest.prototype = Object.create(Digest.prototype);
  Bit32Digest.prototype.constructor = Bit32Digest;
  Bit64Digest.prototype = Object.create(Digest.prototype);
  Bit64Digest.prototype.constructor = Bit64Digest;
  SHA224.prototype = Object.create(Bit32Digest.prototype);
  SHA224.prototype.constructor = SHA224;
  SHA256.prototype = Object.create(Bit32Digest.prototype);
  SHA256.prototype.constructor = SHA256;
  SHA384.prototype = Object.create(Bit64Digest.prototype);
  SHA384.prototype.constructor = SHA384;
  SHA512.prototype = Object.create(Bit64Digest.prototype);
  SHA512.prototype.constructor = SHA512;
  SHA512t.prototype = Object.create(Bit64Digest.prototype);
  SHA512t.prototype.constructor = SHA512t;
  function Bit32Digest() {
    Bit32Digest$Companion_getInstance();
    this.h0_wrikvq$_0 = 0;
    this.h1_wrikuv$_0 = 0;
    this.h2_wriku0$_0 = 0;
    this.h3_wrikt5$_0 = 0;
    this.h4_wriksa$_0 = 0;
    this.h5_wrikrf$_0 = 0;
    this.h6_wrikqk$_0 = 0;
    this.h7_wrikpp$_0 = 0;
    this.x_q9esuu$_0 = null;
    this.state_umzhbl$_0 = null;
  }
  Bit32Digest.prototype.compress_fqrh44$ = function (buffer) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8, tmp$_9, tmp$_10;
    var x = this.x_q9esuu$_0;
    var bI = 0;
    for (var i = 0; i < 16; i++) {
      x[i] = (buffer[tmp$ = bI, bI = tmp$ + 1 | 0, tmp$] & 255) << 24 | (buffer[tmp$_0 = bI, bI = tmp$_0 + 1 | 0, tmp$_0] & 255) << 16 | (buffer[tmp$_1 = bI, bI = tmp$_1 + 1 | 0, tmp$_1] & 255) << 8 | buffer[tmp$_2 = bI, bI = tmp$_2 + 1 | 0, tmp$_2] & 255;
    }
    for (var i_0 = 16; i_0 < 64; i_0++) {
      var x15 = x[i_0 - 15 | 0];
      var s0 = (x15 >>> 7 | x15 << 25) ^ (x15 >>> 18 | x15 << 14) ^ x15 >>> 3;
      var x2 = x[i_0 - 2 | 0];
      var s1 = (x2 >>> 17 | x2 << 15) ^ (x2 >>> 19 | x2 << 13) ^ x2 >>> 10;
      var x16 = x[i_0 - 16 | 0];
      var x7 = x[i_0 - 7 | 0];
      x[i_0] = x16 + s0 + x7 + s1 | 0;
    }
    var k = Bit32Digest$Companion_getInstance().K_0;
    var a = this.state_umzhbl$_0[0];
    var b = this.state_umzhbl$_0[1];
    var c = this.state_umzhbl$_0[2];
    var d = this.state_umzhbl$_0[3];
    var e = this.state_umzhbl$_0[4];
    var f = this.state_umzhbl$_0[5];
    var g = this.state_umzhbl$_0[6];
    var h = this.state_umzhbl$_0[7];
    for (var i_1 = 0; i_1 < 64; i_1++) {
      var s0_0 = (a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10);
      var s1_0 = (e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7);
      var ch = e & f ^ ~e & g;
      var maj = a & b ^ a & c ^ b & c;
      var t1 = h + s1_0 + ch + k[i_1] + x[i_1] | 0;
      var t2 = s0_0 + maj | 0;
      h = g;
      g = f;
      f = e;
      e = d + t1 | 0;
      d = c;
      c = b;
      b = a;
      a = t1 + t2 | 0;
    }
    tmp$_3 = this.state_umzhbl$_0;
    tmp$_3[0] = tmp$_3[0] + a | 0;
    tmp$_4 = this.state_umzhbl$_0;
    tmp$_4[1] = tmp$_4[1] + b | 0;
    tmp$_5 = this.state_umzhbl$_0;
    tmp$_5[2] = tmp$_5[2] + c | 0;
    tmp$_6 = this.state_umzhbl$_0;
    tmp$_6[3] = tmp$_6[3] + d | 0;
    tmp$_7 = this.state_umzhbl$_0;
    tmp$_7[4] = tmp$_7[4] + e | 0;
    tmp$_8 = this.state_umzhbl$_0;
    tmp$_8[5] = tmp$_8[5] + f | 0;
    tmp$_9 = this.state_umzhbl$_0;
    tmp$_9[6] = tmp$_9[6] + g | 0;
    tmp$_10 = this.state_umzhbl$_0;
    tmp$_10[7] = tmp$_10[7] + h | 0;
  };
  Bit32Digest.prototype.digest_4r1zfv$ = function (bitLength, bufferOffset, buffer) {
    buffer[bufferOffset] = toByte(128);
    var size = bufferOffset + 1 | 0;
    if (size > 56) {
      fill(buffer, 0, size, 64);
      this.compress_fqrh44$(buffer);
      fill(buffer, 0, 0, size);
    } else {
      fill(buffer, 0, size, 56);
    }
    buffer[56] = toByte(bitLength.shiftRightUnsigned(56).toInt());
    buffer[57] = toByte(bitLength.shiftRightUnsigned(48).toInt());
    buffer[58] = toByte(bitLength.shiftRightUnsigned(40).toInt());
    buffer[59] = toByte(bitLength.shiftRightUnsigned(32).toInt());
    buffer[60] = toByte(bitLength.shiftRightUnsigned(24).toInt());
    buffer[61] = toByte(bitLength.shiftRightUnsigned(16).toInt());
    buffer[62] = toByte(bitLength.shiftRightUnsigned(8).toInt());
    buffer[63] = toByte(bitLength.toInt());
    this.compress_fqrh44$(buffer);
    return this.out_wrdw30$(this.state_umzhbl$_0[0], this.state_umzhbl$_0[1], this.state_umzhbl$_0[2], this.state_umzhbl$_0[3], this.state_umzhbl$_0[4], this.state_umzhbl$_0[5], this.state_umzhbl$_0[6], this.state_umzhbl$_0[7]);
  };
  Bit32Digest.prototype.resetDigest = function () {
    fill_0(this.x_q9esuu$_0, 0);
    this.state_umzhbl$_0[0] = this.h0_wrikvq$_0;
    this.state_umzhbl$_0[1] = this.h1_wrikuv$_0;
    this.state_umzhbl$_0[2] = this.h2_wriku0$_0;
    this.state_umzhbl$_0[3] = this.h3_wrikt5$_0;
    this.state_umzhbl$_0[4] = this.h4_wriksa$_0;
    this.state_umzhbl$_0[5] = this.h5_wrikrf$_0;
    this.state_umzhbl$_0[6] = this.h6_wrikqk$_0;
    this.state_umzhbl$_0[7] = this.h7_wrikpp$_0;
  };
  function Bit32Digest$Companion() {
    Bit32Digest$Companion_instance = this;
    this.K_0 = new Int32Array([1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998]);
  }
  Bit32Digest$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Bit32Digest$Companion_instance = null;
  function Bit32Digest$Companion_getInstance() {
    if (Bit32Digest$Companion_instance === null) {
      new Bit32Digest$Companion();
    }
    return Bit32Digest$Companion_instance;
  }
  Bit32Digest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Bit32Digest',
    interfaces: [Digest]
  };
  function Bit32Digest_init(d, h0, h1, h2, h3, h4, h5, h6, h7, $this) {
    $this = $this || Object.create(Bit32Digest.prototype);
    Digest_init('SHA-' + d, 64, d / 8 | 0, $this);
    Bit32Digest.call($this);
    $this.h0_wrikvq$_0 = h0;
    $this.h1_wrikuv$_0 = h1;
    $this.h2_wriku0$_0 = h2;
    $this.h3_wrikt5$_0 = h3;
    $this.h4_wriksa$_0 = h4;
    $this.h5_wrikrf$_0 = h5;
    $this.h6_wrikqk$_0 = h6;
    $this.h7_wrikpp$_0 = h7;
    $this.x_q9esuu$_0 = new Int32Array(64);
    $this.state_umzhbl$_0 = new Int32Array([h0, h1, h2, h3, h4, h5, h6, h7]);
    return $this;
  }
  function Bit32Digest_init_0(state, digest, $this) {
    $this = $this || Object.create(Bit32Digest.prototype);
    Digest_init_0(state, $this);
    Bit32Digest.call($this);
    $this.h0_wrikvq$_0 = digest.h0_wrikvq$_0;
    $this.h1_wrikuv$_0 = digest.h1_wrikuv$_0;
    $this.h2_wriku0$_0 = digest.h2_wriku0$_0;
    $this.h3_wrikt5$_0 = digest.h3_wrikt5$_0;
    $this.h4_wriksa$_0 = digest.h4_wriksa$_0;
    $this.h5_wrikrf$_0 = digest.h5_wrikrf$_0;
    $this.h6_wrikqk$_0 = digest.h6_wrikqk$_0;
    $this.h7_wrikpp$_0 = digest.h7_wrikpp$_0;
    $this.x_q9esuu$_0 = digest.x_q9esuu$_0.slice();
    $this.state_umzhbl$_0 = digest.state_umzhbl$_0.slice();
    return $this;
  }
  function Bit64Digest() {
    Bit64Digest$Companion_getInstance();
    this.h0 = null;
    this.h1 = null;
    this.h2 = null;
    this.h3 = null;
    this.h4 = null;
    this.h5 = null;
    this.h6 = null;
    this.h7 = null;
    this.x_k58nvv$_0 = null;
    this.state_hojvjm$_0 = null;
  }
  Bit64Digest.prototype.compress_fqrh44$ = function (buffer) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8, tmp$_9, tmp$_10, tmp$_11, tmp$_12, tmp$_13, tmp$_14;
    var x = this.x_k58nvv$_0;
    var bI = 0;
    for (var i = 0; i < 16; i++) {
      x[i] = Kotlin.Long.fromInt(buffer[tmp$ = bI, bI = tmp$ + 1 | 0, tmp$]).and(L255).shiftLeft(56).or(Kotlin.Long.fromInt(buffer[tmp$_0 = bI, bI = tmp$_0 + 1 | 0, tmp$_0]).and(L255).shiftLeft(48)).or(Kotlin.Long.fromInt(buffer[tmp$_1 = bI, bI = tmp$_1 + 1 | 0, tmp$_1]).and(L255).shiftLeft(40)).or(Kotlin.Long.fromInt(buffer[tmp$_2 = bI, bI = tmp$_2 + 1 | 0, tmp$_2]).and(L255).shiftLeft(32)).or(Kotlin.Long.fromInt(buffer[tmp$_3 = bI, bI = tmp$_3 + 1 | 0, tmp$_3]).and(L255).shiftLeft(24)).or(Kotlin.Long.fromInt(buffer[tmp$_4 = bI, bI = tmp$_4 + 1 | 0, tmp$_4]).and(L255).shiftLeft(16)).or(Kotlin.Long.fromInt(buffer[tmp$_5 = bI, bI = tmp$_5 + 1 | 0, tmp$_5]).and(L255).shiftLeft(8)).or(Kotlin.Long.fromInt(buffer[tmp$_6 = bI, bI = tmp$_6 + 1 | 0, tmp$_6]).and(L255));
    }
    for (var i_0 = 16; i_0 < 80; i_0++) {
      var x15 = x[i_0 - 15 | 0];
      var s0 = x15.shiftRightUnsigned(1).or(x15.shiftLeft(64 - 1 | 0)).xor(x15.shiftRightUnsigned(8).or(x15.shiftLeft(64 - 8 | 0))).xor(x15.shiftRightUnsigned(7));
      var x2 = x[i_0 - 2 | 0];
      var s1 = x2.shiftRightUnsigned(19).or(x2.shiftLeft(64 - 19 | 0)).xor(x2.shiftRightUnsigned(61).or(x2.shiftLeft(64 - 61 | 0))).xor(x2.shiftRightUnsigned(6));
      var x16 = x[i_0 - 16 | 0];
      var x7 = x[i_0 - 7 | 0];
      x[i_0] = x16.add(s0).add(x7).add(s1);
    }
    var k = Bit64Digest$Companion_getInstance().K_0;
    var a = this.state_hojvjm$_0[0];
    var b = this.state_hojvjm$_0[1];
    var c = this.state_hojvjm$_0[2];
    var d = this.state_hojvjm$_0[3];
    var e = this.state_hojvjm$_0[4];
    var f = this.state_hojvjm$_0[5];
    var g = this.state_hojvjm$_0[6];
    var h = this.state_hojvjm$_0[7];
    for (var i_1 = 0; i_1 < 80; i_1++) {
      var $receiver = a;
      var $receiver_0 = a;
      var $receiver_1 = a;
      var s0_0 = $receiver.shiftRightUnsigned(28).or($receiver.shiftLeft(64 - 28 | 0)).xor($receiver_0.shiftRightUnsigned(34).or($receiver_0.shiftLeft(64 - 34 | 0))).xor($receiver_1.shiftRightUnsigned(39).or($receiver_1.shiftLeft(64 - 39 | 0)));
      var $receiver_2 = e;
      var $receiver_3 = e;
      var $receiver_4 = e;
      var s1_0 = $receiver_2.shiftRightUnsigned(14).or($receiver_2.shiftLeft(64 - 14 | 0)).xor($receiver_3.shiftRightUnsigned(18).or($receiver_3.shiftLeft(64 - 18 | 0))).xor($receiver_4.shiftRightUnsigned(41).or($receiver_4.shiftLeft(64 - 41 | 0)));
      var ch = e.and(f).xor(e.inv().and(g));
      var maj = a.and(b).xor(a.and(c)).xor(b.and(c));
      var t1 = h.add(s1_0).add(ch).add(k[i_1]).add(x[i_1]);
      var t2 = s0_0.add(maj);
      h = g;
      g = f;
      f = e;
      e = d.add(t1);
      d = c;
      c = b;
      b = a;
      a = t1.add(t2);
    }
    tmp$_7 = this.state_hojvjm$_0;
    tmp$_7[0] = tmp$_7[0].add(a);
    tmp$_8 = this.state_hojvjm$_0;
    tmp$_8[1] = tmp$_8[1].add(b);
    tmp$_9 = this.state_hojvjm$_0;
    tmp$_9[2] = tmp$_9[2].add(c);
    tmp$_10 = this.state_hojvjm$_0;
    tmp$_10[3] = tmp$_10[3].add(d);
    tmp$_11 = this.state_hojvjm$_0;
    tmp$_11[4] = tmp$_11[4].add(e);
    tmp$_12 = this.state_hojvjm$_0;
    tmp$_12[5] = tmp$_12[5].add(f);
    tmp$_13 = this.state_hojvjm$_0;
    tmp$_13[6] = tmp$_13[6].add(g);
    tmp$_14 = this.state_hojvjm$_0;
    tmp$_14[7] = tmp$_14[7].add(h);
  };
  Bit64Digest.prototype.digest_4r1zfv$ = function (bitLength, bufferOffset, buffer) {
    buffer[bufferOffset] = toByte(128);
    var size = bufferOffset + 1 | 0;
    if (size > 112) {
      fill(buffer, 0, size, 128);
      this.compress_fqrh44$(buffer);
      fill(buffer, 0, 0, size);
    } else {
      fill(buffer, 0, size, 120);
    }
    buffer[120] = toByte(bitLength.shiftRightUnsigned(56).toInt());
    buffer[121] = toByte(bitLength.shiftRightUnsigned(48).toInt());
    buffer[122] = toByte(bitLength.shiftRightUnsigned(40).toInt());
    buffer[123] = toByte(bitLength.shiftRightUnsigned(32).toInt());
    buffer[124] = toByte(bitLength.shiftRightUnsigned(24).toInt());
    buffer[125] = toByte(bitLength.shiftRightUnsigned(16).toInt());
    buffer[126] = toByte(bitLength.shiftRightUnsigned(8).toInt());
    buffer[127] = toByte(bitLength.toInt());
    this.compress_fqrh44$(buffer);
    return this.out_s2t7qk$(this.state_hojvjm$_0[0], this.state_hojvjm$_0[1], this.state_hojvjm$_0[2], this.state_hojvjm$_0[3], this.state_hojvjm$_0[4], this.state_hojvjm$_0[5], this.state_hojvjm$_0[6], this.state_hojvjm$_0[7]);
  };
  Bit64Digest.prototype.resetDigest = function () {
    fill_1(this.x_k58nvv$_0, L0);
    this.state_hojvjm$_0[0] = this.h0;
    this.state_hojvjm$_0[1] = this.h1;
    this.state_hojvjm$_0[2] = this.h2;
    this.state_hojvjm$_0[3] = this.h3;
    this.state_hojvjm$_0[4] = this.h4;
    this.state_hojvjm$_0[5] = this.h5;
    this.state_hojvjm$_0[6] = this.h6;
    this.state_hojvjm$_0[7] = this.h7;
  };
  Bit64Digest.prototype.rotateRight_2kh986$_0 = function ($receiver, n) {
    return $receiver.shiftRightUnsigned(n).or($receiver.shiftLeft(64 - n | 0));
  };
  function Bit64Digest$Companion() {
    Bit64Digest$Companion_instance = this;
    this.K_0 = Kotlin.longArrayOf(L4794697086780616226, L8158064640168781261, L_5349999486874862801, L_1606136188198331460, L4131703408338449720, L6480981068601479193, L_7908458776815382629, L_6116909921290321640, L_2880145864133508542, L1334009975649890238, L2608012711638119052, L6128411473006802146, L8268148722764581231, L_9160688886553864527, L_7215885187991268811, L_4495734319001033068, L_1973867731355612462, L_1171420211273849373, L1135362057144423861, L2597628984639134821, L3308224258029322869, L5365058923640841347, L6679025012923562964, L8573033837759648693, L_7476448914759557205, L_6327057829258317296, L_5763719355590565569, L_4658551843659510044, L_4116276920077217854, L_3051310485924567259, L489312712824947311, L1452737877330783856, L2861767655752347644, L3322285676063803686, L5560940570517711597, L5996557281743188959, L7280758554555802590, L8532644243296465576, L_9096487096722542874, L_7894198246740708037, L_6719396339535248540, L_6333637450476146687, L_4446306890439682159, L_4076793802049405392, L_3345356375505022440, L_2983346525034927856, L_860691631967231958, L1182934255886127544, L1847814050463011016, L2177327727835720531, L2830643537854262169, L3796741975233480872, L4115178125766777443, L5681478168544905931, L6601373596472566643, L7507060721942968483, L8399075790359081724, L8693463985226723168, L_8878714635349349518, L_8302665154208450068, L_8016688836872298968, L_6606660893046293015, L_4685533653050689259, L_4147400797238176981, L_3880063495543823972, L_3348786107499101689, L_1523767162380948706, L_757361751448694408, L500013540394364858, L748580250866718886, L1242879168328830382, L1977374033974150939, L2944078676154940804, L3659926193048069267, L4368137639120453308, L4836135668995329356, L5532061633213252278, L6448918945643986474, L6902733635092675308, L7801388544844847127);
  }
  Bit64Digest$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Bit64Digest$Companion_instance = null;
  function Bit64Digest$Companion_getInstance() {
    if (Bit64Digest$Companion_instance === null) {
      new Bit64Digest$Companion();
    }
    return Bit64Digest$Companion_instance;
  }
  Bit64Digest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Bit64Digest',
    interfaces: [Digest]
  };
  function Bit64Digest_init(d, t, h0, h1, h2, h3, h4, h5, h6, h7, $this) {
    $this = $this || Object.create(Bit64Digest.prototype);
    var tmp$;
    Digest_init('SHA-' + d + ((tmp$ = t != null ? '/' + t : null) != null ? tmp$ : ''), 128, (t != null ? t : d) / 8 | 0, $this);
    Bit64Digest.call($this);
    if (t != null) {
      if (!(d === 512)) {
        var message = 't can only be expressed for SHA-512';
        throw IllegalArgumentException_init(message.toString());
      }
      if (!((t % 8 | 0) === 0)) {
        var message_0 = 't must be a factor of 8';
        throw IllegalArgumentException_init(message_0.toString());
      }
      if (!(t < 512)) {
        var message_1 = 't must be less than 512';
        throw IllegalArgumentException_init(message_1.toString());
      }
      if (!(t !== 384)) {
        var message_2 = 't cannot be 384';
        throw IllegalArgumentException_init(message_2.toString());
      }
    }
    $this.h0 = h0;
    $this.h1 = h1;
    $this.h2 = h2;
    $this.h3 = h3;
    $this.h4 = h4;
    $this.h5 = h5;
    $this.h6 = h6;
    $this.h7 = h7;
    $this.x_k58nvv$_0 = Kotlin.longArray(80);
    $this.state_hojvjm$_0 = Kotlin.longArrayOf(h0, h1, h2, h3, h4, h5, h6, h7);
    return $this;
  }
  function Bit64Digest_init_0(state, digest, $this) {
    $this = $this || Object.create(Bit64Digest.prototype);
    Digest_init_0(state, $this);
    Bit64Digest.call($this);
    $this.h0 = digest.h0;
    $this.h1 = digest.h1;
    $this.h2 = digest.h2;
    $this.h3 = digest.h3;
    $this.h4 = digest.h4;
    $this.h5 = digest.h5;
    $this.h6 = digest.h6;
    $this.h7 = digest.h7;
    $this.x_k58nvv$_0 = copyOf(digest.x_k58nvv$_0);
    $this.state_hojvjm$_0 = copyOf(digest.state_hojvjm$_0);
    return $this;
  }
  function SHA224() {
  }
  SHA224.prototype.copy_l73exj$ = function (state) {
    return SHA224_init_0(state, this);
  };
  SHA224.prototype.out_wrdw30$ = function (a, b, c, d, e, f, g, h) {
    return new Int8Array([toByte(a >> 24), toByte(a >> 16), toByte(a >> 8), toByte(a), toByte(b >> 24), toByte(b >> 16), toByte(b >> 8), toByte(b), toByte(c >> 24), toByte(c >> 16), toByte(c >> 8), toByte(c), toByte(d >> 24), toByte(d >> 16), toByte(d >> 8), toByte(d), toByte(e >> 24), toByte(e >> 16), toByte(e >> 8), toByte(e), toByte(f >> 24), toByte(f >> 16), toByte(f >> 8), toByte(f), toByte(g >> 24), toByte(g >> 16), toByte(g >> 8), toByte(g)]);
  };
  SHA224.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHA224',
    interfaces: [Bit32Digest]
  };
  function SHA224_init($this) {
    $this = $this || Object.create(SHA224.prototype);
    Bit32Digest_init(224, -1056596264, 914150663, 812702999, -150054599, -4191439, 1750603025, 1694076839, -1090891868, $this);
    SHA224.call($this);
    return $this;
  }
  function SHA224_init_0(state, sha224, $this) {
    $this = $this || Object.create(SHA224.prototype);
    Bit32Digest_init_0(state, sha224, $this);
    SHA224.call($this);
    return $this;
  }
  function SHA256() {
  }
  SHA256.prototype.copy_l73exj$ = function (state) {
    return SHA256_init_0(state, this);
  };
  SHA256.prototype.out_wrdw30$ = function (a, b, c, d, e, f, g, h) {
    return new Int8Array([toByte(a >> 24), toByte(a >> 16), toByte(a >> 8), toByte(a), toByte(b >> 24), toByte(b >> 16), toByte(b >> 8), toByte(b), toByte(c >> 24), toByte(c >> 16), toByte(c >> 8), toByte(c), toByte(d >> 24), toByte(d >> 16), toByte(d >> 8), toByte(d), toByte(e >> 24), toByte(e >> 16), toByte(e >> 8), toByte(e), toByte(f >> 24), toByte(f >> 16), toByte(f >> 8), toByte(f), toByte(g >> 24), toByte(g >> 16), toByte(g >> 8), toByte(g), toByte(h >> 24), toByte(h >> 16), toByte(h >> 8), toByte(h)]);
  };
  SHA256.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHA256',
    interfaces: [Bit32Digest]
  };
  function SHA256_init($this) {
    $this = $this || Object.create(SHA256.prototype);
    Bit32Digest_init(256, 1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225, $this);
    SHA256.call($this);
    return $this;
  }
  function SHA256_init_0(state, sha256, $this) {
    $this = $this || Object.create(SHA256.prototype);
    Bit32Digest_init_0(state, sha256, $this);
    SHA256.call($this);
    return $this;
  }
  function SHA384() {
  }
  SHA384.prototype.copy_l73exj$ = function (state) {
    return SHA384_init_0(state, this);
  };
  SHA384.prototype.out_s2t7qk$ = function (a, b, c, d, e, f, g, h) {
    return new Int8Array([toByte(a.shiftRight(56).toInt()), toByte(a.shiftRight(48).toInt()), toByte(a.shiftRight(40).toInt()), toByte(a.shiftRight(32).toInt()), toByte(a.shiftRight(24).toInt()), toByte(a.shiftRight(16).toInt()), toByte(a.shiftRight(8).toInt()), toByte(a.toInt()), toByte(b.shiftRight(56).toInt()), toByte(b.shiftRight(48).toInt()), toByte(b.shiftRight(40).toInt()), toByte(b.shiftRight(32).toInt()), toByte(b.shiftRight(24).toInt()), toByte(b.shiftRight(16).toInt()), toByte(b.shiftRight(8).toInt()), toByte(b.toInt()), toByte(c.shiftRight(56).toInt()), toByte(c.shiftRight(48).toInt()), toByte(c.shiftRight(40).toInt()), toByte(c.shiftRight(32).toInt()), toByte(c.shiftRight(24).toInt()), toByte(c.shiftRight(16).toInt()), toByte(c.shiftRight(8).toInt()), toByte(c.toInt()), toByte(d.shiftRight(56).toInt()), toByte(d.shiftRight(48).toInt()), toByte(d.shiftRight(40).toInt()), toByte(d.shiftRight(32).toInt()), toByte(d.shiftRight(24).toInt()), toByte(d.shiftRight(16).toInt()), toByte(d.shiftRight(8).toInt()), toByte(d.toInt()), toByte(e.shiftRight(56).toInt()), toByte(e.shiftRight(48).toInt()), toByte(e.shiftRight(40).toInt()), toByte(e.shiftRight(32).toInt()), toByte(e.shiftRight(24).toInt()), toByte(e.shiftRight(16).toInt()), toByte(e.shiftRight(8).toInt()), toByte(e.toInt()), toByte(f.shiftRight(56).toInt()), toByte(f.shiftRight(48).toInt()), toByte(f.shiftRight(40).toInt()), toByte(f.shiftRight(32).toInt()), toByte(f.shiftRight(24).toInt()), toByte(f.shiftRight(16).toInt()), toByte(f.shiftRight(8).toInt()), toByte(f.toInt())]);
  };
  SHA384.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHA384',
    interfaces: [Bit64Digest]
  };
  function SHA384_init($this) {
    $this = $this || Object.create(SHA384.prototype);
    Bit64Digest_init(384, null, L_3766243637369397544, L7105036623409894663, L_7973340178411365097, L1526699215303891257, L7436329637833083697, L_8163818279084223215, L_2662702644619276377, L5167115440072839076, $this);
    SHA384.call($this);
    return $this;
  }
  function SHA384_init_0(state, sha384, $this) {
    $this = $this || Object.create(SHA384.prototype);
    Bit64Digest_init_0(state, sha384, $this);
    SHA384.call($this);
    return $this;
  }
  function SHA512() {
  }
  SHA512.prototype.copy_l73exj$ = function (state) {
    return SHA512_init_0(state, this);
  };
  SHA512.prototype.out_s2t7qk$ = function (a, b, c, d, e, f, g, h) {
    return new Int8Array([toByte(a.shiftRight(56).toInt()), toByte(a.shiftRight(48).toInt()), toByte(a.shiftRight(40).toInt()), toByte(a.shiftRight(32).toInt()), toByte(a.shiftRight(24).toInt()), toByte(a.shiftRight(16).toInt()), toByte(a.shiftRight(8).toInt()), toByte(a.toInt()), toByte(b.shiftRight(56).toInt()), toByte(b.shiftRight(48).toInt()), toByte(b.shiftRight(40).toInt()), toByte(b.shiftRight(32).toInt()), toByte(b.shiftRight(24).toInt()), toByte(b.shiftRight(16).toInt()), toByte(b.shiftRight(8).toInt()), toByte(b.toInt()), toByte(c.shiftRight(56).toInt()), toByte(c.shiftRight(48).toInt()), toByte(c.shiftRight(40).toInt()), toByte(c.shiftRight(32).toInt()), toByte(c.shiftRight(24).toInt()), toByte(c.shiftRight(16).toInt()), toByte(c.shiftRight(8).toInt()), toByte(c.toInt()), toByte(d.shiftRight(56).toInt()), toByte(d.shiftRight(48).toInt()), toByte(d.shiftRight(40).toInt()), toByte(d.shiftRight(32).toInt()), toByte(d.shiftRight(24).toInt()), toByte(d.shiftRight(16).toInt()), toByte(d.shiftRight(8).toInt()), toByte(d.toInt()), toByte(e.shiftRight(56).toInt()), toByte(e.shiftRight(48).toInt()), toByte(e.shiftRight(40).toInt()), toByte(e.shiftRight(32).toInt()), toByte(e.shiftRight(24).toInt()), toByte(e.shiftRight(16).toInt()), toByte(e.shiftRight(8).toInt()), toByte(e.toInt()), toByte(f.shiftRight(56).toInt()), toByte(f.shiftRight(48).toInt()), toByte(f.shiftRight(40).toInt()), toByte(f.shiftRight(32).toInt()), toByte(f.shiftRight(24).toInt()), toByte(f.shiftRight(16).toInt()), toByte(f.shiftRight(8).toInt()), toByte(f.toInt()), toByte(g.shiftRight(56).toInt()), toByte(g.shiftRight(48).toInt()), toByte(g.shiftRight(40).toInt()), toByte(g.shiftRight(32).toInt()), toByte(g.shiftRight(24).toInt()), toByte(g.shiftRight(16).toInt()), toByte(g.shiftRight(8).toInt()), toByte(g.toInt()), toByte(h.shiftRight(56).toInt()), toByte(h.shiftRight(48).toInt()), toByte(h.shiftRight(40).toInt()), toByte(h.shiftRight(32).toInt()), toByte(h.shiftRight(24).toInt()), toByte(h.shiftRight(16).toInt()), toByte(h.shiftRight(8).toInt()), toByte(h.toInt())]);
  };
  SHA512.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHA512',
    interfaces: [Bit64Digest]
  };
  function SHA512_init($this) {
    $this = $this || Object.create(SHA512.prototype);
    Bit64Digest_init(512, null, L7640891576956012808, L_4942790177534073029, L4354685564936845355, L_6534734903238641935, L5840696475078001361, L_7276294671716946913, L2270897969802886507, L6620516959819538809, $this);
    SHA512.call($this);
    return $this;
  }
  function SHA512_init_0(state, sha512, $this) {
    $this = $this || Object.create(SHA512.prototype);
    Bit64Digest_init_0(state, sha512, $this);
    SHA512.call($this);
    return $this;
  }
  function SHA512_224() {
    return SHA512t_init(224);
  }
  function SHA512_256() {
    return SHA512t_init(256);
  }
  function SHA512t() {
    this.isInitialized_0 = false;
  }
  SHA512t.prototype.copy_l73exj$ = function (state) {
    return SHA512t_init_0(state, this);
  };
  SHA512t.prototype.out_s2t7qk$ = function (a, b, c, d, e, f, g, h) {
    if (!this.isInitialized_0) {
      this.h0 = a;
      this.h1 = b;
      this.h2 = c;
      this.h3 = d;
      this.h4 = e;
      this.h5 = f;
      this.h6 = g;
      this.h7 = h;
      this.isInitialized_0 = true;
      return new Int8Array(0);
    }
    var out = new Int8Array(this.digestLength());
    try {
      out[0] = toByte(a.shiftRight(56).toInt());
      out[1] = toByte(a.shiftRight(48).toInt());
      out[2] = toByte(a.shiftRight(40).toInt());
      out[3] = toByte(a.shiftRight(32).toInt());
      out[4] = toByte(a.shiftRight(24).toInt());
      out[5] = toByte(a.shiftRight(16).toInt());
      out[6] = toByte(a.shiftRight(8).toInt());
      out[7] = toByte(a.toInt());
      out[8] = toByte(b.shiftRight(56).toInt());
      out[9] = toByte(b.shiftRight(48).toInt());
      out[10] = toByte(b.shiftRight(40).toInt());
      out[11] = toByte(b.shiftRight(32).toInt());
      out[12] = toByte(b.shiftRight(24).toInt());
      out[13] = toByte(b.shiftRight(16).toInt());
      out[14] = toByte(b.shiftRight(8).toInt());
      out[15] = toByte(b.toInt());
      out[16] = toByte(c.shiftRight(56).toInt());
      out[17] = toByte(c.shiftRight(48).toInt());
      out[18] = toByte(c.shiftRight(40).toInt());
      out[19] = toByte(c.shiftRight(32).toInt());
      out[20] = toByte(c.shiftRight(24).toInt());
      out[21] = toByte(c.shiftRight(16).toInt());
      out[22] = toByte(c.shiftRight(8).toInt());
      out[23] = toByte(c.toInt());
      out[24] = toByte(d.shiftRight(56).toInt());
      out[25] = toByte(d.shiftRight(48).toInt());
      out[26] = toByte(d.shiftRight(40).toInt());
      out[27] = toByte(d.shiftRight(32).toInt());
      out[28] = toByte(d.shiftRight(24).toInt());
      out[29] = toByte(d.shiftRight(16).toInt());
      out[30] = toByte(d.shiftRight(8).toInt());
      out[31] = toByte(d.toInt());
      out[32] = toByte(e.shiftRight(56).toInt());
      out[33] = toByte(e.shiftRight(48).toInt());
      out[34] = toByte(e.shiftRight(40).toInt());
      out[35] = toByte(e.shiftRight(32).toInt());
      out[36] = toByte(e.shiftRight(24).toInt());
      out[37] = toByte(e.shiftRight(16).toInt());
      out[38] = toByte(e.shiftRight(8).toInt());
      out[39] = toByte(e.toInt());
      out[40] = toByte(f.shiftRight(56).toInt());
      out[41] = toByte(f.shiftRight(48).toInt());
      out[42] = toByte(f.shiftRight(40).toInt());
      out[43] = toByte(f.shiftRight(32).toInt());
      out[44] = toByte(f.shiftRight(24).toInt());
      out[45] = toByte(f.shiftRight(16).toInt());
      out[46] = toByte(f.shiftRight(8).toInt());
      out[47] = toByte(f.toInt());
      out[48] = toByte(g.shiftRight(56).toInt());
      out[49] = toByte(g.shiftRight(48).toInt());
      out[50] = toByte(g.shiftRight(40).toInt());
      out[51] = toByte(g.shiftRight(32).toInt());
      out[52] = toByte(g.shiftRight(24).toInt());
      out[53] = toByte(g.shiftRight(16).toInt());
      out[54] = toByte(g.shiftRight(8).toInt());
      out[55] = toByte(g.toInt());
      out[56] = toByte(h.shiftRight(56).toInt());
      out[57] = toByte(h.shiftRight(48).toInt());
      out[58] = toByte(h.shiftRight(40).toInt());
      out[59] = toByte(h.shiftRight(32).toInt());
      out[60] = toByte(h.shiftRight(24).toInt());
      out[61] = toByte(h.shiftRight(16).toInt());
      out[62] = toByte(h.shiftRight(8).toInt());
      out[63] = toByte(h.toInt());
    } catch (_) {
      if (!Kotlin.isType(_, IndexOutOfBoundsException))
        throw _;
    }
    return out;
  };
  SHA512t.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHA512t',
    interfaces: [Bit64Digest]
  };
  function SHA512t_init(t, $this) {
    $this = $this || Object.create(SHA512t.prototype);
    Bit64Digest_init(512, t, L_3482333909917012819, L2216346199247487646, L_7364697282686394994, L65953792586715988, L_816286391624063116, L4512832404995164602, L_5033199132376557362, L_124578254951840548, $this);
    SHA512t.call($this);
    $this.isInitialized_0 = false;
    $this.update_s8j3t7$(83);
    $this.update_s8j3t7$(72);
    $this.update_s8j3t7$(65);
    $this.update_s8j3t7$(45);
    $this.update_s8j3t7$(53);
    $this.update_s8j3t7$(49);
    $this.update_s8j3t7$(50);
    $this.update_s8j3t7$(47);
    var bitLength = t;
    if (t > 100) {
      $this.update_s8j3t7$(toByte((bitLength / 100 | 0) + 48 | 0));
      bitLength = bitLength % 100 | 0;
    }
    if (t > 10) {
      $this.update_s8j3t7$(toByte((bitLength / 10 | 0) + 48 | 0));
      bitLength = bitLength % 10 | 0;
    }
    $this.update_s8j3t7$(toByte(bitLength + 48 | 0));
    $this.digest();
    return $this;
  }
  function SHA512t_init_0(state, sha512t, $this) {
    $this = $this || Object.create(SHA512t.prototype);
    Bit64Digest_init_0(state, sha512t, $this);
    SHA512t.call($this);
    $this.isInitialized_0 = true;
    return $this;
  }
  var package$org = _.org || (_.org = {});
  var package$kotlincrypto = package$org.kotlincrypto || (package$org.kotlincrypto = {});
  var package$hash = package$kotlincrypto.hash || (package$kotlincrypto.hash = {});
  var package$sha2 = package$hash.sha2 || (package$hash.sha2 = {});
  package$sha2.Bit32Digest_init_6emcny$ = Bit32Digest_init;
  package$sha2.Bit32Digest_init_f1wm21$ = Bit32Digest_init_0;
  package$sha2.Bit32Digest = Bit32Digest;
  $$importsForInline$$['hash-sha2-js-legacy'] = _;
  package$sha2.Bit64Digest_init_boz70l$ = Bit64Digest_init;
  package$sha2.Bit64Digest_init_b6ni9k$ = Bit64Digest_init_0;
  package$sha2.Bit64Digest = Bit64Digest;
  package$sha2.SHA224_init = SHA224_init;
  package$sha2.SHA224 = SHA224;
  package$sha2.SHA256_init = SHA256_init;
  package$sha2.SHA256 = SHA256;
  package$sha2.SHA384_init = SHA384_init;
  package$sha2.SHA384 = SHA384;
  package$sha2.SHA512_init = SHA512_init;
  package$sha2.SHA512 = SHA512;
  package$sha2.SHA512_224 = SHA512_224;
  package$sha2.SHA512_256 = SHA512_256;
  package$sha2.SHA512t_init_za3lpa$ = SHA512t_init;
  package$sha2.SHA512t = SHA512t;
  Kotlin.defineModule('hash-sha2-js-legacy', _);
  return _;
}));

//# sourceMappingURL=hash-sha2-js-legacy.js.map
