/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha2;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.Digest;
import org.kotlincrypto.core.internal.DigestState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 #2\u00020\u0001:\u0001#BO\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fB\u0017\b\u0014\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J \u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0004JH\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H$J\b\u0010\"\u001a\u00020\u0014H\u0004R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002$%\u00a8\u0006&"}, d2={"Lorg/kotlincrypto/hash/sha2/Bit32Digest;", "Lorg/kotlincrypto/core/Digest;", "d", "", "h0", "h1", "h2", "h3", "h4", "h5", "h6", "h7", "(IIIIIIIII)V", "state", "Lorg/kotlincrypto/core/internal/DigestState;", "digest", "(Lorg/kotlincrypto/core/internal/DigestState;Lorg/kotlincrypto/hash/sha2/Bit32Digest;)V", "", "x", "compress", "", "buffer", "", "bitLength", "", "bufferOffset", "out", "a", "b", "c", "e", "f", "g", "h", "resetDigest", "Companion", "Lorg/kotlincrypto/hash/sha2/SHA224;", "Lorg/kotlincrypto/hash/sha2/SHA256;", "sha2"})
public abstract class Bit32Digest
extends Digest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int h0;
    private final int h1;
    private final int h2;
    private final int h3;
    private final int h4;
    private final int h5;
    private final int h6;
    private final int h7;
    @NotNull
    private final int[] x;
    @NotNull
    private final int[] state;
    @Deprecated
    @NotNull
    private static final int[] K;

    private Bit32Digest(int d, int h0, int h1, int h2, int h3, int h4, int h5, int h6, int h7) throws IllegalArgumentException {
        super("SHA-" + d, 64, d / 8);
        this.h0 = h0;
        this.h1 = h1;
        this.h2 = h2;
        this.h3 = h3;
        this.h4 = h4;
        this.h5 = h5;
        this.h6 = h6;
        this.h7 = h7;
        this.x = new int[64];
        int[] nArray = new int[]{h0, h1, h2, h3, h4, h5, h6, h7};
        this.state = nArray;
    }

    private Bit32Digest(DigestState state, Bit32Digest digest) {
        super(state);
        this.h0 = digest.h0;
        this.h1 = digest.h1;
        this.h2 = digest.h2;
        this.h3 = digest.h3;
        this.h4 = digest.h4;
        this.h5 = digest.h5;
        this.h6 = digest.h6;
        this.h7 = digest.h7;
        int[] nArray = Arrays.copyOf(digest.x, digest.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, size)");
        this.x = nArray;
        int[] nArray2 = Arrays.copyOf(digest.state, digest.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(this, size)");
        this.state = nArray2;
    }

    protected final void compress(@NotNull byte[] buffer) {
        int i;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int[] x = this.x;
        int bI = 0;
        for (i = 0; i < 16; ++i) {
            x[i] = (buffer[bI++] & 0xFF) << 24 | (buffer[bI++] & 0xFF) << 16 | (buffer[bI++] & 0xFF) << 8 | buffer[bI++] & 0xFF;
        }
        for (i = 16; i < 64; ++i) {
            int x15 = x[i - 15];
            int s0 = (x15 >>> 7 | x15 << 25) ^ (x15 >>> 18 | x15 << 14) ^ x15 >>> 3;
            int x2 = x[i - 2];
            int s1 = (x2 >>> 17 | x2 << 15) ^ (x2 >>> 19 | x2 << 13) ^ x2 >>> 10;
            int x16 = x[i - 16];
            int x7 = x[i - 7];
            x[i] = x16 + s0 + x7 + s1;
        }
        int[] k = K;
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        int e = this.state[4];
        int f = this.state[5];
        int g = this.state[6];
        int h = this.state[7];
        for (int i2 = 0; i2 < 64; ++i2) {
            int s0 = (a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10);
            int s1 = (e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7);
            int ch = e & f ^ ~e & g;
            int maj = a & b ^ a & c ^ b & c;
            int t1 = h + s1 + ch + k[i2] + x[i2];
            int t2 = s0 + maj;
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
        }
        int[] nArray = this.state;
        nArray[0] = nArray[0] + a;
        nArray = this.state;
        nArray[1] = nArray[1] + b;
        nArray = this.state;
        nArray[2] = nArray[2] + c;
        nArray = this.state;
        nArray[3] = nArray[3] + d;
        nArray = this.state;
        nArray[4] = nArray[4] + e;
        nArray = this.state;
        nArray[5] = nArray[5] + f;
        nArray = this.state;
        nArray[6] = nArray[6] + g;
        nArray = this.state;
        nArray[7] = nArray[7] + h;
    }

    @NotNull
    protected final byte[] digest(long bitLength, int bufferOffset, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer[bufferOffset] = -128;
        int size = bufferOffset + 1;
        if (size > 56) {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)64);
            this.compress(buffer);
            ArraysKt.fill((byte[])buffer, (byte)0, (int)0, (int)size);
        } else {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)56);
        }
        buffer[56] = (byte)(bitLength >>> 56);
        buffer[57] = (byte)(bitLength >>> 48);
        buffer[58] = (byte)(bitLength >>> 40);
        buffer[59] = (byte)(bitLength >>> 32);
        buffer[60] = (byte)(bitLength >>> 24);
        buffer[61] = (byte)(bitLength >>> 16);
        buffer[62] = (byte)(bitLength >>> 8);
        buffer[63] = (byte)bitLength;
        this.compress(buffer);
        return this.out(this.state[0], this.state[1], this.state[2], this.state[3], this.state[4], this.state[5], this.state[6], this.state[7]);
    }

    @NotNull
    protected abstract byte[] out(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected final void resetDigest() {
        ArraysKt.fill$default((int[])this.x, (int)0, (int)0, (int)0, (int)6, null);
        this.state[0] = this.h0;
        this.state[1] = this.h1;
        this.state[2] = this.h2;
        this.state[3] = this.h3;
        this.state[4] = this.h4;
        this.state[5] = this.h5;
        this.state[6] = this.h6;
        this.state[7] = this.h7;
    }

    public /* synthetic */ Bit32Digest(int d, int h0, int h1, int h2, int h3, int h4, int h5, int h6, int h7, DefaultConstructorMarker $constructor_marker) {
        this(d, h0, h1, h2, h3, h4, h5, h6, h7);
    }

    public /* synthetic */ Bit32Digest(DigestState state, Bit32Digest digest, DefaultConstructorMarker $constructor_marker) {
        this(state, digest);
    }

    static {
        int[] nArray = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
        K = nArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kotlincrypto/hash/sha2/Bit32Digest$Companion;", "", "()V", "K", "", "sha2"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

