/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha2;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.Digest;
import org.kotlincrypto.core.internal.DigestState;
import org.kotlincrypto.hash.sha2.Bit64Digest;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014JH\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/kotlincrypto/hash/sha2/SHA512t;", "Lorg/kotlincrypto/hash/sha2/Bit64Digest;", "t", "", "(I)V", "state", "Lorg/kotlincrypto/core/internal/DigestState;", "digest", "(Lorg/kotlincrypto/core/internal/DigestState;Lorg/kotlincrypto/hash/sha2/SHA512t;)V", "isInitialized", "", "copy", "Lorg/kotlincrypto/core/Digest;", "out", "", "a", "", "b", "c", "d", "e", "f", "g", "h", "sha2"})
public final class SHA512t
extends Bit64Digest {
    private boolean isInitialized;

    public SHA512t(int t) throws IllegalArgumentException {
        super(512, t, -3482333909917012819L, 2216346199247487646L, -7364697282686394994L, 65953792586715988L, -816286391624063116L, 4512832404995164602L, -5033199132376557362L, -124578254951840548L, null);
        this.isInitialized = false;
        this.update((byte)83);
        this.update((byte)72);
        this.update((byte)65);
        this.update((byte)45);
        this.update((byte)53);
        this.update((byte)49);
        this.update((byte)50);
        this.update((byte)47);
        int bitLength = t;
        if (t > 100) {
            this.update((byte)(bitLength / 100 + 48));
            bitLength %= 100;
        }
        if (t > 10) {
            this.update((byte)(bitLength / 10 + 48));
            bitLength %= 10;
        }
        this.update((byte)(bitLength + 48));
        this.digest();
    }

    private SHA512t(DigestState state, SHA512t digest) {
        super(state, digest, null);
        this.isInitialized = true;
    }

    @NotNull
    protected Digest copy(@NotNull DigestState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new SHA512t(state, this);
    }

    @Override
    @NotNull
    protected byte[] out(long a, long b, long c, long d, long e, long f, long g, long h) {
        if (!this.isInitialized) {
            this.h0 = a;
            this.h1 = b;
            this.h2 = c;
            this.h3 = d;
            this.h4 = e;
            this.h5 = f;
            this.h6 = g;
            this.h7 = h;
            this.isInitialized = true;
            return new byte[0];
        }
        byte[] out = new byte[this.digestLength()];
        try {
            out[0] = (byte)(a >> 56);
            out[1] = (byte)(a >> 48);
            out[2] = (byte)(a >> 40);
            out[3] = (byte)(a >> 32);
            out[4] = (byte)(a >> 24);
            out[5] = (byte)(a >> 16);
            out[6] = (byte)(a >> 8);
            out[7] = (byte)a;
            out[8] = (byte)(b >> 56);
            out[9] = (byte)(b >> 48);
            out[10] = (byte)(b >> 40);
            out[11] = (byte)(b >> 32);
            out[12] = (byte)(b >> 24);
            out[13] = (byte)(b >> 16);
            out[14] = (byte)(b >> 8);
            out[15] = (byte)b;
            out[16] = (byte)(c >> 56);
            out[17] = (byte)(c >> 48);
            out[18] = (byte)(c >> 40);
            out[19] = (byte)(c >> 32);
            out[20] = (byte)(c >> 24);
            out[21] = (byte)(c >> 16);
            out[22] = (byte)(c >> 8);
            out[23] = (byte)c;
            out[24] = (byte)(d >> 56);
            out[25] = (byte)(d >> 48);
            out[26] = (byte)(d >> 40);
            out[27] = (byte)(d >> 32);
            out[28] = (byte)(d >> 24);
            out[29] = (byte)(d >> 16);
            out[30] = (byte)(d >> 8);
            out[31] = (byte)d;
            out[32] = (byte)(e >> 56);
            out[33] = (byte)(e >> 48);
            out[34] = (byte)(e >> 40);
            out[35] = (byte)(e >> 32);
            out[36] = (byte)(e >> 24);
            out[37] = (byte)(e >> 16);
            out[38] = (byte)(e >> 8);
            out[39] = (byte)e;
            out[40] = (byte)(f >> 56);
            out[41] = (byte)(f >> 48);
            out[42] = (byte)(f >> 40);
            out[43] = (byte)(f >> 32);
            out[44] = (byte)(f >> 24);
            out[45] = (byte)(f >> 16);
            out[46] = (byte)(f >> 8);
            out[47] = (byte)f;
            out[48] = (byte)(g >> 56);
            out[49] = (byte)(g >> 48);
            out[50] = (byte)(g >> 40);
            out[51] = (byte)(g >> 32);
            out[52] = (byte)(g >> 24);
            out[53] = (byte)(g >> 16);
            out[54] = (byte)(g >> 8);
            out[55] = (byte)g;
            out[56] = (byte)(h >> 56);
            out[57] = (byte)(h >> 48);
            out[58] = (byte)(h >> 40);
            out[59] = (byte)(h >> 32);
            out[60] = (byte)(h >> 24);
            out[61] = (byte)(h >> 16);
            out[62] = (byte)(h >> 8);
            out[63] = (byte)h;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return out;
    }
}

