/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha2;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.digest.Digest;
import org.kotlincrypto.core.digest.internal.DigestState;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 (2\u00020\u0001:\u0001(BY\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eB\u0017\b\u0014\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0004J \u0010\u0011\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0018H\u0004JH\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H$J\b\u0010%\u001a\u00020\u0016H\u0004J\u0015\u0010&\u001a\u00020\u0006*\u00020\u00062\u0006\u0010'\u001a\u00020\u0003H\u0082\fR\u0012\u0010\u0005\u001a\u00020\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00068\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003)*+\u00a8\u0006,"}, d2={"Lorg/kotlincrypto/hash/sha2/Bit64Digest;", "Lorg/kotlincrypto/core/digest/Digest;", "d", "", "t", "h0", "", "h1", "h2", "h3", "h4", "h5", "h6", "h7", "(ILjava/lang/Integer;JJJJJJJJ)V", "state", "Lorg/kotlincrypto/core/digest/internal/DigestState;", "digest", "(Lorg/kotlincrypto/core/digest/internal/DigestState;Lorg/kotlincrypto/hash/sha2/Bit64Digest;)V", "", "x", "compress", "", "input", "", "offset", "bitLength", "bufferOffset", "buffer", "out", "a", "b", "c", "e", "f", "g", "h", "resetDigest", "rotateRight", "n", "Companion", "Lorg/kotlincrypto/hash/sha2/SHA384;", "Lorg/kotlincrypto/hash/sha2/SHA512;", "Lorg/kotlincrypto/hash/sha2/SHA512t;", "sha2"})
@SourceDebugExtension(value={"SMAP\nBit64Digest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bit64Digest.kt\norg/kotlincrypto/hash/sha2/Bit64Digest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n219#1:248\n219#1:249\n219#1:250\n219#1:251\n1#2:247\n*S KotlinDebug\n*F\n+ 1 Bit64Digest.kt\norg/kotlincrypto/hash/sha2/Bit64Digest\n*L\n111#1:248\n113#1:249\n131#1:250\n132#1:251\n*E\n"})
public abstract class Bit64Digest
extends Digest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @JvmField
    protected long h0;
    @JvmField
    protected long h1;
    @JvmField
    protected long h2;
    @JvmField
    protected long h3;
    @JvmField
    protected long h4;
    @JvmField
    protected long h5;
    @JvmField
    protected long h6;
    @JvmField
    protected long h7;
    @NotNull
    private final long[] x;
    @NotNull
    private final long[] state;
    @NotNull
    private static final long[] K;

    /*
     * WARNING - void declaration
     */
    private Bit64Digest(int d, Integer t, long h0, long h1, long h2, long h3, long h4, long h5, long h6, long h7) throws IllegalArgumentException {
        Object object;
        StringBuilder stringBuilder;
        Bit64Digest bit64Digest;
        block9: {
            block8: {
                void it;
                bit64Digest = this;
                stringBuilder = new StringBuilder().append("SHA-").append(d);
                object = t;
                if (object == null) break block8;
                int n = ((Number)object).intValue();
                StringBuilder stringBuilder2 = stringBuilder;
                Bit64Digest bit64Digest2 = bit64Digest;
                boolean bl = false;
                String string = "" + '/' + (int)it;
                bit64Digest = bit64Digest2;
                stringBuilder = stringBuilder2;
                String string2 = string;
                object = string2;
                if (string2 != null) break block9;
            }
            object = "";
        }
        Integer n = t;
        super(stringBuilder.append((String)object).toString(), 128, (n != null ? n : d) / 8);
        if (t != null) {
            if (!(d == 512)) {
                boolean $i$a$-require-Bit64Digest$62 = false;
                String $i$a$-require-Bit64Digest$62 = "t can only be expressed for SHA-512";
                throw new IllegalArgumentException($i$a$-require-Bit64Digest$62.toString());
            }
            if (!(t % 8 == 0)) {
                boolean $i$a$-require-Bit64Digest$72 = false;
                String $i$a$-require-Bit64Digest$72 = "t must be a factor of 8";
                throw new IllegalArgumentException($i$a$-require-Bit64Digest$72.toString());
            }
            if (!(t < 512)) {
                boolean $i$a$-require-Bit64Digest$82 = false;
                String $i$a$-require-Bit64Digest$82 = "t must be less than 512";
                throw new IllegalArgumentException($i$a$-require-Bit64Digest$82.toString());
            }
            int n2 = 384;
            if (!(t != n2)) {
                boolean bl = false;
                String string = "t cannot be 384";
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.h0 = h0;
        this.h1 = h1;
        this.h2 = h2;
        this.h3 = h3;
        this.h4 = h4;
        this.h5 = h5;
        this.h6 = h6;
        this.h7 = h7;
        this.x = new long[80];
        long[] lArray = new long[]{h0, h1, h2, h3, h4, h5, h6, h7};
        this.state = lArray;
    }

    private Bit64Digest(DigestState state, Bit64Digest digest) {
        super(state);
        this.h0 = digest.h0;
        this.h1 = digest.h1;
        this.h2 = digest.h2;
        this.h3 = digest.h3;
        this.h4 = digest.h4;
        this.h5 = digest.h5;
        this.h6 = digest.h6;
        this.h7 = digest.h7;
        long[] lArray = Arrays.copyOf(digest.x, digest.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(this, size)");
        this.x = lArray;
        long[] lArray2 = Arrays.copyOf(digest.state, digest.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(this, size)");
        this.state = lArray2;
    }

    protected final void compress(@NotNull byte[] input, int offset) {
        int i;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long[] x = this.x;
        int j = offset;
        for (i = 0; i < 16; ++i) {
            x[i] = ((long)input[j++] & 0xFFL) << 56 | ((long)input[j++] & 0xFFL) << 48 | ((long)input[j++] & 0xFFL) << 40 | ((long)input[j++] & 0xFFL) << 32 | ((long)input[j++] & 0xFFL) << 24 | ((long)input[j++] & 0xFFL) << 16 | ((long)input[j++] & 0xFFL) << 8 | (long)input[j++] & 0xFFL;
        }
        for (i = 16; i < 80; ++i) {
            long $this$rotateRight$iv;
            long $this$rotateRight$iv2;
            long x15 = x[i - 15];
            Bit64Digest bit64Digest = this;
            long l = x15;
            int n$iv = 1;
            boolean $i$f$rotateRight = false;
            void v0 = $this$rotateRight$iv2 >>> n$iv | $this$rotateRight$iv2 << 64 - n$iv;
            Bit64Digest this_$iv = this;
            $this$rotateRight$iv2 = x15;
            n$iv = 8;
            $i$f$rotateRight = false;
            void s0 = v0 ^ ($this$rotateRight$iv2 >>> n$iv | $this$rotateRight$iv2 << 64 - n$iv) ^ x15 >>> 7;
            long x2 = x[i - 2];
            Bit64Digest $i$f$rotateRight2 = this;
            long l2 = x2;
            int n$iv2 = 19;
            boolean $i$f$rotateRight3 = false;
            void v1 = $this$rotateRight$iv >>> n$iv2 | $this$rotateRight$iv << 64 - n$iv2;
            Bit64Digest this_$iv2 = this;
            $this$rotateRight$iv = x2;
            n$iv2 = 61;
            $i$f$rotateRight3 = false;
            void s1 = v1 ^ ($this$rotateRight$iv >>> n$iv2 | $this$rotateRight$iv << 64 - n$iv2) ^ x2 >>> 6;
            long x16 = x[i - 16];
            long x7 = x[i - 7];
            x[i] = x16 + s0 + x7 + s1;
        }
        long[] k = K;
        long a = this.state[0];
        long b = this.state[1];
        long c = this.state[2];
        long d = this.state[3];
        long e = this.state[4];
        long f = this.state[5];
        long g = this.state[6];
        long h = this.state[7];
        for (int i2 = 0; i2 < 80; ++i2) {
            long $this$rotateRight$iv;
            long $this$rotateRight$iv3;
            Bit64Digest bit64Digest = this;
            long l = a;
            int n$iv = 28;
            boolean $i$f$rotateRight = false;
            void v2 = $this$rotateRight$iv3 >>> n$iv | $this$rotateRight$iv3 << 64 - n$iv;
            Bit64Digest this_$iv = this;
            $this$rotateRight$iv3 = a;
            n$iv = 34;
            $i$f$rotateRight = false;
            void v3 = v2 ^ ($this$rotateRight$iv3 >>> n$iv | $this$rotateRight$iv3 << 64 - n$iv);
            this_$iv = this;
            $this$rotateRight$iv3 = a;
            n$iv = 39;
            $i$f$rotateRight = false;
            void s0 = v3 ^ ($this$rotateRight$iv3 >>> n$iv | $this$rotateRight$iv3 << 64 - n$iv);
            Bit64Digest bit64Digest2 = this;
            long n$iv2 = e;
            int n$iv3 = 14;
            boolean $i$f$rotateRight4 = false;
            void v4 = $this$rotateRight$iv >>> n$iv3 | $this$rotateRight$iv << 64 - n$iv3;
            Bit64Digest this_$iv3 = this;
            $this$rotateRight$iv = e;
            n$iv3 = 18;
            $i$f$rotateRight4 = false;
            void v5 = v4 ^ ($this$rotateRight$iv >>> n$iv3 | $this$rotateRight$iv << 64 - n$iv3);
            this_$iv3 = this;
            $this$rotateRight$iv = e;
            n$iv3 = 41;
            $i$f$rotateRight4 = false;
            void s1 = v5 ^ ($this$rotateRight$iv >>> n$iv3 | $this$rotateRight$iv << 64 - n$iv3);
            long ch = e & f ^ (e ^ 0xFFFFFFFFFFFFFFFFL) & g;
            long maj = a & b ^ a & c ^ b & c;
            long t1 = h + s1 + ch + k[i2] + x[i2];
            void t2 = s0 + maj;
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
        }
        long[] lArray = this.state;
        lArray[0] = lArray[0] + a;
        lArray = this.state;
        lArray[1] = lArray[1] + b;
        lArray = this.state;
        lArray[2] = lArray[2] + c;
        lArray = this.state;
        lArray[3] = lArray[3] + d;
        lArray = this.state;
        lArray[4] = lArray[4] + e;
        lArray = this.state;
        lArray[5] = lArray[5] + f;
        lArray = this.state;
        lArray[6] = lArray[6] + g;
        lArray = this.state;
        lArray[7] = lArray[7] + h;
    }

    @NotNull
    protected final byte[] digest(long bitLength, int bufferOffset, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer[bufferOffset] = -128;
        int size = bufferOffset + 1;
        if (size > 112) {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)128);
            this.compress(buffer, 0);
            ArraysKt.fill((byte[])buffer, (byte)0, (int)0, (int)size);
        } else {
            ArraysKt.fill((byte[])buffer, (byte)0, (int)size, (int)120);
        }
        buffer[120] = (byte)(bitLength >>> 56);
        buffer[121] = (byte)(bitLength >>> 48);
        buffer[122] = (byte)(bitLength >>> 40);
        buffer[123] = (byte)(bitLength >>> 32);
        buffer[124] = (byte)(bitLength >>> 24);
        buffer[125] = (byte)(bitLength >>> 16);
        buffer[126] = (byte)(bitLength >>> 8);
        buffer[127] = (byte)bitLength;
        this.compress(buffer, 0);
        return this.out(this.state[0], this.state[1], this.state[2], this.state[3], this.state[4], this.state[5], this.state[6], this.state[7]);
    }

    @NotNull
    protected abstract byte[] out(long var1, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

    protected final void resetDigest() {
        ArraysKt.fill$default((long[])this.x, (long)0L, (int)0, (int)0, (int)6, null);
        this.state[0] = this.h0;
        this.state[1] = this.h1;
        this.state[2] = this.h2;
        this.state[3] = this.h3;
        this.state[4] = this.h4;
        this.state[5] = this.h5;
        this.state[6] = this.h6;
        this.state[7] = this.h7;
    }

    private final long rotateRight(long $this$rotateRight, int n) {
        boolean $i$f$rotateRight = false;
        return $this$rotateRight >>> n | $this$rotateRight << 64 - n;
    }

    public /* synthetic */ Bit64Digest(int d, Integer t, long h0, long h1, long h2, long h3, long h4, long h5, long h6, long h7, DefaultConstructorMarker $constructor_marker) {
        this(d, t, h0, h1, h2, h3, h4, h5, h6, h7);
    }

    public /* synthetic */ Bit64Digest(DigestState state, Bit64Digest digest, DefaultConstructorMarker $constructor_marker) {
        this(state, digest);
    }

    static {
        long[] lArray = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
        K = lArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kotlincrypto/hash/sha2/Bit64Digest$Companion;", "", "()V", "K", "", "sha2"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

