/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha2;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.bitops.bits.Counter;
import org.kotlincrypto.bitops.endian.Endian;
import org.kotlincrypto.core.digest.Digest;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB!\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0014\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0004J\b\u0010\u0015\u001a\u00020\u0000H&J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0003H\u0004J\b\u0010\u0019\u001a\u00020\u0011H\u0004R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lorg/kotlincrypto/hash/sha2/Bit64Digest;", "Lorg/kotlincrypto/core/digest/Digest;", "bitStrength", "", "t", "h", "", "(ILjava/lang/Integer;[J)V", "other", "(Lorg/kotlincrypto/hash/sha2/Bit64Digest;)V", "count", "Lorg/kotlincrypto/bitops/bits/Counter$Bit32;", "isInitialized", "", "state", "x", "compressProtected", "", "input", "", "offset", "copy", "digestProtected", "buf", "bufPos", "resetProtected", "Companion", "Lorg/kotlincrypto/hash/sha2/SHA384;", "Lorg/kotlincrypto/hash/sha2/SHA512;", "Lorg/kotlincrypto/hash/sha2/SHA512t;", "org.kotlincrypto.hash_sha2_jvm"})
@SourceDebugExtension(value={"SMAP\nBit64Digest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bit64Digest.kt\norg/kotlincrypto/hash/sha2/Bit64Digest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Endian.kt\norg/kotlincrypto/bitops/endian/Endian$Big\n*L\n1#1,232:1\n1#2:233\n1882#3:234\n1821#3:235\n1821#3:236\n1873#3:237\n1864#3:238\n*S KotlinDebug\n*F\n+ 1 Bit64Digest.kt\norg/kotlincrypto/hash/sha2/Bit64Digest\n*L\n98#1:234\n163#1:235\n164#1:236\n178#1:237\n186#1:238\n*E\n"})
public abstract class Bit64Digest
extends Digest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private boolean isInitialized;
    @NotNull
    private final long[] h;
    @NotNull
    private final long[] x;
    @NotNull
    private final long[] state;
    @NotNull
    private final Counter.Bit32 count;
    private static final int BLOCK_SIZE = 128;
    @NotNull
    private static final long[] K;
    @NotNull
    private static final byte[] T_IV;

    /*
     * WARNING - void declaration
     */
    private Bit64Digest(int bitStrength, Integer t, long[] h) throws IllegalArgumentException {
        boolean bl;
        Bit64Digest bit64Digest;
        Object object;
        StringBuilder stringBuilder;
        Bit64Digest bit64Digest2;
        block13: {
            block12: {
                void it;
                bit64Digest2 = this;
                stringBuilder = new StringBuilder().append("SHA-").append(bitStrength);
                object = t;
                if (object == null) break block12;
                int n = ((Number)object).intValue();
                StringBuilder stringBuilder2 = stringBuilder;
                bit64Digest = bit64Digest2;
                boolean bl2 = false;
                String string = "" + '/' + (int)it;
                bit64Digest2 = bit64Digest;
                stringBuilder = stringBuilder2;
                String string2 = string;
                object = string2;
                if (string2 != null) break block13;
            }
            object = "";
        }
        Integer n = t;
        super(stringBuilder.append((String)object).toString(), 128, (n != null ? n : bitStrength) / 8);
        Bit64Digest bit64Digest3 = this;
        if (t != null) {
            if (!(bitStrength == 512)) {
                bit64Digest = bit64Digest3;
                boolean $i$a$-require-Bit64Digest$62 = false;
                Bit64Digest bit64Digest4 = bit64Digest;
                String $i$a$-require-Bit64Digest$62 = "t can only be expressed for SHA-512";
                throw new IllegalArgumentException($i$a$-require-Bit64Digest$62.toString());
            }
            if (!(t < 512)) {
                bit64Digest = bit64Digest3;
                boolean $i$a$-require-Bit64Digest$72 = false;
                Bit64Digest bit64Digest5 = bit64Digest;
                String $i$a$-require-Bit64Digest$72 = "t[" + t + "] must be less than 512";
                throw new IllegalArgumentException($i$a$-require-Bit64Digest$72.toString());
            }
            int n2 = 384;
            if (!(t != n2)) {
                bit64Digest = bit64Digest3;
                boolean $i$a$-require-Bit64Digest$82 = false;
                Bit64Digest bit64Digest6 = bit64Digest;
                String $i$a$-require-Bit64Digest$82 = "t[" + t + "] cannot be 384";
                throw new IllegalArgumentException($i$a$-require-Bit64Digest$82.toString());
            }
            if (!(t % 8 == 0)) {
                bit64Digest = bit64Digest3;
                boolean bl3 = false;
                Bit64Digest bit64Digest7 = bit64Digest;
                String string = "t[" + t + "] must be a factor of 8";
                throw new IllegalArgumentException(string.toString());
            }
            bl = false;
        } else {
            bl = true;
        }
        bit64Digest3.isInitialized = bl;
        this.h = h;
        this.x = new long[80];
        long[] lArray = Arrays.copyOf(h, h.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        this.state = lArray;
        this.count = new Counter.Bit32(128);
        if (t == null) {
            return;
        }
        this.update(T_IV);
        int bitLength = t;
        if (t > 100) {
            this.update((byte)(bitLength / 100 + 48));
            bitLength %= 100;
        }
        if (t > 10) {
            this.update((byte)(bitLength / 10 + 48));
            bitLength %= 10;
        }
        this.update((byte)(bitLength + 48));
        this.digest();
    }

    private Bit64Digest(Bit64Digest other) {
        super((Digest)other);
        this.h = other.h;
        long[] lArray = Arrays.copyOf(other.x, other.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        this.x = lArray;
        long[] lArray2 = Arrays.copyOf(other.state, other.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(...)");
        this.state = lArray2;
        this.count = other.count.copy();
        this.isInitialized = other.isInitialized;
    }

    @NotNull
    public abstract Bit64Digest copy();

    /*
     * WARNING - void declaration
     */
    protected final void compressProtected(@NotNull byte[] input, int offset) {
        void destOffset$iv;
        void $this$bePackIntoUnsafe$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long[] x = this.x;
        byte[] byArray = input;
        boolean bl = false;
        int sourceIndexEnd$iv = offset + 128;
        boolean $i$f$bePackIntoUnsafe = false;
        Endian.Big.INSTANCE.packUnsafe((byte[])$this$bePackIntoUnsafe$iv, x, (int)destOffset$iv, offset, sourceIndexEnd$iv);
        for (int i = 16; i < 80; ++i) {
            long x15 = x[i - 15];
            long s0 = Long.rotateRight(x15, 1) ^ Long.rotateRight(x15, 8) ^ x15 >>> 7;
            long x2 = x[i - 2];
            long s1 = Long.rotateRight(x2, 19) ^ Long.rotateRight(x2, 61) ^ x2 >>> 6;
            long x16 = x[i - 16];
            long x7 = x[i - 7];
            x[i] = x16 + s0 + x7 + s1;
        }
        long[] k = K;
        long[] state = this.state;
        long a = state[0];
        long b = state[1];
        long c = state[2];
        long d = state[3];
        long e = state[4];
        long f = state[5];
        long g = state[6];
        long h = state[7];
        for (int i = 0; i < 80; ++i) {
            long s0 = Long.rotateRight(a, 28) ^ Long.rotateRight(a, 34) ^ Long.rotateRight(a, 39);
            long s1 = Long.rotateRight(e, 14) ^ Long.rotateRight(e, 18) ^ Long.rotateRight(e, 41);
            long ch = e & f ^ (e ^ 0xFFFFFFFFFFFFFFFFL) & g;
            long maj = a & b ^ a & c ^ b & c;
            long t1 = h + s1 + ch + k[i] + x[i];
            long t2 = s0 + maj;
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
        }
        state[0] = state[0] + a;
        state[1] = state[1] + b;
        state[2] = state[2] + c;
        state[3] = state[3] + d;
        state[4] = state[4] + e;
        state[5] = state[5] + f;
        state[6] = state[6] + g;
        state[7] = state[7] + h;
        this.count.increment();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final byte[] digestProtected(@NotNull byte[] buf, int bufPos) {
        int sourceIndexStart$iv;
        int destOffset$iv;
        void dest$iv;
        void $this$bePackIntoUnsafe$iv3;
        int $this$bePackIntoUnsafe$iv2;
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Counter.Bit32.Final final_ = this.count.final(bufPos).asBits();
        int bitsLo = final_.component1();
        int bitsHi = final_.component2();
        buf[bufPos] = -128;
        if (bufPos + 1 > 112) {
            this.compressProtected(buf, 0);
            ArraysKt.fill((byte[])buf, (byte)0, (int)0, (int)120);
        }
        int n = bitsHi;
        int destOffset$iv2 = 120;
        boolean $i$f$bePackIntoUnsafe = false;
        Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe$iv2, buf, destOffset$iv2);
        $this$bePackIntoUnsafe$iv2 = bitsLo;
        destOffset$iv2 = 124;
        $i$f$bePackIntoUnsafe = false;
        Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe$iv2, buf, destOffset$iv2);
        this.compressProtected(buf, 0);
        long[] state = this.state;
        if (!this.isInitialized) {
            ArraysKt.copyInto$default((long[])state, (long[])this.h, (int)0, (int)0, (int)0, (int)14, null);
            this.isInitialized = true;
            return T_IV;
        }
        int len = this.digestLength();
        int rem = len % 8;
        int iStateEnd = len / 8;
        long[] lArray = state;
        byte[] byArray = new byte[len];
        boolean bl = false;
        boolean bl2 = false;
        boolean $i$f$bePackIntoUnsafe2 = false;
        byte[] out = Endian.Big.INSTANCE.packUnsafe((long[])$this$bePackIntoUnsafe$iv3, (byte[])dest$iv, destOffset$iv, sourceIndexStart$iv, iStateEnd);
        if (rem > 0) {
            long $this$bePackIntoUnsafe$iv3 = state[iStateEnd];
            destOffset$iv = len - rem;
            sourceIndexStart$iv = 0;
            $i$f$bePackIntoUnsafe2 = false;
            Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe$iv3, out, destOffset$iv, sourceIndexStart$iv, rem);
        }
        return out;
    }

    protected final void resetProtected() {
        ArraysKt.copyInto$default((long[])this.h, (long[])this.state, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.fill$default((long[])this.x, (long)0L, (int)0, (int)0, (int)6, null);
        this.count.reset();
    }

    public /* synthetic */ Bit64Digest(int bitStrength, Integer t, long[] h, DefaultConstructorMarker $constructor_marker) {
        this(bitStrength, t, h);
    }

    public /* synthetic */ Bit64Digest(Bit64Digest other, DefaultConstructorMarker $constructor_marker) {
        this(other);
    }

    static {
        Object[] objectArray = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
        K = objectArray;
        objectArray = new byte[8];
        objectArray[0] = 83;
        objectArray[1] = 72;
        objectArray[2] = 65;
        objectArray[3] = 45;
        objectArray[4] = 53;
        objectArray[5] = 49;
        objectArray[6] = 50;
        objectArray[7] = 47;
        T_IV = (byte[])objectArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kotlincrypto/hash/sha2/Bit64Digest$Companion;", "", "()V", "BLOCK_SIZE", "", "K", "", "T_IV", "", "org.kotlincrypto.hash_sha2_jvm"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

