/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha2;

import java.security.InvalidParameterException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.bitops.bits.Counter;
import org.kotlincrypto.bitops.endian.Endian;
import org.kotlincrypto.core.digest.Digest;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0019\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0014\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010\u000e\u001a\u00020\u0000H&J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0004J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0003H\u0004J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0003H\u0004J\b\u0010\u001a\u001a\u00020\u0010H\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lorg/kotlincrypto/hash/sha2/Bit32Digest;", "Lorg/kotlincrypto/core/digest/Digest;", "bitStrength", "", "h", "", "<init>", "(I[I)V", "other", "(Lorg/kotlincrypto/hash/sha2/Bit32Digest;)V", "x", "state", "count", "Lorg/kotlincrypto/bitops/bits/Counter$Bit32;", "copy", "compressProtected", "", "input", "", "offset", "digestProtected", "buf", "bufPos", "digestIntoProtected", "dest", "destOffset", "resetProtected", "Companion", "Lorg/kotlincrypto/hash/sha2/SHA224;", "Lorg/kotlincrypto/hash/sha2/SHA256;", "org.kotlincrypto.hash_sha2_jvm"})
@SourceDebugExtension(value={"SMAP\nBit32Digest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bit32Digest.kt\norg/kotlincrypto/hash/sha2/Bit32Digest\n+ 2 Endian.kt\norg/kotlincrypto/bitops/endian/Endian$Big\n*L\n1#1,182:1\n1848#2:183\n1821#2:184\n1821#2:185\n1833#2,7:186\n*S KotlinDebug\n*F\n+ 1 Bit32Digest.kt\norg/kotlincrypto/hash/sha2/Bit32Digest\n*L\n59#1:183\n142#1:184\n143#1:185\n146#1:186,7\n*E\n"})
public abstract class Bit32Digest
extends Digest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] h;
    @NotNull
    private final int[] x;
    @NotNull
    private final int[] state;
    @NotNull
    private final Counter.Bit32 count;
    private static final int BLOCK_SIZE = 64;
    @NotNull
    private static final int[] K;

    private Bit32Digest(int bitStrength, int[] h) throws InvalidParameterException {
        super("SHA-" + bitStrength, 64, bitStrength / 8);
        this.h = h;
        this.x = new int[64];
        int[] nArray = Arrays.copyOf(h, h.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.state = nArray;
        this.count = new Counter.Bit32(64);
    }

    private Bit32Digest(Bit32Digest other) {
        super((Digest)other);
        this.h = other.h;
        int[] nArray = Arrays.copyOf(other.x, other.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        this.x = nArray;
        int[] nArray2 = Arrays.copyOf(other.state, other.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        this.state = nArray2;
        this.count = other.count.copy();
    }

    @NotNull
    public abstract Bit32Digest copy();

    /*
     * WARNING - void declaration
     */
    protected final void compressProtected(@NotNull byte[] input, int offset) {
        void destOffset$iv;
        void $this$bePackIntoUnsafe$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int[] x = this.x;
        byte[] byArray = input;
        boolean bl = false;
        int sourceIndexEnd$iv = offset + 64;
        boolean $i$f$bePackIntoUnsafe = false;
        Endian.Big.INSTANCE.packUnsafe((byte[])$this$bePackIntoUnsafe$iv, x, (int)destOffset$iv, offset, sourceIndexEnd$iv);
        for (int i = 16; i < 64; ++i) {
            int x15 = x[i - 15];
            int s0 = (x15 >>> 7 | x15 << 25) ^ (x15 >>> 18 | x15 << 14) ^ x15 >>> 3;
            int x2 = x[i - 2];
            int s1 = (x2 >>> 17 | x2 << 15) ^ (x2 >>> 19 | x2 << 13) ^ x2 >>> 10;
            int x16 = x[i - 16];
            int x7 = x[i - 7];
            x[i] = x16 + s0 + x7 + s1;
        }
        int[] k = K;
        int[] state = this.state;
        int a = state[0];
        int b = state[1];
        int c = state[2];
        int d = state[3];
        int e = state[4];
        int f = state[5];
        int g = state[6];
        int h = state[7];
        for (int i = 0; i < 64; ++i) {
            int s0 = (a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10);
            int s1 = (e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7);
            int ch = e & f ^ ~e & g;
            int maj = a & b ^ a & c ^ b & c;
            int t1 = h + s1 + ch + k[i] + x[i];
            int t2 = s0 + maj;
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
        }
        state[0] = state[0] + a;
        state[1] = state[1] + b;
        state[2] = state[2] + c;
        state[3] = state[3] + d;
        state[4] = state[4] + e;
        state[5] = state[5] + f;
        state[6] = state[6] + g;
        state[7] = state[7] + h;
        this.count.increment();
    }

    @NotNull
    protected final byte[] digestProtected(@NotNull byte[] buf, int bufPos) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        byte[] digest = new byte[this.digestLength()];
        this.digestIntoProtected(digest, 0, buf, bufPos);
        return digest;
    }

    /*
     * WARNING - void declaration
     */
    protected final void digestIntoProtected(@NotNull byte[] dest, int destOffset, @NotNull byte[] buf, int bufPos) {
        void sourceIndexEnd$iv;
        void $this$bePackIntoUnsafe_u24default$iv;
        int $this$bePackIntoUnsafe$iv;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Counter.Bit32.Final final_ = this.count.final(bufPos).asBits();
        int bitsLo = final_.component1();
        int bitsHi = final_.component2();
        buf[bufPos] = -128;
        if (bufPos + 1 > 56) {
            this.compressProtected(buf, 0);
            ArraysKt.fill((byte[])buf, (byte)0, (int)0, (int)56);
        }
        int n = bitsHi;
        int destOffset$iv = 56;
        int $i$f$bePackIntoUnsafe = 0;
        Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe$iv, buf, destOffset$iv);
        $this$bePackIntoUnsafe$iv = bitsLo;
        destOffset$iv = 60;
        $i$f$bePackIntoUnsafe = 0;
        Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe$iv, buf, destOffset$iv);
        this.compressProtected(buf, 0);
        int[] $this$bePackIntoUnsafe$iv2 = this.state;
        $i$f$bePackIntoUnsafe = this.digestLength() / 4;
        int sourceIndexStart$iv = 0;
        boolean $i$f$bePackIntoUnsafe2 = false;
        Endian.Big.INSTANCE.packUnsafe((int[])$this$bePackIntoUnsafe_u24default$iv, dest, destOffset, sourceIndexStart$iv, (int)sourceIndexEnd$iv);
    }

    protected final void resetProtected() {
        ArraysKt.fill$default((int[])this.x, (int)0, (int)0, (int)0, (int)6, null);
        ArraysKt.copyInto$default((int[])this.h, (int[])this.state, (int)0, (int)0, (int)0, (int)14, null);
        this.count.reset();
    }

    public /* synthetic */ Bit32Digest(int bitStrength, int[] h, DefaultConstructorMarker $constructor_marker) {
        this(bitStrength, h);
    }

    public /* synthetic */ Bit32Digest(Bit32Digest other, DefaultConstructorMarker $constructor_marker) {
        this(other);
    }

    static {
        int[] nArray = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
        K = nArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kotlincrypto/hash/sha2/Bit32Digest$Companion;", "", "<init>", "()V", "BLOCK_SIZE", "", "K", "", "org.kotlincrypto.hash_sha2_jvm"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

