/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha2;

import java.security.InvalidParameterException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.bitops.bits.Counter;
import org.kotlincrypto.bitops.endian.Endian;
import org.kotlincrypto.core.digest.Digest;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB!\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0014\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0004J\b\u0010\u0015\u001a\u00020\u0000H&J(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0003H\u0004J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0003H\u0004J\b\u0010\u001c\u001a\u00020\u0011H\u0004R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u001e\u001f \u00a8\u0006!"}, d2={"Lorg/kotlincrypto/hash/sha2/Bit64Digest;", "Lorg/kotlincrypto/core/digest/Digest;", "bitStrength", "", "t", "h", "", "(ILjava/lang/Integer;[J)V", "other", "(Lorg/kotlincrypto/hash/sha2/Bit64Digest;)V", "count", "Lorg/kotlincrypto/bitops/bits/Counter$Bit64;", "isInitialized", "", "state", "x", "compressProtected", "", "input", "", "offset", "copy", "digestIntoProtected", "dest", "destOffset", "buf", "bufPos", "digestProtected", "resetProtected", "Companion", "Lorg/kotlincrypto/hash/sha2/SHA384;", "Lorg/kotlincrypto/hash/sha2/SHA512;", "Lorg/kotlincrypto/hash/sha2/SHA512t;", "org.kotlincrypto.hash_sha2_jvm"})
@SourceDebugExtension(value={"SMAP\nBit64Digest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bit64Digest.kt\norg/kotlincrypto/hash/sha2/Bit64Digest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Preconditions.kt\norg/kotlincrypto/error/PreconditionsKt\n+ 4 Endian.kt\norg/kotlincrypto/bitops/endian/Endian$Big\n*L\n1#1,241:1\n1#2:242\n39#3,6:243\n39#3,6:249\n39#3,6:255\n39#3,6:261\n1882#4:267\n1855#4:268\n1855#4:269\n1873#4:270\n1864#4:271\n*S KotlinDebug\n*F\n+ 1 Bit64Digest.kt\norg/kotlincrypto/hash/sha2/Bit64Digest\n*L\n52#1:243,6\n54#1:249,6\n55#1:255,6\n56#1:261,6\n102#1:267\n173#1:268\n174#1:269\n188#1:270\n196#1:271\n*E\n"})
public abstract class Bit64Digest
extends Digest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private boolean isInitialized;
    @NotNull
    private final long[] h;
    @NotNull
    private final long[] x;
    @NotNull
    private final long[] state;
    @NotNull
    private final Counter.Bit64 count;
    private static final int BLOCK_SIZE = 128;
    @NotNull
    private static final byte[] T_INTO = new byte[64];
    @NotNull
    private static final byte[] T_IV;
    @NotNull
    private static final long[] K;

    /*
     * WARNING - void declaration
     */
    private Bit64Digest(int bitStrength, Integer t, long[] h) throws InvalidParameterException {
        boolean bl;
        Bit64Digest bit64Digest;
        Object object;
        StringBuilder stringBuilder;
        Bit64Digest bit64Digest2;
        block13: {
            block12: {
                void it;
                bit64Digest2 = this;
                stringBuilder = new StringBuilder().append("SHA-").append(bitStrength);
                object = t;
                if (object == null) break block12;
                int n = ((Number)object).intValue();
                StringBuilder stringBuilder2 = stringBuilder;
                bit64Digest = bit64Digest2;
                boolean bl2 = false;
                String string = "" + '/' + (int)it;
                bit64Digest2 = bit64Digest;
                stringBuilder = stringBuilder2;
                String string2 = string;
                object = string2;
                if (string2 != null) break block13;
            }
            object = "";
        }
        Integer n = t;
        super(stringBuilder.append((String)object).toString(), 128, (n != null ? n : bitStrength) / 8);
        Bit64Digest bit64Digest3 = this;
        if (t != null) {
            int condition$iv = bitStrength == 512 ? 1 : 0;
            boolean $i$f$requireParam = false;
            if (condition$iv == 0) {
                bit64Digest = bit64Digest3;
                boolean bl3 = false;
                Bit64Digest bit64Digest4 = bit64Digest;
                String message$iv = "t can only be expressed for SHA-512";
                throw new InvalidParameterException(message$iv.toString());
            }
            condition$iv = t < 512 ? 1 : 0;
            $i$f$requireParam = false;
            if (condition$iv == 0) {
                bit64Digest = bit64Digest3;
                boolean bl4 = false;
                Bit64Digest bit64Digest5 = bit64Digest;
                String message$iv = "t[" + t + "] must be less than 512";
                throw new InvalidParameterException(message$iv.toString());
            }
            condition$iv = 384;
            condition$iv = t != condition$iv ? 1 : 0;
            $i$f$requireParam = false;
            if (condition$iv == 0) {
                bit64Digest = bit64Digest3;
                boolean bl5 = false;
                Bit64Digest bit64Digest6 = bit64Digest;
                String message$iv = "t[" + t + "] cannot be 384";
                throw new InvalidParameterException(message$iv.toString());
            }
            condition$iv = t % 8 == 0 ? 1 : 0;
            $i$f$requireParam = false;
            if (condition$iv == 0) {
                bit64Digest = bit64Digest3;
                boolean bl6 = false;
                Bit64Digest bit64Digest7 = bit64Digest;
                String message$iv = "t[" + t + "] must be a factor of 8";
                throw new InvalidParameterException(message$iv.toString());
            }
            bl = false;
        } else {
            bl = true;
        }
        bit64Digest3.isInitialized = bl;
        this.h = h;
        this.x = new long[80];
        long[] lArray = Arrays.copyOf(h, h.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        this.state = lArray;
        this.count = new Counter.Bit64(128L);
        if (t == null) {
            return;
        }
        this.update(T_IV);
        int bitLength = t;
        if (t > 100) {
            this.update((byte)(bitLength / 100 + 48));
            bitLength %= 100;
        }
        if (t > 10) {
            this.update((byte)(bitLength / 10 + 48));
            bitLength %= 10;
        }
        this.update((byte)(bitLength + 48));
        this.digestInto(T_INTO, 0);
    }

    private Bit64Digest(Bit64Digest other) {
        super((Digest)other);
        this.h = other.h;
        long[] lArray = Arrays.copyOf(other.x, other.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        this.x = lArray;
        long[] lArray2 = Arrays.copyOf(other.state, other.state.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(...)");
        this.state = lArray2;
        this.count = other.count.copy();
        this.isInitialized = other.isInitialized;
    }

    @NotNull
    public abstract Bit64Digest copy();

    /*
     * WARNING - void declaration
     */
    protected final void compressProtected(@NotNull byte[] input, int offset) {
        void sourceIndexStart$iv;
        void destOffset$iv;
        void dest$iv;
        void $this$bePackIntoUnsafe$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long[] x = this.x;
        byte[] byArray = input;
        long[] lArray = x;
        boolean bl = false;
        int n = offset;
        int sourceIndexEnd$iv = offset + 128;
        boolean $i$f$bePackIntoUnsafe = false;
        Endian.Big.INSTANCE.packUnsafe((byte[])$this$bePackIntoUnsafe$iv, (long[])dest$iv, (int)destOffset$iv, (int)sourceIndexStart$iv, sourceIndexEnd$iv);
        for (int i = 16; i < 80; ++i) {
            long x15 = x[i - 15];
            long s0 = Long.rotateRight(x15, 1) ^ Long.rotateRight(x15, 8) ^ x15 >>> 7;
            long x2 = x[i - 2];
            long s1 = Long.rotateRight(x2, 19) ^ Long.rotateRight(x2, 61) ^ x2 >>> 6;
            long x16 = x[i - 16];
            long x7 = x[i - 7];
            x[i] = x16 + s0 + x7 + s1;
        }
        long[] k = K;
        long[] state = this.state;
        long a = state[0];
        long b = state[1];
        long c = state[2];
        long d = state[3];
        long e = state[4];
        long f = state[5];
        long g = state[6];
        long h = state[7];
        for (int i = 0; i < 80; ++i) {
            long s0 = Long.rotateRight(a, 28) ^ Long.rotateRight(a, 34) ^ Long.rotateRight(a, 39);
            long s1 = Long.rotateRight(e, 14) ^ Long.rotateRight(e, 18) ^ Long.rotateRight(e, 41);
            long ch = e & f ^ (e ^ 0xFFFFFFFFFFFFFFFFL) & g;
            long maj = a & b ^ a & c ^ b & c;
            long t1 = h + s1 + ch + k[i] + x[i];
            long t2 = s0 + maj;
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
        }
        state[0] = state[0] + a;
        state[1] = state[1] + b;
        state[2] = state[2] + c;
        state[3] = state[3] + d;
        state[4] = state[4] + e;
        state[5] = state[5] + f;
        state[6] = state[6] + g;
        state[7] = state[7] + h;
        this.count.increment();
    }

    @NotNull
    protected final byte[] digestProtected(@NotNull byte[] buf, int bufPos) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        byte[] digest = new byte[this.digestLength()];
        this.digestIntoProtected(digest, 0, buf, bufPos);
        return digest;
    }

    /*
     * WARNING - void declaration
     */
    protected final void digestIntoProtected(@NotNull byte[] dest, int destOffset, @NotNull byte[] buf, int bufPos) {
        void sourceIndexEnd$iv;
        void sourceIndexStart$iv;
        void destOffset$iv;
        void dest$iv;
        boolean sourceIndexEnd$iv2;
        int sourceIndexStart$iv2;
        void destOffset$iv22;
        void dest$iv2;
        void $this$bePackIntoUnsafe$iv22;
        byte[] dest$iv3;
        long $this$bePackIntoUnsafe$iv;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Counter.Bit64.Final final_ = this.count.final(bufPos).asBits();
        long bitsLo = final_.component1();
        long bitsHi = final_.component2();
        buf[bufPos] = -128;
        if (bufPos + 1 > 112) {
            this.compressProtected(buf, 0);
            ArraysKt.fill((byte[])buf, (byte)0, (int)0, (int)112);
        }
        long l = bitsHi;
        byte[] byArray = buf;
        int destOffset$iv3 = 112;
        boolean $i$f$bePackIntoUnsafe = false;
        Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe$iv, dest$iv3, destOffset$iv3);
        $this$bePackIntoUnsafe$iv = bitsLo;
        dest$iv3 = buf;
        destOffset$iv3 = 120;
        $i$f$bePackIntoUnsafe = false;
        Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe$iv, dest$iv3, destOffset$iv3);
        this.compressProtected(buf, 0);
        long[] state = this.state;
        if (!this.isInitialized) {
            ArraysKt.copyInto$default((long[])state, (long[])this.h, (int)0, (int)0, (int)0, (int)14, null);
            this.isInitialized = true;
            return;
        }
        int len = this.digestLength();
        int rem = len % 8;
        int iStateEnd = len / 8;
        long[] $i$f$bePackIntoUnsafe2 = state;
        byte[] byArray2 = dest;
        int n = destOffset;
        boolean bl = false;
        int n2 = iStateEnd;
        int $i$f$bePackIntoUnsafe3 = 0;
        Endian.Big.INSTANCE.packUnsafe((long[])$this$bePackIntoUnsafe$iv22, (byte[])dest$iv2, (int)destOffset$iv22, sourceIndexStart$iv2, sourceIndexEnd$iv2 ? 1 : 0);
        if (rem == 0) {
            return;
        }
        long $this$bePackIntoUnsafe$iv22 = state[iStateEnd];
        byte[] destOffset$iv22 = dest;
        sourceIndexStart$iv2 = destOffset + len - rem;
        sourceIndexEnd$iv2 = false;
        $i$f$bePackIntoUnsafe3 = rem;
        boolean $i$f$bePackIntoUnsafe4 = false;
        Endian.Big.INSTANCE.packUnsafe($this$bePackIntoUnsafe$iv22, (byte[])dest$iv, (int)destOffset$iv, (int)sourceIndexStart$iv, (int)sourceIndexEnd$iv);
    }

    protected final void resetProtected() {
        ArraysKt.copyInto$default((long[])this.h, (long[])this.state, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.fill$default((long[])this.x, (long)0L, (int)0, (int)0, (int)6, null);
        this.count.reset();
    }

    public /* synthetic */ Bit64Digest(int bitStrength, Integer t, long[] h, DefaultConstructorMarker $constructor_marker) {
        this(bitStrength, t, h);
    }

    public /* synthetic */ Bit64Digest(Bit64Digest other, DefaultConstructorMarker $constructor_marker) {
        this(other);
    }

    static {
        Object[] objectArray = new byte[]{83, 72, 65, 45, 53, 49, 50, 47};
        T_IV = objectArray;
        objectArray = new long[80];
        objectArray[0] = (byte)4794697086780616226L;
        objectArray[1] = (byte)8158064640168781261L;
        objectArray[2] = (byte)-5349999486874862801L;
        objectArray[3] = (byte)-1606136188198331460L;
        objectArray[4] = (byte)4131703408338449720L;
        objectArray[5] = (byte)6480981068601479193L;
        objectArray[6] = (byte)-7908458776815382629L;
        objectArray[7] = (byte)-6116909921290321640L;
        objectArray[8] = (byte)-2880145864133508542L;
        objectArray[9] = (byte)1334009975649890238L;
        objectArray[10] = (byte)2608012711638119052L;
        objectArray[11] = (byte)6128411473006802146L;
        objectArray[12] = (byte)8268148722764581231L;
        objectArray[13] = (byte)-9160688886553864527L;
        objectArray[14] = (byte)-7215885187991268811L;
        objectArray[15] = (byte)-4495734319001033068L;
        objectArray[16] = (byte)-1973867731355612462L;
        objectArray[17] = (byte)-1171420211273849373L;
        objectArray[18] = (byte)1135362057144423861L;
        objectArray[19] = (byte)2597628984639134821L;
        objectArray[20] = (byte)3308224258029322869L;
        objectArray[21] = (byte)5365058923640841347L;
        objectArray[22] = (byte)6679025012923562964L;
        objectArray[23] = (byte)8573033837759648693L;
        objectArray[24] = (byte)-7476448914759557205L;
        objectArray[25] = (byte)-6327057829258317296L;
        objectArray[26] = (byte)-5763719355590565569L;
        objectArray[27] = (byte)-4658551843659510044L;
        objectArray[28] = (byte)-4116276920077217854L;
        objectArray[29] = (byte)-3051310485924567259L;
        objectArray[30] = (byte)489312712824947311L;
        objectArray[31] = (byte)1452737877330783856L;
        objectArray[32] = (byte)2861767655752347644L;
        objectArray[33] = (byte)3322285676063803686L;
        objectArray[34] = (byte)5560940570517711597L;
        objectArray[35] = (byte)5996557281743188959L;
        objectArray[36] = (byte)7280758554555802590L;
        objectArray[37] = (byte)8532644243296465576L;
        objectArray[38] = (byte)-9096487096722542874L;
        objectArray[39] = (byte)-7894198246740708037L;
        objectArray[40] = (byte)-6719396339535248540L;
        objectArray[41] = (byte)-6333637450476146687L;
        objectArray[42] = (byte)-4446306890439682159L;
        objectArray[43] = (byte)-4076793802049405392L;
        objectArray[44] = (byte)-3345356375505022440L;
        objectArray[45] = (byte)-2983346525034927856L;
        objectArray[46] = (byte)-860691631967231958L;
        objectArray[47] = (byte)1182934255886127544L;
        objectArray[48] = (byte)1847814050463011016L;
        objectArray[49] = (byte)2177327727835720531L;
        objectArray[50] = (byte)2830643537854262169L;
        objectArray[51] = (byte)3796741975233480872L;
        objectArray[52] = (byte)4115178125766777443L;
        objectArray[53] = (byte)5681478168544905931L;
        objectArray[54] = (byte)6601373596472566643L;
        objectArray[55] = (byte)7507060721942968483L;
        objectArray[56] = (byte)8399075790359081724L;
        objectArray[57] = (byte)8693463985226723168L;
        objectArray[58] = (byte)-8878714635349349518L;
        objectArray[59] = (byte)-8302665154208450068L;
        objectArray[60] = (byte)-8016688836872298968L;
        objectArray[61] = (byte)-6606660893046293015L;
        objectArray[62] = (byte)-4685533653050689259L;
        objectArray[63] = (byte)-4147400797238176981L;
        objectArray[64] = (byte)-3880063495543823972L;
        objectArray[65] = (byte)-3348786107499101689L;
        objectArray[66] = (byte)-1523767162380948706L;
        objectArray[67] = (byte)-757361751448694408L;
        objectArray[68] = (byte)500013540394364858L;
        objectArray[69] = (byte)748580250866718886L;
        objectArray[70] = (byte)1242879168328830382L;
        objectArray[71] = (byte)1977374033974150939L;
        objectArray[72] = (byte)2944078676154940804L;
        objectArray[73] = (byte)3659926193048069267L;
        objectArray[74] = (byte)4368137639120453308L;
        objectArray[75] = (byte)4836135668995329356L;
        objectArray[76] = (byte)5532061633213252278L;
        objectArray[77] = (byte)6448918945643986474L;
        objectArray[78] = (byte)6902733635092675308L;
        objectArray[79] = (byte)7801388544844847127L;
        K = objectArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/kotlincrypto/hash/sha2/Bit64Digest$Companion;", "", "()V", "BLOCK_SIZE", "", "K", "", "T_INTO", "", "T_IV", "org.kotlincrypto.hash_sha2_jvm"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

