(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'endians-endians-js-legacy', 'sponges-keccak-js-legacy', 'core-digest-js-legacy', 'core-xof-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('endians-endians-js-legacy'), require('sponges-keccak-js-legacy'), require('core-digest-js-legacy'), require('core-xof-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'hash-sha3-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'hash-sha3-js-legacy'.");
    }
    if (typeof this['endians-endians-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'hash-sha3-js-legacy'. Its dependency 'endians-endians-js-legacy' was not found. Please, check whether 'endians-endians-js-legacy' is loaded prior to 'hash-sha3-js-legacy'.");
    }
    if (typeof this['sponges-keccak-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'hash-sha3-js-legacy'. Its dependency 'sponges-keccak-js-legacy' was not found. Please, check whether 'sponges-keccak-js-legacy' is loaded prior to 'hash-sha3-js-legacy'.");
    }
    if (typeof this['core-digest-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'hash-sha3-js-legacy'. Its dependency 'core-digest-js-legacy' was not found. Please, check whether 'core-digest-js-legacy' is loaded prior to 'hash-sha3-js-legacy'.");
    }
    if (typeof this['core-xof-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'hash-sha3-js-legacy'. Its dependency 'core-xof-js-legacy' was not found. Please, check whether 'core-xof-js-legacy' is loaded prior to 'hash-sha3-js-legacy'.");
    }
    root['hash-sha3-js-legacy'] = factory(typeof this['hash-sha3-js-legacy'] === 'undefined' ? {} : this['hash-sha3-js-legacy'], kotlin, this['endians-endians-js-legacy'], this['sponges-keccak-js-legacy'], this['core-digest-js-legacy'], this['core-xof-js-legacy']);
  }
}(this, function (_, Kotlin, $module$endians_endians_js_legacy, $module$sponges_keccak_js_legacy, $module$core_digest_js_legacy, $module$core_xof_js_legacy) {
  'use strict';
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var LittleEndian = $module$endians_endians_js_legacy.org.kotlincrypto.endians.LittleEndian;
  var KeccakP = $module$sponges_keccak_js_legacy.org.kotlincrypto.sponges.keccak.KeccakP_s03gr1$;
  var fill = Kotlin.kotlin.collections.fill_6mk3ue$;
  var last = Kotlin.kotlin.collections.last_964n91$;
  var toByte = Kotlin.toByte;
  var get_lastIndex = Kotlin.kotlin.collections.get_lastIndex_964n91$;
  var L0 = Kotlin.Long.ZERO;
  var Digest = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest;
  var F1600_init = $module$sponges_keccak_js_legacy.org.kotlincrypto.sponges.keccak.F1600_init;
  var Digest_init = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest_init_3m52m6$;
  var Digest_init_0 = $module$core_digest_js_legacy.org.kotlincrypto.core.Digest_init_l73exj$;
  var Unit = Kotlin.kotlin.Unit;
  var Xof$Reader = $module$core_xof_js_legacy.org.kotlincrypto.core.Xof.Reader;
  var throwCCE = Kotlin.throwCCE;
  var XofFactory$XofDelegate = $module$core_xof_js_legacy.org.kotlincrypto.core.XofFactory.XofDelegate;
  var XofFactory = $module$core_xof_js_legacy.org.kotlincrypto.core.XofFactory;
  var Xof = $module$core_xof_js_legacy.org.kotlincrypto.core.Xof;
  var L8 = Kotlin.Long.fromInt(8);
  var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
  SHAKEDigest$SHAKEXofFactory.prototype = Object.create(XofFactory.prototype);
  SHAKEDigest$SHAKEXofFactory.prototype.constructor = SHAKEDigest$SHAKEXofFactory;
  CSHAKE128$Companion.prototype = Object.create(SHAKEDigest$SHAKEXofFactory.prototype);
  CSHAKE128$Companion.prototype.constructor = CSHAKE128$Companion;
  KeccakDigest.prototype = Object.create(Digest.prototype);
  KeccakDigest.prototype.constructor = KeccakDigest;
  SHAKEDigest.prototype = Object.create(KeccakDigest.prototype);
  SHAKEDigest.prototype.constructor = SHAKEDigest;
  CSHAKE128.prototype = Object.create(SHAKEDigest.prototype);
  CSHAKE128.prototype.constructor = CSHAKE128;
  CSHAKE256$Companion.prototype = Object.create(SHAKEDigest$SHAKEXofFactory.prototype);
  CSHAKE256$Companion.prototype.constructor = CSHAKE256$Companion;
  CSHAKE256.prototype = Object.create(SHAKEDigest.prototype);
  CSHAKE256.prototype.constructor = CSHAKE256;
  Keccak224.prototype = Object.create(KeccakDigest.prototype);
  Keccak224.prototype.constructor = Keccak224;
  Keccak256.prototype = Object.create(KeccakDigest.prototype);
  Keccak256.prototype.constructor = Keccak256;
  Keccak384.prototype = Object.create(KeccakDigest.prototype);
  Keccak384.prototype.constructor = Keccak384;
  Keccak512.prototype = Object.create(KeccakDigest.prototype);
  Keccak512.prototype.constructor = Keccak512;
  SHA3_224.prototype = Object.create(KeccakDigest.prototype);
  SHA3_224.prototype.constructor = SHA3_224;
  SHA3_256.prototype = Object.create(KeccakDigest.prototype);
  SHA3_256.prototype.constructor = SHA3_256;
  SHA3_384.prototype = Object.create(KeccakDigest.prototype);
  SHA3_384.prototype.constructor = SHA3_384;
  SHA3_512.prototype = Object.create(KeccakDigest.prototype);
  SHA3_512.prototype.constructor = SHA3_512;
  SHAKE128$Companion.prototype = Object.create(SHAKEDigest$SHAKEXofFactory.prototype);
  SHAKE128$Companion.prototype.constructor = SHAKE128$Companion;
  SHAKE128.prototype = Object.create(SHAKEDigest.prototype);
  SHAKE128.prototype.constructor = SHAKE128;
  SHAKE256$Companion.prototype = Object.create(SHAKEDigest$SHAKEXofFactory.prototype);
  SHAKE256$Companion.prototype.constructor = SHAKE256$Companion;
  SHAKE256.prototype = Object.create(SHAKEDigest.prototype);
  SHAKE256.prototype.constructor = SHAKE256;
  SHAKEDigest$SHAKEXofFactory$SHAKEXof$newReader$ObjectLiteral.prototype = Object.create(Xof$Reader.prototype);
  SHAKEDigest$SHAKEXofFactory$SHAKEXof$newReader$ObjectLiteral.prototype.constructor = SHAKEDigest$SHAKEXofFactory$SHAKEXof$newReader$ObjectLiteral;
  SHAKEDigest$SHAKEXofFactory$SHAKEXof.prototype = Object.create(XofFactory$XofDelegate.prototype);
  SHAKEDigest$SHAKEXofFactory$SHAKEXof.prototype.constructor = SHAKEDigest$SHAKEXofFactory$SHAKEXof;
  function CSHAKE128() {
    CSHAKE128$Companion_getInstance();
  }
  CSHAKE128.prototype.copy_l73exj$ = function (state) {
    return CSHAKE128_init_1(state, this);
  };
  function CSHAKE128$Companion() {
    CSHAKE128$Companion_instance = this;
    SHAKEDigest$SHAKEXofFactory.call(this);
    this.BLOCK_SIZE = 168;
    this.DIGEST_LENGTH = 32;
  }
  CSHAKE128$Companion.prototype.xOf_8oucvq$ = function (N, S) {
    return new SHAKEDigest$SHAKEXofFactory$SHAKEXof(this, CSHAKE128_init_0(N, S, true));
  };
  CSHAKE128$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [SHAKEDigest$SHAKEXofFactory]
  };
  var CSHAKE128$Companion_instance = null;
  function CSHAKE128$Companion_getInstance() {
    if (CSHAKE128$Companion_instance === null) {
      new CSHAKE128$Companion();
    }
    return CSHAKE128$Companion_instance;
  }
  CSHAKE128.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CSHAKE128',
    interfaces: [SHAKEDigest]
  };
  function CSHAKE128_init(N, S, $this) {
    $this = $this || Object.create(CSHAKE128.prototype);
    CSHAKE128_init_0(N, S, false, $this);
    return $this;
  }
  function CSHAKE128_init_0(N, S, xOfMode, $this) {
    $this = $this || Object.create(CSHAKE128.prototype);
    SHAKEDigest_init(N, S, xOfMode, 'CSHAKE128', 168, 32, $this);
    CSHAKE128.call($this);
    return $this;
  }
  function CSHAKE128_init_1(state, digest, $this) {
    $this = $this || Object.create(CSHAKE128.prototype);
    SHAKEDigest_init_0(state, digest, $this);
    CSHAKE128.call($this);
    return $this;
  }
  function CSHAKE256() {
    CSHAKE256$Companion_getInstance();
  }
  CSHAKE256.prototype.copy_l73exj$ = function (state) {
    return CSHAKE256_init_1(state, this);
  };
  function CSHAKE256$Companion() {
    CSHAKE256$Companion_instance = this;
    SHAKEDigest$SHAKEXofFactory.call(this);
    this.BLOCK_SIZE = 136;
    this.DIGEST_LENGTH = 64;
  }
  CSHAKE256$Companion.prototype.xOf_8oucvq$ = function (N, S) {
    return new SHAKEDigest$SHAKEXofFactory$SHAKEXof(this, CSHAKE256_init_0(N, S, true));
  };
  CSHAKE256$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [SHAKEDigest$SHAKEXofFactory]
  };
  var CSHAKE256$Companion_instance = null;
  function CSHAKE256$Companion_getInstance() {
    if (CSHAKE256$Companion_instance === null) {
      new CSHAKE256$Companion();
    }
    return CSHAKE256$Companion_instance;
  }
  CSHAKE256.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CSHAKE256',
    interfaces: [SHAKEDigest]
  };
  function CSHAKE256_init(N, S, $this) {
    $this = $this || Object.create(CSHAKE256.prototype);
    CSHAKE256_init_0(N, S, false, $this);
    return $this;
  }
  function CSHAKE256_init_0(N, S, xOfMode, $this) {
    $this = $this || Object.create(CSHAKE256.prototype);
    SHAKEDigest_init(N, S, xOfMode, 'CSHAKE256', 136, 64, $this);
    CSHAKE256.call($this);
    return $this;
  }
  function CSHAKE256_init_1(state, digest, $this) {
    $this = $this || Object.create(CSHAKE256.prototype);
    SHAKEDigest_init_0(state, digest, $this);
    CSHAKE256.call($this);
    return $this;
  }
  function Keccak224() {
  }
  Keccak224.prototype.copy_l73exj$ = function (state) {
    return Keccak224_init_0(state, this);
  };
  Keccak224.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Keccak224',
    interfaces: [KeccakDigest]
  };
  function Keccak224_init($this) {
    $this = $this || Object.create(Keccak224.prototype);
    KeccakDigest_init('Keccak-224', 144, 28, KeccakDigest$Companion_getInstance().PAD_KECCAK_8be2vx$, $this);
    Keccak224.call($this);
    return $this;
  }
  function Keccak224_init_0(state, digest, $this) {
    $this = $this || Object.create(Keccak224.prototype);
    KeccakDigest_init_0(state, digest, $this);
    Keccak224.call($this);
    return $this;
  }
  function Keccak256() {
  }
  Keccak256.prototype.copy_l73exj$ = function (state) {
    return Keccak256_init_0(state, this);
  };
  Keccak256.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Keccak256',
    interfaces: [KeccakDigest]
  };
  function Keccak256_init($this) {
    $this = $this || Object.create(Keccak256.prototype);
    KeccakDigest_init('Keccak-256', 136, 32, KeccakDigest$Companion_getInstance().PAD_KECCAK_8be2vx$, $this);
    Keccak256.call($this);
    return $this;
  }
  function Keccak256_init_0(state, digest, $this) {
    $this = $this || Object.create(Keccak256.prototype);
    KeccakDigest_init_0(state, digest, $this);
    Keccak256.call($this);
    return $this;
  }
  function Keccak384() {
  }
  Keccak384.prototype.copy_l73exj$ = function (state) {
    return Keccak384_init_0(state, this);
  };
  Keccak384.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Keccak384',
    interfaces: [KeccakDigest]
  };
  function Keccak384_init($this) {
    $this = $this || Object.create(Keccak384.prototype);
    KeccakDigest_init('Keccak-384', 104, 48, KeccakDigest$Companion_getInstance().PAD_KECCAK_8be2vx$, $this);
    Keccak384.call($this);
    return $this;
  }
  function Keccak384_init_0(state, digest, $this) {
    $this = $this || Object.create(Keccak384.prototype);
    KeccakDigest_init_0(state, digest, $this);
    Keccak384.call($this);
    return $this;
  }
  function Keccak512() {
  }
  Keccak512.prototype.copy_l73exj$ = function (state) {
    return Keccak512_init_0(state, this);
  };
  Keccak512.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Keccak512',
    interfaces: [KeccakDigest]
  };
  function Keccak512_init($this) {
    $this = $this || Object.create(Keccak512.prototype);
    KeccakDigest_init('Keccak-512', 72, 64, KeccakDigest$Companion_getInstance().PAD_KECCAK_8be2vx$, $this);
    Keccak512.call($this);
    return $this;
  }
  function Keccak512_init_0(state, digest, $this) {
    $this = $this || Object.create(Keccak512.prototype);
    KeccakDigest_init_0(state, digest, $this);
    Keccak512.call($this);
    return $this;
  }
  function KeccakDigest() {
    KeccakDigest$Companion_getInstance();
    this.dsByte_n3w9i2$_0 = 0;
    this.state_r0bome$_0 = null;
  }
  KeccakDigest.prototype.compress_ir89t6$ = function (input, offset) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7;
    var A = this.state_r0bome$_0;
    var b = input;
    var i = 0;
    var o = offset;
    var limit = o + this.blockSize() | 0;
    while (o < limit) {
      A.addData_xgg9qo$((tmp$ = i, i = tmp$ + 1 | 0, tmp$), LittleEndian.Companion.bytesToLong_uwl3p0$(b[tmp$_0 = o, o = tmp$_0 + 1 | 0, tmp$_0], b[tmp$_1 = o, o = tmp$_1 + 1 | 0, tmp$_1], b[tmp$_2 = o, o = tmp$_2 + 1 | 0, tmp$_2], b[tmp$_3 = o, o = tmp$_3 + 1 | 0, tmp$_3], b[tmp$_4 = o, o = tmp$_4 + 1 | 0, tmp$_4], b[tmp$_5 = o, o = tmp$_5 + 1 | 0, tmp$_5], b[tmp$_6 = o, o = tmp$_6 + 1 | 0, tmp$_6], b[tmp$_7 = o, o = tmp$_7 + 1 | 0, tmp$_7]));
    }
    KeccakP(A);
  };
  KeccakDigest.prototype.digest_4r1zfv$ = function (bitLength, bufferOffset, buffer) {
    buffer[bufferOffset] = this.dsByte_n3w9i2$_0;
    fill(buffer, 0, bufferOffset + 1 | 0);
    var xor$result;
    xor$result = toByte(last(buffer) ^ toByte(128));
    buffer[get_lastIndex(buffer)] = xor$result;
    this.compress_ir89t6$(buffer, 0);
    return this.extract_ussx79$(this.state_r0bome$_0, new Int8Array(this.digestLength()), 0, this.digestLength(), L0);
  };
  function KeccakDigest$extract$writeData(closure$spongeRemaining, closure$b, closure$offset, closure$limit, closure$out) {
    return function (data) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
      if (closure$spongeRemaining.v < data.size)
        tmp$ = data.size - closure$spongeRemaining.v | 0;
      else if (closure$b.v === closure$offset) {
        var remainder = closure$spongeRemaining.v % data.size | 0;
        tmp$ = remainder === 0 ? 0 : data.size - remainder | 0;
      } else
        tmp$ = 0;
      var j = tmp$;
      var written = 0;
      while (closure$b.v < closure$limit && j < data.size) {
        tmp$_3 = (tmp$_2 = closure$b.v, closure$b.v = tmp$_2 + 1 | 0, tmp$_2);
        tmp$_1 = (tmp$_0 = j, j = tmp$_0 + 1 | 0, tmp$_0);
        closure$out[tmp$_3] = data.get_za3lpa$(tmp$_1);
        written = written + 1 | 0;
      }
      closure$spongeRemaining.v = closure$spongeRemaining.v - written | 0;
      return written;
    };
  }
  KeccakDigest.prototype.extract_ussx79$ = function (A, out, offset, len, bytesRead) {
    var tmp$, tmp$_0;
    var spongeSize = this.blockSize();
    var spongeRemaining = {v: spongeSize - bytesRead.modulo(Kotlin.Long.fromInt(spongeSize)).toInt() | 0};
    var b = {v: offset};
    var limit = b.v + len | 0;
    var writeData = KeccakDigest$extract$writeData(spongeRemaining, b, offset, limit, out);
    var iLimit = (this.blockSize() / 8 | 0) + 1 | 0;
    var i = (spongeSize - spongeRemaining.v | 0) / 8 | 0;
    while (b.v < limit) {
      while (i < iLimit) {
        tmp$_0 = (tmp$ = i, i = tmp$ + 1 | 0, tmp$);
        var data = LittleEndian.Companion.toLittleEndian_mts6qi$(A.get_za3lpa$(tmp$_0));
        if (writeData(data) === 0)
          break;
      }
      if (spongeRemaining.v === 0) {
        KeccakP(A);
        i = 0;
        spongeRemaining.v = spongeSize;
      }
    }
    return out;
  };
  KeccakDigest.prototype.resetDigest = function () {
    this.state_r0bome$_0.reset();
  };
  function KeccakDigest$Companion() {
    KeccakDigest$Companion_instance = this;
    this.KECCAK_8be2vx$ = 'Keccak';
    this.SHA3_8be2vx$ = 'SHA3';
    this.PAD_KECCAK_8be2vx$ = 1;
    this.PAD_SHA3_8be2vx$ = 6;
  }
  KeccakDigest$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var KeccakDigest$Companion_instance = null;
  function KeccakDigest$Companion_getInstance() {
    if (KeccakDigest$Companion_instance === null) {
      new KeccakDigest$Companion();
    }
    return KeccakDigest$Companion_instance;
  }
  KeccakDigest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KeccakDigest',
    interfaces: [Digest]
  };
  function KeccakDigest_init(algorithm, blockSize, digestLength, dsByte, $this) {
    $this = $this || Object.create(KeccakDigest.prototype);
    Digest_init(algorithm, blockSize, digestLength, $this);
    KeccakDigest.call($this);
    $this.dsByte_n3w9i2$_0 = dsByte;
    $this.state_r0bome$_0 = F1600_init();
    return $this;
  }
  function KeccakDigest_init_0(state, digest, $this) {
    $this = $this || Object.create(KeccakDigest.prototype);
    Digest_init_0(state, $this);
    KeccakDigest.call($this);
    $this.dsByte_n3w9i2$_0 = digest.dsByte_n3w9i2$_0;
    $this.state_r0bome$_0 = digest.state_r0bome$_0.copy();
    return $this;
  }
  function SHA3_224() {
  }
  SHA3_224.prototype.copy_l73exj$ = function (state) {
    return SHA3_224_init_0(state, this);
  };
  SHA3_224.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHA3_224',
    interfaces: [KeccakDigest]
  };
  function SHA3_224_init($this) {
    $this = $this || Object.create(SHA3_224.prototype);
    KeccakDigest_init('SHA3-224', 144, 28, KeccakDigest$Companion_getInstance().PAD_SHA3_8be2vx$, $this);
    SHA3_224.call($this);
    return $this;
  }
  function SHA3_224_init_0(state, digest, $this) {
    $this = $this || Object.create(SHA3_224.prototype);
    KeccakDigest_init_0(state, digest, $this);
    SHA3_224.call($this);
    return $this;
  }
  function SHA3_256() {
  }
  SHA3_256.prototype.copy_l73exj$ = function (state) {
    return SHA3_256_init_0(state, this);
  };
  SHA3_256.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHA3_256',
    interfaces: [KeccakDigest]
  };
  function SHA3_256_init($this) {
    $this = $this || Object.create(SHA3_256.prototype);
    KeccakDigest_init('SHA3-256', 136, 32, KeccakDigest$Companion_getInstance().PAD_SHA3_8be2vx$, $this);
    SHA3_256.call($this);
    return $this;
  }
  function SHA3_256_init_0(state, digest, $this) {
    $this = $this || Object.create(SHA3_256.prototype);
    KeccakDigest_init_0(state, digest, $this);
    SHA3_256.call($this);
    return $this;
  }
  function SHA3_384() {
  }
  SHA3_384.prototype.copy_l73exj$ = function (state) {
    return SHA3_384_init_0(state, this);
  };
  SHA3_384.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHA3_384',
    interfaces: [KeccakDigest]
  };
  function SHA3_384_init($this) {
    $this = $this || Object.create(SHA3_384.prototype);
    KeccakDigest_init('SHA3-384', 104, 48, KeccakDigest$Companion_getInstance().PAD_SHA3_8be2vx$, $this);
    SHA3_384.call($this);
    return $this;
  }
  function SHA3_384_init_0(state, digest, $this) {
    $this = $this || Object.create(SHA3_384.prototype);
    KeccakDigest_init_0(state, digest, $this);
    SHA3_384.call($this);
    return $this;
  }
  function SHA3_512() {
  }
  SHA3_512.prototype.copy_l73exj$ = function (state) {
    return SHA3_512_init_0(state, this);
  };
  SHA3_512.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHA3_512',
    interfaces: [KeccakDigest]
  };
  function SHA3_512_init($this) {
    $this = $this || Object.create(SHA3_512.prototype);
    KeccakDigest_init('SHA3-512', 72, 64, KeccakDigest$Companion_getInstance().PAD_SHA3_8be2vx$, $this);
    SHA3_512.call($this);
    return $this;
  }
  function SHA3_512_init_0(state, digest, $this) {
    $this = $this || Object.create(SHA3_512.prototype);
    KeccakDigest_init_0(state, digest, $this);
    SHA3_512.call($this);
    return $this;
  }
  function SHAKE128() {
    SHAKE128$Companion_getInstance();
  }
  SHAKE128.prototype.copy_l73exj$ = function (state) {
    return SHAKE128_init_1(state, this);
  };
  function SHAKE128$Companion() {
    SHAKE128$Companion_instance = this;
    SHAKEDigest$SHAKEXofFactory.call(this);
  }
  SHAKE128$Companion.prototype.xOf = function () {
    return new SHAKEDigest$SHAKEXofFactory$SHAKEXof(this, SHAKE128_init_0(true));
  };
  SHAKE128$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [SHAKEDigest$SHAKEXofFactory]
  };
  var SHAKE128$Companion_instance = null;
  function SHAKE128$Companion_getInstance() {
    if (SHAKE128$Companion_instance === null) {
      new SHAKE128$Companion();
    }
    return SHAKE128$Companion_instance;
  }
  SHAKE128.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHAKE128',
    interfaces: [SHAKEDigest]
  };
  function SHAKE128_init($this) {
    $this = $this || Object.create(SHAKE128.prototype);
    SHAKE128_init_0(false, $this);
    return $this;
  }
  function SHAKE128_init_0(xOfMode, $this) {
    $this = $this || Object.create(SHAKE128.prototype);
    SHAKEDigest_init(null, null, xOfMode, 'SHAKE128', 168, 32, $this);
    SHAKE128.call($this);
    return $this;
  }
  function SHAKE128_init_1(state, digest, $this) {
    $this = $this || Object.create(SHAKE128.prototype);
    SHAKEDigest_init_0(state, digest, $this);
    SHAKE128.call($this);
    return $this;
  }
  function SHAKE256() {
    SHAKE256$Companion_getInstance();
  }
  SHAKE256.prototype.copy_l73exj$ = function (state) {
    return SHAKE256_init_1(state, this);
  };
  function SHAKE256$Companion() {
    SHAKE256$Companion_instance = this;
    SHAKEDigest$SHAKEXofFactory.call(this);
  }
  SHAKE256$Companion.prototype.xOf = function () {
    return new SHAKEDigest$SHAKEXofFactory$SHAKEXof(this, SHAKE256_init_0(true));
  };
  SHAKE256$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [SHAKEDigest$SHAKEXofFactory]
  };
  var SHAKE256$Companion_instance = null;
  function SHAKE256$Companion_getInstance() {
    if (SHAKE256$Companion_instance === null) {
      new SHAKE256$Companion();
    }
    return SHAKE256$Companion_instance;
  }
  SHAKE256.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHAKE256',
    interfaces: [SHAKEDigest]
  };
  function SHAKE256_init($this) {
    $this = $this || Object.create(SHAKE256.prototype);
    SHAKE256_init_0(false, $this);
    return $this;
  }
  function SHAKE256_init_0(xOfMode, $this) {
    $this = $this || Object.create(SHAKE256.prototype);
    SHAKEDigest_init(null, null, xOfMode, 'SHAKE256', 136, 64, $this);
    SHAKE256.call($this);
    return $this;
  }
  function SHAKE256_init_1(state, digest, $this) {
    $this = $this || Object.create(SHAKE256.prototype);
    SHAKEDigest_init_0(state, digest, $this);
    SHAKE256.call($this);
    return $this;
  }
  function SHAKEDigest() {
    SHAKEDigest$Companion_getInstance();
    this.initBlock_eabic6$_0 = null;
    this.xOfMode_x1w9h1$_0 = false;
    this.isReadingXof_3deqcg$_0 = false;
  }
  SHAKEDigest.prototype.extract_ussx79$ = function (A, out, offset, len, bytesRead) {
    var tmp$;
    if (this.xOfMode_x1w9h1$_0 && !this.isReadingXof_3deqcg$_0) {
      var newOut = new Int8Array(A.size * 8 | 0);
      for (var i = 0; i !== A.size; ++i) {
        LittleEndian.Companion.toLittleEndian_mts6qi$(A.get_za3lpa$(i)).copyInto_elxobu$(newOut, i * 8 | 0);
      }
      this.isReadingXof_3deqcg$_0 = true;
      return newOut;
    } else {
      tmp$ = KeccakDigest.prototype.extract_ussx79$.call(this, A, out, offset, len, bytesRead);
    }
    return tmp$;
  };
  SHAKEDigest.prototype.resetDigest = function () {
    var tmp$;
    KeccakDigest.prototype.resetDigest.call(this);
    (tmp$ = this.initBlock_eabic6$_0) != null ? (this.bytepad_7fcvpr$_0(tmp$), Unit) : null;
  };
  SHAKEDigest.prototype.bytepad_7fcvpr$_0 = function ($receiver) {
    this.update_fqrh44$($receiver);
    var remainder = $receiver.length % this.blockSize() | 0;
    if (remainder === 0)
      return;
    var times = this.blockSize() - remainder | 0;
    for (var index = 0; index < times; index++) {
      this.update_s8j3t7$(0);
    }
  };
  function SHAKEDigest$SHAKEXofFactory() {
    XofFactory.call(this);
  }
  function SHAKEDigest$SHAKEXofFactory$SHAKEXof($outer, delegate) {
    this.$outer = $outer;
    XofFactory$XofDelegate.call(this, this.$outer, delegate);
  }
  function SHAKEDigest$SHAKEXofFactory$SHAKEXof$newReader$ObjectLiteral(closure$delegateCopy, closure$state, this$SHAKEXof) {
    this.closure$delegateCopy = closure$delegateCopy;
    this.closure$state = closure$state;
    Xof$Reader.call(this, this$SHAKEXof);
  }
  SHAKEDigest$SHAKEXofFactory$SHAKEXof$newReader$ObjectLiteral.prototype.readProtected_qpdjz5$ = function (out, offset, len, bytesRead) {
    this.closure$delegateCopy.extract_ussx79$(this.closure$state, out, offset, len, bytesRead);
  };
  SHAKEDigest$SHAKEXofFactory$SHAKEXof$newReader$ObjectLiteral.prototype.closeProtected = function () {
    this.closure$state.reset();
  };
  SHAKEDigest$SHAKEXofFactory$SHAKEXof$newReader$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [Xof$Reader]
  };
  SHAKEDigest$SHAKEXofFactory$SHAKEXof.prototype.newReader_mhftrk$ = function (delegateCopy) {
    var A = delegateCopy.digest();
    var f1600 = F1600_init();
    var b = 0;
    for (var i = 0; i !== f1600.size; ++i) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6;
      f1600.addData_xgg9qo$(i, LittleEndian.Companion.bytesToLong_uwl3p0$(A[tmp$ = b, b = tmp$ + 1 | 0, tmp$], A[tmp$_0 = b, b = tmp$_0 + 1 | 0, tmp$_0], A[tmp$_1 = b, b = tmp$_1 + 1 | 0, tmp$_1], A[tmp$_2 = b, b = tmp$_2 + 1 | 0, tmp$_2], A[tmp$_3 = b, b = tmp$_3 + 1 | 0, tmp$_3], A[tmp$_4 = b, b = tmp$_4 + 1 | 0, tmp$_4], A[tmp$_5 = b, b = tmp$_5 + 1 | 0, tmp$_5], A[tmp$_6 = b, b = tmp$_6 + 1 | 0, tmp$_6]));
    }
    fill(A, 0);
    var state = f1600;
    return new SHAKEDigest$SHAKEXofFactory$SHAKEXof$newReader$ObjectLiteral(delegateCopy, state, this);
  };
  SHAKEDigest$SHAKEXofFactory$SHAKEXof.prototype.copy = function () {
    var tmp$, tmp$_0;
    tmp$_0 = Kotlin.isType(tmp$ = this.delegate.copy(), SHAKEDigest) ? tmp$ : throwCCE();
    return new SHAKEDigest$SHAKEXofFactory$SHAKEXof(this.$outer, tmp$_0);
  };
  SHAKEDigest$SHAKEXofFactory$SHAKEXof.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHAKEXof',
    interfaces: [XofFactory$XofDelegate]
  };
  SHAKEDigest$SHAKEXofFactory.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHAKEXofFactory',
    interfaces: [XofFactory]
  };
  function SHAKEDigest$Companion() {
    SHAKEDigest$Companion_instance = this;
    this.SHAKE_8be2vx$ = 'SHAKE';
    this.CSHAKE_8be2vx$ = 'CSHAKE';
    this.PAD_SHAKE_0 = 31;
    this.PAD_CSHAKE_0 = 4;
  }
  SHAKEDigest$Companion.prototype.dsByteFromInput_0 = function (N, S) {
    var tmp$ = (N != null ? !(N.length === 0) : null) === true;
    if (!tmp$) {
      tmp$ = (S != null ? !(S.length === 0) : null) === true;
    }
    return tmp$ ? this.PAD_CSHAKE_0 : this.PAD_SHAKE_0;
  };
  SHAKEDigest$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SHAKEDigest$Companion_instance = null;
  function SHAKEDigest$Companion_getInstance() {
    if (SHAKEDigest$Companion_instance === null) {
      new SHAKEDigest$Companion();
    }
    return SHAKEDigest$Companion_instance;
  }
  SHAKEDigest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SHAKEDigest',
    interfaces: [KeccakDigest]
  };
  function SHAKEDigest_init(N, S, xOfMode, algorithm, blockSize, digestLength, $this) {
    $this = $this || Object.create(SHAKEDigest.prototype);
    KeccakDigest_init(algorithm, blockSize, digestLength, SHAKEDigest$Companion_getInstance().dsByteFromInput_0(N, S), $this);
    SHAKEDigest.call($this);
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    $this.xOfMode_x1w9h1$_0 = xOfMode;
    $this.isReadingXof_3deqcg$_0 = false;
    var tmp$_3 = (N != null ? !(N.length === 0) : null) === true;
    if (!tmp$_3) {
      tmp$_3 = (S != null ? !(S.length === 0) : null) === true;
    }
    if (tmp$_3) {
      var nSize = (tmp$ = N != null ? N.length : null) != null ? tmp$ : 0;
      var sSize = (tmp$_0 = S != null ? S.length : null) != null ? tmp$_0 : 0;
      var bE = Xof.Utils.leftEncode_s8cxhz$(Kotlin.Long.fromInt(blockSize));
      var nE = Xof.Utils.leftEncode_s8cxhz$(Kotlin.Long.fromInt(nSize).multiply(L8));
      var sE = Xof.Utils.leftEncode_s8cxhz$(Kotlin.Long.fromInt(sSize).multiply(L8));
      var b = new Int8Array(bE.length + nE.length + nSize + sE.length + sSize | 0);
      arrayCopy(bE, b, 0, 0, bE.length);
      arrayCopy(nE, b, bE.length, 0, nE.length);
      if (N != null) {
        arrayCopy(N, b, bE.length + nE.length | 0, 0, N.length);
      }
      arrayCopy(sE, b, bE.length + nE.length + nSize | 0, 0, sE.length);
      if (S != null) {
        arrayCopy(S, b, bE.length + nE.length + nSize + sE.length | 0, 0, S.length);
      }
      tmp$_1 = b;
    } else {
      tmp$_1 = null;
    }
    $this.initBlock_eabic6$_0 = tmp$_1;
    (tmp$_2 = $this.initBlock_eabic6$_0) != null ? ($this.bytepad_7fcvpr$_0(tmp$_2), Unit) : null;
    return $this;
  }
  function SHAKEDigest_init_0(state, digest, $this) {
    $this = $this || Object.create(SHAKEDigest.prototype);
    KeccakDigest_init_0(state, digest, $this);
    SHAKEDigest.call($this);
    var tmp$;
    $this.xOfMode_x1w9h1$_0 = digest.xOfMode_x1w9h1$_0;
    $this.isReadingXof_3deqcg$_0 = digest.isReadingXof_3deqcg$_0;
    $this.initBlock_eabic6$_0 = (tmp$ = digest.initBlock_eabic6$_0) != null ? tmp$.slice() : null;
    return $this;
  }
  Object.defineProperty(CSHAKE128, 'Companion', {
    get: CSHAKE128$Companion_getInstance
  });
  var package$org = _.org || (_.org = {});
  var package$kotlincrypto = package$org.kotlincrypto || (package$org.kotlincrypto = {});
  var package$hash = package$kotlincrypto.hash || (package$kotlincrypto.hash = {});
  var package$sha3 = package$hash.sha3 || (package$hash.sha3 = {});
  package$sha3.CSHAKE128_init_8oucvq$ = CSHAKE128_init;
  package$sha3.CSHAKE128 = CSHAKE128;
  Object.defineProperty(CSHAKE256, 'Companion', {
    get: CSHAKE256$Companion_getInstance
  });
  package$sha3.CSHAKE256_init_8oucvq$ = CSHAKE256_init;
  package$sha3.CSHAKE256 = CSHAKE256;
  package$sha3.Keccak224_init = Keccak224_init;
  package$sha3.Keccak224 = Keccak224;
  package$sha3.Keccak256_init = Keccak256_init;
  package$sha3.Keccak256 = Keccak256;
  package$sha3.Keccak384_init = Keccak384_init;
  package$sha3.Keccak384 = Keccak384;
  package$sha3.Keccak512_init = Keccak512_init;
  package$sha3.Keccak512 = Keccak512;
  Object.defineProperty(KeccakDigest, 'Companion', {
    get: KeccakDigest$Companion_getInstance
  });
  package$sha3.KeccakDigest_init_b58r0n$ = KeccakDigest_init;
  package$sha3.KeccakDigest_init_a2pn2q$ = KeccakDigest_init_0;
  package$sha3.KeccakDigest = KeccakDigest;
  package$sha3.SHA3_224_init = SHA3_224_init;
  package$sha3.SHA3_224 = SHA3_224;
  package$sha3.SHA3_256_init = SHA3_256_init;
  package$sha3.SHA3_256 = SHA3_256;
  package$sha3.SHA3_384_init = SHA3_384_init;
  package$sha3.SHA3_384 = SHA3_384;
  package$sha3.SHA3_512_init = SHA3_512_init;
  package$sha3.SHA3_512 = SHA3_512;
  Object.defineProperty(SHAKE128, 'Companion', {
    get: SHAKE128$Companion_getInstance
  });
  package$sha3.SHAKE128_init = SHAKE128_init;
  package$sha3.SHAKE128 = SHAKE128;
  Object.defineProperty(SHAKE256, 'Companion', {
    get: SHAKE256$Companion_getInstance
  });
  package$sha3.SHAKE256_init = SHAKE256_init;
  package$sha3.SHAKE256 = SHAKE256;
  SHAKEDigest$SHAKEXofFactory.SHAKEXof = SHAKEDigest$SHAKEXofFactory$SHAKEXof;
  SHAKEDigest.SHAKEXofFactory = SHAKEDigest$SHAKEXofFactory;
  Object.defineProperty(SHAKEDigest, 'Companion', {
    get: SHAKEDigest$Companion_getInstance
  });
  package$sha3.SHAKEDigest_init_5kche7$ = SHAKEDigest_init;
  package$sha3.SHAKEDigest_init_nkk9ks$ = SHAKEDigest_init_0;
  package$sha3.SHAKEDigest = SHAKEDigest;
  Kotlin.defineModule('hash-sha3-js-legacy', _);
  return _;
}));

//# sourceMappingURL=hash-sha3-js-legacy.js.map
