/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha3;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.Digest;
import org.kotlincrypto.core.Xof;
import org.kotlincrypto.core.internal.DigestState;
import org.kotlincrypto.hash.sha3.CSHAKE128;
import org.kotlincrypto.hash.sha3.CSHAKE256;
import org.kotlincrypto.hash.sha3.SHAKEDigest;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB1\b\u0014\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u0017\b\u0014\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u000eJ \u0010\r\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0003H\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0004J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001dH\u0004J \u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0004R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002 !\u00a8\u0006\""}, d2={"Lorg/kotlincrypto/hash/sha3/ParallelDigest;", "Lorg/kotlincrypto/hash/sha3/SHAKEDigest;", "S", "", "B", "", "xOfMode", "", "bitStrength", "digestLength", "([BIZII)V", "state", "Lorg/kotlincrypto/core/internal/DigestState;", "digest", "(Lorg/kotlincrypto/core/internal/DigestState;Lorg/kotlincrypto/hash/sha3/ParallelDigest;)V", "inner", "innerBufOffs", "innerBuffer", "processCount", "", "bitLength", "bufferOffset", "buffer", "processBlock", "", "input", "offset", "resetDigest", "updateDigest", "", "len", "Companion", "Lorg/kotlincrypto/hash/sha3/ParallelHash128;", "Lorg/kotlincrypto/hash/sha3/ParallelHash256;", "sha3"})
@SourceDebugExtension(value={"SMAP\nParallelDigest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParallelDigest.kt\norg/kotlincrypto/hash/sha3/ParallelDigest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public abstract class ParallelDigest
extends SHAKEDigest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SHAKEDigest inner;
    @NotNull
    private final byte[] innerBuffer;
    private int innerBufOffs;
    private long processCount;
    @NotNull
    private static final String PARALLEL_HASH = "ParallelHash";

    private ParallelDigest(byte[] S, int B, boolean xOfMode, int bitStrength, int digestLength) {
        super(StringsKt.encodeToByteArray((String)PARALLEL_HASH), S, xOfMode, PARALLEL_HASH + bitStrength, SHAKEDigest.Companion.blockSizeFromBitStrength$sha3(bitStrength), digestLength, null);
        SHAKEDigest sHAKEDigest;
        if (!(B > 0)) {
            boolean bl = false;
            String string = "B must be greater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        switch (bitStrength) {
            case 128: {
                sHAKEDigest = new CSHAKE128(null, null);
                break;
            }
            case 256: {
                sHAKEDigest = new CSHAKE256(null, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("bitStrength must be 128 or 256");
            }
        }
        this.inner = sHAKEDigest;
        this.innerBuffer = new byte[B];
        this.innerBufOffs = 0;
        this.processCount = 0L;
        byte[] encB = Xof.Utils.leftEncode((long)this.innerBuffer.length);
        super.updateDigest(encB, 0, encB.length);
    }

    private ParallelDigest(DigestState state, ParallelDigest digest) {
        super(state, digest, null);
        Digest digest2 = digest.inner.copy();
        Intrinsics.checkNotNull((Object)digest2, (String)"null cannot be cast to non-null type org.kotlincrypto.hash.sha3.SHAKEDigest");
        this.inner = (SHAKEDigest)digest2;
        byte[] byArray = Arrays.copyOf(digest.innerBuffer, digest.innerBuffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        this.innerBuffer = byArray;
        this.innerBufOffs = digest.innerBufOffs;
        this.processCount = digest.processCount;
    }

    @Override
    @NotNull
    protected final byte[] digest(long bitLength, int bufferOffset, @NotNull byte[] buffer) {
        byte[] byArray;
        byte[] byArray2;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.innerBufOffs != 0) {
            this.inner.update(this.innerBuffer, 0, this.innerBufOffs);
            long l = this.processCount;
            this.processCount = l + 1L;
            this.innerBufOffs = 0;
            byArray2 = this.inner.digest();
        } else {
            byArray2 = new byte[]{};
        }
        byte[] buffered = byArray2;
        byte[] byArray3 = ArraysKt.plus((byte[])ArraysKt.plus((byte[])buffered, (byte[])Xof.Utils.rightEncode((long)this.processCount)), (byte[])Xof.Utils.rightEncode((long)((long)this.digestLength() * 8L)));
        int size = bufferOffset + byArray3.length;
        long newBitLength = bitLength + (long)(byArray3.length * 8);
        if (size > ArraysKt.getLastIndex((byte[])buffer)) {
            int i = buffer.length - bufferOffset;
            ArraysKt.copyInto((byte[])byArray3, (byte[])buffer, (int)bufferOffset, (int)0, (int)i);
            this.compress(buffer, 0);
            ArraysKt.copyInto((byte[])byArray3, (byte[])buffer, (int)0, (int)i, (int)byArray3.length);
            byArray = super.digest(newBitLength, size - buffer.length, buffer);
        } else {
            ArraysKt.copyInto$default((byte[])byArray3, (byte[])buffer, (int)bufferOffset, (int)0, (int)0, (int)12, null);
            byArray = super.digest(newBitLength, size, buffer);
        }
        return byArray;
    }

    protected final void updateDigest(byte input) {
        this.innerBuffer[this.innerBufOffs] = input;
        ++this.innerBufOffs;
        if (this.innerBufOffs != this.innerBuffer.length) {
            return;
        }
        this.processBlock(this.innerBuffer, 0);
        this.innerBufOffs = 0;
    }

    protected final void updateDigest(@NotNull byte[] input, int offset, int len) {
        int remaining;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int i = offset;
        for (remaining = len; this.innerBufOffs != 0 && remaining > 0; --remaining) {
            this.updateDigest(input[i++]);
        }
        while (remaining >= this.innerBuffer.length) {
            this.processBlock(input, i);
            i += this.innerBuffer.length;
            remaining -= this.innerBuffer.length;
        }
        while (remaining-- > 0) {
            this.updateDigest(input[i++]);
        }
    }

    private final void processBlock(byte[] input, int offset) {
        this.inner.update(input, offset, this.innerBuffer.length);
        super.updateDigest(this.inner.digest(), 0, this.inner.digestLength());
        long l = this.processCount;
        this.processCount = l + 1L;
    }

    @Override
    protected final void resetDigest() {
        super.resetDigest();
        ArraysKt.fill$default((byte[])this.innerBuffer, (byte)0, (int)0, (int)0, (int)6, null);
        this.innerBufOffs = 0;
        this.processCount = 0L;
        byte[] encB = Xof.Utils.leftEncode((long)this.innerBuffer.length);
        super.updateDigest(encB, 0, encB.length);
    }

    public /* synthetic */ ParallelDigest(byte[] S, int B, boolean xOfMode, int bitStrength, int digestLength, DefaultConstructorMarker $constructor_marker) {
        this(S, B, xOfMode, bitStrength, digestLength);
    }

    public /* synthetic */ ParallelDigest(DigestState state, ParallelDigest digest, DefaultConstructorMarker $constructor_marker) {
        this(state, digest);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kotlincrypto/hash/sha3/ParallelDigest$Companion;", "", "()V", "PARALLEL_HASH", "", "sha3"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

