/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha3;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.digest.Digest;
import org.kotlincrypto.core.digest.internal.DigestState;
import org.kotlincrypto.endians.LittleEndian;
import org.kotlincrypto.sponges.keccak.F1600;
import org.kotlincrypto.sponges.keccak.KeccakPKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0014\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0004J \u0010\f\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0012H\u0014J0\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0015H\u0014J\b\u0010\u001d\u001a\u00020\u0010H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\t\u001f !\"#$%&'\u00a8\u0006("}, d2={"Lorg/kotlincrypto/hash/sha3/KeccakDigest;", "Lorg/kotlincrypto/core/digest/Digest;", "algorithm", "", "blockSize", "", "digestLength", "dsByte", "", "(Ljava/lang/String;IIB)V", "state", "Lorg/kotlincrypto/core/digest/internal/DigestState;", "digest", "(Lorg/kotlincrypto/core/digest/internal/DigestState;Lorg/kotlincrypto/hash/sha3/KeccakDigest;)V", "Lorg/kotlincrypto/sponges/keccak/F1600;", "compress", "", "input", "", "offset", "bitLength", "", "bufferOffset", "buffer", "extract", "A", "out", "len", "bytesRead", "resetDigest", "Companion", "Lorg/kotlincrypto/hash/sha3/Keccak224;", "Lorg/kotlincrypto/hash/sha3/Keccak256;", "Lorg/kotlincrypto/hash/sha3/Keccak384;", "Lorg/kotlincrypto/hash/sha3/Keccak512;", "Lorg/kotlincrypto/hash/sha3/SHA3_224;", "Lorg/kotlincrypto/hash/sha3/SHA3_256;", "Lorg/kotlincrypto/hash/sha3/SHA3_384;", "Lorg/kotlincrypto/hash/sha3/SHA3_512;", "Lorg/kotlincrypto/hash/sha3/SHAKEDigest;", "org.kotlincrypto.hash_sha3_jvm"})
public abstract class KeccakDigest
extends Digest {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    private final byte dsByte;
    @NotNull
    private final F1600 state;
    @NotNull
    public static final String KECCAK = "Keccak";
    @NotNull
    public static final String SHA3 = "SHA3";
    public static final byte PAD_KECCAK = 1;
    public static final byte PAD_SHA3 = 6;

    private KeccakDigest(String algorithm, int blockSize, int digestLength, byte dsByte) {
        super(algorithm, blockSize, digestLength);
        this.dsByte = dsByte;
        this.state = new F1600();
    }

    private KeccakDigest(DigestState state, KeccakDigest digest) {
        super(state);
        this.dsByte = digest.dsByte;
        this.state = digest.state.copy();
    }

    protected final void compress(@NotNull byte[] input, int offset) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        F1600 A = this.state;
        int APos = 0;
        int inputPos = offset;
        int inputLimit = inputPos + this.blockSize();
        while (inputPos < inputLimit) {
            A.addData(APos++, LittleEndian.Companion.bytesToLong(input[inputPos++], input[inputPos++], input[inputPos++], input[inputPos++], input[inputPos++], input[inputPos++], input[inputPos++], input[inputPos++]));
        }
        KeccakPKt.keccakP$default((F1600)A, (byte)0, (int)1, null);
    }

    @NotNull
    protected byte[] digest(long bitLength, int bufferOffset, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer[bufferOffset] = this.dsByte;
        ArraysKt.fill$default((byte[])buffer, (byte)0, (int)(bufferOffset + 1), (int)0, (int)4, null);
        int iLast = ArraysKt.getLastIndex((byte[])buffer);
        buffer[iLast] = (byte)(buffer[iLast] ^ 0xFFFFFF80);
        this.compress(buffer, 0);
        int len = this.digestLength();
        return this.extract(this.state, new byte[len], 0, len, 0L);
    }

    @NotNull
    protected byte[] extract(@NotNull F1600 A, @NotNull byte[] out, int offset, int len, long bytesRead) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int outPos = offset;
        int outLimit = outPos + len;
        int spongeSize = this.blockSize();
        int spongeLimit = spongeSize / 8 + 1;
        int spongeRem = spongeSize - (int)(bytesRead % (long)spongeSize);
        int spongePos = (spongeSize - spongeRem) / 8;
        while (outPos < outLimit) {
            while (spongePos < spongeLimit) {
                int priorRem;
                long lane = A.get(spongePos++);
                int laneOffset = spongeRem < 8 ? 8 - spongeRem : (outPos == offset ? ((priorRem = spongeRem % 8) == 0 ? 0 : 8 - priorRem) : 0);
                int i = 0;
                while (outPos < outLimit && laneOffset + i < 8) {
                    int bits = (laneOffset + i++) * 8;
                    out[outPos++] = (byte)(lane >>> bits);
                }
                if (i == 0) break;
                spongeRem -= i;
            }
            if (spongeRem != 0) continue;
            KeccakPKt.keccakP$default((F1600)A, (byte)0, (int)1, null);
            spongePos = 0;
            spongeRem = spongeSize;
        }
        return out;
    }

    protected void resetDigest() {
        this.state.reset();
    }

    public /* synthetic */ KeccakDigest(String algorithm, int blockSize, int digestLength, byte dsByte, DefaultConstructorMarker $constructor_marker) {
        this(algorithm, blockSize, digestLength, dsByte);
    }

    public /* synthetic */ KeccakDigest(DigestState state, KeccakDigest digest, DefaultConstructorMarker $constructor_marker) {
        this(state, digest);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\b\u0084\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kotlincrypto/hash/sha3/KeccakDigest$Companion;", "", "()V", "KECCAK", "", "PAD_KECCAK", "", "PAD_SHA3", "SHA3", "org.kotlincrypto.hash_sha3_jvm"})
    protected static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

