/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha3;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.xof.Xof;
import org.kotlincrypto.hash.sha3.CSHAKE128;
import org.kotlincrypto.hash.sha3.CSHAKE256;
import org.kotlincrypto.hash.sha3.SHAKEDigest;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB1\b\u0014\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u000f\b\u0014\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0012\u001a\u00020\u0000H&J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0005H\u0004J\t\u0010\u0016\u001a\u00020\u0017H\u0082\bJ\t\u0010\u0018\u001a\u00020\u0017H\u0082\bJ\b\u0010\u0019\u001a\u00020\u0017H\u0004J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J \u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0004R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002 !\u00a8\u0006\""}, d2={"Lorg/kotlincrypto/hash/sha3/ParallelDigest;", "Lorg/kotlincrypto/hash/sha3/SHAKEDigest;", "S", "", "B", "", "xOfMode", "", "bitStrength", "digestLength", "([BIZII)V", "other", "(Lorg/kotlincrypto/hash/sha3/ParallelDigest;)V", "countHi", "countLo", "inner", "innerBlockSize", "innerPos", "copy", "digestProtected", "buf", "bufPos", "incrementCount", "", "processBlock", "resetProtected", "updateProtected", "input", "", "offset", "len", "Companion", "Lorg/kotlincrypto/hash/sha3/ParallelHash128;", "Lorg/kotlincrypto/hash/sha3/ParallelHash256;", "org.kotlincrypto.hash_sha3_jvm"})
@SourceDebugExtension(value={"SMAP\nParallelDigest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParallelDigest.kt\norg/kotlincrypto/hash/sha3/ParallelDigest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SHAKEDigest.kt\norg/kotlincrypto/hash/sha3/SHAKEDigest$Companion\n*L\n1#1,186:1\n180#1:188\n164#1,2:190\n180#1:192\n166#1:193\n164#1,2:194\n180#1:196\n166#1:197\n164#1,2:198\n180#1:200\n166#1:201\n180#1:202\n1#2:187\n243#3:189\n*S KotlinDebug\n*F\n+ 1 ParallelDigest.kt\norg/kotlincrypto/hash/sha3/ParallelDigest\n*L\n89#1:188\n122#1:190,2\n122#1:192\n122#1:193\n141#1:194,2\n141#1:196\n141#1:197\n156#1:198,2\n156#1:200\n156#1:201\n165#1:202\n96#1:189\n*E\n"})
public abstract class ParallelDigest
extends SHAKEDigest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SHAKEDigest inner;
    private final int innerBlockSize;
    private int innerPos;
    private int countLo;
    private int countHi;
    @NotNull
    private static final String PARALLEL_HASH = "ParallelHash";

    private ParallelDigest(byte[] S, int B, boolean xOfMode, int bitStrength, int digestLength) {
        super(StringsKt.encodeToByteArray((String)PARALLEL_HASH), S, xOfMode, PARALLEL_HASH + bitStrength, SHAKEDigest.Companion.blockSizeFromBitStrength$org_kotlincrypto_hash_sha3_jvm(bitStrength), digestLength, null);
        SHAKEDigest sHAKEDigest;
        if (!(B > 0)) {
            boolean bl = false;
            String string = "B must be greater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        switch (bitStrength) {
            case 128: {
                sHAKEDigest = new CSHAKE128(null, null);
                break;
            }
            case 256: {
                sHAKEDigest = new CSHAKE256(null, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("bitStrength must be 128 or 256");
            }
        }
        this.inner = sHAKEDigest;
        this.innerBlockSize = B;
        this.innerPos = 0;
        this.countLo = 0;
        this.countHi = 0;
        byte[] encB = Xof.Utils.leftEncode((int)B);
        super.updateProtected(encB, 0, encB.length);
    }

    private ParallelDigest(ParallelDigest other) {
        super(other, null);
        this.inner = other.inner.copy();
        this.innerBlockSize = other.innerBlockSize;
        this.innerPos = other.innerPos;
        this.countLo = other.countLo;
        this.countHi = other.countHi;
    }

    @Override
    @NotNull
    public abstract ParallelDigest copy();

    @Override
    @NotNull
    protected final byte[] digestProtected(@NotNull byte[] buf, int bufPos) {
        byte[] byArray;
        byte[] byArray2;
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (this.innerPos != 0) {
            this.innerPos = 0;
            ParallelDigest this_$iv = this;
            boolean $i$f$incrementCount = false;
            ++this_$iv.countLo;
            if (this_$iv.countLo == 0) {
                int n = this_$iv.countHi;
                this_$iv.countHi = n + 1;
            }
            byArray2 = this.inner.digest();
        } else {
            byArray2 = new byte[]{};
        }
        byte[] buffered = byArray2;
        SHAKEDigest.Companion $i$f$incrementCount = SHAKEDigest.Companion;
        int $this$rightEncodeBits$iv = this.digestLength();
        boolean $i$f$rightEncodeBits$org_kotlincrypto_hash_sha3_jvm = false;
        byte[] byArray3 = ArraysKt.plus((byte[])ArraysKt.plus((byte[])buffered, (byte[])Xof.Utils.rightEncode((int)this.countLo, (int)this.countHi)), (byte[])Xof.Utils.rightEncode((int)($this$rightEncodeBits$iv << 3), (int)($this$rightEncodeBits$iv >>> 29)));
        int needed = bufPos + byArray3.length;
        if (needed > ArraysKt.getLastIndex((byte[])buf)) {
            int i = buf.length - bufPos;
            ArraysKt.copyInto((byte[])byArray3, (byte[])buf, (int)bufPos, (int)0, (int)i);
            this.compressProtected(buf, 0);
            ArraysKt.fill$default((byte[])buf, (byte)0, (int)(byArray3.length - i + 1), (int)0, (int)4, null);
            ArraysKt.copyInto((byte[])byArray3, (byte[])buf, (int)0, (int)i, (int)byArray3.length);
            byArray = super.digestProtected(buf, needed - buf.length);
        } else {
            ArraysKt.copyInto$default((byte[])byArray3, (byte[])buf, (int)bufPos, (int)0, (int)0, (int)12, null);
            byArray = super.digestProtected(buf, needed);
        }
        return byArray;
    }

    protected final void updateProtected(byte input) {
        this.inner.update(input);
        ++this.innerPos;
        if (this.innerPos != this.innerBlockSize) {
            return;
        }
        ParallelDigest this_$iv = this;
        boolean $i$f$processBlock = false;
        super.updateProtected(this_$iv.inner.digest(), 0, this_$iv.inner.digestLength());
        ParallelDigest this_$iv$iv = this_$iv;
        boolean $i$f$incrementCount = false;
        ++this_$iv$iv.countLo;
        if (this_$iv$iv.countLo == 0) {
            int n = this_$iv$iv.countHi;
            this_$iv$iv.countHi = n + 1;
        }
        this.innerPos = 0;
    }

    protected final void updateProtected(@NotNull byte[] input, int offset, int len) {
        int n;
        boolean $i$f$incrementCount;
        ParallelDigest this_$iv$iv;
        boolean $i$f$processBlock;
        ParallelDigest this_$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int inputPos = offset;
        int inputLimit = inputPos + len;
        int innerPos = this.innerPos;
        if (innerPos > 0) {
            if (innerPos + len < this.innerBlockSize) {
                this.inner.update(input, offset, len);
                this.innerPos = innerPos + len;
                return;
            }
            int needed = this.innerBlockSize - innerPos;
            this.inner.update(input, inputPos, needed);
            this_$iv = this;
            $i$f$processBlock = false;
            super.updateProtected(this_$iv.inner.digest(), 0, this_$iv.inner.digestLength());
            this_$iv$iv = this_$iv;
            $i$f$incrementCount = false;
            ++this_$iv$iv.countLo;
            if (this_$iv$iv.countLo == 0) {
                n = this_$iv$iv.countHi;
                this_$iv$iv.countHi = n + 1;
            }
            innerPos = 0;
            inputPos += needed;
        }
        while (inputPos < inputLimit) {
            int nextPos = inputPos + this.innerBlockSize;
            if (nextPos > inputLimit) {
                innerPos = inputLimit - inputPos;
                this.inner.update(input, inputPos, innerPos);
                break;
            }
            this.inner.update(input, inputPos, this.innerBlockSize);
            this_$iv = this;
            $i$f$processBlock = false;
            super.updateProtected(this_$iv.inner.digest(), 0, this_$iv.inner.digestLength());
            this_$iv$iv = this_$iv;
            $i$f$incrementCount = false;
            ++this_$iv$iv.countLo;
            if (this_$iv$iv.countLo == 0) {
                n = this_$iv$iv.countHi;
                this_$iv$iv.countHi = n + 1;
            }
            inputPos = nextPos;
        }
        this.innerPos = innerPos;
    }

    private final void processBlock() {
        boolean $i$f$processBlock = false;
        super.updateProtected(this.inner.digest(), 0, this.inner.digestLength());
        ParallelDigest this_$iv = this;
        boolean $i$f$incrementCount = false;
        ++this_$iv.countLo;
        if (this_$iv.countLo == 0) {
            int n = this_$iv.countHi;
            this_$iv.countHi = n + 1;
        }
    }

    @Override
    protected final void resetProtected() {
        super.resetProtected();
        this.inner.reset();
        this.innerPos = 0;
        this.countLo = 0;
        this.countHi = 0;
        byte[] encBSize = Xof.Utils.leftEncode((int)this.innerBlockSize);
        super.updateProtected(encBSize, 0, encBSize.length);
    }

    private final void incrementCount() {
        boolean $i$f$incrementCount = false;
        ++this.countLo;
        if (this.countLo == 0) {
            int n = this.countHi;
            this.countHi = n + 1;
        }
    }

    public /* synthetic */ ParallelDigest(byte[] S, int B, boolean xOfMode, int bitStrength, int digestLength, DefaultConstructorMarker $constructor_marker) {
        this(S, B, xOfMode, bitStrength, digestLength);
    }

    public /* synthetic */ ParallelDigest(ParallelDigest other, DefaultConstructorMarker $constructor_marker) {
        this(other);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kotlincrypto/hash/sha3/ParallelDigest$Companion;", "", "()V", "PARALLEL_HASH", "", "org.kotlincrypto.hash_sha3_jvm"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

