/*
 * Decompiled with CFR 0.152.
 */
package org.kotlincrypto.hash.sha3;

import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kotlincrypto.bitops.endian.Endian;
import org.kotlincrypto.core.digest.Digest;
import org.kotlincrypto.sponges.keccak.F1600;
import org.kotlincrypto.sponges.keccak.KeccakPKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 $2\u00020\u0001:\u0002#$B)\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0014\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\fJ\b\u0010\u000f\u001a\u00020\u0000H&J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0004J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0005H\u0004J(\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0005H\u0004J0\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0014J2\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0014J\b\u0010\"\u001a\u00020\u0011H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\t%&'()*+,-\u00a8\u0006."}, d2={"Lorg/kotlincrypto/hash/sha3/KeccakDigest;", "Lorg/kotlincrypto/core/digest/Digest;", "algorithm", "", "blockSize", "", "digestLength", "dsByte", "", "<init>", "(Ljava/lang/String;IIB)V", "other", "(Lorg/kotlincrypto/hash/sha3/KeccakDigest;)V", "state", "Lorg/kotlincrypto/sponges/keccak/F1600;", "copy", "compressProtected", "", "input", "", "offset", "digestProtected", "buf", "bufPos", "digestIntoProtected", "dest", "destOffset", "finalizeAndExtractTo", "len", "extract", "A", "r", "Lorg/kotlincrypto/hash/sha3/KeccakDigest$SpongeRemainder;", "out", "resetProtected", "SpongeRemainder", "Companion", "Lorg/kotlincrypto/hash/sha3/Keccak224;", "Lorg/kotlincrypto/hash/sha3/Keccak256;", "Lorg/kotlincrypto/hash/sha3/Keccak384;", "Lorg/kotlincrypto/hash/sha3/Keccak512;", "Lorg/kotlincrypto/hash/sha3/SHA3_224;", "Lorg/kotlincrypto/hash/sha3/SHA3_256;", "Lorg/kotlincrypto/hash/sha3/SHA3_384;", "Lorg/kotlincrypto/hash/sha3/SHA3_512;", "Lorg/kotlincrypto/hash/sha3/SHAKEDigest;", "org.kotlincrypto.hash_sha3_jvm"})
@SourceDebugExtension(value={"SMAP\nKeccakDigest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeccakDigest.kt\norg/kotlincrypto/hash/sha3/KeccakDigest\n+ 2 Endian.kt\norg/kotlincrypto/bitops/endian/Endian$Little\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n2097#2:202\n1#3:203\n*S KotlinDebug\n*F\n+ 1 KeccakDigest.kt\norg/kotlincrypto/hash/sha3/KeccakDigest\n*L\n78#1:202\n*E\n"})
public abstract class KeccakDigest
extends Digest {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    private final byte dsByte;
    @NotNull
    private final F1600 state;
    @NotNull
    public static final String KECCAK = "Keccak";
    @NotNull
    public static final String SHA3 = "SHA3";
    public static final byte PAD_KECCAK = 1;
    public static final byte PAD_SHA3 = 6;

    private KeccakDigest(String algorithm, int blockSize, int digestLength, byte dsByte) throws InvalidParameterException {
        super(algorithm, blockSize, digestLength);
        this.dsByte = dsByte;
        this.state = new F1600();
    }

    private KeccakDigest(KeccakDigest other) {
        super((Digest)other);
        this.dsByte = other.dsByte;
        this.state = other.state.copy();
    }

    @NotNull
    public abstract KeccakDigest copy();

    protected final void compressProtected(@NotNull byte[] input, int offset) {
        int inputPos;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        F1600 A = this.state;
        int APos = 0;
        int inputLimit = inputPos + this.blockSize();
        for (inputPos = offset; inputPos < inputLimit; inputPos += 8) {
            int n = APos++;
            byte[] $this$leLongAt$iv = input;
            boolean $i$f$leLongAt = false;
            A.addData(n, Endian.Little.INSTANCE.longFrom($this$leLongAt$iv, inputPos));
        }
        KeccakPKt.keccakP$default((F1600)A, (byte)0, (int)1, null);
    }

    @NotNull
    protected final byte[] digestProtected(@NotNull byte[] buf, int bufPos) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int len = this.digestLength();
        return this.finalizeAndExtractTo(new byte[len], 0, buf, bufPos, len);
    }

    protected final void digestIntoProtected(@NotNull byte[] dest, int destOffset, @NotNull byte[] buf, int bufPos) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.finalizeAndExtractTo(dest, destOffset, buf, bufPos, this.digestLength());
    }

    @NotNull
    protected byte[] finalizeAndExtractTo(@NotNull byte[] dest, int destOffset, @NotNull byte[] buf, int bufPos, int len) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf[bufPos] = this.dsByte;
        int iLast = ArraysKt.getLastIndex((byte[])buf);
        buf[iLast] = (byte)(buf[iLast] ^ 0xFFFFFF80);
        this.compressProtected(buf, 0);
        return this.extract(this.state, null, dest, destOffset, len);
    }

    @NotNull
    protected byte[] extract(@NotNull F1600 A, @Nullable SpongeRemainder r, @NotNull byte[] out, int offset, int len) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)A, (String)"A");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int outPos = offset;
            int outLimit = outPos + len;
            int spongeSize = this.blockSize();
            int spongeLimit = spongeSize / 8 + 1;
            int spongeRem = 0;
            SpongeRemainder spongeRemainder = r;
            spongeRem = spongeRemainder != null ? spongeRemainder.value : spongeSize;
            int spongePos = (spongeSize - spongeRem) / 8;
            while (outPos < outLimit) {
                while (spongePos < spongeLimit) {
                    int priorRem;
                    long lane = A.get(spongePos++);
                    int laneOffset = spongeRem < 8 ? 8 - spongeRem : (outPos == offset ? ((priorRem = spongeRem % 8) == 0 ? 0 : 8 - priorRem) : 0);
                    int i = 0;
                    while (outPos < outLimit && laneOffset + i < 8) {
                        int bits = 8 * (laneOffset + i++);
                        out[outPos++] = (byte)(lane >>> bits);
                    }
                    if (i == 0) break;
                    spongeRem -= i;
                }
                if (spongeRem != 0) continue;
                KeccakPKt.keccakP$default((F1600)A, (byte)0, (int)1, null);
                spongePos = 0;
                spongeRem = spongeSize;
            }
            SpongeRemainder spongeRemainder2 = r;
            if (spongeRemainder2 == null) break block3;
            SpongeRemainder it = spongeRemainder2;
            boolean bl = false;
            it.value = spongeRem;
        }
        return out;
    }

    protected void resetProtected() {
        this.state.reset();
    }

    public /* synthetic */ KeccakDigest(String algorithm, int blockSize, int digestLength, byte dsByte, DefaultConstructorMarker $constructor_marker) {
        this(algorithm, blockSize, digestLength, dsByte);
    }

    public /* synthetic */ KeccakDigest(KeccakDigest other, DefaultConstructorMarker $constructor_marker) {
        this(other);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0084\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/kotlincrypto/hash/sha3/KeccakDigest$Companion;", "", "<init>", "()V", "KECCAK", "", "SHA3", "PAD_KECCAK", "", "PAD_SHA3", "org.kotlincrypto.hash_sha3_jvm"})
    protected static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kotlincrypto/hash/sha3/KeccakDigest$SpongeRemainder;", "", "d", "Lorg/kotlincrypto/hash/sha3/KeccakDigest;", "<init>", "(Lorg/kotlincrypto/hash/sha3/KeccakDigest;)V", "value", "", "org.kotlincrypto.hash_sha3_jvm"})
    protected static final class SpongeRemainder {
        @JvmField
        public int value;

        public SpongeRemainder(@NotNull KeccakDigest d) {
            Intrinsics.checkNotNullParameter((Object)((Object)d), (String)"d");
            this.value = d.blockSize();
        }
    }
}

