/*
 * Copyright (c) 2023 Matthew Nelson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/
package org.kotlincrypto.hash.sha3

import kotlin.test.Test
import org.kotlincrypto.core.Digest
import org.kotlincrypto.hash.DigestUnitTest

open class Keccak512UnitTest: DigestUnitTest() {
    override val digest: Digest = Keccak512()
    final override val expectedResetHash: String = "0eab42de4c3ceb9235fc91acffe746b29c29a8c366b7c60e4e67c466f36a4304c00fa9caf9d87976ba469bcbe06713b435f091ef2769fb160cdab33d3670680e"
    final override val expectedMultiBlockHash: String = "1b754964c676835605b427de53e88fb0051343f839467ed4581b5c33cc2b929534d5a8a09caced753e3dfbecacf1591ba012340064b402699089e58fc1be3ef4"
    final override val expectedUpdateSmallHash: String = "b9796be8d17dd0462312a5fdaa14cbc3553f2881be79c4e0ee36ee7af32836e1daea9b8b97896fef67679e0106e121fda16611707fe8de3c9008188ecbd1640d"
    final override val expectedUpdateMediumHash: String = "00b9eb87c814240a661c432680aa3b2d33f7d249acd54dd52b63503e746b2e510e7f529f14acf9b25863895228e12f64f721836adbaa1b6b9d088b639aca7225"

    @Test
    final override fun givenDigest_whenReset_thenDigestDigestReturnsExpected() {
        super.givenDigest_whenReset_thenDigestDigestReturnsExpected()
    }

    @Test
    final override fun givenDigest_whenMultiBlockDigest_thenDigestDigestReturnsExpected() {
        super.givenDigest_whenMultiBlockDigest_thenDigestDigestReturnsExpected()
    }

    @Test
    final override fun givenDigest_whenUpdatedSmall_thenDigestDigestReturnsExpected() {
        super.givenDigest_whenUpdatedSmall_thenDigestDigestReturnsExpected()
    }

    @Test
    final override fun givenDigest_whenUpdatedMedium_thenDigestDigestReturnsExpected() {
        super.givenDigest_whenUpdatedMedium_thenDigestDigestReturnsExpected()
    }

    @Test
    final override fun givenDigest_whenCopied_thenIsDifferentInstance() {
        super.givenDigest_whenCopied_thenIsDifferentInstance()
    }

    @Test
    final override fun givenDigest_whenDigested_thenLengthMatchesOutput() {
        super.givenDigest_whenDigested_thenLengthMatchesOutput()
    }

}
