/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.jobscheduler;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;
import org.aeonbits.owner.ConfigCache;
import org.kquiet.browser.ActionComposer;
import org.kquiet.concurrent.PausableThreadPoolExecutor;
import org.kquiet.jobscheduler.JobController;
import org.kquiet.jobscheduler.SystemConfig;
import org.kquiet.jobscheduler.util.TimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobBase
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobBase.class);
    private final SystemConfig systemConfig = (SystemConfig)ConfigCache.getOrCreate(SystemConfig.class, (Map[])new Map[0]);
    private volatile JobController controller = null;
    private final String jobName;
    private final PausableThreadPoolExecutor eventExecutor;
    private volatile boolean isPaused = false;

    public JobBase() {
        this(UUID.randomUUID().toString());
    }

    public JobBase(String jobName) {
        this.jobName = jobName;
        this.eventExecutor = new PausableThreadPoolExecutor("EventExecutor-" + jobName, 1, 1);
    }

    public final JobBase setJobController(JobController ctrl) {
        this.controller = ctrl;
        return this;
    }

    @Override
    public abstract void run();

    protected boolean pause() {
        if (this.isPaused) {
            return false;
        }
        this.isPaused = true;
        return true;
    }

    protected boolean isPaused() {
        return this.isPaused;
    }

    protected boolean resume() {
        if (!this.isPaused) {
            return false;
        }
        this.isPaused = false;
        return true;
    }

    public final LocalDateTime calculateNextFireDateTime(LocalDateTime from) {
        return TimeUtility.calculateNextFireDateTime(this.getTimerConfig().start().get(), this.getTimerConfig().end().get(), this.getTimerConfig().dailyStart().get(), this.getTimerConfig().dailyEnd().get(), from);
    }

    public final void raiseEvent(Object event) {
        if (event == null) {
            return;
        }
        this.controller.forwardEvent(this, event);
    }

    public final void receiveEvent(Object event) {
        if (event == null) {
            return;
        }
        this.eventExecutor.submit(() -> {
            try {
                this.onEvent(event);
            }
            catch (Exception ex) {
                LOGGER.error("[{}] process event error:{}", new Object[]{"EventExecutor-" + this.jobName, event, ex});
            }
        });
    }

    protected void onEvent(Object event) {
        if (event == null) {
            return;
        }
        LOGGER.info("event bypassed:{}", event);
    }

    public final String getInstanceName() {
        return this.systemConfig.instanceName();
    }

    public final SystemConfig.JobConfig getTimerConfig() {
        return this.systemConfig.jobs().get(this.getJobName());
    }

    public final String getParameter(String name) {
        Map<String, String> parameter = this.getTimerConfig().parameter();
        if (parameter != null) {
            return parameter.get(name);
        }
        return null;
    }

    protected final void restartInternalBrowser() {
        if (this.controller != null) {
            this.controller.restartBrowserTaskManager();
        }
    }

    protected final void pauseInternalBrowser() {
        if (this.controller != null) {
            this.controller.pause(JobController.PauseTarget.Browser);
        }
    }

    protected final void resumeInternalBrowser() {
        if (this.controller != null) {
            this.controller.resume(JobController.PauseTarget.Browser);
        }
    }

    protected final boolean registerInternalBrowserTask(ActionComposer task) {
        if (this.controller != null) {
            return this.controller.acceptBrowserTask(task);
        }
        throw new RuntimeException("No assocaited job controller available");
    }

    protected final void awaitInteraction() {
        if (this.controller == null) {
            throw new RuntimeException("No assocaited job controller available");
        }
        this.controller.awaitInteraction();
    }

    protected final JobController.InteractionType getLatestInteraction() {
        if (this.controller != null) {
            return this.controller.getLatestInteraction();
        }
        throw new RuntimeException("No assocaited job controller available");
    }

    public final String getJobName() {
        return this.jobName;
    }
}

