/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.jobscheduler;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.LoggerContext;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.aeonbits.owner.ConfigCache;
import org.kquiet.concurrent.PausableScheduledThreadPoolExecutor;
import org.kquiet.jobscheduler.JobController;
import org.kquiet.jobscheduler.SystemConfig;
import org.kquiet.jobscheduler.util.JTextAreaLogAppender;
import org.kquiet.jobscheduler.util.TimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorFrame.class);
    private final LocalDateTime initTime = LocalDateTime.now();
    private SystemConfig configInfo = null;
    private transient JobController controller = null;
    private transient PausableScheduledThreadPoolExecutor timerExecutor = null;
    private JButton jbuttonCancel;
    private JButton jbuttonPositive;
    private JMenuBar jmenuBarMain;
    private JMenu jmenuClear;
    private JMenu jmenuPauseJobExecutor;
    private JPanel jpanelMisc;
    private JScrollPane jscrollPaneDebugLog;
    private JScrollPane jscrollPaneErrorLog;
    private JScrollPane jscrollPaneInfoLog;
    private JScrollPane jscrollPaneMisc;
    private JScrollPane jscrollPaneMiscText;
    private JTabbedPane jtabbedPaneMain;
    private JTextArea jtextAreaDebugLog;
    private JTextArea jtextAreaErrorLog;
    private JTextArea jtextAreaInfoLog;
    private JTextArea jtextAreaMisc;
    private GridBagConstraints gridBagConstraints2;
    private JMenu jmenuPauseBrowser;

    public MonitorFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.jtabbedPaneMain = new JTabbedPane();
        this.jscrollPaneInfoLog = new JScrollPane();
        this.jtextAreaInfoLog = new JTextArea();
        this.jscrollPaneErrorLog = new JScrollPane();
        this.jtextAreaErrorLog = new JTextArea();
        this.jscrollPaneDebugLog = new JScrollPane();
        this.jtextAreaDebugLog = new JTextArea();
        this.jscrollPaneMisc = new JScrollPane();
        this.jpanelMisc = new JPanel();
        this.jscrollPaneMiscText = new JScrollPane();
        this.jtextAreaMisc = new JTextArea();
        this.jbuttonCancel = new JButton();
        this.jmenuBarMain = new JMenuBar();
        this.jmenuPauseJobExecutor = new JMenu();
        this.jmenuClear = new JMenu();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MonitorFrame.this.formWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                MonitorFrame.this.formWindowOpened(evt);
            }
        });
        this.jtextAreaInfoLog.setColumns(20);
        this.jtextAreaInfoLog.setRows(5);
        this.jscrollPaneInfoLog.setViewportView(this.jtextAreaInfoLog);
        this.jtabbedPaneMain.addTab("InfoLog", this.jscrollPaneInfoLog);
        this.jtextAreaErrorLog.setColumns(20);
        this.jtextAreaErrorLog.setRows(5);
        this.jscrollPaneErrorLog.setViewportView(this.jtextAreaErrorLog);
        this.jtabbedPaneMain.addTab("ErrorLog", this.jscrollPaneErrorLog);
        this.jtextAreaDebugLog.setColumns(20);
        this.jtextAreaDebugLog.setRows(5);
        this.jscrollPaneDebugLog.setViewportView(this.jtextAreaDebugLog);
        this.jtabbedPaneMain.addTab("DebugLog", this.jscrollPaneDebugLog);
        this.jpanelMisc.setLayout(new GridBagLayout());
        this.jbuttonPositive = new JButton();
        this.jbuttonPositive.setText("Positive");
        this.jbuttonPositive.setEnabled(false);
        this.jbuttonPositive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorFrame.this.jbuttonSubmitActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.jpanelMisc.add((Component)this.jbuttonPositive, gridBagConstraints);
        this.jtextAreaMisc.setColumns(20);
        this.jtextAreaMisc.setRows(5);
        this.jscrollPaneMiscText.setViewportView(this.jtextAreaMisc);
        this.gridBagConstraints2 = new GridBagConstraints();
        this.gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        this.gridBagConstraints2.gridx = 0;
        this.gridBagConstraints2.gridy = 1;
        this.gridBagConstraints2.fill = 1;
        this.gridBagConstraints2.weightx = 1.0;
        this.gridBagConstraints2.weighty = 1.0;
        this.jpanelMisc.add((Component)this.jscrollPaneMiscText, this.gridBagConstraints2);
        this.jbuttonCancel.setText("Negative");
        this.jbuttonCancel.setEnabled(false);
        this.jbuttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorFrame.this.jbuttonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jpanelMisc.add((Component)this.jbuttonCancel, gridBagConstraints);
        this.jscrollPaneMisc.setViewportView(this.jpanelMisc);
        this.jtabbedPaneMain.addTab("Misc.", this.jscrollPaneMisc);
        this.jmenuPauseJobExecutor.setText("PauseJobExecutor");
        this.jmenuPauseJobExecutor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (MonitorFrame.this.controller.isPaused(JobController.PauseTarget.JobExecutor)) {
                    MonitorFrame.this.changePageStatus(PageStatus.JobExecutorResumed);
                } else {
                    MonitorFrame.this.changePageStatus(PageStatus.JobExecutorPaused);
                }
            }
        });
        this.jmenuBarMain.add(this.jmenuPauseJobExecutor);
        this.jmenuClear.setText("Clear");
        this.jmenuClear.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    SwingUtilities.invokeLater(() -> {
                        MonitorFrame.this.jtextAreaInfoLog.setText(null);
                        MonitorFrame.this.jtextAreaErrorLog.setText(null);
                        MonitorFrame.this.jtextAreaDebugLog.setText(null);
                        MonitorFrame.this.jtextAreaMisc.setText(null);
                    });
                    LOGGER.info("[GUI] JTextArea log cleared");
                }
                catch (Exception ex) {
                    LOGGER.error("[GUI] clear JTextArea log fail", (Throwable)ex);
                }
            }
        });
        this.jmenuPauseBrowser = new JMenu("PauseBrowser");
        this.jmenuPauseBrowser.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MonitorFrame.this.controller.isPaused(JobController.PauseTarget.Browser)) {
                    MonitorFrame.this.changePageStatus(PageStatus.BrowserResumed);
                } else {
                    MonitorFrame.this.changePageStatus(PageStatus.BrowserPaused);
                }
            }
        });
        this.jmenuBarMain.add(this.jmenuPauseBrowser);
        this.jmenuBarMain.add(this.jmenuClear);
        this.setJMenuBar(this.jmenuBarMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jtabbedPaneMain, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jtabbedPaneMain, -1, 279, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        SwingUtilities.invokeLater(() -> this.customInit());
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
        this.releaseResources();
    }

    private void jbuttonSubmitActionPerformed(ActionEvent evt) {
        this.jbuttonPositive.setEnabled(false);
        this.jbuttonCancel.setEnabled(false);
        this.controller.signalInteractionType(JobController.InteractionType.Positive);
    }

    private void jbuttonCancelActionPerformed(ActionEvent evt) {
        this.jbuttonCancel.setEnabled(false);
        this.jbuttonPositive.setEnabled(false);
        this.controller.signalInteractionType(JobController.InteractionType.Negative);
    }

    private void changePageStatus(PageStatus newStatus) {
        switch (newStatus) {
            default: {
                break;
            }
            case JobExecutorResumed: {
                SwingUtilities.invokeLater(() -> {
                    if (this.controller.isPaused(JobController.PauseTarget.JobExecutor)) {
                        this.controller.resume(JobController.PauseTarget.JobExecutor);
                        this.jmenuPauseJobExecutor.setText("PauseJobExecutor");
                    }
                });
                break;
            }
            case JobExecutorPaused: {
                SwingUtilities.invokeLater(() -> {
                    if (!this.controller.isPaused(JobController.PauseTarget.JobExecutor)) {
                        this.controller.pause(JobController.PauseTarget.JobExecutor);
                        this.jmenuPauseJobExecutor.setText("ResumeJobExecutor");
                    }
                });
                break;
            }
            case BrowserResumed: {
                SwingUtilities.invokeLater(() -> {
                    if (this.controller.isPaused(JobController.PauseTarget.Browser)) {
                        this.controller.resume(JobController.PauseTarget.Browser);
                        this.jmenuPauseBrowser.setText("PauseBowser");
                    }
                });
                break;
            }
            case BrowserPaused: {
                SwingUtilities.invokeLater(() -> {
                    if (!this.controller.isPaused(JobController.PauseTarget.Browser)) {
                        this.controller.pause(JobController.PauseTarget.Browser);
                        this.jmenuPauseBrowser.setText("ResumeBowser");
                    }
                });
            }
        }
    }

    public void releaseResources() {
        try {
            LOGGER.info("[GUI] Releasing all resources...");
            this.controller.stop();
            this.timerExecutor.shutdown();
            LOGGER.info("[GUI] All resources released");
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        finally {
            this.configInfo = null;
            this.controller = null;
        }
    }

    private void refreshTitle(String extra) {
        try {
            String title = String.format("JobScheduler(%s-%s)_%s", this.configInfo.instanceName(), this.getClass().getPackage().getImplementationVersion(), extra);
            String since = ", since " + TimeUtility.toStr(this.initTime, "yyyy-MM-dd HH:mm:ss");
            SwingUtilities.invokeLater(() -> this.setTitle(title + since));
        }
        catch (Exception ex) {
            LOGGER.error("[GUI] set frame title error", (Throwable)ex);
        }
    }

    private static void setJTextAreaLogAppender(String appenderName, JTextArea textArea) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.getLoggerList().stream().map(logger -> (AsyncAppender)logger.getAppender(appenderName)).filter(asyncAppender -> asyncAppender != null).forEachOrdered(asyncAppender -> asyncAppender.iteratorForAppenders().forEachRemaining(f -> ((JTextAreaLogAppender)((Object)((Object)f))).setTextArea(textArea)));
    }

    private void customInit() {
        this.configInfo = (SystemConfig)ConfigCache.getOrCreate(SystemConfig.class, (Map[])new Map[0]);
        MonitorFrame.setJTextAreaLogAppender("asyncJTextAreaError", this.jtextAreaErrorLog);
        MonitorFrame.setJTextAreaLogAppender("asyncJTextAreaInfo", this.jtextAreaInfoLog);
        MonitorFrame.setJTextAreaLogAppender("asyncJTextAreaDebug", this.jtextAreaDebugLog);
        this.refreshTitle("");
        this.setExtendedState(6);
        this.controller = new JobController();
        this.controller.setExecutingJobDescriptionConsumer(s -> this.refreshTitle((String)s));
        this.controller.setPreInteractionFunction(() -> SwingUtilities.invokeLater(() -> {
            this.jbuttonPositive.setEnabled(true);
            this.jbuttonCancel.setEnabled(true);
            this.jtabbedPaneMain.setSelectedIndex(this.jtabbedPaneMain.getTabCount() - 1);
        }));
        this.controller.setAfterPauseFunction(JobController.PauseTarget.Browser, () -> SwingUtilities.invokeLater(() -> this.jmenuPauseBrowser.setText("ResumeBrowser")));
        this.controller.setAfterResumeFunction(JobController.PauseTarget.Browser, () -> SwingUtilities.invokeLater(() -> this.jmenuPauseBrowser.setText("PauseBrowser")));
        this.controller.setAfterPauseFunction(JobController.PauseTarget.JobExecutor, () -> SwingUtilities.invokeLater(() -> this.jmenuPauseJobExecutor.setText("ResumeJobExecutor")));
        this.controller.setAfterResumeFunction(JobController.PauseTarget.JobExecutor, () -> SwingUtilities.invokeLater(() -> this.jmenuPauseJobExecutor.setText("PauseJobExecutor")));
        this.controller.start();
        this.timerExecutor = new PausableScheduledThreadPoolExecutor("FrameTimerExecutor", 1);
        this.timerExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.timerExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        int logClearInterval = this.configInfo.clearLogInterval();
        this.timerExecutor.scheduleWithFixedDelay(() -> {
            SwingUtilities.invokeLater(() -> {
                this.jtextAreaInfoLog.setText(null);
                this.jtextAreaErrorLog.setText(null);
                this.jtextAreaDebugLog.setText(null);
                this.jtextAreaMisc.setText(null);
            });
            LOGGER.info("[GUI] clearn JTextAreaLog every {} seconds", (Object)logClearInterval);
        }, (long)logClearInterval, (long)logClearInterval, TimeUnit.SECONDS);
    }

    public String ping() {
        int index;
        String fullLog = this.jtextAreaInfoLog.getText();
        if (fullLog.endsWith(System.lineSeparator())) {
            fullLog = fullLog.substring(0, fullLog.length() - System.lineSeparator().length());
        }
        if ((index = fullLog.lastIndexOf(System.lineSeparator())) >= 0) {
            return fullLog.substring(index);
        }
        return fullLog;
    }

    private static enum PageStatus {
        Running,
        JobExecutorPaused,
        JobExecutorResumed,
        BrowserPaused,
        BrowserResumed;

    }
}

