/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.jobscheduler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;
import org.aeonbits.owner.Converter;
import org.aeonbits.owner.Reloadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Config.HotReload(value=10L, unit=TimeUnit.SECONDS, type=Config.HotReloadType.ASYNC)
@Config.Sources(value={"file:jobscheduler.config", "classpath:jobscheduler.config"})
@Config.LoadPolicy(value=Config.LoadType.FIRST)
public interface SystemConfig
extends Reloadable {
    @Config.Key(value="gui.enable")
    @Config.DefaultValue(value="false")
    public boolean guiFlag();

    @Config.Key(value="instanceName")
    @Config.DefaultValue(value="")
    public String instanceName();

    @Config.Key(value="browser.type")
    @Config.DefaultValue(value="")
    public String browserType();

    @Config.Key(value="browser.headless")
    @Config.DefaultValue(value="true")
    public boolean headlessBrowser();

    @Config.Key(value="gui.clearLogInterval")
    @Config.DefaultValue(value="86400")
    public int clearLogInterval();

    @Config.Key(value="job.parallelism")
    @Config.DefaultValue(value="1")
    public int jobParallelism();

    @Config.ConverterClass(value=JobListConverter.class)
    @Config.Key(value="job.enable")
    @Config.DefaultValue(value="")
    public Map<String, JobConfig> jobs();

    public static class JobParameterConverter
    implements Converter<Map<String, String>> {
        public Map<String, String> convert(Method method, String input) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                if (input == null || input.isEmpty()) {
                    return new LinkedHashMap<String, String>();
                }
                Map parameterMap = (Map)mapper.readValue(input, (TypeReference)new TypeReference<Map<String, String>>(){});
                return parameterMap;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class JobListConverter
    implements Converter<Map<String, JobConfig>> {
        public Map<String, JobConfig> convert(Method method, String input) {
            LinkedHashMap<String, JobConfig> jobList = new LinkedHashMap<String, JobConfig>();
            if (input != null) {
                List nameList = Arrays.asList(input.split(",")).stream().map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                for (String name : nameList) {
                    HashMap<String, String> imports = new HashMap<String, String>();
                    imports.put("jobName", name);
                    JobConfig config = (JobConfig)ConfigFactory.create(JobConfig.class, (Map[])new Map[]{imports});
                    jobList.put(name, config);
                }
            }
            return jobList;
        }
    }

    public static class OptionalLocalTimeConverter
    implements Converter<Optional<LocalTime>> {
        public Optional<LocalTime> convert(Method method, String input) {
            Logger logger = LoggerFactory.getLogger(SystemConfig.class);
            try {
                return Optional.of(LocalTime.parse(input));
            }
            catch (Exception ex) {
                logger.error("Error config:{}", (Object)input);
                return Optional.ofNullable(null);
            }
        }
    }

    public static class OptionalEndLocalDateTimeConverter
    implements Converter<Optional<LocalDateTime>> {
        public Optional<LocalDateTime> convert(Method method, String input) {
            Logger logger = LoggerFactory.getLogger(SystemConfig.class);
            try {
                if (Optional.ofNullable(input).orElse("").trim().isEmpty()) {
                    return Optional.of(LocalDateTime.MAX);
                }
                return Optional.of(LocalDateTime.parse(input));
            }
            catch (Exception ex) {
                logger.error("Error config:{}", (Object)input);
                return Optional.ofNullable(null);
            }
        }
    }

    public static class OptionalStartLocalDateTimeConverter
    implements Converter<Optional<LocalDateTime>> {
        public Optional<LocalDateTime> convert(Method method, String input) {
            Logger logger = LoggerFactory.getLogger(SystemConfig.class);
            try {
                if (Optional.ofNullable(input).orElse("").trim().isEmpty()) {
                    return Optional.of(LocalDateTime.parse("1900-01-01T00:00:00"));
                }
                return Optional.of(LocalDateTime.parse(input));
            }
            catch (Exception ex) {
                logger.error("Error config:{}", (Object)input);
                return Optional.ofNullable(null);
            }
        }
    }

    public static class BooleanConverter
    implements Converter<Boolean> {
        public Boolean convert(Method method, String input) {
            return Boolean.valueOf(input);
        }
    }

    @Config.Sources(value={"file:jobscheduler.config", "classpath:jobscheduler.config"})
    @Config.LoadPolicy(value=Config.LoadType.FIRST)
    public static interface JobConfig
    extends Reloadable {
        @Config.Key(value="job.${jobName}.impl")
        public String implementName();

        @Config.ConverterClass(value=OptionalStartLocalDateTimeConverter.class)
        @Config.Key(value="job.${jobName}.start")
        @Config.DefaultValue(value="")
        public Optional<LocalDateTime> start();

        @Config.ConverterClass(value=OptionalEndLocalDateTimeConverter.class)
        @Config.Key(value="job.${jobName}.end")
        @Config.DefaultValue(value="")
        public Optional<LocalDateTime> end();

        @Config.ConverterClass(value=OptionalLocalTimeConverter.class)
        @Config.Key(value="job.${jobName}.dailyStart")
        public Optional<LocalTime> dailyStart();

        @Config.ConverterClass(value=OptionalLocalTimeConverter.class)
        @Config.Key(value="job.${jobName}.dailyEnd")
        public Optional<LocalTime> dailyEnd();

        @Config.Key(value="job.${jobName}.interval")
        public int interval();

        @Config.ConverterClass(value=BooleanConverter.class)
        @Config.Key(value="job.${jobName}.scheduleAfterExec")
        public boolean scheduleAfterExec();

        @Config.ConverterClass(value=JobParameterConverter.class)
        @Config.Key(value="job.${jobName}.parameter")
        @Config.DefaultValue(value="{}")
        public Map<String, String> parameter();
    }
}

