/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.jobscheduler.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public final class TimeUtility {
    private TimeUtility() {
    }

    public static String nowStr(String format) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
    }

    public static String utcNowStr(String format) {
        return LocalDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(format));
    }

    public static String toStr(LocalDateTime dateTime, String format) {
        if (dateTime == null) {
            return "";
        }
        return dateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static String toStr(ZonedDateTime zonedDateTime, String format) {
        if (zonedDateTime == null) {
            return "";
        }
        return zonedDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static String toStr(LocalDate date, String format) {
        if (date == null) {
            return "";
        }
        return date.format(DateTimeFormatter.ofPattern(format));
    }

    public static String toStr(LocalTime time, String format) {
        if (time == null) {
            return "";
        }
        return time.format(DateTimeFormatter.ofPattern(format));
    }

    public static boolean isBetween(LocalDateTime start, LocalDateTime end, LocalDateTime dateTime) {
        if (start.isAfter(end)) {
            return false;
        }
        return !dateTime.isBefore(start) && !dateTime.isAfter(end);
    }

    public static boolean isBetween(LocalTime start, LocalTime end, LocalTime time) {
        if (start.equals(end)) {
            return true;
        }
        if (start.isAfter(end)) {
            return !time.isBefore(start) || !time.isAfter(end);
        }
        return !time.isBefore(start) && !time.isAfter(end);
    }

    public static LocalDateTime calculateNextFireDateTime(LocalDateTime start, LocalDateTime end, LocalTime dailyStart, LocalTime dailyEnd, LocalDateTime from) {
        if (start.isAfter(end) || from.isAfter(end)) {
            return null;
        }
        if (from.isBefore(start)) {
            from = start;
        }
        LocalDate startDate = from.toLocalDate();
        LocalTime startTime = from.toLocalTime();
        LocalDateTime candidate = null;
        candidate = dailyStart.equals(dailyEnd) ? from : (dailyStart.isAfter(dailyEnd) ? (startTime.isBefore(dailyStart) && startTime.isAfter(dailyEnd) ? LocalDateTime.of(startDate, dailyStart) : from) : (!startTime.isBefore(dailyStart) && !startTime.isAfter(dailyEnd) ? from : (startTime.isBefore(dailyStart) ? LocalDateTime.of(startDate, dailyStart) : LocalDateTime.of(startDate.plusDays(1L), dailyStart))));
        if (candidate.isAfter(end)) {
            return null;
        }
        return candidate;
    }
}

