/*
 * Decompiled with CFR 0.152.
 */
package org.kquiet.jobscheduler;

import java.lang.reflect.Constructor;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.aeonbits.owner.ConfigCache;
import org.kquiet.browser.ActionComposer;
import org.kquiet.browser.ActionRunner;
import org.kquiet.browser.BasicActionRunner;
import org.kquiet.browser.BrowserType;
import org.kquiet.concurrent.PausableScheduledThreadPoolExecutor;
import org.kquiet.jobscheduler.JobBase;
import org.kquiet.jobscheduler.SystemConfig;
import org.kquiet.jobscheduler.util.TimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobController {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobController.class);
    private final SystemConfig configInfo = (SystemConfig)ConfigCache.getOrCreate(SystemConfig.class, (Map[])new Map[0]);
    private volatile ActionRunner browserAgent;
    private final Phaser interactionPhaser;
    private volatile InteractionType latestInteractionType;
    private volatile Runnable preInteractionFunc;
    private volatile Runnable postInteractionFunc;
    private final PausableScheduledThreadPoolExecutor jobExecutor;
    private final Map<PauseTarget, PauseConfig> pauseConfigMap = new HashMap<PauseTarget, PauseConfig>();
    private final List<JobBase> scheduleJobList = new ArrayList<JobBase>();
    private final Map<String, ScheduledFuture<?>> scheduledTask = new LinkedHashMap();
    private volatile boolean scheduled = false;
    private volatile Consumer<String> executingJobDescriptionConsumer = null;

    public JobController() {
        this.browserAgent = this.createNewActionRunner();
        int parallelism = this.configInfo.jobParallelism();
        this.jobExecutor = new PausableScheduledThreadPoolExecutor("CtrlJobExecutor", parallelism);
        this.jobExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.jobExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.jobExecutor.setRemoveOnCancelPolicy(true);
        this.interactionPhaser = new Phaser(1);
        LOGGER.info("[Ctrl] Job Parallelism:{}", (Object)parallelism);
        this.pauseConfigMap.put(PauseTarget.Browser, new PauseConfig());
        this.pauseConfigMap.put(PauseTarget.JobExecutor, new PauseConfig());
    }

    private void scheduleJobs(Iterable<JobBase> jobs) {
        Iterable<JobBase> jobIterator = jobs == null ? this.getConfigJobs() : jobs;
        LocalDateTime now = LocalDateTime.now();
        for (JobBase impl : jobIterator) {
            if (!this.scheduledTask.containsKey(impl.getJobName())) {
                SystemConfig.JobConfig config = impl.getTimerConfig();
                long interval = config.interval();
                LocalDateTime initDateTime = impl.calculateNextFireDateTime(now);
                if (initDateTime != null) {
                    long initialDelay = ChronoUnit.MILLIS.between(now, initDateTime);
                    Runnable toRun = this.compileJob(impl, interval);
                    if (config.scheduleAfterExec()) {
                        this.scheduledTask.put(impl.getJobName(), this.jobExecutor.scheduleWithFixedDelay(toRun, initialDelay, interval * 1000L, TimeUnit.MILLISECONDS));
                    } else {
                        this.scheduledTask.put(impl.getJobName(), this.jobExecutor.scheduleAtFixedRate(toRun, initialDelay, interval * 1000L, TimeUnit.MILLISECONDS));
                    }
                    this.scheduleJobList.add(impl);
                    LOGGER.info("[Ctrl] Job {}({}) scheduled with fixed {}({}), first execution will be at around {}", new Object[]{impl.getJobName(), impl.getClass().getName(), config.scheduleAfterExec() ? "delay" : "rate", interval, TimeUtility.toStr(initDateTime, "yyyy-MM-dd HH:mm:ss")});
                    continue;
                }
                LOGGER.info("[Ctrl] Job {}({}) won't be fired due to its configuration", (Object)impl.getJobName(), (Object)impl.getClass().getName());
                continue;
            }
            LOGGER.info("[Ctrl] Duplicate job found:{}({}), skipped", (Object)impl.getJobName(), (Object)impl.getClass().getName());
        }
    }

    private Runnable compileJob(JobBase jobToRun, long interval) {
        return () -> {
            try {
                SystemConfig.JobConfig config = jobToRun.getTimerConfig();
                if (!TimeUtility.isBetween(config.start().get(), config.end().get(), LocalDateTime.now())) {
                    this.scheduledTask.get(jobToRun.getJobName()).cancel(false);
                    LOGGER.info("[Scheduler] Job({}) is cancelled because it isn't allowed to be executed outside the period:{} ~ {}", new Object[]{jobToRun.getJobName(), TimeUtility.toStr(config.start().get(), "yyyy-MM-dd HH:mm:ss"), TimeUtility.toStr(config.end().get(), "yyyy-MM-dd HH:mm:ss")});
                    return;
                }
                if (!config.scheduleAfterExec()) {
                    LOGGER.info("[Scheduler] Next execution of {} will be at around {}", (Object)jobToRun.getJobName(), (Object)TimeUtility.toStr(LocalDateTime.now().plusSeconds(interval), "yyyy-MM-dd HH:mm:ss"));
                }
                if (this.getExecutingJobDescriptionConsumer() != null) {
                    try {
                        this.getExecutingJobDescriptionConsumer().accept(jobToRun.getJobName());
                    }
                    catch (Exception ex) {
                        LOGGER.error("[Scheduler] {} executingJobDescriptionDelegate exception:", (Object)jobToRun.getJobName(), (Object)ex);
                    }
                }
                try {
                    jobToRun.run();
                }
                catch (Exception ex) {
                    LOGGER.error("[Scheduler] {} execution exception:", (Object)jobToRun.getJobName(), (Object)ex);
                }
                if (config.scheduleAfterExec()) {
                    LOGGER.info("[Scheduler] Next execution of {} will be at around {}", (Object)jobToRun.getJobName(), (Object)TimeUtility.toStr(LocalDateTime.now().plusSeconds(interval), "yyyy-MM-dd HH:mm:ss"));
                }
            }
            catch (Exception ex) {
                LOGGER.error("[Scheduler] {} unknown exception:", (Object)jobToRun.getJobName(), (Object)ex);
            }
        };
    }

    private Iterable<JobBase> getConfigJobs() {
        Map<String, SystemConfig.JobConfig> jobConfigMap = this.configInfo.jobs();
        if (jobConfigMap == null) {
            LOGGER.warn("[Ctrl] Can't find jobs from config!");
            return new ArrayList<JobBase>();
        }
        ArrayList<JobBase> jobList = new ArrayList<JobBase>();
        for (Map.Entry<String, SystemConfig.JobConfig> jobConfig : jobConfigMap.entrySet()) {
            String jobName = jobConfig.getKey();
            String implName = jobConfig.getValue().implementName();
            try {
                Class<?> implClass = Class.forName(implName);
                Constructor<?> implConstructor = implClass.getConstructor(String.class);
                jobList.add(((JobBase)implConstructor.newInstance(jobName)).setJobController(this));
            }
            catch (Exception ex) {
                LOGGER.error("[Ctrl] Can't instantiate job class:{},{}", new Object[]{jobName, implName, ex});
            }
        }
        return jobList;
    }

    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Iterable<JobBase> jobList) {
        block6: {
            try {
                if (this.scheduled) break block6;
                JobController jobController = this;
                synchronized (jobController) {
                    if (!this.scheduled) {
                        this.scheduleJobs(jobList);
                        this.scheduled = true;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("[Ctrl] start fail", (Throwable)ex);
            }
        }
    }

    public void stop() {
        try {
            this.jobExecutor.shutdown();
            if (this.browserAgent != null) {
                this.browserAgent.close();
            }
            this.scheduledTask.clear();
        }
        catch (Exception ex) {
            LOGGER.error("[Ctrl] stop fail", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean pause(PauseTarget target, boolean autoResumable) {
        if (target == null || !this.pauseConfigMap.containsKey((Object)target)) {
            return false;
        }
        PauseConfig pauseConfig = this.pauseConfigMap.get((Object)target);
        if (pauseConfig.isPaused) {
            return false;
        }
        try {
            switch (target) {
                case Browser: {
                    if (this.browserAgent == null) break;
                    this.browserAgent.pause();
                    LOGGER.info("[Ctrl] Bowser paused");
                    break;
                }
                case JobExecutor: {
                    if (this.jobExecutor == null) break;
                    this.jobExecutor.pause();
                    LOGGER.info("[Ctrl] JobExecutor paused");
                    break;
                }
            }
            try {
                if (pauseConfig.afterPauseFunc != null) {
                    pauseConfig.afterPauseFunc.run();
                }
            }
            catch (Exception ex) {
                LOGGER.error("[Ctrl] error after pause({})", (Object)target.toString(), (Object)ex);
            }
            for (JobBase impl : this.scheduleJobList) {
                try {
                    impl.pause();
                }
                catch (Exception ex) {
                    LOGGER.error("[Ctrl] job({}) pause error", (Object)impl.getJobName(), (Object)ex);
                }
            }
        }
        catch (Throwable throwable) {
            pauseConfig.autoResumable = pauseConfig.autoResumable && autoResumable;
            pauseConfig.isPaused = true;
            throw throwable;
        }
        pauseConfig.autoResumable = pauseConfig.autoResumable && autoResumable;
        pauseConfig.isPaused = true;
        return true;
    }

    public synchronized boolean pause(PauseTarget target) {
        return this.pause(target, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean resume(PauseTarget target, boolean autoResumable) {
        if (target == null || !this.pauseConfigMap.containsKey((Object)target)) {
            return false;
        }
        PauseConfig pauseConfig = this.pauseConfigMap.get((Object)target);
        if (!pauseConfig.isPaused) {
            return false;
        }
        if (autoResumable && !pauseConfig.autoResumable) {
            LOGGER.info("[Ctrl] Can't resume " + target.toString() + " automatically because system was paused by user, please resume manually");
            return false;
        }
        try {
            switch (target) {
                case Browser: {
                    if (this.browserAgent == null) break;
                    this.browserAgent.resume();
                    LOGGER.info("[Ctrl] Browser resumed");
                    break;
                }
                case JobExecutor: {
                    if (this.jobExecutor == null) break;
                    this.jobExecutor.resume();
                    LOGGER.info("[Ctrl] JobExecutor resumed");
                    break;
                }
            }
            try {
                if (pauseConfig.afterResumeFunc != null) {
                    pauseConfig.afterResumeFunc.run();
                }
            }
            catch (Exception ex) {
                LOGGER.error("[Ctrl] error after resume({})", (Object)target.toString(), (Object)ex);
            }
            for (JobBase impl : this.scheduleJobList) {
                try {
                    impl.resume();
                }
                catch (Exception ex) {
                    LOGGER.error("[Ctrl] job({}) resume error", (Object)impl.getJobName(), (Object)ex);
                }
            }
        }
        finally {
            pauseConfig.isPaused = false;
            pauseConfig.autoResumable = true;
        }
        return true;
    }

    public synchronized boolean resume(PauseTarget target) {
        return this.resume(target, false);
    }

    public synchronized boolean isPaused(PauseTarget target) {
        if (target == null || !this.pauseConfigMap.containsKey((Object)target)) {
            return false;
        }
        PauseConfig pauseConfig = this.pauseConfigMap.get((Object)target);
        return pauseConfig.isPaused;
    }

    public void signalInteractionType(InteractionType interaction) {
        this.latestInteractionType = interaction;
        this.interactionPhaser.arrive();
    }

    public final void forwardEvent(JobBase sourceJob, Object event) {
        if (event == null) {
            return;
        }
        for (JobBase impl : this.scheduleJobList) {
            try {
                if (impl == sourceJob) continue;
                impl.receiveEvent(event);
            }
            catch (Exception ex) {
                LOGGER.error("[Ctrl] job {} resume delegate error", (Object)impl.getJobName(), (Object)ex);
            }
        }
    }

    public void setAfterPauseFunction(PauseTarget target, Runnable afterPauseFunc) {
        if (target != null && this.pauseConfigMap.containsKey((Object)target)) {
            this.pauseConfigMap.get((Object)target).afterPauseFunc = afterPauseFunc;
        }
    }

    public void setAfterResumeFunction(PauseTarget target, Runnable afterResumeFunc) {
        if (target != null && this.pauseConfigMap.containsKey((Object)target)) {
            this.pauseConfigMap.get((Object)target).afterResumeFunc = afterResumeFunc;
        }
    }

    private ActionRunner createNewActionRunner() {
        BasicActionRunner btm;
        BrowserType browserType = BrowserType.fromString((String)this.configInfo.browserType());
        if (this.configInfo.headlessBrowser()) {
            System.setProperty("webdriver_headless", "yes");
        }
        BasicActionRunner basicActionRunner = btm = browserType == null ? null : new BasicActionRunner(this.configInfo.browserPageLoadStrategy(), browserType, this.configInfo.browserMaxTask()).setName("ActionRunner");
        if (btm != null) {
            LOGGER.info("[Ctrl] browser task manger created");
        }
        return btm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptBrowserTask(ActionComposer task) {
        if (this.browserAgent == null || task == null) {
            return false;
        }
        ActionRunner actionRunner = this.browserAgent;
        synchronized (actionRunner) {
            if (this.browserAgent == null) {
                return false;
            }
            try {
                if (!this.browserAgent.isBrowserAlive()) {
                    this.restartBrowserTaskManager();
                }
                this.browserAgent.executeComposer(task);
                return true;
            }
            catch (Exception ex) {
                LOGGER.error("[Ctrl] accept task fail", (Throwable)ex);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartBrowserTaskManager() {
        if (this.browserAgent == null) {
            return;
        }
        ActionRunner actionRunner = this.browserAgent;
        synchronized (actionRunner) {
            if (this.browserAgent == null) {
                return;
            }
            try {
                this.browserAgent.close();
                LOGGER.info("[Ctrl] browser task manger closed");
            }
            catch (Exception ex) {
                LOGGER.error("[Ctrl] Close browser error", (Throwable)ex);
            }
        }
        this.browserAgent = this.createNewActionRunner();
    }

    public void awaitInteraction() {
        int phaseNo = this.interactionPhaser.getPhase();
        if (this.preInteractionFunc != null) {
            try {
                this.preInteractionFunc.run();
            }
            catch (Exception e) {
                LOGGER.error("[Ctrl] preInteraction function error", (Throwable)e);
            }
        }
        try {
            this.interactionPhaser.awaitAdvanceInterruptibly(phaseNo);
        }
        catch (InterruptedException e) {
            LOGGER.info("[Ctrl] awaiting interaction result...");
        }
        if (this.postInteractionFunc != null) {
            try {
                this.postInteractionFunc.run();
            }
            catch (Exception e) {
                LOGGER.error("[Ctrl] postInteraction function error", (Throwable)e);
            }
        }
    }

    public InteractionType getLatestInteraction() {
        return this.latestInteractionType;
    }

    public void setPreInteractionFunction(Runnable func) {
        this.preInteractionFunc = func;
    }

    public void setPostInteractionFunction(Runnable func) {
        this.postInteractionFunc = func;
    }

    public Consumer<String> getExecutingJobDescriptionConsumer() {
        return this.executingJobDescriptionConsumer;
    }

    public void setExecutingJobDescriptionConsumer(Consumer<String> executingJobDescriptionConsumer) {
        this.executingJobDescriptionConsumer = executingJobDescriptionConsumer;
    }

    public static enum InteractionType {
        Positive,
        Negative;

    }

    public static enum PauseTarget {
        Browser,
        JobExecutor;

    }

    private static class PauseConfig {
        private volatile boolean isPaused = false;
        private volatile boolean autoResumable = true;
        private volatile Runnable afterPauseFunc = null;
        private volatile Runnable afterResumeFunc = null;

        private PauseConfig() {
        }
    }
}

