package org.kramerlab.bmad.algorithms;

import org.kramerlab.bmad.matrix.BooleanMatrix;

/**
 * A "formal" combinator, that does nothing itself and just returns the
 * approximation generated by the basis selector in the previous step.
 */
public class IdentityCombinator extends Combinator {

	@Override
	protected BooleanMatrix combineRow(BooleanMatrix row,
			BooleanMatrix previousCombination, BooleanMatrix basis,
			double onesWeight) {
		return previousCombination;
	}

	@Override
	public String toString() {
		return "Id";
	}
}
