/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.algorithms;

import org.kramerlab.bmad.algorithms.AssociationGenerator;
import org.kramerlab.bmad.algorithms.BasisSelector;
import org.kramerlab.bmad.algorithms.CandidateGenerator;
import org.kramerlab.bmad.algorithms.Combinator;
import org.kramerlab.bmad.algorithms.CombinatorPipeline;
import org.kramerlab.bmad.algorithms.DensityGreedyCombinator;
import org.kramerlab.bmad.algorithms.FastLoc;
import org.kramerlab.bmad.algorithms.GreedySelector;
import org.kramerlab.bmad.algorithms.IdentityCombinator;
import org.kramerlab.bmad.algorithms.IdentityGenerator;
import org.kramerlab.bmad.algorithms.Iter;
import org.kramerlab.bmad.general.Package;
import org.kramerlab.bmad.general.Tuple;
import org.kramerlab.bmad.matrix.BooleanMatrix;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanMatrixDecomposition {
    protected CandidateGenerator generator;
    protected BasisSelector selector;
    protected Combinator combinator;
    protected double onesWeight;
    public static BooleanMatrixDecomposition LOC_ITER = new BooleanMatrixDecomposition(new IdentityGenerator(), new FastLoc(), new Iter(), 1.0);
    public static BooleanMatrixDecomposition DBP = new BooleanMatrixDecomposition(new AssociationGenerator(0.5), new GreedySelector(), new IdentityCombinator(), 1.0);
    public static BooleanMatrixDecomposition BEST_UNCONFIGURED = new BooleanMatrixDecomposition(new IdentityGenerator(), new FastLoc(), new CombinatorPipeline(new DensityGreedyCombinator(), new Iter()), 1.0);

    public BooleanMatrixDecomposition(CandidateGenerator generator, BasisSelector selector, Combinator combinator, double onesWeight) {
        this.generator = generator;
        this.selector = selector;
        this.combinator = combinator;
        this.onesWeight = onesWeight;
    }

    public Tuple<BooleanMatrix, BooleanMatrix> decompose(BooleanMatrix a, int dimension) {
        BooleanMatrix candidates = this.generator.generateCandidates(a, dimension);
        Tuple<BooleanMatrix, BooleanMatrix> combinationAndBasis = this.selector.selectBasis(candidates, a, dimension, this.onesWeight);
        BooleanMatrix combination = (BooleanMatrix)combinationAndBasis._1;
        BooleanMatrix basis = (BooleanMatrix)combinationAndBasis._2;
        BooleanMatrix improvedCombination = this.combinator.combineMatrix(a, combination, basis, this.onesWeight);
        return Package.tuple(improvedCombination, basis);
    }

    public Tuple<Instances, Instances> decompose(Instances a, int dimension) {
        Tuple<BooleanMatrix, BooleanMatrix> t = this.decompose(new BooleanMatrix(a), dimension);
        return Package.tuple(((BooleanMatrix)t._1).toInstances(), ((BooleanMatrix)t._2).toInstances());
    }

    public String toString() {
        return "" + this.generator + "+" + this.selector + "+" + this.combinator;
    }

    public static BooleanMatrixDecomposition BEST_CONFIGURED(double assocThreshold) {
        return new BooleanMatrixDecomposition(new AssociationGenerator(assocThreshold), new FastLoc(), new CombinatorPipeline(new DensityGreedyCombinator(), new Iter()), 1.0);
    }
}

