/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.algorithms;

import java.util.Arrays;
import org.kramerlab.bmad.general.Package;
import org.kramerlab.bmad.general.Tuple;
import org.kramerlab.bmad.matrix.BooleanMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cover {
    protected double onesWeight;
    protected int width;
    protected int[] entries;
    private static int trueMultiplicator = 32768;

    public Cover(int width, double onesWeight) {
        this.width = width;
        this.onesWeight = onesWeight;
        this.entries = new int[width];
    }

    public Tuple<Integer, Integer> apply(int c) {
        int i = this.entries[c];
        return Package.tuple(i / trueMultiplicator, i % trueMultiplicator);
    }

    public void update(int c, int ones, int unknowns) {
        this.entries[c] = trueMultiplicator * ones + unknowns;
    }

    public void include(BooleanMatrix basisRow) {
        for (int c = 0; c < this.width; ++c) {
            byte b = basisRow.apply(c);
            if (b == 0) continue;
            int n = c;
            this.entries[n] = this.entries[n] + (b == 1 ? 1 : trueMultiplicator);
        }
    }

    public void exclude(BooleanMatrix basisRow) {
        for (int c = 0; c < this.width; ++c) {
            byte b = basisRow.apply(c);
            if (b == 0) continue;
            int n = c;
            this.entries[n] = this.entries[n] - (b == 1 ? 1 : trueMultiplicator);
        }
    }

    public Tuple<Integer, Integer> coveredOnesAndZerosOnInclusion(BooleanMatrix coveredRow, BooleanMatrix basisRow) {
        int coveredOnes = 0;
        int coveredZeros = 0;
        for (int c = 0; c < this.width; ++c) {
            byte aEntry = coveredRow.apply(c);
            if (aEntry == 3 && this.entries[c] < trueMultiplicator && basisRow.apply(c) == 3) {
                ++coveredOnes;
                continue;
            }
            if (aEntry != 0 || this.entries[c] != 0 || basisRow.apply(c) == 0) continue;
            ++coveredZeros;
        }
        return Package.tuple(coveredOnes, coveredZeros);
    }

    public Tuple<Integer, Integer> uncoveredOnesAndZerosOnExclusion(BooleanMatrix coveredRow, BooleanMatrix basisRow) {
        int uncoveredOnes = 0;
        int uncoveredZeros = 0;
        for (int c = 0; c < this.width; ++c) {
            byte aEntry = coveredRow.apply(c);
            if (aEntry == 0) {
                int cEntry = this.entries[c];
                byte bEntry = basisRow.apply(c);
                if ((cEntry != trueMultiplicator || bEntry != 3) && (cEntry != 1 || bEntry != 1)) continue;
                ++uncoveredZeros;
                continue;
            }
            if (aEntry != 3 || this.entries[c] / trueMultiplicator != 1 || basisRow.apply(c) != 3) continue;
            ++uncoveredOnes;
        }
        return Package.tuple(uncoveredOnes, uncoveredZeros);
    }

    public double coverChangeOnInclusion(BooleanMatrix coveredRow, BooleanMatrix basisRow) {
        Tuple<Integer, Integer> t = this.coveredOnesAndZerosOnInclusion(coveredRow, basisRow);
        return this.onesWeight * (double)((Integer)t._1).intValue() - (double)((Integer)t._2).intValue();
    }

    public double coverChangeOnExclusion(BooleanMatrix coveredRow, BooleanMatrix basisRow) {
        Tuple<Integer, Integer> t = this.uncoveredOnesAndZerosOnExclusion(coveredRow, basisRow);
        return (double)((Integer)t._2).intValue() - this.onesWeight * (double)((Integer)t._1).intValue();
    }

    public double coverChangeDensityOnInclusion(BooleanMatrix coveredRow, BooleanMatrix basisRow) {
        Tuple<Integer, Integer> t = this.coveredOnesAndZerosOnInclusion(coveredRow, basisRow);
        double denominator = this.onesWeight * (double)((Integer)t._1).intValue() + (double)((Integer)t._2).intValue();
        return denominator == 0.0 ? -1.0 : (this.onesWeight * (double)((Integer)t._1).intValue() - (double)((Integer)t._2).intValue()) / denominator;
    }

    public BooleanMatrix toBooleanMatrix() {
        BooleanMatrix row = new BooleanMatrix(1, this.width);
        for (int i = 0; i < this.width; ++i) {
            Tuple<Integer, Integer> t = this.apply(i);
            if ((Integer)t._1 > 0) {
                row.update(i, (byte)3);
                continue;
            }
            if ((Integer)t._2 <= 0) continue;
            row.update(i, (byte)1);
        }
        return row;
    }

    public Cover zero(int width) {
        return new Cover(width, this.onesWeight);
    }

    public String toString() {
        String res = "[";
        for (int c = 0; c < this.width; ++c) {
            res = res + this.apply(c);
        }
        res = res + "]";
        return res;
    }

    public int hashCode() {
        System.err.println("Do we ever use hash code of covers?...");
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.entries);
        long temp = Double.doubleToLongBits(this.onesWeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cover other = (Cover)obj;
        if (!Arrays.equals(this.entries, other.entries)) {
            return false;
        }
        if (Double.doubleToLongBits(this.onesWeight) != Double.doubleToLongBits(other.onesWeight)) {
            return false;
        }
        return this.width == other.width;
    }
}

