/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.algorithms;

import org.kramerlab.bmad.algorithms.Combinator;
import org.kramerlab.bmad.algorithms.Cover;
import org.kramerlab.bmad.matrix.BooleanMatrix;

public class Iter
extends Combinator {
    protected BooleanMatrix combineRow(BooleanMatrix row, BooleanMatrix previousCombination, BooleanMatrix basis, double onesWeight) {
        int dim = basis.getHeight();
        Cover cover = new Cover(row.getWidth(), onesWeight);
        for (int c = 0; c < dim; ++c) {
            if (previousCombination.apply(c) != 3) continue;
            cover.include(basis.getRow(c));
        }
        boolean approximationImproves = true;
        while (approximationImproves) {
            approximationImproves = false;
            for (int c = 0; c < dim; ++c) {
                byte combinationEntry = previousCombination.apply(c);
                BooleanMatrix basisRow = basis.getRow(c);
                if (combinationEntry == 0) {
                    if (!(cover.coverChangeOnInclusion(row, basisRow) > 0.0)) continue;
                    cover.include(basisRow);
                    previousCombination.update(c, (byte)3);
                    approximationImproves = true;
                    continue;
                }
                if (combinationEntry != 3 || !(cover.coverChangeOnExclusion(row, basisRow) >= 0.0)) continue;
                cover.exclude(basisRow);
                previousCombination.update(c, (byte)0);
                approximationImproves = true;
            }
        }
        return previousCombination;
    }

    public String toString() {
        return "Iter";
    }
}

