/*
 * Decompiled with CFR 0.152.
 */
package org.kramerlab.bmad.visualization;

import java.awt.Color;
import javax.swing.JFrame;
import org.kramerlab.bmad.general.Function;
import org.kramerlab.bmad.matrix.BooleanMatrix;
import org.kramerlab.bmad.matrix.RowMajor;
import org.kramerlab.bmad.visualization.SingleImageComponent;
import weka.core.Instances;

public class DecompositionLayout {
    public static void showDecomposition(String title, Instances original, Instances combinations, Instances basisRows) {
        BooleanMatrix a = new BooleanMatrix(original);
        BooleanMatrix comb = new BooleanMatrix(combinations);
        BooleanMatrix basis = new BooleanMatrix(basisRows);
        BooleanMatrix reconstruction = comb.booleanProduct(basis);
        int dim = basis.getHeight();
        int w = a.getWidth();
        int h = a.getHeight();
        int ONE_ZERO = 16;
        int ZERO_ONE = 32;
        BooleanMatrix errorMatrix = new BooleanMatrix(h, w);
        for (int r = 0; r < h; ++r) {
            for (int c = 0; c < w; ++c) {
                byte is;
                byte should = a.apply(r, c);
                if (should == (is = reconstruction.apply(r, c)) || should == 1) {
                    errorMatrix.update(r, c, is);
                    continue;
                }
                errorMatrix.update(r, c, should == 0 ? (byte)16 : 32);
            }
        }
        RowMajor<BooleanMatrix> imgComponents = new RowMajor<BooleanMatrix>(2, 3, (BooleanMatrix)null);
        imgComponents.update(0, 0, new BooleanMatrix(dim, dim));
        imgComponents.update(0, 1, basis);
        imgComponents.update(0, 2, new BooleanMatrix(dim, w));
        imgComponents.update(1, 0, comb);
        imgComponents.update(1, 1, errorMatrix);
        imgComponents.update(1, 2, a);
        RowMajor<Byte> img = imgComponents.flatMap(new Function<BooleanMatrix, RowMajor<Byte>>(){

            @Override
            public RowMajor<Byte> apply(BooleanMatrix b) {
                return DecompositionLayout.padMatrix(b, 20).toRowMajor();
            }
        });
        JFrame f = new JFrame(title);
        f.getContentPane().add(new SingleImageComponent(img.toImage(new Function<Byte, Color>(){

            @Override
            public Color apply(Byte b) {
                if (b == 0) {
                    return Color.WHITE;
                }
                if (b == 1) {
                    return new Color(200, 240, 240);
                }
                if (b == 3) {
                    return Color.BLACK;
                }
                if (b == 16) {
                    return new Color(255, 100, 100);
                }
                if (b == 32) {
                    return Color.RED;
                }
                return Color.RED;
            }
        })));
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        f.setExtendedState(f.getExtendedState() | 6);
    }

    private static BooleanMatrix padMatrix(BooleanMatrix m, int padding) {
        BooleanMatrix padded = new BooleanMatrix(m.getHeight() + 2 * padding, m.getWidth() + 2 * padding);
        for (int c = 0; c < m.getWidth(); ++c) {
            for (int r = 0; r < m.getHeight(); ++r) {
                padded.update(r + padding, c + padding, m.apply(r, c));
            }
        }
        return padded;
    }
}

