package org.krosai.core.model

/**
 * Represents the result generated by an AI model.
 *
 * @param T The type of the output generated by the AI model.
 *
 * @author KAMOsama
 */
interface ModelResult<T> {

    /**
     * Retrieves the output generated by the AI model.
     * @return the output generated by the AI model
     */
    val output: T

    /**
     * Retrieves the metadata associated with the result of an AI model.
     * @return the metadata associated with the result
     */
    val metadata: ResultMetadata

}

/**
 * Represents the metadata associated with a result generated by an AI model.
 *
 * @author KAMOsama
 */
interface ResultMetadata{

    object Null : ResultMetadata

}

